/* unity-scope-interface.c generated by valac 0.12.1, the Vala compiler
 * generated from unity-scope-interface.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define UNITY_TYPE_SCOPE_INFO (unity_scope_info_get_type ())
typedef struct _UnityScopeInfo UnityScopeInfo;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define UNITY_TYPE_ACTIVATION_REPLY_RAW (unity_activation_reply_raw_get_type ())
typedef struct _UnityActivationReplyRaw UnityActivationReplyRaw;

#define UNITY_TYPE_PREVIEW_REPLY_RAW (unity_preview_reply_raw_get_type ())
typedef struct _UnityPreviewReplyRaw UnityPreviewReplyRaw;

#define UNITY_TYPE_SCOPE_SERVICE (unity_scope_service_get_type ())
#define UNITY_SCOPE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_SERVICE, UnityScopeService))
#define UNITY_IS_SCOPE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_SERVICE))
#define UNITY_SCOPE_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_SCOPE_SERVICE, UnityScopeServiceIface))

typedef struct _UnityScopeService UnityScopeService;
typedef struct _UnityScopeServiceIface UnityScopeServiceIface;

#define UNITY_TYPE_SCOPE_SERVICE_PROXY (unity_scope_service_proxy_get_type ())
typedef GDBusProxy UnityScopeServiceProxy;
typedef GDBusProxyClass UnityScopeServiceProxyClass;

struct _UnityScopeInfo {
	gchar* dbus_path;
	gchar** sources;
	gint sources_length1;
	gint _sources_size_;
	gboolean search_in_global;
	gchar* private_connection_name;
	gchar* results_model_name;
	gchar* global_results_model_name;
	gchar* filters_model_name;
	GHashTable* hints;
};

struct _UnityActivationReplyRaw {
	gchar* uri;
	guint handled;
	GHashTable* hints;
};

struct _UnityPreviewReplyRaw {
	gchar* uri;
	gchar* renderer_name;
	GHashTable* properties;
};

struct _UnityScopeServiceIface {
	GTypeInterface parent_iface;
	void (*info_request) (UnityScopeService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*info_request_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*activate) (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*activate_finish) (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
	void (*search) (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*search_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*global_search) (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*global_search_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*preview) (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*preview_finish) (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
	void (*set_active) (UnityScopeService* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*set_active_sources) (UnityScopeService* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_sources_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
};



GType unity_scope_info_get_type (void) G_GNUC_CONST;
UnityScopeInfo* unity_scope_info_dup (const UnityScopeInfo* self);
void unity_scope_info_free (UnityScopeInfo* self);
void unity_scope_info_copy (const UnityScopeInfo* self, UnityScopeInfo* dest);
void unity_scope_info_destroy (UnityScopeInfo* self);
static gchar** _vala_array_dup5 (gchar** self, int length);
GType unity_activation_reply_raw_get_type (void) G_GNUC_CONST;
UnityActivationReplyRaw* unity_activation_reply_raw_dup (const UnityActivationReplyRaw* self);
void unity_activation_reply_raw_free (UnityActivationReplyRaw* self);
void unity_activation_reply_raw_copy (const UnityActivationReplyRaw* self, UnityActivationReplyRaw* dest);
void unity_activation_reply_raw_destroy (UnityActivationReplyRaw* self);
GType unity_preview_reply_raw_get_type (void) G_GNUC_CONST;
UnityPreviewReplyRaw* unity_preview_reply_raw_dup (const UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_free (UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_copy (const UnityPreviewReplyRaw* self, UnityPreviewReplyRaw* dest);
void unity_preview_reply_raw_destroy (UnityPreviewReplyRaw* self);
GType unity_scope_service_proxy_get_type (void) G_GNUC_CONST;
guint unity_scope_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_scope_service_get_type (void) G_GNUC_CONST;
void unity_scope_service_info_request (UnityScopeService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_info_request_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
void unity_scope_service_activate (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_activate_finish (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
void unity_scope_service_search (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
void unity_scope_service_global_search (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_global_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
void unity_scope_service_preview (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_preview_finish (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
void unity_scope_service_set_active (UnityScopeService* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_set_active_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
void unity_scope_service_set_active_sources (UnityScopeService* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_set_active_sources_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void unity_scope_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_unity_scope_service_changed (UnityScopeService* self, GVariant* parameters);
static void _dbus_handle_unity_scope_service_search_finished (UnityScopeService* self, GVariant* parameters);
static void _dbus_handle_unity_scope_service_global_search_finished (UnityScopeService* self, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void unity_scope_service_proxy_info_request_async (UnityScopeService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_scope_service_proxy_info_request_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_service_proxy_activate_async (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_scope_service_proxy_activate_finish (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
static void unity_scope_service_proxy_search_async (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_scope_service_proxy_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_service_proxy_global_search_async (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_scope_service_proxy_global_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_service_proxy_preview_async (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_scope_service_proxy_preview_finish (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
static void unity_scope_service_proxy_set_active_async (UnityScopeService* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_scope_service_proxy_set_active_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_service_proxy_set_active_sources_async (UnityScopeService* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_scope_service_proxy_set_active_sources_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_service_proxy_unity_scope_service_interface_init (UnityScopeServiceIface* iface);
static void _dbus_unity_scope_service_info_request (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_scope_service_info_request_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_scope_service_activate (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_scope_service_activate_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_scope_service_search (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_scope_service_search_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_scope_service_global_search (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_scope_service_global_search_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_scope_service_preview (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_scope_service_preview_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_scope_service_set_active (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_scope_service_set_active_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_scope_service_set_active_sources (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_scope_service_set_active_sources_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void unity_scope_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* unity_scope_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean unity_scope_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_unity_scope_service_changed (GObject* _sender, UnityScopeInfo* lens_info, gpointer* _data);
static void _dbus_unity_scope_service_search_finished (GObject* _sender, const gchar* search_string, GHashTable* hints, gpointer* _data);
static void _dbus_unity_scope_service_global_search_finished (GObject* _sender, const gchar* search_string, GHashTable* hints, gpointer* _data);
static void _unity_scope_service_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_info_request_in[] = {NULL};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_info_request_out[] = {NULL};
static const GDBusMethodInfo _unity_scope_service_dbus_method_info_info_request = {-1, "InfoRequest", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_info_request_in), (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_info_request_out)};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_activate_uri = {-1, "uri", "s"};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_activate_action_type = {-1, "action_type", "u"};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_activate_result = {-1, "result", "(sua{sv})"};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_activate_in[] = {&_unity_scope_service_dbus_arg_info_activate_uri, &_unity_scope_service_dbus_arg_info_activate_action_type, NULL};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_activate_out[] = {&_unity_scope_service_dbus_arg_info_activate_result, NULL};
static const GDBusMethodInfo _unity_scope_service_dbus_method_info_activate = {-1, "Activate", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_activate_in), (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_activate_out)};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_search_search_string = {-1, "search_string", "s"};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_search_hints = {-1, "hints", "a{sv}"};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_search_in[] = {&_unity_scope_service_dbus_arg_info_search_search_string, &_unity_scope_service_dbus_arg_info_search_hints, NULL};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_search_out[] = {NULL};
static const GDBusMethodInfo _unity_scope_service_dbus_method_info_search = {-1, "Search", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_search_in), (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_search_out)};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_global_search_search_string = {-1, "search_string", "s"};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_global_search_hints = {-1, "hints", "a{sv}"};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_global_search_in[] = {&_unity_scope_service_dbus_arg_info_global_search_search_string, &_unity_scope_service_dbus_arg_info_global_search_hints, NULL};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_global_search_out[] = {NULL};
static const GDBusMethodInfo _unity_scope_service_dbus_method_info_global_search = {-1, "GlobalSearch", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_global_search_in), (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_global_search_out)};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_preview_uri = {-1, "uri", "s"};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_preview_result = {-1, "result", "(ssa{sv})"};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_preview_in[] = {&_unity_scope_service_dbus_arg_info_preview_uri, NULL};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_preview_out[] = {&_unity_scope_service_dbus_arg_info_preview_result, NULL};
static const GDBusMethodInfo _unity_scope_service_dbus_method_info_preview = {-1, "Preview", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_preview_in), (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_preview_out)};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_set_active_active = {-1, "active", "b"};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_set_active_in[] = {&_unity_scope_service_dbus_arg_info_set_active_active, NULL};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_set_active_out[] = {NULL};
static const GDBusMethodInfo _unity_scope_service_dbus_method_info_set_active = {-1, "SetActive", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_set_active_in), (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_set_active_out)};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_set_active_sources_sources = {-1, "sources", "as"};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_set_active_sources_in[] = {&_unity_scope_service_dbus_arg_info_set_active_sources_sources, NULL};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_set_active_sources_out[] = {NULL};
static const GDBusMethodInfo _unity_scope_service_dbus_method_info_set_active_sources = {-1, "SetActiveSources", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_set_active_sources_in), (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_set_active_sources_out)};
static const GDBusMethodInfo * const _unity_scope_service_dbus_method_info[] = {&_unity_scope_service_dbus_method_info_info_request, &_unity_scope_service_dbus_method_info_activate, &_unity_scope_service_dbus_method_info_search, &_unity_scope_service_dbus_method_info_global_search, &_unity_scope_service_dbus_method_info_preview, &_unity_scope_service_dbus_method_info_set_active, &_unity_scope_service_dbus_method_info_set_active_sources, NULL};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_changed_lens_info = {-1, "lens_info", "(sasbssssa{sv})"};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_changed[] = {&_unity_scope_service_dbus_arg_info_changed_lens_info, NULL};
static const GDBusSignalInfo _unity_scope_service_dbus_signal_info_changed = {-1, "Changed", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_changed)};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_search_finished_search_string = {-1, "search_string", "s"};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_search_finished_hints = {-1, "hints", "a{sv}"};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_search_finished[] = {&_unity_scope_service_dbus_arg_info_search_finished_search_string, &_unity_scope_service_dbus_arg_info_search_finished_hints, NULL};
static const GDBusSignalInfo _unity_scope_service_dbus_signal_info_search_finished = {-1, "SearchFinished", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_search_finished)};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_global_search_finished_search_string = {-1, "search_string", "s"};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_global_search_finished_hints = {-1, "hints", "a{sv}"};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_global_search_finished[] = {&_unity_scope_service_dbus_arg_info_global_search_finished_search_string, &_unity_scope_service_dbus_arg_info_global_search_finished_hints, NULL};
static const GDBusSignalInfo _unity_scope_service_dbus_signal_info_global_search_finished = {-1, "GlobalSearchFinished", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_global_search_finished)};
static const GDBusSignalInfo * const _unity_scope_service_dbus_signal_info[] = {&_unity_scope_service_dbus_signal_info_changed, &_unity_scope_service_dbus_signal_info_search_finished, &_unity_scope_service_dbus_signal_info_global_search_finished, NULL};
static const GDBusPropertyInfo * const _unity_scope_service_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _unity_scope_service_dbus_interface_info = {-1, "com.canonical.Unity.Scope", (GDBusMethodInfo **) (&_unity_scope_service_dbus_method_info), (GDBusSignalInfo **) (&_unity_scope_service_dbus_signal_info), (GDBusPropertyInfo **) (&_unity_scope_service_dbus_property_info)};
static const GDBusInterfaceVTable _unity_scope_service_dbus_interface_vtable = {unity_scope_service_dbus_interface_method_call, unity_scope_service_dbus_interface_get_property, unity_scope_service_dbus_interface_set_property};

static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void unity_scope_info_copy (const UnityScopeInfo* self, UnityScopeInfo* dest) {
	gchar** _tmp0_;
	dest->dbus_path = g_strdup (self->dbus_path);
	dest->sources = (_tmp0_ = self->sources, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup5 (_tmp0_, (*self).sources_length1));
	dest->sources_length1 = self->sources_length1;
	dest->search_in_global = self->search_in_global;
	dest->private_connection_name = g_strdup (self->private_connection_name);
	dest->results_model_name = g_strdup (self->results_model_name);
	dest->global_results_model_name = g_strdup (self->global_results_model_name);
	dest->filters_model_name = g_strdup (self->filters_model_name);
	dest->hints = _g_hash_table_ref0 (self->hints);
}


void unity_scope_info_destroy (UnityScopeInfo* self) {
	_g_free0 ((*self).dbus_path);
	(*self).sources = (_vala_array_free ((*self).sources, (*self).sources_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 ((*self).private_connection_name);
	_g_free0 ((*self).results_model_name);
	_g_free0 ((*self).global_results_model_name);
	_g_free0 ((*self).filters_model_name);
	_g_hash_table_unref0 ((*self).hints);
}


UnityScopeInfo* unity_scope_info_dup (const UnityScopeInfo* self) {
	UnityScopeInfo* dup;
	dup = g_new0 (UnityScopeInfo, 1);
	unity_scope_info_copy (self, dup);
	return dup;
}


void unity_scope_info_free (UnityScopeInfo* self) {
	unity_scope_info_destroy (self);
	g_free (self);
}


GType unity_scope_info_get_type (void) {
	static volatile gsize unity_scope_info_type_id__volatile = 0;
	if (g_once_init_enter (&unity_scope_info_type_id__volatile)) {
		GType unity_scope_info_type_id;
		unity_scope_info_type_id = g_boxed_type_register_static ("UnityScopeInfo", (GBoxedCopyFunc) unity_scope_info_dup, (GBoxedFreeFunc) unity_scope_info_free);
		g_once_init_leave (&unity_scope_info_type_id__volatile, unity_scope_info_type_id);
	}
	return unity_scope_info_type_id__volatile;
}


void unity_activation_reply_raw_copy (const UnityActivationReplyRaw* self, UnityActivationReplyRaw* dest) {
	dest->uri = g_strdup (self->uri);
	dest->handled = self->handled;
	dest->hints = _g_hash_table_ref0 (self->hints);
}


void unity_activation_reply_raw_destroy (UnityActivationReplyRaw* self) {
	_g_free0 ((*self).uri);
	_g_hash_table_unref0 ((*self).hints);
}


UnityActivationReplyRaw* unity_activation_reply_raw_dup (const UnityActivationReplyRaw* self) {
	UnityActivationReplyRaw* dup;
	dup = g_new0 (UnityActivationReplyRaw, 1);
	unity_activation_reply_raw_copy (self, dup);
	return dup;
}


void unity_activation_reply_raw_free (UnityActivationReplyRaw* self) {
	unity_activation_reply_raw_destroy (self);
	g_free (self);
}


GType unity_activation_reply_raw_get_type (void) {
	static volatile gsize unity_activation_reply_raw_type_id__volatile = 0;
	if (g_once_init_enter (&unity_activation_reply_raw_type_id__volatile)) {
		GType unity_activation_reply_raw_type_id;
		unity_activation_reply_raw_type_id = g_boxed_type_register_static ("UnityActivationReplyRaw", (GBoxedCopyFunc) unity_activation_reply_raw_dup, (GBoxedFreeFunc) unity_activation_reply_raw_free);
		g_once_init_leave (&unity_activation_reply_raw_type_id__volatile, unity_activation_reply_raw_type_id);
	}
	return unity_activation_reply_raw_type_id__volatile;
}


void unity_preview_reply_raw_copy (const UnityPreviewReplyRaw* self, UnityPreviewReplyRaw* dest) {
	dest->uri = g_strdup (self->uri);
	dest->renderer_name = g_strdup (self->renderer_name);
	dest->properties = _g_hash_table_ref0 (self->properties);
}


void unity_preview_reply_raw_destroy (UnityPreviewReplyRaw* self) {
	_g_free0 ((*self).uri);
	_g_free0 ((*self).renderer_name);
	_g_hash_table_unref0 ((*self).properties);
}


UnityPreviewReplyRaw* unity_preview_reply_raw_dup (const UnityPreviewReplyRaw* self) {
	UnityPreviewReplyRaw* dup;
	dup = g_new0 (UnityPreviewReplyRaw, 1);
	unity_preview_reply_raw_copy (self, dup);
	return dup;
}


void unity_preview_reply_raw_free (UnityPreviewReplyRaw* self) {
	unity_preview_reply_raw_destroy (self);
	g_free (self);
}


GType unity_preview_reply_raw_get_type (void) {
	static volatile gsize unity_preview_reply_raw_type_id__volatile = 0;
	if (g_once_init_enter (&unity_preview_reply_raw_type_id__volatile)) {
		GType unity_preview_reply_raw_type_id;
		unity_preview_reply_raw_type_id = g_boxed_type_register_static ("UnityPreviewReplyRaw", (GBoxedCopyFunc) unity_preview_reply_raw_dup, (GBoxedFreeFunc) unity_preview_reply_raw_free);
		g_once_init_leave (&unity_preview_reply_raw_type_id__volatile, unity_preview_reply_raw_type_id);
	}
	return unity_preview_reply_raw_type_id__volatile;
}


void unity_scope_service_info_request (UnityScopeService* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->info_request (self, _callback_, _user_data_);
}


void unity_scope_service_info_request_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->info_request_finish (self, _res_, error);
}


void unity_scope_service_activate (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->activate (self, uri, action_type, _callback_, _user_data_);
}


void unity_scope_service_activate_finish (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->activate_finish (self, _res_, result, error);
}


void unity_scope_service_search (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->search (self, search_string, hints, _callback_, _user_data_);
}


void unity_scope_service_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->search_finish (self, _res_, error);
}


void unity_scope_service_global_search (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->global_search (self, search_string, hints, _callback_, _user_data_);
}


void unity_scope_service_global_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->global_search_finish (self, _res_, error);
}


void unity_scope_service_preview (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->preview (self, uri, _callback_, _user_data_);
}


void unity_scope_service_preview_finish (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->preview_finish (self, _res_, result, error);
}


void unity_scope_service_set_active (UnityScopeService* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->set_active (self, active, _callback_, _user_data_);
}


void unity_scope_service_set_active_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->set_active_finish (self, _res_, error);
}


void unity_scope_service_set_active_sources (UnityScopeService* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->set_active_sources (self, sources, sources_length1, _callback_, _user_data_);
}


void unity_scope_service_set_active_sources_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->set_active_sources_finish (self, _res_, error);
}


static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOXED) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}


static void unity_scope_service_base_init (UnityScopeServiceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("changed", UNITY_TYPE_SCOPE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, UNITY_TYPE_SCOPE_INFO);
		g_signal_new ("search_finished", UNITY_TYPE_SCOPE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_HASH_TABLE);
		g_signal_new ("global_search_finished", UNITY_TYPE_SCOPE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_HASH_TABLE);
	}
}


/**
 * ScopeService:
 *
 * The Scope interface exported on DBus
 */
GType unity_scope_service_get_type (void) {
	static volatile gsize unity_scope_service_type_id__volatile = 0;
	if (g_once_init_enter (&unity_scope_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityScopeServiceIface), (GBaseInitFunc) unity_scope_service_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType unity_scope_service_type_id;
		unity_scope_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "UnityScopeService", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (unity_scope_service_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (unity_scope_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) unity_scope_service_proxy_get_type);
		g_type_set_qdata (unity_scope_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.canonical.Unity.Scope");
		g_type_set_qdata (unity_scope_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) unity_scope_service_register_object);
		g_once_init_leave (&unity_scope_service_type_id__volatile, unity_scope_service_type_id);
	}
	return unity_scope_service_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (UnityScopeServiceProxy, unity_scope_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (UNITY_TYPE_SCOPE_SERVICE, unity_scope_service_proxy_unity_scope_service_interface_init) )
static void unity_scope_service_proxy_class_init (UnityScopeServiceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = unity_scope_service_proxy_g_signal;
}


static void _dbus_handle_unity_scope_service_changed (UnityScopeService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	UnityScopeInfo lens_info = {0};
	GVariant* _tmp114_;
	UnityScopeInfo _tmp115_;
	GVariantIter _tmp116_;
	GVariant* _tmp117_;
	GVariant* _tmp118_;
	gchar** _tmp119_;
	int _tmp119__length;
	int _tmp119__size;
	int _tmp119__length1;
	GVariantIter _tmp120_;
	GVariant* _tmp121_;
	GVariant* _tmp122_;
	GVariant* _tmp123_;
	GVariant* _tmp124_;
	GVariant* _tmp125_;
	GVariant* _tmp126_;
	GVariant* _tmp127_;
	GHashTable* _tmp128_;
	GVariantIter _tmp129_;
	GVariant* _tmp130_;
	GVariant* _tmp131_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp114_ = g_variant_iter_next_value (&_arguments_iter);
	g_variant_iter_init (&_tmp116_, _tmp114_);
	_tmp117_ = g_variant_iter_next_value (&_tmp116_);
	_tmp115_.dbus_path = g_variant_dup_string (_tmp117_, NULL);
	g_variant_unref (_tmp117_);
	_tmp118_ = g_variant_iter_next_value (&_tmp116_);
	_tmp119_ = g_new (gchar*, 5);
	_tmp119__length = 0;
	_tmp119__size = 4;
	_tmp119__length1 = 0;
	g_variant_iter_init (&_tmp120_, _tmp118_);
	for (; (_tmp121_ = g_variant_iter_next_value (&_tmp120_)) != NULL; _tmp119__length1++) {
		if (_tmp119__size == _tmp119__length) {
			_tmp119__size = 2 * _tmp119__size;
			_tmp119_ = g_renew (gchar*, _tmp119_, _tmp119__size + 1);
		}
		_tmp119_[_tmp119__length++] = g_variant_dup_string (_tmp121_, NULL);
		g_variant_unref (_tmp121_);
	}
	_tmp115_.sources_length1 = _tmp119__length1;
	_tmp119_[_tmp119__length] = NULL;
	_tmp115_.sources = _tmp119_;
	g_variant_unref (_tmp118_);
	_tmp122_ = g_variant_iter_next_value (&_tmp116_);
	_tmp115_.search_in_global = g_variant_get_boolean (_tmp122_);
	g_variant_unref (_tmp122_);
	_tmp123_ = g_variant_iter_next_value (&_tmp116_);
	_tmp115_.private_connection_name = g_variant_dup_string (_tmp123_, NULL);
	g_variant_unref (_tmp123_);
	_tmp124_ = g_variant_iter_next_value (&_tmp116_);
	_tmp115_.results_model_name = g_variant_dup_string (_tmp124_, NULL);
	g_variant_unref (_tmp124_);
	_tmp125_ = g_variant_iter_next_value (&_tmp116_);
	_tmp115_.global_results_model_name = g_variant_dup_string (_tmp125_, NULL);
	g_variant_unref (_tmp125_);
	_tmp126_ = g_variant_iter_next_value (&_tmp116_);
	_tmp115_.filters_model_name = g_variant_dup_string (_tmp126_, NULL);
	g_variant_unref (_tmp126_);
	_tmp127_ = g_variant_iter_next_value (&_tmp116_);
	_tmp128_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp129_, _tmp127_);
	while (g_variant_iter_loop (&_tmp129_, "{?*}", &_tmp130_, &_tmp131_)) {
		g_hash_table_insert (_tmp128_, g_variant_dup_string (_tmp130_, NULL), g_variant_get_variant (_tmp131_));
	}
	_tmp115_.hints = _tmp128_;
	g_variant_unref (_tmp127_);
	lens_info = _tmp115_;
	g_variant_unref (_tmp114_);
	g_signal_emit_by_name (self, "changed", &lens_info);
	unity_scope_info_destroy (&lens_info);
}


static void _dbus_handle_unity_scope_service_search_finished (UnityScopeService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* search_string = NULL;
	GVariant* _tmp132_;
	GHashTable* hints = NULL;
	GVariant* _tmp133_;
	GHashTable* _tmp134_;
	GVariantIter _tmp135_;
	GVariant* _tmp136_;
	GVariant* _tmp137_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp132_ = g_variant_iter_next_value (&_arguments_iter);
	search_string = g_variant_dup_string (_tmp132_, NULL);
	g_variant_unref (_tmp132_);
	_tmp133_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp134_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp135_, _tmp133_);
	while (g_variant_iter_loop (&_tmp135_, "{?*}", &_tmp136_, &_tmp137_)) {
		g_hash_table_insert (_tmp134_, g_variant_dup_string (_tmp136_, NULL), g_variant_get_variant (_tmp137_));
	}
	hints = _tmp134_;
	g_variant_unref (_tmp133_);
	g_signal_emit_by_name (self, "search-finished", search_string, hints);
	_g_free0 (search_string);
	_g_hash_table_unref0 (hints);
}


static void _dbus_handle_unity_scope_service_global_search_finished (UnityScopeService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* search_string = NULL;
	GVariant* _tmp138_;
	GHashTable* hints = NULL;
	GVariant* _tmp139_;
	GHashTable* _tmp140_;
	GVariantIter _tmp141_;
	GVariant* _tmp142_;
	GVariant* _tmp143_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp138_ = g_variant_iter_next_value (&_arguments_iter);
	search_string = g_variant_dup_string (_tmp138_, NULL);
	g_variant_unref (_tmp138_);
	_tmp139_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp140_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp141_, _tmp139_);
	while (g_variant_iter_loop (&_tmp141_, "{?*}", &_tmp142_, &_tmp143_)) {
		g_hash_table_insert (_tmp140_, g_variant_dup_string (_tmp142_, NULL), g_variant_get_variant (_tmp143_));
	}
	hints = _tmp140_;
	g_variant_unref (_tmp139_);
	g_signal_emit_by_name (self, "global-search-finished", search_string, hints);
	_g_free0 (search_string);
	_g_hash_table_unref0 (hints);
}


static void unity_scope_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "Changed") == 0) {
		_dbus_handle_unity_scope_service_changed ((UnityScopeService*) proxy, parameters);
	} else if (strcmp (signal_name, "SearchFinished") == 0) {
		_dbus_handle_unity_scope_service_search_finished ((UnityScopeService*) proxy, parameters);
	} else if (strcmp (signal_name, "GlobalSearchFinished") == 0) {
		_dbus_handle_unity_scope_service_global_search_finished ((UnityScopeService*) proxy, parameters);
	}
}


static void unity_scope_service_proxy_init (UnityScopeServiceProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void unity_scope_service_proxy_info_request_async (UnityScopeService* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Scope", "InfoRequest");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_scope_service_proxy_info_request_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_scope_service_proxy_activate_async (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Scope", "Activate");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uri));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (action_type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_scope_service_proxy_activate_finish (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _tmp144_;
	UnityActivationReplyRaw _tmp145_;
	GVariantIter _tmp146_;
	GVariant* _tmp147_;
	GVariant* _tmp148_;
	GVariant* _tmp149_;
	GHashTable* _tmp150_;
	GVariantIter _tmp151_;
	GVariant* _tmp152_;
	GVariant* _tmp153_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp144_ = g_variant_iter_next_value (&_reply_iter);
	g_variant_iter_init (&_tmp146_, _tmp144_);
	_tmp147_ = g_variant_iter_next_value (&_tmp146_);
	_tmp145_.uri = g_variant_dup_string (_tmp147_, NULL);
	g_variant_unref (_tmp147_);
	_tmp148_ = g_variant_iter_next_value (&_tmp146_);
	_tmp145_.handled = g_variant_get_uint32 (_tmp148_);
	g_variant_unref (_tmp148_);
	_tmp149_ = g_variant_iter_next_value (&_tmp146_);
	_tmp150_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp151_, _tmp149_);
	while (g_variant_iter_loop (&_tmp151_, "{?*}", &_tmp152_, &_tmp153_)) {
		g_hash_table_insert (_tmp150_, g_variant_dup_string (_tmp152_, NULL), g_variant_get_variant (_tmp153_));
	}
	_tmp145_.hints = _tmp150_;
	g_variant_unref (_tmp149_);
	*result = _tmp145_;
	g_variant_unref (_tmp144_);
	g_object_unref (_reply_message);
}


static void unity_scope_service_proxy_search_async (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp154_;
	GHashTableIter _tmp155_;
	gpointer _tmp156_;
	gpointer _tmp157_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Scope", "Search");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (search_string));
	g_hash_table_iter_init (&_tmp155_, hints);
	g_variant_builder_init (&_tmp154_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp155_, &_tmp156_, &_tmp157_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp156_;
		_value = (GVariant*) _tmp157_;
		g_variant_builder_add (&_tmp154_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp154_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_scope_service_proxy_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_scope_service_proxy_global_search_async (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp158_;
	GHashTableIter _tmp159_;
	gpointer _tmp160_;
	gpointer _tmp161_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Scope", "GlobalSearch");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (search_string));
	g_hash_table_iter_init (&_tmp159_, hints);
	g_variant_builder_init (&_tmp158_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp159_, &_tmp160_, &_tmp161_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp160_;
		_value = (GVariant*) _tmp161_;
		g_variant_builder_add (&_tmp158_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp158_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_scope_service_proxy_global_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_scope_service_proxy_preview_async (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Scope", "Preview");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uri));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_scope_service_proxy_preview_finish (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _tmp162_;
	UnityPreviewReplyRaw _tmp163_;
	GVariantIter _tmp164_;
	GVariant* _tmp165_;
	GVariant* _tmp166_;
	GVariant* _tmp167_;
	GHashTable* _tmp168_;
	GVariantIter _tmp169_;
	GVariant* _tmp170_;
	GVariant* _tmp171_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp162_ = g_variant_iter_next_value (&_reply_iter);
	g_variant_iter_init (&_tmp164_, _tmp162_);
	_tmp165_ = g_variant_iter_next_value (&_tmp164_);
	_tmp163_.uri = g_variant_dup_string (_tmp165_, NULL);
	g_variant_unref (_tmp165_);
	_tmp166_ = g_variant_iter_next_value (&_tmp164_);
	_tmp163_.renderer_name = g_variant_dup_string (_tmp166_, NULL);
	g_variant_unref (_tmp166_);
	_tmp167_ = g_variant_iter_next_value (&_tmp164_);
	_tmp168_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp169_, _tmp167_);
	while (g_variant_iter_loop (&_tmp169_, "{?*}", &_tmp170_, &_tmp171_)) {
		g_hash_table_insert (_tmp168_, g_variant_dup_string (_tmp170_, NULL), g_variant_get_variant (_tmp171_));
	}
	_tmp163_.properties = _tmp168_;
	g_variant_unref (_tmp167_);
	*result = _tmp163_;
	g_variant_unref (_tmp162_);
	g_object_unref (_reply_message);
}


static void unity_scope_service_proxy_set_active_async (UnityScopeService* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Scope", "SetActive");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (active));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_scope_service_proxy_set_active_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_scope_service_proxy_set_active_sources_async (UnityScopeService* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp172_;
	GVariantBuilder _tmp173_;
	int _tmp174_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Scope", "SetActiveSources");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp172_ = sources;
	g_variant_builder_init (&_tmp173_, G_VARIANT_TYPE ("as"));
	for (_tmp174_ = 0; _tmp174_ < sources_length1; _tmp174_++) {
		g_variant_builder_add_value (&_tmp173_, g_variant_new_string (*_tmp172_));
		_tmp172_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp173_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_scope_service_proxy_set_active_sources_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_scope_service_proxy_unity_scope_service_interface_init (UnityScopeServiceIface* iface) {
	iface->info_request = unity_scope_service_proxy_info_request_async;
	iface->info_request_finish = unity_scope_service_proxy_info_request_finish;
	iface->activate = unity_scope_service_proxy_activate_async;
	iface->activate_finish = unity_scope_service_proxy_activate_finish;
	iface->search = unity_scope_service_proxy_search_async;
	iface->search_finish = unity_scope_service_proxy_search_finish;
	iface->global_search = unity_scope_service_proxy_global_search_async;
	iface->global_search_finish = unity_scope_service_proxy_global_search_finish;
	iface->preview = unity_scope_service_proxy_preview_async;
	iface->preview_finish = unity_scope_service_proxy_preview_finish;
	iface->set_active = unity_scope_service_proxy_set_active_async;
	iface->set_active_finish = unity_scope_service_proxy_set_active_finish;
	iface->set_active_sources = unity_scope_service_proxy_set_active_sources_async;
	iface->set_active_sources_finish = unity_scope_service_proxy_set_active_sources_finish;
}


static void _dbus_unity_scope_service_info_request (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	unity_scope_service_info_request (self, (GAsyncReadyCallback) _dbus_unity_scope_service_info_request_ready, invocation);
}


static void _dbus_unity_scope_service_info_request_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_scope_service_info_request_finish ((UnityScopeService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_scope_service_activate (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* uri = NULL;
	GVariant* _tmp175_;
	guint action_type = 0U;
	GVariant* _tmp176_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp175_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp175_, NULL);
	g_variant_unref (_tmp175_);
	_tmp176_ = g_variant_iter_next_value (&_arguments_iter);
	action_type = g_variant_get_uint32 (_tmp176_);
	g_variant_unref (_tmp176_);
	unity_scope_service_activate (self, uri, action_type, (GAsyncReadyCallback) _dbus_unity_scope_service_activate_ready, invocation);
	_g_free0 (uri);
}


static void _dbus_unity_scope_service_activate_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	UnityActivationReplyRaw result = {0};
	GVariantBuilder _tmp177_;
	GVariantBuilder _tmp178_;
	GHashTableIter _tmp179_;
	gpointer _tmp180_;
	gpointer _tmp181_;
	invocation = _user_data_;
	unity_scope_service_activate_finish ((UnityScopeService*) source_object, _res_, &result, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp177_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp177_, g_variant_new_string (result.uri));
	g_variant_builder_add_value (&_tmp177_, g_variant_new_uint32 (result.handled));
	g_hash_table_iter_init (&_tmp179_, result.hints);
	g_variant_builder_init (&_tmp178_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp179_, &_tmp180_, &_tmp181_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp180_;
		_value = (GVariant*) _tmp181_;
		g_variant_builder_add (&_tmp178_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_tmp177_, g_variant_builder_end (&_tmp178_));
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp177_));
	unity_activation_reply_raw_destroy (& result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_scope_service_search (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* search_string = NULL;
	GVariant* _tmp182_;
	GHashTable* hints = NULL;
	GVariant* _tmp183_;
	GHashTable* _tmp184_;
	GVariantIter _tmp185_;
	GVariant* _tmp186_;
	GVariant* _tmp187_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp182_ = g_variant_iter_next_value (&_arguments_iter);
	search_string = g_variant_dup_string (_tmp182_, NULL);
	g_variant_unref (_tmp182_);
	_tmp183_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp184_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp185_, _tmp183_);
	while (g_variant_iter_loop (&_tmp185_, "{?*}", &_tmp186_, &_tmp187_)) {
		g_hash_table_insert (_tmp184_, g_variant_dup_string (_tmp186_, NULL), g_variant_get_variant (_tmp187_));
	}
	hints = _tmp184_;
	g_variant_unref (_tmp183_);
	unity_scope_service_search (self, search_string, hints, (GAsyncReadyCallback) _dbus_unity_scope_service_search_ready, invocation);
	_g_free0 (search_string);
	_g_hash_table_unref0 (hints);
}


static void _dbus_unity_scope_service_search_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_scope_service_search_finish ((UnityScopeService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_scope_service_global_search (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* search_string = NULL;
	GVariant* _tmp188_;
	GHashTable* hints = NULL;
	GVariant* _tmp189_;
	GHashTable* _tmp190_;
	GVariantIter _tmp191_;
	GVariant* _tmp192_;
	GVariant* _tmp193_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp188_ = g_variant_iter_next_value (&_arguments_iter);
	search_string = g_variant_dup_string (_tmp188_, NULL);
	g_variant_unref (_tmp188_);
	_tmp189_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp190_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp191_, _tmp189_);
	while (g_variant_iter_loop (&_tmp191_, "{?*}", &_tmp192_, &_tmp193_)) {
		g_hash_table_insert (_tmp190_, g_variant_dup_string (_tmp192_, NULL), g_variant_get_variant (_tmp193_));
	}
	hints = _tmp190_;
	g_variant_unref (_tmp189_);
	unity_scope_service_global_search (self, search_string, hints, (GAsyncReadyCallback) _dbus_unity_scope_service_global_search_ready, invocation);
	_g_free0 (search_string);
	_g_hash_table_unref0 (hints);
}


static void _dbus_unity_scope_service_global_search_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_scope_service_global_search_finish ((UnityScopeService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_scope_service_preview (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* uri = NULL;
	GVariant* _tmp194_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp194_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp194_, NULL);
	g_variant_unref (_tmp194_);
	unity_scope_service_preview (self, uri, (GAsyncReadyCallback) _dbus_unity_scope_service_preview_ready, invocation);
	_g_free0 (uri);
}


static void _dbus_unity_scope_service_preview_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	UnityPreviewReplyRaw result = {0};
	GVariantBuilder _tmp195_;
	GVariantBuilder _tmp196_;
	GHashTableIter _tmp197_;
	gpointer _tmp198_;
	gpointer _tmp199_;
	invocation = _user_data_;
	unity_scope_service_preview_finish ((UnityScopeService*) source_object, _res_, &result, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp195_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp195_, g_variant_new_string (result.uri));
	g_variant_builder_add_value (&_tmp195_, g_variant_new_string (result.renderer_name));
	g_hash_table_iter_init (&_tmp197_, result.properties);
	g_variant_builder_init (&_tmp196_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp197_, &_tmp198_, &_tmp199_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp198_;
		_value = (GVariant*) _tmp199_;
		g_variant_builder_add (&_tmp196_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_tmp195_, g_variant_builder_end (&_tmp196_));
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp195_));
	unity_preview_reply_raw_destroy (& result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_scope_service_set_active (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gboolean active = FALSE;
	GVariant* _tmp200_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp200_ = g_variant_iter_next_value (&_arguments_iter);
	active = g_variant_get_boolean (_tmp200_);
	g_variant_unref (_tmp200_);
	unity_scope_service_set_active (self, active, (GAsyncReadyCallback) _dbus_unity_scope_service_set_active_ready, invocation);
}


static void _dbus_unity_scope_service_set_active_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_scope_service_set_active_finish ((UnityScopeService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_scope_service_set_active_sources (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar** sources = NULL;
	int sources_length1 = 0;
	GVariant* _tmp201_;
	gchar** _tmp202_;
	int _tmp202__length;
	int _tmp202__size;
	int _tmp202__length1;
	GVariantIter _tmp203_;
	GVariant* _tmp204_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp201_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp202_ = g_new (gchar*, 5);
	_tmp202__length = 0;
	_tmp202__size = 4;
	_tmp202__length1 = 0;
	g_variant_iter_init (&_tmp203_, _tmp201_);
	for (; (_tmp204_ = g_variant_iter_next_value (&_tmp203_)) != NULL; _tmp202__length1++) {
		if (_tmp202__size == _tmp202__length) {
			_tmp202__size = 2 * _tmp202__size;
			_tmp202_ = g_renew (gchar*, _tmp202_, _tmp202__size + 1);
		}
		_tmp202_[_tmp202__length++] = g_variant_dup_string (_tmp204_, NULL);
		g_variant_unref (_tmp204_);
	}
	sources_length1 = _tmp202__length1;
	_tmp202_[_tmp202__length] = NULL;
	sources = _tmp202_;
	g_variant_unref (_tmp201_);
	unity_scope_service_set_active_sources (self, sources, sources_length1, (GAsyncReadyCallback) _dbus_unity_scope_service_set_active_sources_ready, invocation);
	sources = (_vala_array_free (sources, sources_length1, (GDestroyNotify) g_free), NULL);
}


static void _dbus_unity_scope_service_set_active_sources_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_scope_service_set_active_sources_finish ((UnityScopeService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void unity_scope_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "InfoRequest") == 0) {
		_dbus_unity_scope_service_info_request (object, parameters, invocation);
	} else if (strcmp (method_name, "Activate") == 0) {
		_dbus_unity_scope_service_activate (object, parameters, invocation);
	} else if (strcmp (method_name, "Search") == 0) {
		_dbus_unity_scope_service_search (object, parameters, invocation);
	} else if (strcmp (method_name, "GlobalSearch") == 0) {
		_dbus_unity_scope_service_global_search (object, parameters, invocation);
	} else if (strcmp (method_name, "Preview") == 0) {
		_dbus_unity_scope_service_preview (object, parameters, invocation);
	} else if (strcmp (method_name, "SetActive") == 0) {
		_dbus_unity_scope_service_set_active (object, parameters, invocation);
	} else if (strcmp (method_name, "SetActiveSources") == 0) {
		_dbus_unity_scope_service_set_active_sources (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* unity_scope_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean unity_scope_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_unity_scope_service_changed (GObject* _sender, UnityScopeInfo* lens_info, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp205_;
	gchar** _tmp206_;
	GVariantBuilder _tmp207_;
	int _tmp208_;
	GVariantBuilder _tmp209_;
	GHashTableIter _tmp210_;
	gpointer _tmp211_;
	gpointer _tmp212_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp205_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp205_, g_variant_new_string ((*lens_info).dbus_path));
	_tmp206_ = (*lens_info).sources;
	g_variant_builder_init (&_tmp207_, G_VARIANT_TYPE ("as"));
	for (_tmp208_ = 0; _tmp208_ < (*lens_info).sources_length1; _tmp208_++) {
		g_variant_builder_add_value (&_tmp207_, g_variant_new_string (*_tmp206_));
		_tmp206_++;
	}
	g_variant_builder_add_value (&_tmp205_, g_variant_builder_end (&_tmp207_));
	g_variant_builder_add_value (&_tmp205_, g_variant_new_boolean ((*lens_info).search_in_global));
	g_variant_builder_add_value (&_tmp205_, g_variant_new_string ((*lens_info).private_connection_name));
	g_variant_builder_add_value (&_tmp205_, g_variant_new_string ((*lens_info).results_model_name));
	g_variant_builder_add_value (&_tmp205_, g_variant_new_string ((*lens_info).global_results_model_name));
	g_variant_builder_add_value (&_tmp205_, g_variant_new_string ((*lens_info).filters_model_name));
	g_hash_table_iter_init (&_tmp210_, (*lens_info).hints);
	g_variant_builder_init (&_tmp209_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp210_, &_tmp211_, &_tmp212_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp211_;
		_value = (GVariant*) _tmp212_;
		g_variant_builder_add (&_tmp209_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_tmp205_, g_variant_builder_end (&_tmp209_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp205_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.Unity.Scope", "Changed", _arguments, NULL);
}


static void _dbus_unity_scope_service_search_finished (GObject* _sender, const gchar* search_string, GHashTable* hints, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp213_;
	GHashTableIter _tmp214_;
	gpointer _tmp215_;
	gpointer _tmp216_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (search_string));
	g_hash_table_iter_init (&_tmp214_, hints);
	g_variant_builder_init (&_tmp213_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp214_, &_tmp215_, &_tmp216_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp215_;
		_value = (GVariant*) _tmp216_;
		g_variant_builder_add (&_tmp213_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp213_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.Unity.Scope", "SearchFinished", _arguments, NULL);
}


static void _dbus_unity_scope_service_global_search_finished (GObject* _sender, const gchar* search_string, GHashTable* hints, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp217_;
	GHashTableIter _tmp218_;
	gpointer _tmp219_;
	gpointer _tmp220_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (search_string));
	g_hash_table_iter_init (&_tmp218_, hints);
	g_variant_builder_init (&_tmp217_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp218_, &_tmp219_, &_tmp220_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp219_;
		_value = (GVariant*) _tmp220_;
		g_variant_builder_add (&_tmp217_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp217_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.Unity.Scope", "GlobalSearchFinished", _arguments, NULL);
}


guint unity_scope_service_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_unity_scope_service_dbus_interface_info), &_unity_scope_service_dbus_interface_vtable, data, _unity_scope_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_unity_scope_service_changed, data);
	g_signal_connect (object, "search-finished", (GCallback) _dbus_unity_scope_service_search_finished, data);
	g_signal_connect (object, "global-search-finished", (GCallback) _dbus_unity_scope_service_global_search_finished, data);
	return result;
}


static void _unity_scope_service_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



