/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

using Unity.Test;

public class Main
{
  public static int main (string[] args)
  {
    IOSuite io;
    AppInfoManagerSuite appinfo_manager;
    LauncherSuite launcher;
    SoundMenuSuite sound_menu_test_suite;
    FilterSuite filter_suite;
    
    Environment.set_variable ("XDG_DATA_HOME", Config.TESTDIR+"/data", true);
    Test.init (ref args);

    /* Sound Menu tests */
    sound_menu_test_suite = new SoundMenuSuite();
     
    /* IO utility tests */
    io = new IOSuite ();
    appinfo_manager = new AppInfoManagerSuite ();
    
    launcher = new LauncherSuite ();
    
    /* Lens Filters */
    filter_suite = new FilterSuite ();

    Test.run ();

    return 0;
  }
}
