/* unity-scope-proxy-local.c generated by valac 0.14.2, the Vala compiler
 * generated from unity-scope-proxy-local.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "unity.h"
#include <dee.h>


#define UNITY_TYPE_SCOPE_PROXY (unity_scope_proxy_get_type ())
#define UNITY_SCOPE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_PROXY, UnityScopeProxy))
#define UNITY_IS_SCOPE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_PROXY))
#define UNITY_SCOPE_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_SCOPE_PROXY, UnityScopeProxyIface))

typedef struct _UnityScopeProxy UnityScopeProxy;
typedef struct _UnityScopeProxyIface UnityScopeProxyIface;

#define UNITY_TYPE_ACTIVATION_REPLY_RAW (unity_activation_reply_raw_get_type ())
typedef struct _UnityActivationReplyRaw UnityActivationReplyRaw;

#define UNITY_TYPE_PREVIEW_REPLY_RAW (unity_preview_reply_raw_get_type ())
typedef struct _UnityPreviewReplyRaw UnityPreviewReplyRaw;

#define UNITY_TYPE_VIEW_TYPE (unity_view_type_get_type ())

#define UNITY_TYPE_SCOPE_PROXY_LOCAL (unity_scope_proxy_local_get_type ())
#define UNITY_SCOPE_PROXY_LOCAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_PROXY_LOCAL, UnityScopeProxyLocal))
#define UNITY_SCOPE_PROXY_LOCAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SCOPE_PROXY_LOCAL, UnityScopeProxyLocalClass))
#define UNITY_IS_SCOPE_PROXY_LOCAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_PROXY_LOCAL))
#define UNITY_IS_SCOPE_PROXY_LOCAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SCOPE_PROXY_LOCAL))
#define UNITY_SCOPE_PROXY_LOCAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SCOPE_PROXY_LOCAL, UnityScopeProxyLocalClass))

typedef struct _UnityScopeProxyLocal UnityScopeProxyLocal;
typedef struct _UnityScopeProxyLocalClass UnityScopeProxyLocalClass;
typedef struct _UnityScopeProxyLocalPrivate UnityScopeProxyLocalPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _UnityScopeProxyLocalActivateData UnityScopeProxyLocalActivateData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnityScopeProxyLocalSearchData UnityScopeProxyLocalSearchData;
typedef struct _UnityScopeProxyLocalGlobalSearchData UnityScopeProxyLocalGlobalSearchData;
typedef struct _UnityScopeProxyLocalPreviewData UnityScopeProxyLocalPreviewData;
typedef struct _UnityScopeProxyLocalSetActiveSourcesData UnityScopeProxyLocalSetActiveSourcesData;

struct _UnityActivationReplyRaw {
	gchar* uri;
	guint handled;
	GHashTable* hints;
};

struct _UnityPreviewReplyRaw {
	gchar* uri;
	gchar* renderer_name;
	GHashTable* properties;
};

typedef enum  {
	UNITY_VIEW_TYPE_HIDDEN,
	UNITY_VIEW_TYPE_HOME_VIEW,
	UNITY_VIEW_TYPE_LENS_VIEW
} UnityViewType;

struct _UnityScopeProxyIface {
	GTypeInterface parent_iface;
	void (*activate) (UnityScopeProxy* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*activate_finish) (UnityScopeProxy* self, GAsyncResult* _res_, UnityActivationReplyRaw* result);
	void (*search) (UnityScopeProxy* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*search_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	void (*global_search) (UnityScopeProxy* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*global_search_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	void (*preview) (UnityScopeProxy* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*preview_finish) (UnityScopeProxy* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result);
	void (*set_active_sources) (UnityScopeProxy* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_sources_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	UnityOptionsFilter* (*get_sources) (UnityScopeProxy* self);
	void (*set_sources) (UnityScopeProxy* self, UnityOptionsFilter* value);
	gboolean (*get_search_in_global) (UnityScopeProxy* self);
	void (*set_search_in_global) (UnityScopeProxy* self, gboolean value);
	UnityViewType (*get_view_type) (UnityScopeProxy* self);
	void (*set_view_type) (UnityScopeProxy* self, UnityViewType value);
	DeeSerializableModel* (*get_results_model) (UnityScopeProxy* self);
	void (*set_results_model) (UnityScopeProxy* self, DeeSerializableModel* value);
	DeeSerializableModel* (*get_global_results_model) (UnityScopeProxy* self);
	void (*set_global_results_model) (UnityScopeProxy* self, DeeSerializableModel* value);
	DeeSerializableModel* (*get_filters_model) (UnityScopeProxy* self);
	void (*set_filters_model) (UnityScopeProxy* self, DeeSerializableModel* value);
};

struct _UnityScopeProxyLocal {
	GObject parent_instance;
	UnityScopeProxyLocalPrivate * priv;
};

struct _UnityScopeProxyLocalClass {
	GObjectClass parent_class;
};

struct _UnityScopeProxyLocalPrivate {
	UnityScope* _scope;
	UnityViewType _view_type;
};

struct _UnityScopeProxyLocalActivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeProxyLocal* self;
	gchar* uri;
	guint action_type;
	UnityActivationReplyRaw result;
	UnityScope* _tmp0_;
	const gchar* _tmp1_;
	guint _tmp2_;
	UnityActivationReplyRaw _tmp3_;
	UnityActivationReplyRaw reply;
};

struct _UnityScopeProxyLocalSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeProxyLocal* self;
	gchar* search_string;
	GHashTable* hints;
	GHashTable* result;
	UnityScope* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _result_;
	GError* scope_error;
	GError* e;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GHashFunc _tmp11_;
	GEqualFunc _tmp12_;
	GHashTable* _tmp13_;
	GError * _inner_error_;
};

struct _UnityScopeProxyLocalGlobalSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeProxyLocal* self;
	gchar* search_string;
	GHashTable* hints;
	GHashTable* result;
	UnityScope* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _result_;
	GError* scope_error;
	GError* e;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GHashFunc _tmp11_;
	GEqualFunc _tmp12_;
	GHashTable* _tmp13_;
	GError * _inner_error_;
};

struct _UnityScopeProxyLocalPreviewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeProxyLocal* self;
	gchar* uri;
	UnityPreviewReplyRaw result;
	UnityScope* _tmp0_;
	const gchar* _tmp1_;
	UnityPreviewReplyRaw _tmp2_;
	UnityPreviewReplyRaw reply;
};

struct _UnityScopeProxyLocalSetActiveSourcesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeProxyLocal* self;
	gchar** sources;
	gint sources_length1;
	UnityScope* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
};


static gpointer unity_scope_proxy_local_parent_class = NULL;
static UnityScopeProxyIface* unity_scope_proxy_local_unity_scope_proxy_parent_iface = NULL;

GType unity_activation_reply_raw_get_type (void) G_GNUC_CONST;
UnityActivationReplyRaw* unity_activation_reply_raw_dup (const UnityActivationReplyRaw* self);
void unity_activation_reply_raw_free (UnityActivationReplyRaw* self);
void unity_activation_reply_raw_copy (const UnityActivationReplyRaw* self, UnityActivationReplyRaw* dest);
void unity_activation_reply_raw_destroy (UnityActivationReplyRaw* self);
GType unity_preview_reply_raw_get_type (void) G_GNUC_CONST;
UnityPreviewReplyRaw* unity_preview_reply_raw_dup (const UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_free (UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_copy (const UnityPreviewReplyRaw* self, UnityPreviewReplyRaw* dest);
void unity_preview_reply_raw_destroy (UnityPreviewReplyRaw* self);
GType unity_view_type_get_type (void) G_GNUC_CONST;
GType unity_scope_proxy_get_type (void) G_GNUC_CONST;
GType unity_scope_proxy_local_get_type (void) G_GNUC_CONST;
#define UNITY_SCOPE_PROXY_LOCAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_SCOPE_PROXY_LOCAL, UnityScopeProxyLocalPrivate))
enum  {
	UNITY_SCOPE_PROXY_LOCAL_DUMMY_PROPERTY,
	UNITY_SCOPE_PROXY_LOCAL_SCOPE,
	UNITY_SCOPE_PROXY_LOCAL_SOURCES,
	UNITY_SCOPE_PROXY_LOCAL_SEARCH_IN_GLOBAL,
	UNITY_SCOPE_PROXY_LOCAL_RESULTS_MODEL,
	UNITY_SCOPE_PROXY_LOCAL_GLOBAL_RESULTS_MODEL,
	UNITY_SCOPE_PROXY_LOCAL_FILTERS_MODEL,
	UNITY_SCOPE_PROXY_LOCAL_VIEW_TYPE
};
UnityScopeProxyLocal* unity_scope_proxy_local_new (UnityScope* scope);
UnityScopeProxyLocal* unity_scope_proxy_local_construct (GType object_type, UnityScope* scope);
static void unity_scope_proxy_local_real_activate_data_free (gpointer _data);
static void unity_scope_proxy_local_real_activate (UnityScopeProxy* base, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_proxy_local_real_activate_co (UnityScopeProxyLocalActivateData* _data_);
UnityScope* unity_scope_proxy_local_get_scope (UnityScopeProxyLocal* self);
void unity_scope_activate (UnityScope* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_activate_finish (UnityScope* self, GAsyncResult* _res_, UnityActivationReplyRaw* result);
static void unity_scope_proxy_local_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_scope_proxy_local_real_search_data_free (gpointer _data);
static void unity_scope_proxy_local_real_search (UnityScopeProxy* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_proxy_local_real_search_co (UnityScopeProxyLocalSearchData* _data_);
void unity_scope_search (UnityScope* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* unity_scope_search_finish (UnityScope* self, GAsyncResult* _res_, GError** error);
static void unity_scope_proxy_local_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static void unity_scope_proxy_local_real_global_search_data_free (gpointer _data);
static void unity_scope_proxy_local_real_global_search (UnityScopeProxy* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_proxy_local_real_global_search_co (UnityScopeProxyLocalGlobalSearchData* _data_);
void unity_scope_global_search (UnityScope* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* unity_scope_global_search_finish (UnityScope* self, GAsyncResult* _res_, GError** error);
static void unity_scope_proxy_local_global_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_scope_proxy_local_real_preview_data_free (gpointer _data);
static void unity_scope_proxy_local_real_preview (UnityScopeProxy* base, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_proxy_local_real_preview_co (UnityScopeProxyLocalPreviewData* _data_);
void unity_scope_preview (UnityScope* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_preview_finish (UnityScope* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result);
static void unity_scope_proxy_local_preview_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_scope_proxy_local_real_set_active_sources_data_free (gpointer _data);
static void unity_scope_proxy_local_real_set_active_sources (UnityScopeProxy* base, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gboolean unity_scope_proxy_local_real_set_active_sources_co (UnityScopeProxyLocalSetActiveSourcesData* _data_);
void unity_scope_set_active_sources_internal (UnityScope* self, gchar** active_sources_, int active_sources__length1);
static void unity_scope_proxy_local_set_scope (UnityScopeProxyLocal* self, UnityScope* value);
DeeSerializableModel* unity_scope_get_filter_model (UnityScope* self);
static GObject * unity_scope_proxy_local_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _unity_scope_proxy_local___lambda6_ (UnityScopeProxyLocal* self);
static void __unity_scope_proxy_local___lambda6__unity_filter_changed (UnityFilter* _sender, gpointer self);
static void _unity_scope_proxy_local___lambda7_ (UnityScopeProxyLocal* self);
void unity_scope_set_view_type_internal (UnityScope* self, UnityViewType view_type);
UnityViewType unity_scope_proxy_get_view_type (UnityScopeProxy* self);
static void __unity_scope_proxy_local___lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _unity_scope_proxy_local___lambda8_ (UnityScopeProxyLocal* self);
static gboolean __unity_scope_proxy_local___lambda8__gsource_func (gpointer self);
static void unity_scope_proxy_local_finalize (GObject* obj);
UnityOptionsFilter* unity_scope_proxy_get_sources (UnityScopeProxy* self);
gboolean unity_scope_proxy_get_search_in_global (UnityScopeProxy* self);
DeeSerializableModel* unity_scope_proxy_get_results_model (UnityScopeProxy* self);
DeeSerializableModel* unity_scope_proxy_get_global_results_model (UnityScopeProxy* self);
DeeSerializableModel* unity_scope_proxy_get_filters_model (UnityScopeProxy* self);
static void _vala_unity_scope_proxy_local_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void unity_scope_proxy_set_sources (UnityScopeProxy* self, UnityOptionsFilter* value);
void unity_scope_proxy_set_search_in_global (UnityScopeProxy* self, gboolean value);
void unity_scope_proxy_set_results_model (UnityScopeProxy* self, DeeSerializableModel* value);
void unity_scope_proxy_set_global_results_model (UnityScopeProxy* self, DeeSerializableModel* value);
void unity_scope_proxy_set_filters_model (UnityScopeProxy* self, DeeSerializableModel* value);
void unity_scope_proxy_set_view_type (UnityScopeProxy* self, UnityViewType value);
static void _vala_unity_scope_proxy_local_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


UnityScopeProxyLocal* unity_scope_proxy_local_construct (GType object_type, UnityScope* scope) {
	UnityScopeProxyLocal * self = NULL;
	UnityScope* _tmp0_;
	g_return_val_if_fail (scope != NULL, NULL);
	_tmp0_ = scope;
	self = (UnityScopeProxyLocal*) g_object_new (object_type, "scope", _tmp0_, NULL);
	return self;
}


UnityScopeProxyLocal* unity_scope_proxy_local_new (UnityScope* scope) {
	return unity_scope_proxy_local_construct (UNITY_TYPE_SCOPE_PROXY_LOCAL, scope);
}


static void unity_scope_proxy_local_real_activate_data_free (gpointer _data) {
	UnityScopeProxyLocalActivateData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	unity_activation_reply_raw_destroy (&_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeProxyLocalActivateData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void unity_scope_proxy_local_real_activate (UnityScopeProxy* base, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeProxyLocal * self;
	UnityScopeProxyLocalActivateData* _data_;
	UnityScopeProxyLocal* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	guint _tmp3_;
	self = (UnityScopeProxyLocal*) base;
	_data_ = g_slice_new0 (UnityScopeProxyLocalActivateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_proxy_local_real_activate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_proxy_local_real_activate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->uri = _tmp2_;
	_tmp3_ = action_type;
	_data_->action_type = _tmp3_;
	unity_scope_proxy_local_real_activate_co (_data_);
}


static void unity_scope_proxy_local_real_activate_finish (UnityScopeProxy* base, GAsyncResult* _res_, UnityActivationReplyRaw* result) {
	UnityScopeProxyLocalActivateData* _data_;
	UnityActivationReplyRaw _tmp0_ = {0};
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	unity_activation_reply_raw_copy (&_data_->result, &_tmp0_);
	*result = _tmp0_;
}


static void unity_scope_proxy_local_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeProxyLocalActivateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_proxy_local_real_activate_co (_data_);
}


static gboolean unity_scope_proxy_local_real_activate_co (UnityScopeProxyLocalActivateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_scope;
	_data_->_tmp1_ = _data_->uri;
	_data_->_tmp2_ = _data_->action_type;
	memset (&_data_->_tmp3_, 0, sizeof (UnityActivationReplyRaw));
	_data_->_state_ = 1;
	unity_scope_activate (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, unity_scope_proxy_local_activate_ready, _data_);
	return FALSE;
	_state_1:
	unity_scope_activate_finish (_data_->_tmp0_, _data_->_res_, &_data_->_tmp3_);
	_data_->reply = _data_->_tmp3_;
	_data_->result = _data_->reply;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	unity_activation_reply_raw_destroy (&_data_->reply);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_proxy_local_real_search_data_free (gpointer _data) {
	UnityScopeProxyLocalSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search_string);
	_g_hash_table_unref0 (_data_->hints);
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeProxyLocalSearchData, _data_);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void unity_scope_proxy_local_real_search (UnityScopeProxy* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeProxyLocal * self;
	UnityScopeProxyLocalSearchData* _data_;
	UnityScopeProxyLocal* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	self = (UnityScopeProxyLocal*) base;
	_data_ = g_slice_new0 (UnityScopeProxyLocalSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_proxy_local_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_proxy_local_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search_string;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->search_string = _tmp2_;
	_tmp3_ = hints;
	_tmp4_ = _g_hash_table_ref0 (_tmp3_);
	_data_->hints = _tmp4_;
	unity_scope_proxy_local_real_search_co (_data_);
}


static GHashTable* unity_scope_proxy_local_real_search_finish (UnityScopeProxy* base, GAsyncResult* _res_) {
	GHashTable* result;
	UnityScopeProxyLocalSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void unity_scope_proxy_local_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeProxyLocalSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_proxy_local_real_search_co (_data_);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static gboolean unity_scope_proxy_local_real_search_co (UnityScopeProxyLocalSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_scope;
		_data_->_tmp1_ = _data_->search_string;
		_data_->_tmp2_ = _data_->hints;
		_data_->_state_ = 1;
		unity_scope_search (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, unity_scope_proxy_local_search_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = unity_scope_search_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
		_data_->_result_ = _data_->_tmp3_;
		if (_data_->_inner_error_ != NULL) {
			if (g_error_matches (_data_->_inner_error_, UNITY_SCOPE_ERROR, UNITY_SCOPE_ERROR_SEARCH_CANCELLED)) {
				goto __catch23_unity_scope_error_search_cancelled;
			}
			goto __catch23_g_error;
		}
		_data_->result = _data_->_result_;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally23;
	__catch23_unity_scope_error_search_cancelled:
	{
		_data_->scope_error = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->scope_error);
	}
	goto __finally23;
	__catch23_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp4_ = _data_->search_string;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = string_to_string (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->e;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = string_to_string (_data_->_tmp7_);
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = g_strconcat ("Unable to search scope ('", _data_->_tmp5_, "'): ", _data_->_tmp8_, NULL);
		_data_->_tmp10_ = _data_->_tmp9_;
		g_warning ("unity-scope-proxy-local.vala:97: %s", _data_->_tmp10_);
		_g_free0 (_data_->_tmp10_);
		_g_error_free0 (_data_->e);
	}
	__finally23:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp11_ = g_str_hash;
	_data_->_tmp12_ = g_str_equal;
	_data_->_tmp13_ = g_hash_table_new_full (_data_->_tmp11_, _data_->_tmp12_, _g_free0_, _g_variant_unref0_);
	_data_->result = _data_->_tmp13_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_proxy_local_real_global_search_data_free (gpointer _data) {
	UnityScopeProxyLocalGlobalSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search_string);
	_g_hash_table_unref0 (_data_->hints);
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeProxyLocalGlobalSearchData, _data_);
}


static void unity_scope_proxy_local_real_global_search (UnityScopeProxy* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeProxyLocal * self;
	UnityScopeProxyLocalGlobalSearchData* _data_;
	UnityScopeProxyLocal* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	self = (UnityScopeProxyLocal*) base;
	_data_ = g_slice_new0 (UnityScopeProxyLocalGlobalSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_proxy_local_real_global_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_proxy_local_real_global_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search_string;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->search_string = _tmp2_;
	_tmp3_ = hints;
	_tmp4_ = _g_hash_table_ref0 (_tmp3_);
	_data_->hints = _tmp4_;
	unity_scope_proxy_local_real_global_search_co (_data_);
}


static GHashTable* unity_scope_proxy_local_real_global_search_finish (UnityScopeProxy* base, GAsyncResult* _res_) {
	GHashTable* result;
	UnityScopeProxyLocalGlobalSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void unity_scope_proxy_local_global_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeProxyLocalGlobalSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_proxy_local_real_global_search_co (_data_);
}


static gboolean unity_scope_proxy_local_real_global_search_co (UnityScopeProxyLocalGlobalSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_scope;
		_data_->_tmp1_ = _data_->search_string;
		_data_->_tmp2_ = _data_->hints;
		_data_->_state_ = 1;
		unity_scope_global_search (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, unity_scope_proxy_local_global_search_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = unity_scope_global_search_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
		_data_->_result_ = _data_->_tmp3_;
		if (_data_->_inner_error_ != NULL) {
			if (g_error_matches (_data_->_inner_error_, UNITY_SCOPE_ERROR, UNITY_SCOPE_ERROR_SEARCH_CANCELLED)) {
				goto __catch24_unity_scope_error_search_cancelled;
			}
			goto __catch24_g_error;
		}
		_data_->result = _data_->_result_;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally24;
	__catch24_unity_scope_error_search_cancelled:
	{
		_data_->scope_error = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->scope_error);
	}
	goto __finally24;
	__catch24_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp4_ = _data_->search_string;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = string_to_string (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->e;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = string_to_string (_data_->_tmp7_);
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = g_strconcat ("Unable to global_search scope ('", _data_->_tmp5_, "'): ", _data_->_tmp8_, NULL);
		_data_->_tmp10_ = _data_->_tmp9_;
		g_warning ("unity-scope-proxy-local.vala:112: %s", _data_->_tmp10_);
		_g_free0 (_data_->_tmp10_);
		_g_error_free0 (_data_->e);
	}
	__finally24:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp11_ = g_str_hash;
	_data_->_tmp12_ = g_str_equal;
	_data_->_tmp13_ = g_hash_table_new_full (_data_->_tmp11_, _data_->_tmp12_, _g_free0_, _g_variant_unref0_);
	_data_->result = _data_->_tmp13_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_proxy_local_real_preview_data_free (gpointer _data) {
	UnityScopeProxyLocalPreviewData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	unity_preview_reply_raw_destroy (&_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeProxyLocalPreviewData, _data_);
}


static void unity_scope_proxy_local_real_preview (UnityScopeProxy* base, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeProxyLocal * self;
	UnityScopeProxyLocalPreviewData* _data_;
	UnityScopeProxyLocal* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = (UnityScopeProxyLocal*) base;
	_data_ = g_slice_new0 (UnityScopeProxyLocalPreviewData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_proxy_local_real_preview);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_proxy_local_real_preview_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->uri = _tmp2_;
	unity_scope_proxy_local_real_preview_co (_data_);
}


static void unity_scope_proxy_local_real_preview_finish (UnityScopeProxy* base, GAsyncResult* _res_, UnityPreviewReplyRaw* result) {
	UnityScopeProxyLocalPreviewData* _data_;
	UnityPreviewReplyRaw _tmp0_ = {0};
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	unity_preview_reply_raw_copy (&_data_->result, &_tmp0_);
	*result = _tmp0_;
}


static void unity_scope_proxy_local_preview_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeProxyLocalPreviewData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_proxy_local_real_preview_co (_data_);
}


static gboolean unity_scope_proxy_local_real_preview_co (UnityScopeProxyLocalPreviewData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_scope;
	_data_->_tmp1_ = _data_->uri;
	memset (&_data_->_tmp2_, 0, sizeof (UnityPreviewReplyRaw));
	_data_->_state_ = 1;
	unity_scope_preview (_data_->_tmp0_, _data_->_tmp1_, unity_scope_proxy_local_preview_ready, _data_);
	return FALSE;
	_state_1:
	unity_scope_preview_finish (_data_->_tmp0_, _data_->_res_, &_data_->_tmp2_);
	_data_->reply = _data_->_tmp2_;
	_data_->result = _data_->reply;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	unity_preview_reply_raw_destroy (&_data_->reply);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_proxy_local_real_set_active_sources_data_free (gpointer _data) {
	UnityScopeProxyLocalSetActiveSourcesData* _data_;
	_data_ = _data;
	_data_->sources = (_vala_array_free (_data_->sources, _data_->sources_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeProxyLocalSetActiveSourcesData, _data_);
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void unity_scope_proxy_local_real_set_active_sources (UnityScopeProxy* base, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeProxyLocal * self;
	UnityScopeProxyLocalSetActiveSourcesData* _data_;
	UnityScopeProxyLocal* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	self = (UnityScopeProxyLocal*) base;
	_data_ = g_slice_new0 (UnityScopeProxyLocalSetActiveSourcesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_proxy_local_real_set_active_sources);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_proxy_local_real_set_active_sources_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = sources;
	_tmp1__length1 = sources_length1;
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup5 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
	_tmp2__length1 = _tmp1__length1;
	_data_->sources = _tmp2_;
	_data_->sources_length1 = _tmp2__length1;
	unity_scope_proxy_local_real_set_active_sources_co (_data_);
}


static void unity_scope_proxy_local_real_set_active_sources_finish (UnityScopeProxy* base, GAsyncResult* _res_) {
	UnityScopeProxyLocalSetActiveSourcesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_scope_proxy_local_real_set_active_sources_co (UnityScopeProxyLocalSetActiveSourcesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_scope;
	_data_->_tmp1_ = _data_->sources;
	_data_->_tmp1__length1 = _data_->sources_length1;
	unity_scope_set_active_sources_internal (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp1__length1);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


UnityScope* unity_scope_proxy_local_get_scope (UnityScopeProxyLocal* self) {
	UnityScope* result;
	UnityScope* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scope;
	result = _tmp0_;
	return result;
}


static void unity_scope_proxy_local_set_scope (UnityScopeProxyLocal* self, UnityScope* value) {
	UnityScope* _tmp0_;
	UnityScope* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_scope);
	self->priv->_scope = _tmp1_;
	g_object_notify ((GObject *) self, "scope");
}


static UnityOptionsFilter* unity_scope_proxy_local_real_get_sources (UnityScopeProxy* base) {
	UnityOptionsFilter* result;
	UnityScopeProxyLocal* self;
	UnityScope* _tmp0_;
	UnityOptionsFilter* _tmp1_;
	UnityOptionsFilter* _tmp2_;
	self = (UnityScopeProxyLocal*) base;
	_tmp0_ = self->priv->_scope;
	_tmp1_ = unity_scope_get_sources (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void unity_scope_proxy_local_real_set_sources (UnityScopeProxy* base, UnityOptionsFilter* value) {
	UnityScopeProxyLocal* self;
	self = (UnityScopeProxyLocal*) base;
	g_object_notify ((GObject *) self, "sources");
}


static gboolean unity_scope_proxy_local_real_get_search_in_global (UnityScopeProxy* base) {
	gboolean result;
	UnityScopeProxyLocal* self;
	UnityScope* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (UnityScopeProxyLocal*) base;
	_tmp0_ = self->priv->_scope;
	_tmp1_ = unity_scope_get_search_in_global (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void unity_scope_proxy_local_real_set_search_in_global (UnityScopeProxy* base, gboolean value) {
	UnityScopeProxyLocal* self;
	self = (UnityScopeProxyLocal*) base;
	g_object_notify ((GObject *) self, "search-in-global");
}


static DeeSerializableModel* unity_scope_proxy_local_real_get_results_model (UnityScopeProxy* base) {
	DeeSerializableModel* result;
	UnityScopeProxyLocal* self;
	UnityScope* _tmp0_;
	DeeSerializableModel* _tmp1_;
	DeeSerializableModel* _tmp2_;
	self = (UnityScopeProxyLocal*) base;
	_tmp0_ = self->priv->_scope;
	_tmp1_ = unity_scope_get_results_model (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void unity_scope_proxy_local_real_set_results_model (UnityScopeProxy* base, DeeSerializableModel* value) {
	UnityScopeProxyLocal* self;
	self = (UnityScopeProxyLocal*) base;
	g_object_notify ((GObject *) self, "results-model");
}


static DeeSerializableModel* unity_scope_proxy_local_real_get_global_results_model (UnityScopeProxy* base) {
	DeeSerializableModel* result;
	UnityScopeProxyLocal* self;
	UnityScope* _tmp0_;
	DeeSerializableModel* _tmp1_;
	DeeSerializableModel* _tmp2_;
	self = (UnityScopeProxyLocal*) base;
	_tmp0_ = self->priv->_scope;
	_tmp1_ = unity_scope_get_global_results_model (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void unity_scope_proxy_local_real_set_global_results_model (UnityScopeProxy* base, DeeSerializableModel* value) {
	UnityScopeProxyLocal* self;
	self = (UnityScopeProxyLocal*) base;
	g_object_notify ((GObject *) self, "global-results-model");
}


static DeeSerializableModel* unity_scope_proxy_local_real_get_filters_model (UnityScopeProxy* base) {
	DeeSerializableModel* result;
	UnityScopeProxyLocal* self;
	UnityScope* _tmp0_;
	DeeSerializableModel* _tmp1_ = NULL;
	self = (UnityScopeProxyLocal*) base;
	_tmp0_ = self->priv->_scope;
	_tmp1_ = unity_scope_get_filter_model (_tmp0_);
	result = _tmp1_;
	return result;
}


static void unity_scope_proxy_local_real_set_filters_model (UnityScopeProxy* base, DeeSerializableModel* value) {
	UnityScopeProxyLocal* self;
	self = (UnityScopeProxyLocal*) base;
	g_object_notify ((GObject *) self, "filters-model");
}


static UnityViewType unity_scope_proxy_local_real_get_view_type (UnityScopeProxy* base) {
	UnityViewType result;
	UnityScopeProxyLocal* self;
	UnityViewType _tmp0_;
	self = (UnityScopeProxyLocal*) base;
	_tmp0_ = self->priv->_view_type;
	result = _tmp0_;
	return result;
}


static void unity_scope_proxy_local_real_set_view_type (UnityScopeProxy* base, UnityViewType value) {
	UnityScopeProxyLocal* self;
	UnityViewType _tmp0_;
	self = (UnityScopeProxyLocal*) base;
	_tmp0_ = value;
	self->priv->_view_type = _tmp0_;
	g_object_notify ((GObject *) self, "view-type");
}


static void _unity_scope_proxy_local___lambda6_ (UnityScopeProxyLocal* self) {
	g_object_notify ((GObject*) self, "sources");
}


static void __unity_scope_proxy_local___lambda6__unity_filter_changed (UnityFilter* _sender, gpointer self) {
	_unity_scope_proxy_local___lambda6_ (self);
}


static void _unity_scope_proxy_local___lambda7_ (UnityScopeProxyLocal* self) {
	UnityScope* _tmp0_;
	UnityViewType _tmp1_;
	UnityViewType _tmp2_;
	_tmp0_ = self->priv->_scope;
	_tmp1_ = unity_scope_proxy_get_view_type ((UnityScopeProxy*) self);
	_tmp2_ = _tmp1_;
	unity_scope_set_view_type_internal (_tmp0_, _tmp2_);
}


static void __unity_scope_proxy_local___lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_unity_scope_proxy_local___lambda7_ (self);
}


static gboolean _unity_scope_proxy_local___lambda8_ (UnityScopeProxyLocal* self) {
	gboolean result = FALSE;
	g_object_notify ((GObject*) self, "search-in-global");
	g_object_notify ((GObject*) self, "sources");
	result = FALSE;
	return result;
}


static gboolean __unity_scope_proxy_local___lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = _unity_scope_proxy_local___lambda8_ (self);
	return result;
}


static GObject * unity_scope_proxy_local_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityScopeProxyLocal * self;
	UnityScope* _tmp0_;
	UnityScope* _tmp1_;
	UnityOptionsFilter* _tmp2_;
	UnityOptionsFilter* _tmp3_;
	parent_class = G_OBJECT_CLASS (unity_scope_proxy_local_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_SCOPE_PROXY_LOCAL (obj);
	_tmp0_ = self->priv->_scope;
	g_object_bind_property_with_closures ((GObject*) _tmp0_, "search-in-global", (GObject*) self, "search-in-global", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp1_ = self->priv->_scope;
	_tmp2_ = unity_scope_get_sources (_tmp1_);
	_tmp3_ = _tmp2_;
	g_signal_connect_object ((UnityFilter*) _tmp3_, "changed", (GCallback) __unity_scope_proxy_local___lambda6__unity_filter_changed, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::view-type", (GCallback) __unity_scope_proxy_local___lambda7__g_object_notify, self, 0);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __unity_scope_proxy_local___lambda8__gsource_func, g_object_ref (self), g_object_unref);
	return obj;
}


static void unity_scope_proxy_local_class_init (UnityScopeProxyLocalClass * klass) {
	unity_scope_proxy_local_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityScopeProxyLocalPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_scope_proxy_local_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_scope_proxy_local_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_scope_proxy_local_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_scope_proxy_local_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_PROXY_LOCAL_SCOPE, g_param_spec_object ("scope", "scope", "scope", UNITY_TYPE_SCOPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_PROXY_LOCAL_SOURCES, g_param_spec_object ("sources", "sources", "sources", UNITY_TYPE_OPTIONS_FILTER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_PROXY_LOCAL_SEARCH_IN_GLOBAL, g_param_spec_boolean ("search-in-global", "search-in-global", "search-in-global", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_PROXY_LOCAL_RESULTS_MODEL, g_param_spec_object ("results-model", "results-model", "results-model", dee_serializable_model_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_PROXY_LOCAL_GLOBAL_RESULTS_MODEL, g_param_spec_object ("global-results-model", "global-results-model", "global-results-model", dee_serializable_model_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_PROXY_LOCAL_FILTERS_MODEL, g_param_spec_object ("filters-model", "filters-model", "filters-model", dee_serializable_model_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_PROXY_LOCAL_VIEW_TYPE, g_param_spec_enum ("view-type", "view-type", "view-type", UNITY_TYPE_VIEW_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_scope_proxy_local_unity_scope_proxy_interface_init (UnityScopeProxyIface * iface) {
	unity_scope_proxy_local_unity_scope_proxy_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*)(UnityScopeProxy*, const gchar*, guint, UnityActivationReplyRaw*)) unity_scope_proxy_local_real_activate;
	iface->activate_finish = unity_scope_proxy_local_real_activate_finish;
	iface->search = (GHashTable* (*)(UnityScopeProxy*, const gchar*, GHashTable*)) unity_scope_proxy_local_real_search;
	iface->search_finish = unity_scope_proxy_local_real_search_finish;
	iface->global_search = (GHashTable* (*)(UnityScopeProxy*, const gchar*, GHashTable*)) unity_scope_proxy_local_real_global_search;
	iface->global_search_finish = unity_scope_proxy_local_real_global_search_finish;
	iface->preview = (void (*)(UnityScopeProxy*, const gchar*, UnityPreviewReplyRaw*)) unity_scope_proxy_local_real_preview;
	iface->preview_finish = unity_scope_proxy_local_real_preview_finish;
	iface->set_active_sources = (void (*)(UnityScopeProxy*, gchar**, int)) unity_scope_proxy_local_real_set_active_sources;
	iface->set_active_sources_finish = unity_scope_proxy_local_real_set_active_sources_finish;
	iface->get_sources = unity_scope_proxy_local_real_get_sources;
	iface->set_sources = unity_scope_proxy_local_real_set_sources;
	iface->get_search_in_global = unity_scope_proxy_local_real_get_search_in_global;
	iface->set_search_in_global = unity_scope_proxy_local_real_set_search_in_global;
	iface->get_results_model = unity_scope_proxy_local_real_get_results_model;
	iface->set_results_model = unity_scope_proxy_local_real_set_results_model;
	iface->get_global_results_model = unity_scope_proxy_local_real_get_global_results_model;
	iface->set_global_results_model = unity_scope_proxy_local_real_set_global_results_model;
	iface->get_filters_model = unity_scope_proxy_local_real_get_filters_model;
	iface->set_filters_model = unity_scope_proxy_local_real_set_filters_model;
	iface->get_view_type = unity_scope_proxy_local_real_get_view_type;
	iface->set_view_type = unity_scope_proxy_local_real_set_view_type;
}


static void unity_scope_proxy_local_instance_init (UnityScopeProxyLocal * self) {
	self->priv = UNITY_SCOPE_PROXY_LOCAL_GET_PRIVATE (self);
}


static void unity_scope_proxy_local_finalize (GObject* obj) {
	UnityScopeProxyLocal * self;
	self = UNITY_SCOPE_PROXY_LOCAL (obj);
	_g_object_unref0 (self->priv->_scope);
	G_OBJECT_CLASS (unity_scope_proxy_local_parent_class)->finalize (obj);
}


GType unity_scope_proxy_local_get_type (void) {
	static volatile gsize unity_scope_proxy_local_type_id__volatile = 0;
	if (g_once_init_enter (&unity_scope_proxy_local_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityScopeProxyLocalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_scope_proxy_local_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityScopeProxyLocal), 0, (GInstanceInitFunc) unity_scope_proxy_local_instance_init, NULL };
		static const GInterfaceInfo unity_scope_proxy_info = { (GInterfaceInitFunc) unity_scope_proxy_local_unity_scope_proxy_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_scope_proxy_local_type_id;
		unity_scope_proxy_local_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityScopeProxyLocal", &g_define_type_info, 0);
		g_type_add_interface_static (unity_scope_proxy_local_type_id, UNITY_TYPE_SCOPE_PROXY, &unity_scope_proxy_info);
		g_once_init_leave (&unity_scope_proxy_local_type_id__volatile, unity_scope_proxy_local_type_id);
	}
	return unity_scope_proxy_local_type_id__volatile;
}


static void _vala_unity_scope_proxy_local_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityScopeProxyLocal * self;
	self = UNITY_SCOPE_PROXY_LOCAL (object);
	switch (property_id) {
		case UNITY_SCOPE_PROXY_LOCAL_SCOPE:
		g_value_set_object (value, unity_scope_proxy_local_get_scope (self));
		break;
		case UNITY_SCOPE_PROXY_LOCAL_SOURCES:
		g_value_set_object (value, unity_scope_proxy_get_sources ((UnityScopeProxy*) self));
		break;
		case UNITY_SCOPE_PROXY_LOCAL_SEARCH_IN_GLOBAL:
		g_value_set_boolean (value, unity_scope_proxy_get_search_in_global ((UnityScopeProxy*) self));
		break;
		case UNITY_SCOPE_PROXY_LOCAL_RESULTS_MODEL:
		g_value_set_object (value, unity_scope_proxy_get_results_model ((UnityScopeProxy*) self));
		break;
		case UNITY_SCOPE_PROXY_LOCAL_GLOBAL_RESULTS_MODEL:
		g_value_set_object (value, unity_scope_proxy_get_global_results_model ((UnityScopeProxy*) self));
		break;
		case UNITY_SCOPE_PROXY_LOCAL_FILTERS_MODEL:
		g_value_set_object (value, unity_scope_proxy_get_filters_model ((UnityScopeProxy*) self));
		break;
		case UNITY_SCOPE_PROXY_LOCAL_VIEW_TYPE:
		g_value_set_enum (value, unity_scope_proxy_get_view_type ((UnityScopeProxy*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_scope_proxy_local_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityScopeProxyLocal * self;
	self = UNITY_SCOPE_PROXY_LOCAL (object);
	switch (property_id) {
		case UNITY_SCOPE_PROXY_LOCAL_SCOPE:
		unity_scope_proxy_local_set_scope (self, g_value_get_object (value));
		break;
		case UNITY_SCOPE_PROXY_LOCAL_SOURCES:
		unity_scope_proxy_set_sources ((UnityScopeProxy*) self, g_value_get_object (value));
		break;
		case UNITY_SCOPE_PROXY_LOCAL_SEARCH_IN_GLOBAL:
		unity_scope_proxy_set_search_in_global ((UnityScopeProxy*) self, g_value_get_boolean (value));
		break;
		case UNITY_SCOPE_PROXY_LOCAL_RESULTS_MODEL:
		unity_scope_proxy_set_results_model ((UnityScopeProxy*) self, g_value_get_object (value));
		break;
		case UNITY_SCOPE_PROXY_LOCAL_GLOBAL_RESULTS_MODEL:
		unity_scope_proxy_set_global_results_model ((UnityScopeProxy*) self, g_value_get_object (value));
		break;
		case UNITY_SCOPE_PROXY_LOCAL_FILTERS_MODEL:
		unity_scope_proxy_set_filters_model ((UnityScopeProxy*) self, g_value_get_object (value));
		break;
		case UNITY_SCOPE_PROXY_LOCAL_VIEW_TYPE:
		unity_scope_proxy_set_view_type ((UnityScopeProxy*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



