

##########
#BASEURL
##########
class BASEURL:
    BUG = "https://launchpad.net/bugs/"
    BUG_NG = "https://bugs.launchpad.net"
    # https://bugs.edge.launchpad.net/ubuntu/+source/bughelper/+bug/153846/+text
    BUGLIST = ""
    BUGPAGE = ""
    BLUEPRINT = "https://blueprints.launchpad.net"
    BLUEPRINTLIST = ""
    
    
##########
#Bug
##########
class BUG:
    STATUS = {  'statusNEW': 'New',
                "statusINCOMPLETE": 'Incomplete',
                'statusINVALID': 'Invalid',
                "statusWONTFIX": 'Won\'t Fix',
                "statusCONFIRMED": 'Confirmed',
                "statusTRIAGED": 'Triaged',
                "statusINPROGRESS": 'In Progress',
                'statusFIXCOMMITTED': 'Fix Committed',
                'statusFIXRELEASED': 'Fix Released'}
                
    STATUS_INCOMPLETE_ADD = { 'INCOMPLETE_WITH_RESPONSE': 'Incomplete w/',
                              "INCOMPLETE_WITHOUT_RESPONSE": 'Incomplete w/o'}
                
    SORT_STATUS = ["Fix Released","Fix Committed","In Progress",\
            "Triaged", "Confirmed","Won\'t Fix","Invalid","Incomplete", "New"]
                
    IMPORTANCE = {  "importanceUNDECIDED": "Undecided",
                    "importanceWISHLIST": "Wishlist",
                    "importanceLOW": "Low",
                    "importanceMEDIUM": "Medium",
                    "importanceHIGH": "High",
                    "importanceCRITICAL": "Critical"}

    SORT_IMPORTANCE = ["Critical","High","Medium","Low","Wishlist","Undecided"]


##########
#Buglist
##########
class BUGLIST:
    DEFAULT_DISTRO = "ubuntu"
    
    COMPONENT_DICT = { "main": 1,
                       "restricted": 2,
                       "universe": 3,
                       "multiverse": 4,
                       "contrib": 5,
                       "non-free": 6,
                       "partner": 7}


##########
#Blueprint
##########
class BLUEPRINT:
    PRIORITY = {
        "specpriorityESSENTIAL" : "Essential",
        "specpriorityHIGH" : "High",
        "specpriorityMEDIUM" : "Medium",
        "specpriorityLOW" : "Low",
        "specpriorityUNDEFINED" : "Undefined",
        "specpriorityNOTFORUS": "Not"
        #MORE?
    }
    SORT_PRIORITY = ["Essential", "High", "Medium", "Low", "Undefined", "Not"]

    STATUS = {
        "specstatusAPPROVED" : "Approved",
        "specstatusPENDINGAPPROVAL" : "Pending Approval",
        "specstatusPENDINGREVIEW" : "Review",
        "specstatusDRAFT" : "Drafting",
        "specstatusDISCUSSION" : "Discussion",
        "specstatusNEW" : "New",
        "specstatusSUPERSEDED" : "Superseded",
        "specstatusOBSOLETE" : "Obsolete"
    }
    SORT_STATUS = ["Approved", "Pending Approval", "Review", "Drafting",
                    "Discussion", "New", "Superseded", "Obsolete"]

    DELIVERY = {
        "specdeliveryUNKNOWN" : "Unknown",
        "specdeliveryINFORMATIONAL" : "Informational",
        "specdeliveryIMPLEMENTED" : "Implemented",
        "specdeliveryNOTSTARTED" : "Not started",
        "specdeliveryBETA" : "Beta Available",
        "specdeliverySTARTED" : "Started",
        "specdeliveryDEFERRED" : "Deferred",
        "specdeliveryBLOCKED" : "Blocked",
        "specdeliveryGOOD" : "Good progress",
        "specdeliveryAWAITINGDEPLOYMENT" : "Awaiting deployment",
        "specdeliverySLOW"  : "Slow progress",
        "specdeliveryNEEDSREVIEW" : "Needs code review",
        "specdeliveryNEEDSINFRASTRUCTURE" : "Needs Infrastructure"
    }
    SORT_DELIVERY = ["Unknown", "Not started", "Deferred",
            "Needs Infrastructure", "Blocked", "Started", "Slow progress",
            "Good progress", "Beta Available", "Needs Code Review",
            "Deployment", "Implemented", "Informational"]
            
            
################
#ATTACHMENTS
################
class ATTACHMENTS:
    ATTACHMENT_PATH = "~/.bughelper/attachments-cache" # default should be None
    CONTENT_TYPES = ["text/html"] # default should be an empty-list
    
    
    
