"""
TODO:
 * move user/Comment-class to bugbase (?) as this class is used in html_bug and text_bug
 * check .private/.security: this seems to be wrong/maybe it  does not work
 
 * remove these ugly dict-element vs. object-attribute things
"""

from bugbase import Bug as BugBase
import email
import cStringIO as StringIO
import re
from lptime import LPTime
from lphelper import user, product
from tasksbase import LPTasks, LPTask
from attachmentsbase import LPAttachments, LPAttachment
from commentsbase import LPComments, LPComment


#from html_bug import Bug as BugBase # using html_bug as fallback
        
class Task(LPTask):
    def __init__(self, value_dict):
        #unpack values
        task_dict = {}
        for k, i in value_dict.iteritems():
            if i:
                task_dict[k] = i.pop()
                
        #print task_dict
        task_dict["affects"], task_dict["targeted_to"] = product.parse_text_product(task_dict["task"])
        for i in ["reporter", "assignee"]:
            if task_dict.has_key(i):            
                task_dict[i] = user.parse_text_user(task_dict[i])
        for i in ["date-created", "date-confirmed", "date-assigned", "date-inprogress", "date-closed"]:
            if task_dict.has_key(i):
                task_dict[i] = LPTime(task_dict[i])
        if task_dict.has_key("watch"):
            task_dict["remote"] = True
        #print task_dict
        LPTask.__init__(self, task_dict)
                    
    def get_date_created(self):
        return self._date_created
    
    def get_date_confirmed(self):
        return self._date_confirmed
    
    def get_date_assigned(self):
        return self._date_assigned
    
    def get_date_inprogress(self):
        return self._date_inprogress
    
    def get_date_closed(self):
        return self._date_closed
    
    def get_user(self):
        return self._user
        
        
class BugReport(object): 
    def __init__(self, bug_dict, connection=None):
        self.__data = bug_dict
        for i in ("tags", "duplicates"):
            self.__data[i] = self.__data.get(i, [])
            if self.__data[i]:
                self.__data[i] = self.__data[i][0].split()
        self.__data["bugnumber"] = int(bug_dict["bug"][0])
        self.__data["reporter"] = [user.parse_text_user(u) for u in self.__data.get("reporter", [])]
        self.__data["subscribers"] = [user.parse_text_user(u) for u in self.__data.get("subscribers", [])]
        self.__data["description"] = ""
        for i in ["date-reported", "date-updated"]:
            if self.__data.has_key(i):
                self.__data[i] = LPTime(self.__data[i][0])
        a = list()
        for i in self.__data.get("attachments",[]):
            url, contenttype = i.split(" ", 1)
            contenttype = contenttype.split(";")[0]
            a.append(Attachment(url, contenttype, connection, self.__data["bugnumber"]))
        self.__data["attachments"] = Attachments(a)
        
    def _add_description(self, description):
        self.__data["description"] = description
        
    def __getattr__(self, name):
        try:
            return self.__data[name.replace("_", "-")]
        except KeyError:
            if name in ["bugnumber", "title", "reporter", "duplicate_of", "duplicates", "subscribers",
                        "assignee", "private", "security", "tags", "date_reported", "date_updated",
                        "description", "attachments"]:
                return None
            else:
                raise AttributeError
        
class Comments(LPComments):
    def __init__(self):
        LPComments.__init__(self)
        
class Comment(LPComment):
    
    def __init__(self, nr, author, date, comment):
        LPComment.__init__(self,text=comment)
        self.set_attr(nr=nr, user=user.parse_text_user(author[0]), date=LPTime(date[0]))


class Attachments(LPAttachments):
    def __init__(self, a_set):
        LPAttachments.__init__(self, attachments=a_set, parsed=True)
        
    def add(self, attachment):
        raise NotImplementedError, "It is impossible to add attachments in the text-mode"
        
    def remove(self, key=None, func=None):
        raise NotImplementedError, "It is impossible to remove attachments in the text-mode"

class Attachment(LPAttachment):
    def __init__(self, url, contenttype, connection, bugnumber=None):
        LPAttachment.__init__(self, connection, url=url, contenttype=contenttype)
        self.__bugnumber = bugnumber
                    
    def get_sourcepackage(self):
        if self.is_up:
            return "unknown_sourcepackage"
            
    def get_bugnumber(self):
        if self.is_up:
            return self.__bugnumber
        
        

class TextPage(object):
    def __init__(self, url, connection):
        self.parsed = False
        self.__url = url + "/+text"
        self.__connection = connection
        self.__data = {}
        
    def __getitem__(self, key):
        if not self.parsed:
            self.parse()
        return self.__data.get(key, [])
        
    def parse(self):
        text = self.__connection.get(self.__url).text
        text_file = StringIO.StringIO(text)
        end_start = False
        k = None
        v = []
        block = None
        task_count = 0
        tmp_task = LPTasks({"url": self.__url})
        current_task_tupel = LPTasks.current_from_url(self.__url)
        cur_data = {}
        for l in text_file:
            if l == "\n":
                if block == "task":
                    if k:
                        cur_data[k] = v
                    task_obj = Task(cur_data)
                    if task_obj.is_current(current_task_tupel):
                        tmp_task._current = len(tmp_task)
                    tmp_task.append(task_obj)
                elif block == "bug":
                    self.__data["bug"] = BugReport(cur_data, connection=self.__connection)
                else:
                    self.__data[block][k] = v
                block = None
                cur_data = {}
                k = None
                v = []
            else:
                if l.startswith(" "):
                    if block == "bug":
                        try:
                            cur_data[k].append(l.strip(" \n"))
                        except KeyError:
                            cur_data[k] = [l.strip(" \n")]
                    else:
                        v.append(l.strip(" \n"))
                else:
                    x = l.split(":",1)
                    if l.startswith("Content-Type:"):
                        end_start = True
                        break
                    assert len(x) == 2, "wrong line:%s" %l
                    if not block:
                        block = x[0]
                        if block == "task" or block == "bug":
                            cur_data = {}
                        else:
                            self.__data[block] = {}
                    if k and v:
                        if block == "task" or block == "bug":
                            cur_data[k] = v
                        else:
                            self.__data[block][k] = v
                        k = None
                        v = []
                    k = x[0]
                    y = x[1].strip(" \n")
                    if y:
                        v = [y]
        if block:
            if block == "task":
                tmp_task.append(Task(cur_data))
            elif block == "bug":
                self.__data["bug"] = BugReport(cur_data)
            else:
                self.__data[block][k] = v
        if tmp_task._current == None and len(tmp_task) == 1:
            # "only one task, this must be current"
            tmp_task._current = 0
        self.__data["task"] = tmp_task
        self.__data["comments"] = Comments()
        if end_start:
            l += text_file.read()
            comments_msg = email.message_from_string(l)
            messages = comments_msg.get_payload()
            description = messages.pop(0)
            self.__data["bug"]._add_description(description.get_payload(decode=True))
            for i, msg in enumerate(messages):
                self.__data["comments"].append(Comment(i+1, msg.get_all("Author"), msg.get_all("Date"), msg.get_payload(decode=True)))
        self.parsed = True
                    


class Bug(BugBase):
    def __init__(self, bug=None, url=None, connection=None):
            
        BugBase.__init__(self, bug, url, connection)
        self.__textpage = TextPage(self.url, self.__connection)
        
    def get_url(self):
        return self.url
    
    def get_bugnumber(self):
        assert self.bugnumber == self.__textpage["bug"].bugnumber[0]
        return self.__textpage["bug"].bugnumber[0]
        
    def get_reporter(self):
        return self.__textpage["bug"].reporter[0]
        
    def get_title(self):
        return self.__textpage["bug"].title[0]
        
    def get_subscriptions(self):
        return set(self.__textpage["bug"].subscribers)
        
    def get_duplicate(self):
        try: return self.__textpage["bug"].duplicate_of[0]
        except: return None
        
    def get_duplicates(self):
        # the 'or []'-statement ensures that this always returns a list and not 'None'
        return set(self.__textpage["bug"].duplicates or [])
        
    def get_infotable(self):
        return self.__textpage["task"]
        
    def get_info(self):
        return self.__textpage["task"].current
        
    def get_status(self):
        return self.__textpage["task"].current.status
        
    def get_importance(self):
        return self.__textpage["task"].current.importance
        
    def get_target(self):
        return self.__textpage["task"].current.target
        
    def get_milestone(self):
        return self.__textpage["task"].current.milestone
        
    def get_assignee(self):
        return self.__textpage["task"].current.assignee
        
    def get_sourcepackage(self):
        return self.__textpage["task"].current.sourcepackage
        
    def get_affects(self):
        return self.__textpage["task"].current.affects

    def get_private(self):
        a = self.__textpage["private"]
        try:
            return a[0]
        except IndexError:
            return False

    def get_security(self):
        a = self.__textpage["security"]
        try:
            return a[0]
        except IndexError:
            return False

    def get_tags(self):
        return self.__textpage["bug"].tags
        
    def get_attachments(self):
        return self.__textpage["bug"].attachments

    def get_date(self):
        return self.__textpage["bug"].date_reported

    def get_date_updated(self):
        return self.__textpage["bug"].date_updated
        
    def get_comments(self):
        return self.__textpage["comments"]
        
    def get_description(self):
        return self.__textpage["bug"].description or ""
    get_description_raw = get_description
        
    def get_text(self):
        return "%s\n%s" %(self.description,"\n".join([c.text for c in self.comments]))
