import urlparse

from bugbase import LPBugInfo
from buglistbase import LPBugList, LPBugPage

class BugInfo(LPBugInfo):
    # TODO: use same attribute names like Bug.Bug
    def __init__(self, nr, all_tasks):
        LPBugInfo.__init__(self, nr, None, None, None, None, None, all_tasks)
        
        
class BugPage(LPBugPage):
    """
    grab content of a single bug-table    
    """
    @staticmethod
    def find_parse_function(connection, url, all_tasks):
        """ this can extended to parse other listtypes (like
            https://edge.launchpad.net/ubuntu/+milestone/gutsy-updates"""
        u = urlparse.urlsplit(url)
        if u[2].endswith("+bugs-text"):
            pass
        elif u[2].endswith("+bugs"):
            url = urlparse.urlunsplit((u[0],u[1],"%s-text"%u[2],u[3],u[4]))
        else:
            url = urlparse.urlunsplit((u[0],u[1],"%s/+bugs-text"%u[2],u[3],u[4]))
        lp_content = connection.get(url)
        result = BugPage.parse_text_bugpage(lp_content.text, all_tasks, url)
        return result
        
    @staticmethod
    def parse_text_bugpage(text, all_tasks, url):
        def _parse():
            for i in text.split("\n"):
                if i:
                    yield BugInfo(i, all_tasks)
        return _parse(), False


class BugList(LPBugList):
    """
    returns a SET of BugInfo objects
    searches baseurl and its following pages
    """
    def __init__(self, baseurl, connection=None, filter=None,
                    length=None, all_tasks=False, start_bugs=[], helper_bugpage=None):
        LPBugList.__init__(self, baseurl, connection, filter, length,
                                all_tasks, start_bugs, BugPage)

