"""
Example using of Bug
====================
"""

import launchpadbugs.connector as Connector


print ">>> connect to Bug class"
Bug = Connector.ConnectBug()

print ">>> Set cookie handler"
Bug.authentication="cookie.txt"    
    
print ">>> Getting a bug by given bugnumber"
"""LIST OF BUGS:
1 : complex infotable
109857: related branch
120593: testing bug
88521:
107735:
113853: attachments
88102:
118855: """
bug = Bug(120593)

print ">>> Getting an overview of all properies:"
not_implemented = []
for p in dir(bug):
    if not p.startswith("_") or p.startswith("set") or p.startswith("get") or p == "xmldoc":
        try:
            print "    >>> %s: %s" %(p, str(getattr(bug, p)))
        except NotImplementedError, e:
            not_implemented.append(p)
print ">>> following properties are not implemented: %s" %not_implemented
print
print ">>> change some bug properties (e.g. .status, .importance, .private):"
bug.status = "Invalid"
print "    >>> .status:", bug.status
try:
    bug.importance = "High"
except IOError, e:
    print e
print "    >>> .importance:", bug.importance
bug.private = not(bug.private)
print "    >>> .private:", bug.private
print 
print ">>> Attachments:"
print "    >>> getting a list of attachments:", bug.attachments
print "    >>> description of the first attachment:", bug.attachments[0].description
bug.attachments[0].is_patch = not(bug.attachments[0].is_patch)
print "    >>> properties of an attachment can be changed (e.g. is_patch):", bug.attachments[0].is_patch
print "    >>> download the first attachment and print the text: [...]", bug.attachments[0].text[10:40], "[...]"
print "    >>> after downloading the attachment it is known to be local:", bug.attachments
def test_filter(a):
    import re
    return re.match(".*attachment", a.description)
print "    >>> filter the list attachments:", [i for i in bug.attachments.filter(test_filter)]
print "    >>> delete attachment by index:"#, bug.attachments.remove(1)
print "    >>> delete attachment 'object':"#, bug.attachments.remove(func=test_filter)
print "    >>> create an new attachment and add it to the bugreport"
attachment = Bug.NewAttachment(localfilename="/home/markus/prog/bugs/patches.queue/79140.patch")
attachment.description = "example patch"
attachment.is_patch = True
print "    >>> that is the new attachment-object:", attachment
bug.attachments.add(attachment)
print "    >>> added to the bugreport:", bug.attachments
print
print ">>> comments:"
print "    >>> create a new comment"
comment = Bug.NewComment(text="this is a test comment")
print "    >>> that is the new comment", comment
bug.comments.add(comment)
print "    >>> added to the bugreport:", bug.comments

print ">>> get a list of all changes"
print [str(i) for i in bug.changed]
print
print ">>> finally commit changes!"

bug.commit(force_changes=True, ignore_lp_errors=False)
#print bug.attachments[0].description
#bug.attachments[0].description = "second test-description"
#bug.attachments.remove(0)
#print bug.attachments.get_deleted()
#attachment = Bug.NewAttachment(localfilename="/home/markus/prog/bugs/patches.queue/79140.patch")
#attachment.description = "example patch"
#attachment.is_patch = True

#print attachment
#print bug.attachments
#bug.attachments.add(attachment)
#print bug.attachments
#print [str(i) for i in bug.changed]
#bug.commit()
#bug.subscribtions.add("test888")
#bug.subscribtions.add("thekorn")
#bug.subscribtions.remove("thekorn")
#print bug._Bug__subscribers.commit(bug.url)
#bug = Bug(126927)
#print bug.subscribtions
#print bug.attachments
#def test_filter(a):
    #import re
    #return re.match("po.*", a._Attachment__description)
#print [a for a in bug.attachments.filter(test_filter)]
#print bug.attachments[7599329]
#print bug.private
#bug.private = not bug.private
#bug._Bug__secrecy.commit(bug.url)
#bug = Bug(120593)
#print bug.private
#print bug.attachments
#a = bug.attachments[6542450]
#a.download()
#bug.infotable[0].apply()
#print bug.bugreport.reporter
#bug.bugreport.description += "\n\nEdited the description with python-launchpad-bugs"
#bug.bugreport.apply(bug._Bug__url)
#bug2 = b.Bug(1)
#Set cookie_handler
    

"""
print ">>> Getting a bug by given BugInfo object"
bug = b.Bug(bl.BugInfo(123,"a","b","c"))
"""

