#!/usr/bin/env python
##########################################################################
# automatically generate html page which lists bugs tagged 'qa-hardy-list'
##########################################################################
import os
import sys
import launchpadbugs.connector as Connector
import commands
import re
import urllib
import getopt

title = ["malone","QA Malone Buglist"]

if len(sys.argv) != 2:
    print 'Usage: %s <%s-buglist.txt>' % (sys.argv[0], title[0])
    sys.exit(1)

red = "#ffa2a2"
green = "#c4ffc4"
yellow = "#fffec4"
grey = "#e0e0e0"

Bug = Connector.ConnectBug("TEXT")
htmlfile = "./%s-buglist-temp.html" % (title[0])
buglist = sys.argv[1]

html = "<html>\n"
html += "<head>\n"
html += "\t<title>%s</title>\n" % (title[1])
html += "\t<link defanghtml_rel=\"made\" defanghtml_href=\"mailto:webmaster@ubuntu.com\">\n"
html += "\t<link rel=\"stylesheet\" type=\"text/css\" charset=\"utf-8\" media=\"all\" href=\"http://www.ubuntu.com/htdocs/ubuntuweb/css/common.css\">\n"
html += "\t<link rel=\"stylesheet\" type=\"text/css\" charset=\"utf-8\" media=\"screen\" href=\"http://www.ubuntu.com/htdocs/ubuntuweb/css/screen.css\">\n"
html += "\t<link rel=\"stylesheet\" type=\"text/css\" charset=\"utf-8\" href=\"buglist.css\">\n"
html += "</head>"
html += "<body>\n"
html += "<h3>%s</h3>\n" % (title[1])

html_table = "<p>\n<table border=1>\n"
html_table += "<tbody><tr>\n"
html_table += "\t<th align=center>Bug</defanghtml_hd>\n"
html_table += "\t<th align=center>Summary</th>\n"
html_table += "\t<th align=center>Source Package(s)</th>\n"
html_table += "\t<th align=center>Importance</th>\n"
html_table += "\t<th align=center>Status</th>\n"
html_table += "\t<th align=center>Assignee</th>\n"
html_table += "\t<th align=center>Comment</th>\n"
html_table += "</tr>\n"

html += html_table
html_fixed = html_table
html_fixed += "<p></p><h3>Fixed Bugs</h3>"
html_fixed_list = []
LIST = open(buglist, "r")
for line in LIST:
    if re.match('#', line):
        continue
    arg = line.split(',')
    num = arg[0]
    comment = arg[1]
    try:
        URL = "https://bugs.launchpad.net/bugs/%s" % num
        bug = Bug(url=URL)
        packagelist = list(bug.infotable)
        length = len(packagelist)
        count = 0
        html_row_end = ""
        html_fixed_list = []
        invalid = 0
        for i in bug.infotable:
            try:
                if i.status == 'Fix Released' or i.status == 'Fix Committed':
                    color= green
                elif i.status == 'In Progress':
                    color= yellow
                elif i.status == 'Invalid':
                    color= grey
                else:
                    color=""

                html_row = ""
                targeted_to = (i.targeted_to and " (%s)" %i.targeted_to) or ""
                if count > 0:
                    html_row += "<tr>\n"

                html_row += "\t<td>%s%s</td>\n" % (i.sourcepackage, targeted_to)
                html_row += "\t<td>%s</td>\n" % i.importance
                html_row += "\t<td bgcolor=\"%s\">%s</td>\n" % (color, i.status)
                html_row += "\t<td>%s</td>\n" % i.assignee
                html_row += "\t<td>%s</td>\n" % comment
                html_row += "</tr>\n"
                html_row_end += html_row

                if i.status == 'Fix Released' or i.status == 'Fix Committed':
                    html_fixed_list.append(html_row)
                count += 1
            except:
                print "    Sorry:", sys.exc_type, ":", sys.exc_value
                print "    Omitting package from the list"

        html_row_start = "<tr>\n"
        html_row_start += "\t<td class=\"first\" rowspan=\"%d\"><a href=\"%s\">%d</a></td>\n" % (count, URL, bug.bugnumber)
        html_row_start += "\t<td rowspan=\"%d\">%s</td>\n" % (count, bug.summary)
        html_row_start += html_row_end
        html += html_row_start

        if len(html_fixed_list) > 0:
            html_fixed += "<tr>\n"
            html_fixed += "\t<td class=\"first\" rowspan=\"%d\"><a href=\"%s\">%d</a></td>\n" % (len(html_fixed_list), URL, bug.bugnumber)
            html_fixed += "\t<td rowspan=\"%d\">%s</td>\n" % (len(html_fixed_list), bug.summary)
            temp = re.match("<tr>(.*)", html_fixed_list[0])

            if temp:
                html_fixed_list[0] = html_fixed_list[0].lstrip("<tr>\n")

            for fixed in html_fixed_list:
                html_fixed += fixed
    except:
        print "    Sorry:", sys.exc_type, ":", sys.exc_value
        print "    Omitting bug from the list"

html += "</tbody></table>\n</p>"
html += html_fixed
html_fixed += "</table>\n</p>"
html += "</tbody></table></p></body></html>\n"
HTML = open(htmlfile, 'w')
HTML.write(html)
HTML.close()
