/* GraphGenerator.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.generators.graphs;

import org.grinvin.factories.FactoryException;
import org.grinvin.factories.FactoryParameterException;
import org.grinvin.factories.NamedFactory;

/**
 * An object that satisfies this interface can be used to instantiate
 * an object of type {@link GraphGeneratorInstance}.
 */
public interface GraphGenerator extends NamedFactory {
        
    /**
     * Return the string that uniquely identifies this generator. This id
     * is typically used for retreiving documentation pages for this generator
     * and for building URIs for the instances created by this generator. 
     */
    public String getId ();
    
    /**
     * Return the id of the generator instance which will be created
     * when using the current parameter values.
     */
    public String getInstanceId() throws FactoryParameterException;

    /**
     * Should be overridden to generate an instance for the current values of the
     * factory arguments.
     */
    public GraphGeneratorInstance createInstance() throws FactoryException;
}
