/* GeneratorTOCView.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.help;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.help.HelpSet;
import javax.help.Map;
import javax.help.Map.ID;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.swing.tree.DefaultMutableTreeNode;


/**
 * Loads an overview of the generators and places them in a TOC tree
 * that is mergeable with the GrInvIn help TOC tree.
 */
public class GeneratorTOCView extends TOCView {
    
    /**
     * Creates a new instance of GeneratorTOCView
     */
    public GeneratorTOCView(){
        super(HelpManager.getHelpSet(), HelpManager.getResourceBundle().getString("TOC.name"), HelpManager.getResourceBundle().getString("TOC.label"), HelpManager.getHelpSet().getLocale(), new Hashtable());
   }
    
    public GeneratorTOCView(HelpSet hs, String name, String Label, Hashtable params){
        this();
    }
    
    public GeneratorTOCView(HelpSet hs, String name, String Label, Locale locale, Hashtable params){
        this();
    }
    
    public String getMergeType(){
        return "javax.help.UniteAppendMerge";
    }
    
    public DefaultMutableTreeNode getDataAsTree() {
        //grinvin
        TOCItem itemgrinvin = new TOCItem();
        itemgrinvin.setName(HelpManager.getResourceBundle().getString("TOC.item.grinvin"));
        DefaultMutableTreeNode grinvin = new DefaultMutableTreeNode(itemgrinvin);
        // -- mainwindow
        TOCItem itemmainwindow = new TOCItem(ID.create("org.grinvin.window.main", HelpManager.getHelpSet()), null, null);
        itemmainwindow.setName(HelpManager.getResourceBundle().getString("TOC.item.mainwindow"));
        DefaultMutableTreeNode mainWindow = new DefaultMutableTreeNode(itemmainwindow);
        // -- -- generator tab
        TOCItem itemGeneratorTab = new TOCItem(ID.create("org.grinvin.window.main.tab.generators", HelpManager.getHelpSet()), null, null);
        itemGeneratorTab.setName(HelpManager.getResourceBundle().getString("TOC.item.generatorstab"));
        DefaultMutableTreeNode generatorTab = new DefaultMutableTreeNode(itemGeneratorTab);
        // -- -- -- (generators)
        for(Enumeration e = GeneratorMap.getInstance().getAllIDs(); e.hasMoreElements(); ){
            Map.ID id = (Map.ID)e.nextElement();
            String stringId = id.id;
            TOCItem item = new TOCItem(id, ID.create("org.grinvin.icons.generator", HelpManager.getHelpSet()), null, null);
            item.setName(GeneratorMap.getInstance().getGeneratorNameForID(stringId));
            generatorTab.add(new DefaultMutableTreeNode(item, false));
        }
        mainWindow.add(generatorTab);
        grinvin.add(mainWindow);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(null);
        root.add(grinvin);
        return root;
    }
}
