/* DoubleEditor.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.params;

import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;

/**
 * Default {@link ParameterEditor} for real numbers. The type implicitely associated
 * with this editor, is {@code Double}.
 */
class DoubleEditor implements ParameterEditor {
    
    //
    public Double fromText(String string) {
        return new Double(string);
    }
    
    //
    public String toText(Object value) {
        return value.toString();
    }
    
    //
    public ParameterComponent getEditorComponent() {
        return new DoubleTextField();
    }
    
    //
    private static class DoubleTextField extends JFormattedTextField implements ParameterComponent {
        
        //
        public DoubleTextField() {
            super(NumberFormat.getNumberInstance());
            Dimension dim = getPreferredSize();
            dim.width = 60;
            setPreferredSize(dim);
            dim = getMinimumSize ();
            dim.width = 60;
            setMinimumSize(dim);
            getInputMap(WHEN_FOCUSED).put(KeyStroke.getKeyStroke("ENTER"), "focusNextComponent");
            getActionMap().put("focusNextComponent", new AbstractAction() {
                public void actionPerformed(ActionEvent ev) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            });
        }
        
        //
        public void setParameterValue(Object value) {
            setValue((Double)value);
        }
        
        //
        public Double getParameterValue() {
            Number number = (Number)getValue();
            if (number instanceof Double)
                return (Double)number;
            else
                return new Double(number.doubleValue());
        }
        
    }
}
