/* GrinvinWindowWrapper_1_0.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.workspace.compat;

import java.awt.Window;
import java.io.IOException;
import java.util.Map;

import org.grinvin.io.IOFormatException;
import org.grinvin.io.SectionLoader;
import org.grinvin.io.SectionSaver;
import org.grinvin.logging.LoggingWindow;
import org.grinvin.main.GrinvinWindow;
import org.grinvin.main.GrinvinWindow.GrinvinWindowComponentType;
import org.grinvin.workspace.DefaultWindowWrapper;
import org.grinvin.workspace.WorksheetWindowWrapper;

import org.jdom.DataConversionException;
import org.jdom.Element;

/**
 *
 */
public class GrinvinWindowWrapper_1_0 extends DefaultWindowWrapper<GrinvinWindow> {

    //
    private final WorksheetWindowWrapper wrapper;
    
    //
    private final Map<String, Window> windowMap;
    
    //
    public GrinvinWindowWrapper_1_0(Map<String, Window> windowMap) {
        this.wrapper = new WorksheetWindowWrapper();
        this.windowMap = windowMap;
    }

    public GrinvinWindow create() {
        throw new UnsupportedOperationException("This wrapper cannot be used to create new workspaces");
    }

    private void registerAllOtherWindows (GrinvinWindow grinvinWindow) {
        for (Map.Entry<String, Window> entry : windowMap.entrySet()) {
            grinvinWindow.registerWindow(entry.getKey(), entry.getValue());
        }
    }


    @Override
    public GrinvinWindow load(Element element, SectionLoader sloader) throws IOException {
        
        // load standard windows
        Object loggingObj = element.getChild("loggingWindow");
        LoggingWindow loggingWindow = new LoggingWindowWrapper_1_0().load((Element)loggingObj, sloader);
        windowMap.put("LoggingWindow", loggingWindow);
        
        EditorWindowWrapper_1_0 editorWindowWrapper = new EditorWindowWrapper_1_0();
        Window editorWindow = editorWindowWrapper.load(element.getChild(editorWindowWrapper.getElementName()), sloader);
        windowMap.put("EditorWindow", editorWindow);
        
        
        GrinvinWindow window = new GrinvinWindow();
        registerAllOtherWindows(window);
        window.setupContents();
        windowMap.put("GrinvinWindow", window);

        // load backward compatibility
        Object conjObj = element.getChild("conjecturingWindow");
        if (conjObj != null)
            window.getWorksheetListModel().getWorksheetWindowListModel().add(new ConjecturingWindowWrapper().load((Element)conjObj, sloader));
        
        for (Object obj : element.getChildren("browserWindow"))
            window.getWorksheetListModel().getWorksheetWindowListModel().add(new GraphBrowserWindowWrapper().load((Element)obj, sloader));

        try {
            int seqno = element.getAttribute("listSeqNum").getIntValue();
            window.getWorksheetListModel().setListSequenceNumber(seqno);
        } catch (DataConversionException ex) {
            throw new IOFormatException("Incorrect integer attribute value", ex);
        }
        
        // make window visible
        loadWindowProperties(element, window);
        
        // select tab
        String tab = element.getAttributeValue("tab");
        if (tab.equals("invariants")) {
            window.setSelectedTab(GrinvinWindowComponentType.INVARIANTS);
        } else if (tab.equals("factories")) {
            window.setSelectedTab(GrinvinWindowComponentType.FACTORIES);
        } else if (tab.equals("graphlists")) {
            window.setSelectedTab(GrinvinWindowComponentType.WORKSHEETS);
        } else {
            //do nothing: just select first tab
        }

        window.setVisible(true);
        
        return window;
        
    }

    public void save(GrinvinWindow component, Element parent, SectionSaver ssaver) throws IOException {
        throw new UnsupportedOperationException("This wrapper cannot be used to save workspaces");
    }

    public String getElementName() {
        return "grinvinWindow";
    }
    
}
