#!usr/bin/env python
"""Unit tests for fast metric scaling functions"""

from cogent.util.unit_test import TestCase, main
from cogent.cluster import goodness_of_fit
from cogent.cluster.approximate_mds \
    import nystrom
from cogent.cluster.approximate_mds \
    import calc_matrix_a, calc_matrix_b, build_seed_matrix
from cogent.cluster.approximate_mds import rowmeans, \
    affine_mapping, adjust_mds_to_ref, recenter, combine_mds, \
    cmds_tzeng, CombineMds
from numpy import array, matrix, random, argsort

__author__ = "Andreas Wilm"
__copyright__ = "FIXME"
__credits__ = ["Andreas Wilm"]
__license__ = "GPL"
__version__ = "1.5.0"
__maintainer__ = "Andreas Wilm"
__email__ = "andreas.wilm@ucd.ie"
__status__ = "FIXME"

PRINT_STRESS = False


# Bigish symmetrical matrix for testing: The following is a distance
# matrix of 100 points making up a 16-dimensional spiral. Idea was
# copied from Tzeng et al. 2008 (PMID 18394154).
#
# Note: the objects are ordered, i.e. permuting the distances will
# give better MDS approximations
#
FULL_SYM_MATRIX =  array([
        [  0.     ,   9.94319,   7.11402,   7.30016,   9.1998 ,   7.52661,
           10.1122 ,  11.71544,  11.72171,  12.23729,  16.55706,  15.07764,
           17.41182,  19.23286,  22.03428,  20.37969,  21.79021,  23.31804,
           25.27884,  25.33384,  25.51721,  25.23346,  27.13757,  27.77099,
           31.89744,  30.12906,  30.853  ,  31.25053,  32.01368,  32.92915,
           34.80687,  34.67094,  34.61157,  33.95445,  36.09099,  34.39821,
           35.29278,  33.43954,  35.50327,  34.96861,  34.61776,  31.52205,
           31.5479 ,  31.86234,  30.85453,  29.69611,  29.41756,  28.83014,
           30.11403,  28.76504,  23.7291 ,  25.6983 ,  25.97412,  25.13513,
           24.45972,  21.55045,  21.69278,  19.95303,  16.26348,  17.11013,
           14.32254,  17.62265,  15.44168,  17.37134,  13.90914,  11.73735,
           12.23879,  12.84236,  16.11693,  14.78883,  14.85241,  16.81082,
           15.84987,  19.49531,  19.10495,  20.82333,  22.2353 ,  24.10629,
           25.58022,  26.94421,  29.15922,  29.35633,  30.44926,  33.44155,
           33.20634,  35.10944,  37.58041,  36.97612,  37.4974 ,  39.19126,
           41.96371,  39.49224,  44.24451,  44.49713,  46.20998,  45.17665,
           43.34276,  45.20143,  42.75318,  46.74111],
        [  9.94319,   0.     ,   9.15502,   9.50864,   4.67066,   8.73786,
           10.65396,   7.07033,   7.65245,  11.7303 ,  13.97535,  14.44678,
           14.4366 ,  17.67632,  17.78924,  17.34483,  20.92378,  19.64563,
           22.37953,  22.50652,  22.59182,  23.16428,  25.36422,  24.53657,
           28.53754,  28.8102 ,  28.67001,  29.99149,  29.0992 ,  30.78134,
           32.60362,  33.06432,  32.35053,  31.31204,  33.96212,  32.70361,
           34.0075 ,  31.79899,  34.1394 ,  34.08447,  34.40636,  32.09843,
           31.55098,  32.21933,  29.68935,  30.64989,  29.84656,  30.31266,
           30.95073,  29.50086,  25.13342,  26.92125,  26.77764,  25.45479,
           26.64139,  24.28835,  23.54393,  21.14658,  19.0042 ,  19.69926,
           17.01569,  17.70308,  16.76036,  18.85088,  15.67933,  13.11373,
           14.57384,  14.49709,  13.93834,  13.97627,  15.28133,  15.43603,
           15.38908,  19.14731,  18.0164 ,  19.25691,  20.79821,  21.17772,
           23.34925,  24.69467,  25.91663,  26.0043 ,  27.48027,  31.09767,
           29.88905,  31.87226,  35.07482,  34.08161,  34.96767,  36.59085,
           39.56174,  37.35437,  42.00158,  42.65467,  44.21824,  42.7808 ,
           41.49634,  42.89946,  41.51576,  45.2993 ],
        [  7.11402,   9.15502,   0.     ,   6.86568,   9.13056,   6.40397,
           9.71158,   8.69917,   8.75907,   9.94964,  12.60852,  10.83371,
           13.24922,  15.56278,  18.00935,  17.28358,  18.64376,  18.74751,
           21.30424,  20.79329,  22.52019,  21.17382,  24.35227,  24.04257,
           27.79547,  27.14583,  27.9384 ,  28.31876,  29.19352,  30.31387,
           32.49497,  32.53298,  32.54342,  31.6677 ,  34.4333 ,  33.06171,
           33.8104 ,  32.32825,  34.54666,  33.66703,  34.21985,  31.60984,
           31.44096,  32.23245,  30.68488,  30.737  ,  30.20034,  30.13288,
           31.62192,  30.13293,  25.84322,  27.91135,  28.12311,  27.30813,
           27.01853,  24.69093,  24.94734,  23.21836,  20.37644,  20.92257,
           17.85377,  20.91217,  19.36837,  20.86528,  17.38101,  14.14065,
           15.49992,  14.33989,  17.43602,  15.89444,  14.88863,  15.37154,
           15.57648,  18.73803,  17.66276,  19.14902,  19.51857,  21.56308,
           22.21288,  23.47894,  25.86362,  25.36028,  26.33286,  29.98075,
           29.33639,  31.30981,  33.73965,  33.6759 ,  34.04663,  35.63369,
           38.24726,  36.06871,  40.78921,  41.34813,  43.00012,  42.36618,
           40.24461,  42.30763,  40.55066,  44.09355],
        [  7.30016,   9.50864,   6.86568,   0.     ,   7.99096,   7.60197,
           10.10639,   9.22165,   8.8801 ,   9.49238,  13.66406,  12.57744,
           13.13858,  15.46775,  17.73952,  16.56614,  18.40617,  19.64056,
           21.45177,  22.03097,  21.88416,  22.61383,  24.92398,  25.28642,
           29.08492,  27.8259 ,  29.18638,  29.3961 ,  30.42798,  31.81182,
           33.20848,  33.36339,  34.03547,  33.03364,  35.82444,  34.7116 ,
           35.8487 ,  33.89059,  36.02136,  35.60052,  36.08047,  33.37669,
           33.34017,  33.79942,  32.42774,  31.97527,  31.72587,  31.85386,
           33.66607,  32.0357 ,  26.92882,  29.3656 ,  29.6113 ,  28.77098,
           27.98344,  25.49869,  26.08835,  24.3511 ,  21.22304,  21.25266,
           18.87943,  21.25316,  19.09945,  20.88305,  16.98734,  14.43121,
           14.87293,  12.60412,  16.25858,  14.52592,  14.10743,  13.84321,
           13.02127,  16.58691,  15.13994,  17.45726,  18.68005,  20.17601,
           21.41715,  23.0355 ,  25.07801,  24.73817,  26.67714,  29.31584,
           29.02044,  31.28387,  33.55744,  33.39091,  34.49413,  36.29427,
           39.09789,  36.46602,  41.84873,  41.95262,  44.21519,  43.15904,
           41.86844,  43.70448,  41.85398,  45.9426 ],
        [  9.1998 ,   4.67066,   9.13056,   7.99096,   0.     ,   8.10903,
           8.12191,   6.68991,   6.01745,   8.81851,  12.76517,  13.05449,
           13.25358,  16.08166,  16.85701,  14.96082,  18.58137,  18.78881,
           21.03104,  21.37792,  20.97864,  22.24007,  23.27987,  23.47925,
           27.51623,  27.08492,  27.63842,  28.49791,  28.08892,  29.94971,
           31.60411,  32.35099,  31.64065,  30.7586 ,  33.58783,  32.51966,
           33.71852,  31.59205,  34.09468,  34.22325,  34.16007,  32.3283 ,
           31.89116,  32.43132,  30.52192,  31.02961,  30.1106 ,  31.0687 ,
           31.53677,  30.2114 ,  25.7518 ,  27.6139 ,  28.20037,  27.20175,
           27.57982,  25.10337,  25.22312,  22.84998,  20.28434,  20.93006,
           18.50018,  19.27925,  17.75401,  20.49716,  16.24356,  13.95706,
           14.68697,  14.86848,  14.61363,  14.13096,  14.51717,  15.68778,
           14.51018,  17.43174,  16.76305,  18.13449,  19.68793,  19.75357,
           21.78947,  23.32496,  24.54554,  24.18059,  26.19812,  29.52194,
           28.20267,  30.01717,  33.36934,  32.26088,  33.40864,  34.83176,
           38.18059,  35.81903,  40.65885,  41.40321,  43.17206,  41.53149,
           40.71829,  42.49124,  40.79031,  44.66045],
        [  7.52661,   8.73786,   6.40397,   7.60197,   8.10903,   0.     ,
           6.16569,   7.32563,   7.75387,   7.69682,  10.69552,   9.88725,
           11.3961 ,  14.00163,  16.23874,  15.6289 ,  16.73334,  17.44048,
           19.99725,  19.9533 ,  20.46002,  19.84823,  22.72976,  23.22363,
           27.33355,  26.83688,  27.09796,  28.27618,  28.3494 ,  29.75656,
           31.77772,  32.50386,  32.5482 ,  31.99727,  34.67355,  33.19062,
           34.46902,  33.13995,  35.80184,  35.25591,  35.33808,  33.38177,
           33.04059,  33.91149,  32.75336,  32.5993 ,  32.43664,  32.23116,
           33.38874,  32.62237,  28.36209,  30.55605,  30.3347 ,  29.56765,
           29.58556,  27.53405,  26.86667,  25.00712,  21.74171,  23.02809,
           19.62897,  22.0497 ,  20.71073,  20.89719,  18.9401 ,  14.67542,
           15.87359,  14.84921,  15.9765 ,  14.6316 ,  13.43337,  14.09887,
           13.393  ,  15.35339,  15.15473,  15.57783,  16.38066,  18.12999,
           19.33544,  20.47957,  22.53012,  23.41117,  23.94749,  27.14785,
           27.12172,  29.01223,  32.1432 ,  31.53822,  31.97442,  34.20046,
           36.96213,  35.11644,  39.86917,  40.59916,  42.25278,  42.35218,
           40.45489,  42.53407,  40.64863,  44.57547],
        [ 10.1122 ,  10.65396,   9.71158,  10.10639,   8.12191,   6.16569,
          0.     ,   8.95464,   7.95483,   6.96854,  10.2321 ,   9.1072 ,
          11.40191,  13.88653,  16.49484,  12.77356,  14.76539,  17.37815,
          19.05223,  19.09134,  19.48543,  19.25793,  20.07018,  21.44923,
          26.16354,  24.71872,  25.7368 ,  26.60446,  26.8787 ,  27.97926,
          30.01728,  31.59176,  31.2204 ,  30.74726,  33.36662,  32.19782,
          33.24557,  32.26498,  35.20755,  35.27066,  34.3224 ,  33.45572,
          33.21501,  33.77282,  32.98931,  33.29691,  32.48639,  32.89237,
          33.31269,  33.17576,  29.06571,  31.25932,  31.50259,  31.19405,
          31.33608,  28.94501,  28.98748,  26.83509,  23.67883,  25.4293 ,
          22.19619,  23.92894,  22.48331,  23.70778,  20.61034,  16.80414,
          17.54135,  17.64634,  18.13698,  16.73796,  15.0992 ,  16.73965,
          15.39915,  15.3146 ,  16.21818,  15.90665,  16.80116,  17.15962,
          18.1004 ,  20.22697,  21.04317,  22.01882,  23.10616,  25.70386,
          25.33855,  26.90823,  30.27089,  29.34631,  29.92087,  31.66778,
          35.17056,  33.31352,  37.56416,  39.27059,  40.62456,  40.2062 ,
          39.40489,  41.81369,  39.33236,  43.20546],
        [ 11.71544,   7.07033,   8.69917,   9.22165,   6.68991,   7.32563,
          8.95464,   0.     ,   3.7505 ,   6.85568,   7.69523,   9.7299 ,
          8.8292 ,  12.08808,  12.84075,  12.41397,  15.7665 ,  13.80821,
          17.10528,  17.0151 ,  18.03523,  18.49492,  21.4005 ,  20.91953,
          24.56468,  24.98275,  25.20224,  26.47583,  26.01966,  28.37676,
          30.43507,  31.12544,  31.08021,  29.96861,  33.06401,  32.57304,
          33.997  ,  32.11079,  34.68809,  34.12659,  35.42161,  33.62916,
          33.16394,  34.14988,  31.96731,  33.13473,  32.68089,  33.34788,
          34.37908,  32.97516,  29.38917,  31.30679,  31.86587,  30.67301,
          31.14565,  29.06828,  29.04268,  27.11562,  24.63125,  25.08637,
          22.31814,  23.71491,  22.41495,  23.87865,  20.79483,  17.13811,
          18.05839,  16.67094,  16.67337,  15.59013,  15.29917,  14.46026,
          14.31921,  16.68845,  14.41634,  16.10611,  16.76691,  16.68857,
          18.02822,  19.23566,  20.91886,  19.93191,  21.22647,  25.60087,
          24.01222,  26.23519,  29.55426,  29.01695,  29.67471,  31.85062,
          34.7836 ,  32.77038,  38.06911,  38.63774,  40.78472,  39.75408,
          38.43139,  40.51321,  39.43324,  43.19846],
        [ 11.72171,   7.65245,   8.75907,   8.8801 ,   6.01745,   7.75387,
          7.95483,   3.7505 ,   0.     ,   6.25554,   7.94184,   9.40809,
          9.37058,  12.64537,  13.25671,  11.69312,  15.73247,  14.29708,
          17.17558,  17.07269,  18.18613,  18.66698,  20.99351,  20.83302,
          24.42795,  24.65435,  25.16361,  26.40833,  26.00333,  28.48816,
          30.39505,  31.12778,  31.04052,  30.02038,  33.06101,  32.51077,
          33.91746,  32.16109,  34.72522,  34.26106,  35.29431,  33.7662 ,
          33.40285,  34.11146,  32.13639,  33.33042,  32.66608,  33.38514,
          34.29769,  32.89254,  29.26526,  31.06269,  32.01605,  30.75263,
          31.17672,  28.89607,  29.20958,  27.32181,  24.53975,  25.21252,
          22.16274,  23.60181,  22.19147,  23.8951 ,  20.57865,  17.20223,
          17.67657,  16.61788,  17.05001,  15.68349,  15.30447,  14.95815,
          14.4235 ,  16.70277,  14.6234 ,  16.24885,  16.87216,  16.49137,
          17.85663,  19.18505,  20.91421,  19.70914,  21.64589,  25.6927 ,
          24.18448,  26.08005,  29.35354,  29.00965,  29.70327,  31.74665,
          34.68077,  32.64932,  37.91062,  38.78521,  40.83826,  39.61926,
          38.5705 ,  40.69567,  39.56802,  43.04025],
        [ 12.23729,  11.7303 ,   9.94964,   9.49238,   8.81851,   7.69682,
          6.96854,   6.85568,   6.25554,   0.     ,   7.3016 ,   8.07212,
          8.2089 ,   9.98656,  12.42781,  10.62705,  12.28722,  13.48977,
          16.04661,  16.19534,  16.3577 ,  17.32154,  19.0178 ,  20.5046 ,
          23.95953,  23.43756,  24.50878,  25.26128,  25.60517,  28.0269 ,
          30.02525,  31.11886,  31.15891,  30.49865,  33.86459,  33.37975,
          34.65544,  33.14589,  36.03802,  35.51766,  36.24468,  35.04257,
          34.67094,  35.65553,  34.59658,  34.79422,  34.36677,  35.45895,
          36.3779 ,  35.3327 ,  31.54706,  33.65312,  34.74652,  33.95725,
          33.40518,  31.44167,  31.93944,  30.05815,  26.96615,  27.64338,
          24.84473,  26.74278,  24.89471,  26.39705,  22.80323,  19.30856,
          19.43576,  18.22819,  18.64491,  17.05169,  14.82973,  15.51568,
          14.01205,  14.33961,  13.3435 ,  14.52817,  14.70497,  14.77414,
          15.56051,  16.74031,  18.93591,  17.75143,  19.27456,  22.94456,
          21.91537,  23.84675,  27.42168,  26.76934,  27.66108,  29.75946,
          33.0935 ,  30.98471,  36.65424,  37.30058,  39.65202,  39.12975,
          38.02632,  40.69416,  39.21815,  43.02089],
        [ 16.55706,  13.97535,  12.60852,  13.66406,  12.76517,  10.69552,
          10.2321 ,   7.69523,   7.94184,   7.3016 ,   0.     ,   6.34024,
          6.29442,   9.31874,  10.60831,   9.48152,  11.679  ,   9.86008,
          12.78319,  12.47705,  15.20036,  14.79868,  18.06249,  17.95878,
          21.80304,  21.94482,  22.94088,  24.29869,  24.32754,  26.55776,
          29.0597 ,  30.47032,  31.03937,  29.92437,  33.13454,  33.19895,
          34.69406,  33.79095,  36.57048,  36.01451,  37.16413,  36.42303,
          36.18591,  37.09342,  35.61312,  37.27428,  36.78719,  37.18274,
          38.417  ,  37.62287,  34.72634,  36.87088,  37.5226 ,  36.63014,
          37.07125,  35.13839,  35.36933,  33.57977,  30.77296,  31.75893,
          28.54674,  30.22502,  28.99081,  29.49656,  27.01958,  22.64011,
          23.11653,  21.4745 ,  21.88627,  19.79573,  18.19257,  16.9958 ,
          16.94848,  16.33478,  14.10467,  14.58976,  14.07395,  12.99207,
          12.74353,  13.92433,  15.69868,  14.25548,  15.27649,  19.74988,
          18.25877,  20.80091,  23.91183,  24.08524,  24.27307,  27.16596,
          30.02343,  28.55089,  33.83448,  35.47091,  37.51809,  37.42083,
          36.17692,  39.05643,  38.09928,  41.43184],
        [ 15.07764,  14.44678,  10.83371,  12.57744,  13.05449,   9.88725,
          9.1072 ,   9.7299 ,   9.40809,   8.07212,   6.34024,   0.     ,
          6.9511 ,   8.1817 ,  12.01962,   9.83166,  10.03616,  10.82597,
          12.22157,  12.42638,  14.81562,  13.24075,  15.91179,  16.17176,
          20.81994,  19.82228,  21.65753,  22.19242,  23.10866,  24.91478,
          26.51025,  27.84524,  28.94428,  28.23706,  31.0608 ,  30.49635,
          31.58452,  31.13131,  34.00834,  33.61703,  34.00148,  33.33828,
          33.20841,  33.84176,  33.36215,  34.29352,  34.00194,  34.24137,
          35.53305,  35.23732,  32.32311,  34.68689,  34.89579,  34.4585 ,
          34.33839,  33.07445,  33.23999,  31.99141,  28.83607,  30.27728,
          27.08538,  29.42086,  28.13654,  28.78396,  26.43445,  22.12388,
          23.17097,  21.90119,  23.31711,  21.43302,  19.21266,  18.09438,
          18.37291,  17.67573,  16.69031,  16.42476,  15.74665,  15.65608,
          14.72969,  16.18704,  17.54084,  16.84414,  17.82539,  20.46911,
          20.57828,  21.7296 ,  24.02904,  24.20871,  24.33682,  26.71437,
          29.08875,  27.8246 ,  32.39523,  33.86684,  35.84499,  36.03478,
          34.76023,  37.39742,  35.57779,  39.06011],
        [ 17.41182,  14.4366 ,  13.24922,  13.13858,  13.25358,  11.3961 ,
          11.40191,   8.8292 ,   9.37058,   8.2089 ,   6.29442,   6.9511 ,
          0.     ,   5.80269,   7.34823,   7.61967,   8.88048,   8.03171,
          10.84203,  11.15163,  12.21275,  12.34706,  16.11929,  16.0975 ,
          19.45663,  20.33958,  21.24043,  22.37157,  22.50594,  24.89152,
          26.47231,  28.19409,  29.03612,  28.11855,  31.78424,  31.68759,
          33.16023,  32.00993,  35.12134,  34.61314,  36.07251,  35.37259,
          34.85009,  36.19004,  34.77939,  36.03767,  35.84771,  37.05029,
          38.33912,  37.71305,  34.34605,  36.90215,  37.11372,  36.56462,
          36.48557,  35.26936,  35.32999,  33.72941,  31.33676,  32.09544,
          29.33582,  31.07569,  29.78355,  30.69899,  27.88792,  23.6909 ,
          24.95077,  22.44497,  22.73515,  21.53386,  19.39791,  17.15086,
          17.26961,  16.50911,  14.97885,  14.84698,  14.0348 ,  13.16584,
          12.28025,  14.13143,  14.59832,  13.82806,  14.44424,  17.8433 ,
          16.98162,  19.04357,  22.24141,  22.05366,  22.98183,  25.33998,
          28.35413,  26.6982 ,  32.11611,  32.88203,  35.32819,  35.61998,
          34.74136,  37.0847 ,  36.06984,  40.03816],
        [ 19.23286,  17.67632,  15.56278,  15.46775,  16.08166,  14.00163,
          13.88653,  12.08808,  12.64537,   9.98656,   9.31874,   8.1817 ,
          5.80269,   0.     ,   7.38877,   8.41906,   6.8504 ,   7.29774,
          9.2088 ,  10.31162,   9.70575,  10.45564,  13.73927,  14.84133,
          17.61261,  18.12427,  19.27123,  19.82935,  20.31297,  23.84286,
          24.56468,  25.91998,  27.59428,  26.89288,  30.55842,  30.76624,
          32.23747,  30.8686 ,  34.10976,  33.50914,  35.42056,  34.64547,
          34.19767,  35.53408,  35.0925 ,  35.58014,  35.82126,  37.49003,
          38.6495 ,  38.10808,  35.42106,  37.82413,  38.53678,  38.03388,
          37.13566,  36.62481,  36.8622 ,  35.93997,  33.1206 ,  33.81829,
          31.46152,  33.72103,  32.12859,  33.34453,  30.4796 ,  26.68134,
          27.47971,  25.54979,  25.74229,  24.75989,  22.16485,  20.06477,
          20.06272,  19.02226,  17.40359,  17.54345,  16.56831,  15.07742,
          13.83543,  14.50581,  15.50799,  13.55086,  13.77702,  16.34443,
          16.4955 ,  17.40327,  20.09447,  19.53993,  20.64083,  23.14301,
          25.73473,  23.91935,  30.1514 ,  29.62866,  33.12758,  33.46496,
          32.47884,  35.00942,  33.91675,  38.06303],
        [ 22.03428,  17.78924,  18.00935,  17.73952,  16.85701,  16.23874,
          16.49484,  12.84075,  13.25671,  12.42781,  10.60831,  12.01962,
          7.34823,   7.38877,   0.     ,   9.98466,  10.45042,   7.01399,
          9.5126 ,  10.22698,   8.29332,  10.75866,  15.09764,  14.55   ,
          16.07545,  19.17678,  18.69286,  20.74564,  19.36248,  23.2144 ,
          24.62428,  26.05861,  27.01352,  25.91131,  30.18725,  30.6706 ,
          32.78994,  31.0901 ,  34.2731 ,  33.85408,  36.35145,  35.76726,
          35.06246,  36.69763,  35.34281,  36.84744,  36.8362 ,  38.82735,
          39.99487,  39.19622,  36.6623 ,  39.10442,  39.88191,  38.95773,
          38.89602,  38.43435,  38.31651,  37.10258,  34.93565,  35.54241,
          33.22748,  34.83971,  33.64244,  34.72378,  32.11209,  28.69735,
          29.37637,  27.27617,  26.28932,  25.69016,  23.88593,  21.52732,
          21.55272,  20.82185,  18.79088,  18.59526,  17.84671,  15.16618,
          14.82818,  14.49505,  15.15638,  12.82821,  12.71296,  15.97897,
          14.73869,  16.7043 ,  19.42872,  18.50832,  20.11721,  22.55747,
          25.22857,  23.0396 ,  29.71055,  29.41731,  32.39176,  32.91178,
          31.62541,  33.79263,  34.18837,  37.85652],
        [ 20.37969,  17.34483,  17.28358,  16.56614,  14.96082,  15.6289 ,
          12.77356,  12.41397,  11.69312,  10.62705,   9.48152,   9.83166,
          7.61967,   8.41906,   9.98466,   0.     ,   7.63615,   9.92392,
          10.04376,  10.49189,  11.12076,  12.59852,  12.42193,  13.54166,
          17.25956,  16.80266,  18.81578,  19.22611,  19.70099,  22.40398,
          23.49591,  25.94766,  26.54727,  25.58126,  29.12877,  29.7836 ,
          31.07416,  29.98562,  33.17048,  33.35028,  34.18506,  34.59722,
          34.20947,  35.18721,  34.12158,  35.88742,  35.13336,  37.20982,
          37.74652,  37.47408,  34.70021,  37.06721,  38.15456,  37.88232,
          37.77484,  36.36806,  37.32521,  35.80232,  33.52616,  34.40962,
          32.12772,  33.40582,  31.97045,  34.19075,  30.2786 ,  26.83978,
          27.6592 ,  26.30551,  26.20587,  25.12388,  23.22648,  22.09752,
          21.38396,  19.8089 ,  18.83186,  18.86371,  18.34015,  15.42575,
          14.24007,  16.84456,  15.52977,  13.17945,  15.12571,  17.63489,
          15.48099,  16.55105,  19.58731,  18.96449,  20.24747,  21.6386 ,
          25.58849,  23.63285,  28.70622,  30.21742,  32.68447,  31.55284,
          32.34425,  35.03969,  33.47656,  37.35049],
        [ 21.79021,  20.92378,  18.64376,  18.40617,  18.58137,  16.73334,
          14.76539,  15.7665 ,  15.73247,  12.28722,  11.679  ,  10.03616,
          8.88048,   6.8504 ,  10.45042,   7.63615,   0.     ,  10.17132,
          8.68748,   9.45034,   8.94115,   9.44003,   9.64568,  12.4589 ,
          15.94741,  14.65608,  17.17587,  17.02335,  18.67632,  20.67866,
          21.7796 ,  24.38931,  25.59948,  25.17219,  28.8489 ,  29.1434 ,
          30.36341,  29.95065,  33.33854,  33.29967,  33.88558,  34.48264,
          34.10065,  35.42542,  35.45233,  36.19829,  36.03964,  37.86692,
          38.88208,  39.07201,  36.40368,  39.23049,  39.92573,  40.05261,
          39.20976,  38.61636,  39.27939,  38.1003 ,  35.6578 ,  36.74788,
          34.53888,  36.56434,  35.07799,  36.59537,  33.28937,  29.56233,
          30.64956,  29.02811,  29.40351,  28.14274,  25.25644,  24.3272 ,
          23.56296,  20.85461,  20.80185,  19.89348,  18.69289,  17.03854,
          14.62848,  16.26612,  15.56155,  13.83998,  13.72169,  14.82471,
          14.34678,  15.01213,  17.11687,  16.34701,  17.47794,  19.00668,
          22.61177,  20.87814,  25.97138,  27.04819,  29.54295,  30.34684,
          30.10012,  33.17501,  31.31277,  35.47796],
        [ 23.31804,  19.64563,  18.74751,  19.64056,  18.78881,  17.44048,
          17.37815,  13.80821,  14.29708,  13.48977,   9.86008,  10.82597,
          8.03171,   7.29774,   7.01399,   9.92392,  10.17132,   0.     ,
          6.48226,   6.68   ,   9.57466,   9.48408,  13.97397,  13.15679,
          15.03983,  17.80094,  18.12113,  19.85319,  18.97979,  23.36183,
          24.33233,  25.80959,  27.19217,  26.53318,  30.11932,  30.64921,
          32.34859,  31.49555,  34.6749 ,  33.71667,  36.43731,  36.39199,
          35.67965,  37.13664,  35.96695,  37.67898,  37.95828,  39.3333 ,
          40.59642,  39.92405,  37.99061,  40.17349,  40.90994,  39.98119,
          39.92003,  39.6808 ,  39.62528,  38.71391,  36.21198,  37.08048,
          34.29651,  36.10593,  34.99984,  35.8496 ,  33.74472,  29.52144,
          30.75883,  28.63502,  28.32294,  27.26777,  25.1948 ,  22.50728,
          23.05361,  22.12662,  19.74132,  19.63274,  17.89876,  15.79792,
          14.13342,  14.08034,  14.92898,  11.06895,  11.02782,  15.65033,
          14.30857,  14.46629,  17.74227,  17.97385,  18.06633,  21.34884,
          22.96009,  22.50932,  28.30391,  28.4628 ,  31.64773,  32.1907 ,
          31.04573,  33.47638,  33.5043 ,  36.83706],
        [ 25.27884,  22.37953,  21.30424,  21.45177,  21.03104,  19.99725,
          19.05223,  17.10528,  17.17558,  16.04661,  12.78319,  12.22157,
          10.84203,   9.2088 ,   9.5126 ,  10.04376,   8.68748,   6.48226,
          0.     ,   5.22655,   6.84299,   8.01445,  10.22964,   9.35169,
          12.50172,  13.03384,  15.11671,  16.15319,  16.32212,  20.01859,
          20.19876,  22.03234,  24.49275,  23.76956,  26.89441,  27.73295,
          29.57591,  29.31235,  32.28865,  31.99324,  33.95671,  34.64837,
          34.25079,  35.22869,  34.85416,  36.69074,  37.04425,  38.1781 ,
          39.77615,  39.60791,  38.021  ,  40.62842,  41.3098 ,  40.72945,
          40.56478,  40.68159,  40.97394,  40.4026 ,  37.91905,  39.08311,
          36.66186,  38.48701,  37.36496,  38.4644 ,  36.32379,  32.42384,
          33.65172,  31.82761,  32.1881 ,  30.80285,  28.93245,  26.4393 ,
          26.65776,  25.03495,  23.12291,  22.70202,  21.31299,  18.64901,
          16.46835,  16.81846,  16.44223,  12.42447,  12.98025,  14.62265,
          13.85173,  13.32047,  13.81794,  14.45423,  14.59398,  17.7774 ,
          18.83897,  18.33698,  23.71274,  24.45456,  27.512  ,  27.97503,
          27.44909,  29.9473 ,  29.47687,  32.87905],
        [ 25.33384,  22.50652,  20.79329,  22.03097,  21.37792,  19.9533 ,
          19.09134,  17.0151 ,  17.07269,  16.19534,  12.47705,  12.42638,
          11.15163,  10.31162,  10.22698,  10.49189,   9.45034,   6.68   ,
          5.22655,   0.     ,   9.1845 ,   6.24097,  10.68858,   8.9892 ,
          10.75227,  12.5549 ,  13.42965,  14.83639,  15.19843,  18.37361,
          20.11514,  21.80086,  23.21553,  22.42534,  25.94406,  26.90792,
          28.49847,  28.38986,  31.34822,  30.44753,  32.95536,  33.76841,
          33.23805,  34.76968,  33.79277,  36.13666,  36.16784,  37.57777,
          39.01639,  38.73035,  37.37737,  39.86314,  40.9369 ,  40.37831,
          40.3905 ,  40.18733,  40.75477,  40.04084,  38.03854,  39.0819 ,
          36.62329,  38.68787,  37.66226,  39.09107,  36.48663,  32.61225,
          34.05121,  32.23   ,  32.67538,  31.35308,  29.36674,  27.44256,
          27.60226,  26.2458 ,  24.4287 ,  24.17496,  22.32386,  20.26882,
          17.63621,  18.1981 ,  18.06242,  13.71252,  12.60611,  16.39878,
          13.84417,  13.90252,  14.58239,  15.61773,  14.72379,  17.00739,
          18.61744,  17.9266 ,  22.92496,  24.15302,  26.40181,  27.03924,
          25.82034,  28.7832 ,  28.60458,  31.58328],
        [ 25.51721,  22.59182,  22.52019,  21.88416,  20.97864,  20.46002,
          19.48543,  18.03523,  18.18613,  16.3577 ,  15.20036,  14.81562,
          12.21275,   9.70575,   8.29332,  11.12076,   8.94115,   9.57466,
          6.84299,   9.1845 ,   0.     ,   8.42136,   9.37678,  10.39484,
          12.03637,  13.28049,  13.52418,  15.33503,  14.2314 ,  18.60678,
          18.65654,  20.52313,  22.48976,  21.9616 ,  25.69566,  26.5576 ,
          28.88904,  27.73913,  31.08385,  31.06195,  33.13063,  33.66469,
          33.0211 ,  34.43139,  34.32978,  35.45315,  35.945  ,  38.07486,
          39.28353,  39.22602,  37.42741,  40.16763,  41.16595,  40.59288,
          40.07303,  40.5409 ,  40.65161,  40.1262 ,  37.85329,  38.93651,
          37.02688,  38.83153,  37.52198,  39.07799,  36.60449,  33.43265,
          34.30145,  32.81646,  32.20425,  31.53711,  29.60455,  27.68888,
          27.2861 ,  25.60395,  24.28611,  23.68602,  22.83922,  19.6321 ,
          18.43043,  18.32631,  17.7009 ,  14.75941,  14.24738,  14.81143,
          14.39659,  14.09233,  14.84183,  13.11227,  14.67681,  17.10835,
          19.10648,  17.05555,  23.72982,  22.93954,  26.36839,  26.99544,
          26.43948,  28.60162,  28.39343,  32.42605],
        [ 25.23346,  23.16428,  21.17382,  22.61383,  22.24007,  19.84823,
          19.25793,  18.49492,  18.66698,  17.32154,  14.79868,  13.24075,
          12.34706,  10.45564,  10.75866,  12.59852,   9.44003,   9.48408,
          8.01445,   6.24097,   8.42136,   0.     ,   9.19567,   8.28483,
          9.68535,  11.98782,  11.05565,  13.27899,  12.97288,  15.95134,
          17.47779,  19.26536,  20.81256,  20.47412,  24.07951,  24.48853,
          26.31214,  26.12805,  29.5516 ,  28.71938,  30.9913 ,  31.6734 ,
          31.05312,  32.90775,  32.68055,  34.31807,  34.6565 ,  36.33305,
          37.55324,  37.84719,  36.54117,  39.18647,  39.96285,  39.6461 ,
          39.38249,  39.77171,  39.84257,  39.44919,  37.48819,  38.87541,
          36.52095,  39.03388,  38.04894,  39.2854 ,  37.05129,  33.33446,
          34.86519,  33.37436,  33.51843,  32.6792 ,  30.40374,  28.64096,
          28.81112,  27.30426,  26.30338,  25.2772 ,  23.65439,  21.82505,
          19.44844,  19.69742,  19.3097 ,  17.16471,  14.47088,  16.52024,
          15.93936,  15.41702,  15.60782,  15.3568 ,  14.63636,  16.4597 ,
          17.9459 ,  16.78672,  21.70309,  21.98327,  24.07691,  26.11801,
          24.12467,  26.69992,  26.15777,  29.63547],
        [ 27.13757,  25.36422,  24.35227,  24.92398,  23.27987,  22.72976,
          20.07018,  21.4005 ,  20.99351,  19.0178 ,  18.06249,  15.91179,
          16.11929,  13.73927,  15.09764,  12.42193,   9.64568,  13.97397,
          10.22964,  10.68858,   9.37678,   9.19567,   0.     ,   6.87271,
          10.56088,   8.63342,  11.01072,  10.93865,  11.45914,  14.5144 ,
          14.09155,  17.70246,  18.65296,  19.02075,  22.11715,  22.68976,
          23.99425,  24.33084,  28.06753,  28.67934,  28.75474,  31.08502,
          30.53155,  31.69899,  32.62122,  33.92971,  33.80767,  36.2285 ,
          36.50334,  37.53278,  36.5014 ,  39.07491,  40.15724,  40.40674,
          39.85148,  40.40163,  40.9679 ,  40.5153 ,  38.42327,  40.1212 ,
          38.22838,  40.08247,  38.99665,  41.12947,  38.17204,  34.9892 ,
          36.38785,  35.95878,  35.6227 ,  34.90092,  32.5457 ,  31.91806,
          31.28384,  28.86779,  28.98518,  27.6702 ,  26.58669,  23.92989,
          21.86083,  22.75265,  21.11808,  18.7693 ,  18.18955,  18.2176 ,
          17.45544,  15.00264,  15.51133,  13.46033,  13.79958,  13.68436,
          16.58338,  15.70851,  18.99807,  20.56008,  22.44251,  22.97965,
          23.45606,  26.30876,  24.09575,  27.8713 ],
        [ 27.77099,  24.53657,  24.04257,  25.28642,  23.47925,  23.22363,
          21.44923,  20.91953,  20.83302,  20.5046 ,  17.95878,  16.17176,
          16.0975 ,  14.84133,  14.55   ,  13.54166,  12.4589 ,  13.15679,
          9.35169,   8.9892 ,  10.39484,   8.28483,   6.87271,   0.     ,
          7.72073,   8.27576,   9.50557,  10.31176,   9.92433,  12.30625,
          12.50632,  15.65258,  16.85322,  16.28059,  19.40831,  20.28063,
          21.80124,  22.2785 ,  25.59015,  26.20645,  27.03954,  29.20724,
          28.64062,  29.85524,  29.8061 ,  32.57415,  32.29469,  34.31277,
          34.99807,  35.82   ,  35.31492,  37.94267,  38.60944,  38.67121,
          38.95962,  39.63135,  39.99892,  39.64319,  38.13686,  39.73796,
          37.88513,  39.57072,  38.9161 ,  40.94059,  38.2891 ,  35.07866,
          36.89862,  36.20281,  36.05376,  35.34433,  33.67934,  32.25061,
          32.36628,  30.7808 ,  30.11484,  29.01616,  27.92706,  25.32419,
          23.29639,  24.12436,  22.42396,  19.7537 ,  19.01006,  19.94131,
          18.33339,  16.81857,  15.99741,  15.0617 ,  14.77595,  14.59106,
          16.3054 ,  15.56181,  17.98122,  20.15022,  21.20001,  21.39029,
          21.13788,  23.4717 ,  22.23873,  25.49112],
        [ 31.89744,  28.53754,  27.79547,  29.08492,  27.51623,  27.33355,
          26.16354,  24.56468,  24.42795,  23.95953,  21.80304,  20.81994,
          19.45663,  17.61261,  16.07545,  17.25956,  15.94741,  15.03983,
          12.50172,  10.75227,  12.03637,   9.68535,  10.56088,   7.72073,
          0.     ,   9.87641,   7.6598 ,   9.49731,   7.49547,  12.71031,
          13.12007,  15.09318,  15.76199,  15.39935,  19.70394,  21.41588,
          23.13548,  22.85749,  26.18616,  25.68635,  28.9516 ,  30.93716,
          30.0345 ,  32.15204,  31.65812,  34.38793,  34.38638,  37.50663,
          38.17473,  38.39304,  38.36668,  40.71544,  42.31539,  42.04724,
          41.86037,  42.90939,  43.56974,  43.4618 ,  42.34263,  43.41177,
          41.79768,  43.79152,  42.99372,  45.43309,  42.39361,  39.51926,
          41.2064 ,  40.11474,  39.74911,  39.34168,  37.45432,  35.8801 ,
          35.90349,  34.72309,  33.54021,  32.87432,  31.3026 ,  28.63784,
          26.36769,  26.4844 ,  25.34082,  21.25983,  19.4387 ,  21.35453,
          18.66931,  16.58331,  15.29044,  14.5311 ,  14.07159,  12.69685,
          13.75561,  12.45704,  16.48731,  16.18279,  18.19724,  18.82112,
          17.69826,  20.07196,  20.9814 ,  23.64271],
        [ 30.12906,  28.8102 ,  27.14583,  27.8259 ,  27.08492,  26.83688,
          24.71872,  24.98275,  24.65435,  23.43756,  21.94482,  19.82228,
          20.33958,  18.12427,  19.17678,  16.80266,  14.65608,  17.80094,
          13.03384,  12.5549 ,  13.28049,  11.98782,   8.63342,   8.27576,
          9.87641,   0.     ,   7.98874,   5.38369,   9.95786,  10.82054,
          11.0462 ,  12.89802,  15.44491,  14.85573,  17.38129,  19.47045,
          20.77089,  21.32264,  24.07172,  24.28534,  25.596  ,  27.93375,
          27.86256,  28.87872,  29.7082 ,  31.88982,  31.87346,  34.12199,
          35.33819,  36.0731 ,  35.88703,  38.71968,  40.48097,  40.65492,
          40.04445,  40.78432,  42.24041,  42.36186,  40.86445,  42.22587,
          40.89454,  43.17864,  41.97252,  44.85097,  41.45324,  38.91288,
          40.27944,  39.6453 ,  40.59724,  39.49418,  37.70761,  36.65188,
          36.33936,  34.78051,  33.80123,  33.49258,  32.35566,  29.75799,
          27.30116,  28.38011,  27.09472,  23.18208,  22.41711,  22.75371,
          20.88887,  19.50611,  15.96133,  15.86852,  14.98222,  13.66391,
          14.86599,  12.41707,  15.52539,  16.68747,  18.30724,  16.95519,
          17.37892,  20.49274,  18.30611,  21.75684],
        [ 30.853  ,  28.67001,  27.9384 ,  29.18638,  27.63842,  27.09796,
          25.7368 ,  25.20224,  25.16361,  24.50878,  22.94088,  21.65753,
          21.24043,  19.27123,  18.69286,  18.81578,  17.17587,  18.12113,
          15.11671,  13.42965,  13.52418,  11.05565,  11.01072,   9.50557,
          7.6598 ,   7.98874,   0.     ,   6.64528,   4.59801,   8.21652,
          10.31466,  11.16178,  12.08679,  11.83932,  15.09664,  17.18703,
          19.54388,  19.20711,  22.42597,  21.78585,  24.86467,  26.82595,
          26.17402,  28.22608,  28.33647,  30.77347,  31.09911,  33.82732,
          34.63993,  35.32224,  35.64687,  38.19558,  40.17273,  39.9043 ,
          39.71271,  40.82968,  41.59044,  41.89523,  40.82556,  42.24267,
          40.88634,  43.2909 ,  42.33337,  45.05862,  42.17539,  39.71804,
          41.17056,  40.67256,  40.65653,  40.19097,  38.65435,  37.60561,
          37.35235,  36.34129,  35.23204,  34.77337,  33.6225 ,  30.92734,
          29.00015,  29.40958,  28.36382,  25.0391 ,  22.59333,  24.07796,
          21.93502,  20.62995,  18.16191,  17.02272,  15.54819,  14.56199,
          15.3057 ,  12.64367,  16.45475,  15.71403,  16.86429,  16.85299,
          15.00269,  17.43522,  17.0517 ,  20.42138],
        [ 31.25053,  29.99149,  28.31876,  29.3961 ,  28.49791,  28.27618,
          26.60446,  26.47583,  26.40833,  25.26128,  24.29869,  22.19242,
          22.37157,  19.82935,  20.74564,  19.22611,  17.02335,  19.85319,
          16.15319,  14.83639,  15.33503,  13.27899,  10.93865,  10.31176,
          9.49731,   5.38369,   6.64528,   0.     ,   7.92917,   9.13679,
          9.53346,  10.47996,  12.16654,  11.7129 ,  15.01867,  17.3945 ,
          18.42663,  18.36001,  21.25014,  21.14056,  23.39958,  25.64935,
          25.29954,  27.11021,  27.88541,  29.88329,  29.87818,  33.15122,
          33.91166,  34.60562,  34.9862 ,  37.6223 ,  39.74094,  40.05704,
          39.15768,  40.26411,  41.81453,  42.1735 ,  41.17397,  42.24356,
          41.4135 ,  43.87194,  42.72225,  46.08496,  42.30557,  40.15065,
          41.69059,  41.24556,  41.85591,  41.23647,  39.41798,  38.64347,
          38.26693,  37.14527,  36.28322,  36.14132,  34.9677 ,  32.65462,
          30.32245,  31.15585,  30.05495,  26.14201,  24.6254 ,  25.64368,
          23.38049,  21.94394,  18.90934,  18.07516,  17.34202,  14.70928,
          16.17006,  13.04202,  15.86513,  15.06125,  16.67207,  15.02326,
          14.43571,  17.62774,  15.52057,  19.39125],
        [ 32.01368,  29.0992 ,  29.19352,  30.42798,  28.08892,  28.3494 ,
          26.8787 ,  26.01966,  26.00333,  25.60517,  24.32754,  23.10866,
          22.50594,  20.31297,  19.36248,  19.70099,  18.67632,  18.97979,
          16.32212,  15.19843,  14.2314 ,  12.97288,  11.45914,   9.92433,
          7.49547,   9.95786,   4.59801,   7.92917,   0.     ,   9.46759,
          9.53989,  10.77149,  10.67123,  10.77957,  14.38107,  16.55356,
          18.86377,  17.93757,  21.53923,  21.5    ,  24.50229,  26.72856,
          25.8231 ,  27.87236,  28.08681,  30.54159,  30.74741,  34.21383,
          34.31615,  35.0456 ,  35.81848,  38.00399,  40.05607,  39.79457,
          39.61693,  41.10429,  41.69482,  42.04974,  41.08039,  42.4485 ,
          41.31527,  43.35611,  42.53551,  45.50379,  42.54538,  40.30517,
          41.79641,  41.68827,  40.95449,  40.88777,  39.44077,  38.47113,
          38.21591,  37.33843,  36.35944,  35.80693,  34.8564 ,  31.85679,
          30.32951,  30.47848,  29.27892,  25.8884 ,  23.90214,  25.36182,
          23.14462,  21.09032,  19.56871,  17.40934,  16.72036,  15.08113,
          16.01239,  13.78221,  17.09382,  15.61569,  17.24015,  16.33925,
          15.18723,  17.0286 ,  16.96968,  20.31666],
        [ 32.92915,  30.78134,  30.31387,  31.81182,  29.94971,  29.75656,
          27.97926,  28.37676,  28.48816,  28.0269 ,  26.55776,  24.91478,
          24.89152,  23.84286,  23.2144 ,  22.40398,  20.67866,  23.36183,
          20.01859,  18.37361,  18.60678,  15.95134,  14.5144 ,  12.30625,
          12.71031,  10.82054,   8.21652,   9.13679,   9.46759,   0.     ,
          8.89237,  11.56402,   9.66796,   8.7428 ,  11.95979,  14.08575,
          15.80045,  16.65181,  19.74296,  20.61442,  21.15351,  24.45494,
          23.9113 ,  26.09147,  26.17295,  29.57049,  28.96665,  31.93696,
          32.42409,  34.06939,  34.49619,  37.51745,  38.87821,  39.44799,
          39.80638,  40.83166,  41.71964,  41.67128,  41.61213,  43.2428 ,
          42.36568,  44.39476,  43.77865,  46.84558,  43.53456,  41.47749,
          43.3667 ,  43.24129,  43.27906,  42.89426,  41.53307,  41.05796,
          40.77052,  39.41463,  39.1773 ,  38.1895 ,  37.36602,  34.97812,
          33.00745,  34.10653,  32.18818,  29.92886,  27.45379,  28.27133,
          25.75202,  25.34647,  22.44188,  20.82485,  19.82573,  16.70077,
          18.83691,  15.85836,  15.60841,  17.8028 ,  15.28365,  15.19425,
          13.84108,  16.11862,  13.96013,  17.63429],
        [ 34.80687,  32.60362,  32.49497,  33.20848,  31.60411,  31.77772,
          30.01728,  30.43507,  30.39505,  30.02525,  29.0597 ,  26.51025,
          26.47231,  24.56468,  24.62428,  23.49591,  21.7796 ,  24.33233,
          20.19876,  20.11514,  18.65654,  17.47779,  14.09155,  12.50632,
          13.12007,  11.0462 ,  10.31466,   9.53346,   9.53989,   8.89237,
          0.     ,   7.18087,   9.42639,  10.38858,  11.58877,  12.91252,
          14.59769,  15.59285,  18.95488,  20.67684,  20.8958 ,  24.70048,
          24.0165 ,  25.43853,  26.95084,  29.21772,  29.55268,  32.62558,
          32.93689,  34.88785,  35.60229,  38.44528,  39.2932 ,  39.98048,
          39.73092,  41.86321,  42.40135,  43.0919 ,  42.45519,  44.1862 ,
          43.47623,  45.37599,  44.76722,  47.773  ,  44.99764,  42.85482,
          45.0001 ,  44.84355,  44.80852,  44.71783,  43.31817,  42.17357,
          42.00564,  40.73932,  40.54667,  39.4803 ,  38.72058,  36.16405,
          34.29426,  35.27955,  33.02234,  30.89456,  29.48465,  28.8475 ,
          27.86781,  25.48297,  22.56247,  20.68579,  20.34994,  17.57016,
          17.81885,  16.39775,  15.34486,  15.15469,  14.83316,  14.19401,
          15.20368,  15.44059,  11.80224,  16.78251],
        [ 34.67094,  33.06432,  32.53298,  33.36339,  32.35099,  32.50386,
          31.59176,  31.12544,  31.12778,  31.11886,  30.47032,  27.84524,
          28.19409,  25.91998,  26.05861,  25.94766,  24.38931,  25.80959,
          22.03234,  21.80086,  20.52313,  19.26536,  17.70246,  15.65258,
          15.09318,  12.89802,  11.16178,  10.47996,  10.77149,  11.56402,
          7.18087,   0.     ,   8.74195,   9.19296,   8.9676 ,  10.89087,
          13.36331,  12.96807,  15.25494,  15.85912,  18.74728,  20.99385,
          20.58536,  21.90675,  23.7641 ,  25.59202,  26.79648,  29.58366,
          30.67949,  31.89102,  33.4665 ,  36.09133,  37.70993,  37.82863,
          37.1605 ,  39.86674,  40.65224,  42.17263,  41.48734,  42.91311,
          42.56542,  45.03955,  44.26307,  47.54766,  44.95504,  43.36693,
          45.22628,  45.15693,  45.74134,  45.58144,  44.57787,  43.24457,
          43.23535,  43.03554,  41.97252,  41.7482 ,  41.05749,  38.72517,
          37.14338,  37.61494,  36.50124,  33.46255,  32.11582,  32.19497,
          31.24603,  29.25163,  25.58682,  24.49213,  23.73966,  21.92186,
          20.66609,  18.42641,  19.3634 ,  16.24486,  17.24548,  15.15315,
          13.59916,  12.73676,  10.23459,  14.84621],
        [ 34.61157,  32.35053,  32.54342,  34.03547,  31.64065,  32.5482 ,
          31.2204 ,  31.08021,  31.04052,  31.15891,  31.03937,  28.94428,
          29.03612,  27.59428,  27.01352,  26.54727,  25.59948,  27.19217,
          24.49275,  23.21553,  22.48976,  20.81256,  18.65296,  16.85322,
          15.76199,  15.44491,  12.08679,  12.16654,  10.67123,   9.66796,
          9.42639,   8.74195,   0.     ,   4.97625,   7.39172,   8.51026,
          10.14648,   9.50175,  13.1454 ,  14.11243,  15.8578 ,  19.62747,
          18.29823,  20.97263,  21.55663,  24.21139,  24.16038,  28.57247,
          28.2877 ,  29.74339,  31.3773 ,  33.75635,  35.79133,  36.21335,
          36.02599,  38.43108,  39.29054,  40.11502,  40.44974,  41.86014,
          41.7082 ,  43.69002,  43.19493,  47.14492,  43.81483,  42.6301 ,
          44.81877,  45.24839,  44.99179,  45.27901,  44.24326,  44.00885,
          43.62399,  43.42716,  43.097  ,  42.57723,  41.90128,  39.82617,
          38.47462,  39.17248,  37.86386,  34.99443,  33.29005,  34.59372,
          32.25062,  30.55199,  28.63669,  26.61145,  26.02174,  22.74625,
          23.58481,  21.28107,  21.00584,  19.89187,  18.45627,  16.11799,
          14.52011,  14.22711,  12.12231,  15.73701],
        [ 33.95445,  31.31204,  31.6677 ,  33.03364,  30.7586 ,  31.99727,
          30.74726,  29.96861,  30.02038,  30.49865,  29.92437,  28.23706,
          28.11855,  26.89288,  25.91131,  25.58126,  25.17219,  26.53318,
          23.76956,  22.42534,  21.9616 ,  20.47412,  19.02075,  16.28059,
          15.39935,  14.85573,  11.83932,  11.7129 ,  10.77957,   8.7428 ,
          10.38858,   9.19296,   4.97625,   0.     ,   6.72148,  10.12496,
          12.00924,  10.13169,  12.83076,  14.2167 ,  16.72792,  19.37301,
          18.59613,  21.00058,  20.66568,  24.48285,  23.84352,  28.26891,
          28.32281,  29.3094 ,  30.90888,  33.39326,  35.6437 ,  35.93431,
          36.08269,  37.85734,  39.11931,  39.73362,  40.26473,  41.36942,
          41.39021,  43.28881,  42.72848,  46.85017,  43.10439,  42.13604,
          43.99537,  44.34038,  44.26734,  44.39004,  43.65807,  43.18833,
          42.95227,  42.93121,  42.14583,  41.96176,  41.49189,  39.07646,
          37.79461,  38.59134,  37.2521 ,  34.09993,  32.53784,  33.99566,
          31.15287,  30.43379,  27.85509,  26.08889,  25.78955,  22.49509,
          23.83891,  20.37192,  20.98593,  20.20119,  18.99761,  15.27863,
          13.7462 ,  13.92431,  12.80535,  16.20137],
        [ 36.09099,  33.96212,  34.4333 ,  35.82444,  33.58783,  34.67355,
          33.36662,  33.06401,  33.06101,  33.86459,  33.13454,  31.0608 ,
          31.78424,  30.55842,  30.18725,  29.12877,  28.8489 ,  30.11932,
          26.89441,  25.94406,  25.69566,  24.07951,  22.11715,  19.40831,
          19.70394,  17.38129,  15.09664,  15.01867,  14.38107,  11.95979,
          11.58877,   8.9676 ,   7.39172,   6.72148,   0.     ,   6.43367,
          8.98397,   8.67729,  10.0527 ,  12.31282,  13.61151,  17.29523,
          16.952  ,  18.20422,  19.0518 ,  23.06074,  23.05218,  26.13901,
          26.38234,  28.09777,  30.76486,  33.11761,  35.1361 ,  35.41829,
          35.86916,  38.17342,  39.25199,  40.55388,  40.93513,  42.5099 ,
          42.56349,  44.52465,  44.12784,  48.09543,  45.13455,  44.19635,
          46.17291,  46.91914,  47.23808,  47.21417,  46.86937,  46.30617,
          46.18952,  46.3353 ,  45.46555,  45.29483,  44.96068,  42.56432,
          41.36339,  42.23577,  40.86225,  37.9703 ,  36.62617,  37.63698,
          35.45185,  34.21791,  31.08457,  29.69294,  28.68309,  26.09517,
          26.05857,  23.59887,  22.7285 ,  22.24654,  20.53253,  16.26812,
          15.10008,  13.99427,  10.96839,  13.95765],
        [ 34.39821,  32.70361,  33.06171,  34.7116 ,  32.51966,  33.19062,
          32.19782,  32.57304,  32.51077,  33.37975,  33.19895,  30.49635,
          31.68759,  30.76624,  30.6706 ,  29.7836 ,  29.1434 ,  30.64921,
          27.73295,  26.90792,  26.5576 ,  24.48853,  22.68976,  20.28063,
          21.41588,  19.47045,  17.18703,  17.3945 ,  16.55356,  14.08575,
          12.91252,  10.89087,   8.51026,  10.12496,   6.43367,   0.     ,
          5.13455,   7.19981,   9.26742,  11.82888,  10.17125,  14.78769,
          13.87506,  15.22203,  17.04526,  19.97496,  20.45104,  22.81966,
          22.94849,  25.40346,  27.90575,  30.36558,  31.45698,  32.01961,
          32.50931,  35.50764,  35.83888,  37.37873,  37.77828,  39.79016,
          39.73051,  41.74234,  41.66611,  45.21051,  42.9827 ,  41.96344,
          44.45906,  45.37185,  45.70899,  45.86452,  45.49593,  45.23056,
          45.08133,  45.40294,  45.13354,  44.55667,  44.24469,  42.6187 ,
          41.59934,  42.40437,  41.24915,  39.18714,  37.89513,  38.80147,
          37.34563,  35.75256,  33.50089,  31.99846,  30.98915,  28.78806,
          28.57053,  27.01304,  25.56683,  25.4267 ,  23.23683,  21.19257,
          19.15064,  17.6646 ,  13.95903,  16.88417],
        [ 35.29278,  34.0075 ,  33.8104 ,  35.8487 ,  33.71852,  34.46902,
          33.24557,  33.997  ,  33.91746,  34.65544,  34.69406,  31.58452,
          33.16023,  32.23747,  32.78994,  31.07416,  30.36341,  32.34859,
          29.57591,  28.49847,  28.88904,  26.31214,  23.99425,  21.80124,
          23.13548,  20.77089,  19.54388,  18.42663,  18.86377,  15.80045,
          14.59769,  13.36331,  10.14648,  12.00924,   8.98397,   5.13455,
          0.     ,   7.16407,   9.04734,  11.89485,   7.77198,  14.16043,
          13.10023,  14.59801,  16.76365,  19.57846,  19.38376,  22.39702,
          21.86462,  24.72382,  27.4199 ,  29.752  ,  30.72862,  31.93212,
          32.14663,  35.16599,  35.88763,  37.34873,  38.05632,  39.9811 ,
          40.13104,  42.11747,  42.08783,  46.05367,  43.28691,  42.38342,
          45.19904,  46.24403,  46.80226,  47.00371,  46.37995,  46.44777,
          46.32251,  46.58154,  46.66496,  46.07288,  45.61367,  44.385  ,
          43.10472,  44.24015,  42.9754 ,  40.85532,  39.73088,  40.79164,
          39.14055,  37.3534 ,  35.4027 ,  33.98145,  32.97956,  30.08218,
          30.29887,  29.00976,  26.63001,  27.03646,  24.48703,  22.05865,
          20.62081,  19.57784,  14.73243,  17.36648],
        [ 33.43954,  31.79899,  32.32825,  33.89059,  31.59205,  33.13995,
          32.26498,  32.11079,  32.16109,  33.14589,  33.79095,  31.13131,
          32.00993,  30.8686 ,  31.0901 ,  29.98562,  29.95065,  31.49555,
          29.31235,  28.38986,  27.73913,  26.12805,  24.33084,  22.2785 ,
          22.85749,  21.32264,  19.20711,  18.36001,  17.93757,  16.65181,
          15.59285,  12.96807,   9.50175,  10.13169,   8.67729,   7.19981,
          7.16407,   0.     ,   5.29396,   8.67893,   9.00802,  11.50156,
          10.13767,  12.58519,  13.75226,  16.33162,  16.16096,  21.27586,
          20.36335,  22.08521,  24.78172,  26.80699,  28.87533,  29.58085,
          29.35632,  32.37612,  33.42273,  35.02844,  35.98014,  37.25958,
          38.02517,  40.01821,  39.69333,  44.39596,  40.98925,  40.81211,
          43.15676,  44.3192 ,  44.52264,  45.11777,  44.80329,  44.7664 ,
          44.57585,  45.54288,  45.13382,  45.13769,  45.036  ,  43.45157,
          42.69738,  43.68518,  42.70208,  40.23943,  39.23902,  40.71097,
          38.75821,  37.46691,  35.83383,  33.96711,  33.65132,  30.88072,
          31.70992,  29.12309,  28.97938,  27.45576,  26.55069,  22.69609,
          21.31464,  19.94906,  16.52504,  20.00963],
        [ 35.50327,  34.1394 ,  34.54666,  36.02136,  34.09468,  35.80184,
          35.20755,  34.68809,  34.72522,  36.03802,  36.57048,  34.00834,
          35.12134,  34.10976,  34.2731 ,  33.17048,  33.33854,  34.6749 ,
          32.28865,  31.34822,  31.08385,  29.5516 ,  28.06753,  25.59015,
          26.18616,  24.07172,  22.42597,  21.25014,  21.53923,  19.74296,
          18.95488,  15.25494,  13.1454 ,  12.83076,  10.0527 ,   9.26742,
          9.04734,   5.29396,   0.     ,   7.02491,   7.91346,   9.49832,
          8.97779,  10.53213,  11.64105,  15.08541,  14.93272,  19.4389 ,
          19.22241,  20.51852,  24.28367,  26.21266,  28.62454,  29.21067,
          29.13434,  32.23565,  33.74681,  35.77881,  37.02082,  38.04921,
          39.25933,  41.2876 ,  41.02127,  45.92867,  42.53998,  42.80247,
          45.02922,  46.2601 ,  46.99824,  47.39798,  47.50405,  47.43771,
          47.28364,  48.66654,  47.8922 ,  48.31191,  48.29145,  46.78708,
          46.0658 ,  47.00178,  46.27576,  43.40774,  42.66151,  44.23342,
          42.09818,  41.14137,  38.8066 ,  37.42541,  36.96229,  34.28354,
          34.64723,  31.85059,  31.58249,  30.04064,  28.92462,  24.27898,
          22.53438,  20.85881,  17.8264 ,  20.38759],
        [ 34.96861,  34.08447,  33.66703,  35.60052,  34.22325,  35.25591,
          35.27066,  34.12659,  34.26106,  35.51766,  36.01451,  33.61703,
          34.61314,  33.50914,  33.85408,  33.35028,  33.29967,  33.71667,
          31.99324,  30.44753,  31.06195,  28.71938,  28.67934,  26.20645,
          25.68635,  24.28534,  21.78585,  21.14056,  21.5    ,  20.61442,
          20.67684,  15.85912,  14.11243,  14.2167 ,  12.31282,  11.82888,
          11.89485,   8.67893,   7.02491,   0.     ,  11.6549 ,  10.73557,
          9.71187,  12.80952,  12.4755 ,  15.06586,  16.27814,  20.16314,
          21.00477,  21.04933,  24.7121 ,  26.38835,  29.5294 ,  29.42525,
          28.82948,  32.05309,  33.66472,  36.01266,  37.14096,  37.87527,
          38.78613,  41.51105,  41.02762,  45.8564 ,  42.62709,  42.66475,
          44.95803,  45.70734,  46.90492,  47.20804,  47.14969,  46.86   ,
          46.8637 ,  48.70376,  47.41032,  48.23058,  47.81376,  46.72845,
          45.78045,  46.55168,  46.44799,  43.06789,  41.80521,  44.2389 ,
          41.92408,  40.96925,  38.73615,  37.92498,  36.83463,  34.6773 ,
          34.46336,  31.84197,  32.48614,  29.86623,  29.37943,  25.34313,
          22.18623,  20.58748,  18.68724,  20.88898],
        [ 34.61776,  34.40636,  34.21985,  36.08047,  34.16007,  35.33808,
          34.3224 ,  35.42161,  35.29431,  36.24468,  37.16413,  34.00148,
          36.07251,  35.42056,  36.35145,  34.18506,  33.88558,  36.43731,
          33.95671,  32.95536,  33.13063,  30.9913 ,  28.75474,  27.03954,
          28.9516 ,  25.596  ,  24.86467,  23.39958,  24.50229,  21.15351,
          20.8958 ,  18.74728,  15.8578 ,  16.72792,  13.61151,  10.17125,
          7.77198,   9.00802,   7.91346,  11.6549 ,   0.     ,   8.82796,
          8.51924,   8.99769,  12.41161,  14.38248,  13.54233,  16.59245,
          15.72496,  18.98626,  22.36856,  24.60879,  26.09397,  27.63374,
          27.67937,  30.67328,  31.99623,  33.83917,  35.09395,  36.84287,
          37.83474,  39.87093,  39.81846,  44.45979,  41.3634 ,  41.50962,
          44.11761,  45.79608,  46.84759,  47.06841,  46.96281,  47.70312,
          47.32522,  48.293  ,  48.42568,  48.33951,  48.32094,  47.48303,
          46.66074,  47.9282 ,  47.12264,  45.05578,  44.3409 ,  45.66062,
          43.92436,  42.83903,  40.98259,  39.58649,  38.84249,  36.13211,
          36.84814,  34.73249,  33.17741,  33.3556 ,  31.06652,  27.70613,
          26.09503,  25.22437,  20.37247,  22.75393],
        [ 31.52205,  32.09843,  31.60984,  33.37669,  32.3283 ,  33.38177,
          33.45572,  33.62916,  33.7662 ,  35.04257,  36.42303,  33.33828,
          35.37259,  34.64547,  35.76726,  34.59722,  34.48264,  36.39199,
          34.64837,  33.76841,  33.66469,  31.6734 ,  31.08502,  29.20724,
          30.93716,  27.93375,  26.82595,  25.64935,  26.72856,  24.45494,
          24.70048,  20.99385,  19.62747,  19.37301,  17.29523,  14.78769,
          14.16043,  11.50156,   9.49832,  10.73557,   8.82796,   0.     ,
          3.87115,   4.46637,   8.17529,   8.09024,   8.56917,  11.67969,
          12.43841,  13.85593,  17.57202,  19.71272,  21.99594,  22.85153,
          22.16445,  25.45666,  27.04794,  29.67531,  31.04348,  32.13853,
          33.7628 ,  36.48198,  36.14058,  41.01457,  37.91637,  38.79497,
          40.96397,  42.64609,  44.26794,  44.55381,  44.89301,  45.34457,
          45.22525,  47.30472,  46.71893,  47.3816 ,  47.69802,  47.15203,
          46.77432,  47.78838,  47.81124,  45.64705,  44.93698,  46.70672,
          45.20662,  44.90814,  43.03585,  41.8455 ,  41.35057,  39.45815,
          40.11168,  37.08534,  37.64673,  36.20666,  35.37051,  31.85248,
          29.10527,  28.10747,  24.43796,  27.26505],
        [ 31.5479 ,  31.55098,  31.44096,  33.34017,  31.89116,  33.04059,
          33.21501,  33.16394,  33.40285,  34.67094,  36.18591,  33.20841,
          34.85009,  34.19767,  35.06246,  34.20947,  34.10065,  35.67965,
          34.25079,  33.23805,  33.0211 ,  31.05312,  30.53155,  28.64062,
          30.0345 ,  27.86256,  26.17402,  25.29954,  25.8231 ,  23.9113 ,
          24.0165 ,  20.58536,  18.29823,  18.59613,  16.952  ,  13.87506,
          13.10023,  10.13767,   8.97779,   9.71187,   8.51924,   3.87115,
          0.     ,   6.12594,   7.96356,   7.57526,   8.45868,  12.97798,
          12.90918,  14.31407,  17.64249,  19.73502,  21.71174,  22.56943,
          21.94117,  25.69766,  26.75678,  29.24043,  30.87281,  31.9451 ,
          33.52238,  36.04839,  35.83875,  40.75469,  37.69173,  38.4327 ,
          40.95094,  42.4804 ,  43.60742,  44.22534,  44.42682,  44.91905,
          44.77389,  46.85295,  46.45624,  46.96242,  47.13319,  46.71132,
          46.36086,  47.34189,  47.27088,  45.18382,  44.30438,  46.30564,
          44.68842,  44.1482 ,  42.80237,  41.36941,  40.89437,  38.88697,
          39.62182,  36.88549,  37.35607,  35.71787,  34.81861,  31.64177,
          28.85684,  27.61326,  24.23459,  27.25467],
        [ 31.86234,  32.21933,  32.23245,  33.79942,  32.43132,  33.91149,
          33.77282,  34.14988,  34.11146,  35.65553,  37.09342,  33.84176,
          36.19004,  35.53408,  36.69763,  35.18721,  35.42542,  37.13664,
          35.22869,  34.76968,  34.43139,  32.90775,  31.69899,  29.85524,
          32.15204,  28.87872,  28.22608,  27.11021,  27.87236,  26.09147,
          25.43853,  21.90675,  20.97263,  21.00058,  18.20422,  15.22203,
          14.59801,  12.58519,  10.53213,  12.80952,   8.99769,   4.46637,
          6.12594,   0.     ,   8.44401,   7.97982,   8.83251,  10.38464,
          10.82867,  12.8995 ,  17.10962,  18.97275,  20.8149 ,  21.56576,
          21.19765,  24.98392,  26.22855,  29.18584,  30.1669 ,  31.64604,
          33.19261,  35.58516,  35.3853 ,  40.18287,  37.57579,  38.53515,
          40.71094,  42.71524,  44.28372,  44.57255,  45.13821,  45.55069,
          45.47875,  47.62256,  47.08008,  47.68002,  48.15121,  47.49823,
          47.35146,  48.3686 ,  48.33511,  46.28713,  46.10429,  47.57535,
          46.38933,  45.72293,  43.99917,  42.7842 ,  42.32976,  40.70953,
          41.06713,  38.47232,  38.78739,  37.64475,  36.9269 ,  33.11543,
          30.98764,  29.72708,  25.83973,  28.4507 ],
        [ 30.85453,  29.68935,  30.68488,  32.42774,  30.52192,  32.75336,
          32.98931,  31.96731,  32.13639,  34.59658,  35.61312,  33.36215,
          34.77939,  35.0925 ,  35.34281,  34.12158,  35.45233,  35.96695,
          34.85416,  33.79277,  34.32978,  32.68055,  32.62122,  29.8061 ,
          31.65812,  29.7082 ,  28.33647,  27.88541,  28.08681,  26.17295,
          26.95084,  23.7641 ,  21.55663,  20.66568,  19.0518 ,  17.04526,
          16.76365,  13.75226,  11.64105,  12.4755 ,  12.41161,   8.17529,
          7.96356,   8.44401,   0.     ,   9.43444,   8.12104,  10.99449,
          11.78021,  11.37028,  14.90543,  16.80241,  19.058  ,  19.18607,
          20.42547,  22.96086,  24.54862,  26.69301,  29.07142,  29.81017,
          31.49645,  33.32921,  33.38918,  38.71385,  35.4746 ,  36.61224,
          39.11164,  40.61639,  42.02245,  42.49394,  43.59005,  43.80397,
          43.89376,  46.64783,  45.65345,  46.63616,  47.08335,  46.48834,
          46.45531,  47.75785,  47.61879,  45.29908,  45.03967,  47.61192,
          45.31081,  45.41523,  44.16385,  43.17606,  42.72795,  41.05225,
          42.00461,  39.14698,  39.86511,  39.12616,  38.19473,  33.86518,
          31.76617,  30.50207,  27.94986,  30.43803],
        [ 29.69611,  30.64989,  30.737  ,  31.97527,  31.02961,  32.5993 ,
          33.29691,  33.13473,  33.33042,  34.79422,  37.27428,  34.29352,
          36.03767,  35.58014,  36.84744,  35.88742,  36.19829,  37.67898,
          36.69074,  36.13666,  35.45315,  34.31807,  33.92971,  32.57415,
          34.38793,  31.88982,  30.77347,  29.88329,  30.54159,  29.57049,
          29.21772,  25.59202,  24.21139,  24.48285,  23.06074,  19.97496,
          19.57846,  16.33162,  15.08541,  15.06586,  14.38248,   8.09024,
          7.57526,   7.97982,   9.43444,   0.     ,   6.60121,   9.85696,
          10.89332,  10.39258,  12.86851,  14.75476,  17.21257,  17.61602,
          15.71376,  20.40996,  21.66767,  25.03361,  26.60748,  27.25091,
          29.58843,  32.22904,  31.80973,  37.16025,  34.28055,  35.884  ,
          38.25288,  39.99024,  41.63577,  42.34816,  43.03802,  43.69836,
          43.42436,  46.41609,  45.84523,  46.92581,  47.45754,  47.51112,
          47.68894,  48.68155,  49.1594 ,  47.14392,  46.92675,  49.05016,
          47.7489 ,  47.3948 ,  46.55753,  45.24034,  45.04445,  43.71142,
          44.46337,  41.62923,  43.11111,  40.95347,  40.97874,  37.50522,
          35.00647,  33.76313,  30.48797,  33.78487],
        [ 29.41756,  29.84656,  30.20034,  31.72587,  30.1106 ,  32.43664,
          32.48639,  32.68089,  32.66608,  34.36677,  36.78719,  34.00194,
          35.84771,  35.82126,  36.8362 ,  35.13336,  36.03964,  37.95828,
          37.04425,  36.16784,  35.945  ,  34.6565 ,  33.80767,  32.29469,
          34.38638,  31.87346,  31.09911,  29.87818,  30.74741,  28.96665,
          29.55268,  26.79648,  24.16038,  23.84352,  23.05218,  20.45104,
          19.38376,  16.16096,  14.93272,  16.27814,  13.54233,   8.56917,
          8.45868,   8.83251,   8.12104,   6.60121,   0.     ,  10.17757,
          8.53509,   8.32038,  10.85168,  12.70132,  15.99258,  17.25635,
          16.51621,  19.26168,  21.60589,  23.78436,  26.22532,  26.73652,
          29.27758,  31.33041,  31.04823,  37.12763,  32.98749,  35.06947,
          37.28719,  39.461  ,  40.85783,  41.59448,  42.32162,  43.57751,
          43.1737 ,  45.94993,  45.7186 ,  46.70514,  47.35142,  47.22145,
          47.41203,  48.74309,  48.88315,  46.89426,  46.8966 ,  49.20629,
          47.28112,  47.34997,  46.70348,  45.24956,  45.31637,  43.29447,
          44.9994 ,  41.76229,  42.8692 ,  41.88106,  41.23793,  37.14262,
          35.24283,  34.57233,  31.19456,  34.11927],
        [ 28.83014,  30.31266,  30.13288,  31.85386,  31.0687 ,  32.23116,
          32.89237,  33.34788,  33.38514,  35.45895,  37.18274,  34.24137,
          37.05029,  37.49003,  38.82735,  37.20982,  37.86692,  39.3333 ,
          38.1781 ,  37.57777,  38.07486,  36.33305,  36.2285 ,  34.31277,
          37.50663,  34.12199,  33.82732,  33.15122,  34.21383,  31.93696,
          32.62558,  29.58366,  28.57247,  28.26891,  26.13901,  22.81966,
          22.39702,  21.27586,  19.4389 ,  20.16314,  16.59245,  11.67969,
          12.97798,  10.38464,  10.99449,   9.85696,  10.17757,   0.     ,
          7.83858,   8.41089,  11.19326,  13.48331,  14.05563,  14.64482,
          15.51254,  18.33828,  19.49451,  22.64066,  24.21162,  25.72832,
          27.49107,  29.94017,  30.09775,  34.51412,  32.6424 ,  34.1041 ,
          36.48373,  38.65803,  41.22222,  41.17685,  42.52243,  43.43884,
          43.36506,  46.36946,  45.84661,  46.8006 ,  47.56391,  47.96634,
          48.21386,  49.40067,  49.99774,  48.4731 ,  48.58388,  50.70632,
          49.48718,  49.72993,  48.60454,  47.90274,  47.29044,  46.48555,
          47.1459 ,  44.6641 ,  45.39504,  45.2002 ,  44.23507,  41.08682,
          38.38866,  37.70556,  34.12645,  36.59337],
        [ 30.11403,  30.95073,  31.62192,  33.66607,  31.53677,  33.38874,
          33.31269,  34.37908,  34.29769,  36.3779 ,  38.417  ,  35.53305,
          38.33912,  38.6495 ,  39.99487,  37.74652,  38.88208,  40.59642,
          39.77615,  39.01639,  39.28353,  37.55324,  36.50334,  34.99807,
          38.17473,  35.33819,  34.63993,  33.91166,  34.31615,  32.42409,
          32.93689,  30.67949,  28.2877 ,  28.32281,  26.38234,  22.94849,
          21.86462,  20.36335,  19.22241,  21.00477,  15.72496,  12.43841,
          12.90918,  10.82867,  11.78021,  10.89332,   8.53509,   7.83858,
          0.     ,   6.82238,  11.4934 ,  11.88195,  13.2132 ,  14.82213,
          16.05954,  18.55392,  19.55994,  22.19041,  24.20944,  25.95339,
          27.98701,  29.72961,  30.14266,  35.2683 ,  32.68231,  34.49442,
          36.84283,  39.96906,  41.25252,  41.86267,  43.03579,  44.67317,
          44.36291,  47.1119 ,  47.23168,  47.84897,  48.73064,  48.82056,
          49.2878 ,  50.56509,  50.75426,  49.53957,  49.65108,  51.8766 ,
          50.44647,  50.26925,  49.99599,  48.57102,  48.20799,  46.79335,
          48.1779 ,  45.75658,  46.03133,  46.10588,  44.94675,  41.40908,
          39.40758,  38.86882,  34.90814,  37.3594 ],
        [ 28.76504,  29.50086,  30.13293,  32.0357 ,  30.2114 ,  32.62237,
          33.17576,  32.97516,  32.89254,  35.3327 ,  37.62287,  35.23732,
          37.71305,  38.10808,  39.19622,  37.47408,  39.07201,  39.92405,
          39.60791,  38.73035,  39.22602,  37.84719,  37.53278,  35.82   ,
          38.39304,  36.0731 ,  35.32224,  34.60562,  35.0456 ,  34.06939,
          34.88785,  31.89102,  29.74339,  29.3094 ,  28.09777,  25.40346,
          24.72382,  22.08521,  20.51852,  21.04933,  18.98626,  13.85593,
          14.31407,  12.8995 ,  11.37028,  10.39258,   8.32038,   8.41089,
          6.82238,   0.     ,   8.71731,   7.76443,  12.45335,  12.2652 ,
          12.90017,  15.09061,  17.41787,  20.38048,  22.61928,  23.14501,
          25.76323,  27.71115,  27.8258 ,  33.66319,  30.48156,  32.98226,
          34.95939,  37.85604,  39.53608,  40.08616,  41.63043,  43.15796,
          42.86376,  46.50258,  45.86231,  47.29211,  48.17182,  48.3848 ,
          49.04825,  50.09211,  50.93521,  48.90653,  49.34591,  52.28837,
          50.39015,  50.58997,  50.40001,  49.3039 ,  49.05992,  47.89894,
          49.234  ,  46.43048,  47.85874,  47.20917,  46.79585,  42.67964,
          40.30443,  39.8812 ,  36.95114,  39.24277],
        [ 23.7291 ,  25.13342,  25.84322,  26.92882,  25.7518 ,  28.36209,
          29.06571,  29.38917,  29.26526,  31.54706,  34.72634,  32.32311,
          34.34605,  35.42106,  36.6623 ,  34.70021,  36.40368,  37.99061,
          38.021  ,  37.37737,  37.42741,  36.54117,  36.5014 ,  35.31492,
          38.36668,  35.88703,  35.64687,  34.9862 ,  35.81848,  34.49619,
          35.60229,  33.4665 ,  31.3773 ,  30.90888,  30.76486,  27.90575,
          27.4199 ,  24.78172,  24.28367,  24.7121 ,  22.36856,  17.57202,
          17.64249,  17.10962,  14.90543,  12.86851,  10.85168,  11.19326,
          11.4934 ,   8.71731,   0.     ,   5.57175,   8.63071,   9.25549,
          9.12862,   9.36863,  12.44362,  14.25313,  17.25268,  17.45389,
          20.41051,  22.31093,  22.02977,  28.4554 ,  24.40348,  27.41917,
          29.65847,  32.03859,  34.25637,  34.87194,  36.40332,  38.15373,
          37.65245,  41.47684,  41.28355,  42.71965,  43.82151,  44.61234,
          45.47536,  47.05548,  47.78609,  46.48006,  47.17699,  49.92586,
          48.24647,  49.03127,  49.42958,  48.33632,  48.54484,  47.60107,
          49.68564,  46.61442,  48.6812 ,  48.31756,  48.12534,  44.56241,
          42.7187 ,  42.53511,  39.36061,  42.55081],
        [ 25.6983 ,  26.92125,  27.91135,  29.3656 ,  27.6139 ,  30.55605,
          31.25932,  31.30679,  31.06269,  33.65312,  36.87088,  34.68689,
          36.90215,  37.82413,  39.10442,  37.06721,  39.23049,  40.17349,
          40.62842,  39.86314,  40.16763,  39.18647,  39.07491,  37.94267,
          40.71544,  38.71968,  38.19558,  37.6223 ,  38.00399,  37.51745,
          38.44528,  36.09133,  33.75635,  33.39326,  33.11761,  30.36558,
          29.752  ,  26.80699,  26.21266,  26.38835,  24.60879,  19.71272,
          19.73502,  18.97275,  16.80241,  14.75476,  12.70132,  13.48331,
          11.88195,   7.76443,   5.57175,   0.     ,   9.15475,   8.56349,
          8.47478,   8.49044,  11.99477,  14.44966,  17.32829,  17.19026,
          20.41925,  22.11879,  22.02562,  28.80888,  24.85666,  28.34247,
          30.26402,  33.37055,  35.15239,  36.01863,  37.78748,  39.81268,
          39.32254,  43.59766,  43.22273,  44.89829,  46.04871,  46.77149,
          47.87025,  49.21038,  50.23529,  48.6807 ,  49.53981,  52.72328,
          50.9    ,  51.39158,  52.21003,  51.04052,  51.18106,  50.27656,
          52.28684,  49.36971,  51.53462,  50.93333,  50.99637,  47.03863,
          45.1501 ,  44.98107,  42.0262 ,  44.83658],
        [ 25.97412,  26.77764,  28.12311,  29.6113 ,  28.20037,  30.3347 ,
          31.50259,  31.86587,  32.01605,  34.74652,  37.5226 ,  34.89579,
          37.11372,  38.53678,  39.88191,  38.15456,  39.92573,  40.90994,
          41.3098 ,  40.9369 ,  41.16595,  39.96285,  40.15724,  38.60944,
          42.31539,  40.48097,  40.17273,  39.74094,  40.05607,  38.87821,
          39.2932 ,  37.70993,  35.79133,  35.6437 ,  35.1361 ,  31.45698,
          30.72862,  28.87533,  28.62454,  29.5294 ,  26.09397,  21.99594,
          21.71174,  20.8149 ,  19.058  ,  17.21257,  15.99258,  14.05563,
          13.2132 ,  12.45335,   8.63071,   9.15475,   0.     ,   5.69041,
          8.86444,  10.50088,   9.15299,  11.56439,  15.31776,  16.37099,
          19.20324,  20.11261,  21.17791,  26.23138,  24.1575 ,  26.74297,
          29.9642 ,  32.63265,  34.33692,  35.4078 ,  37.27436,  38.82324,
          38.79999,  42.81333,  43.14353,  44.0194 ,  45.29074,  46.65033,
          47.77203,  49.32322,  49.88537,  49.61055,  50.40164,  52.96687,
          51.90866,  52.35132,  53.40064,  52.18807,  52.39054,  51.76294,
          53.60591,  51.35824,  52.66349,  52.69263,  52.29538,  49.4784 ,
          47.59661,  47.05231,  43.63606,  46.86818],
        [ 25.13513,  25.45479,  27.30813,  28.77098,  27.20175,  29.56765,
          31.19405,  30.67301,  30.75263,  33.95725,  36.63014,  34.4585 ,
          36.56462,  38.03388,  38.95773,  37.88232,  40.05261,  39.98119,
          40.72945,  40.37831,  40.59288,  39.6461 ,  40.40674,  38.67121,
          42.04724,  40.65492,  39.9043 ,  40.05704,  39.79457,  39.44799,
          39.98048,  37.82863,  36.21335,  35.93431,  35.41829,  32.01961,
          31.93212,  29.58085,  29.21067,  29.42525,  27.63374,  22.85153,
          22.56943,  21.56576,  19.18607,  17.61602,  17.25635,  14.64482,
          14.82213,  12.2652 ,   9.25549,   8.56349,   5.69041,   0.     ,
          7.69056,   9.58872,   7.27847,  11.07301,  13.97117,  14.85007,
          17.3385 ,  18.54959,  19.51911,  24.47804,  23.22298,  25.99818,
          28.67918,  31.37243,  33.06567,  34.08613,  36.44189,  37.65905,
          37.7809 ,  42.43773,  42.01543,  43.33093,  44.64622,  45.80397,
          47.25139,  48.43046,  49.49756,  48.83554,  49.72558,  52.67093,
          51.57562,  52.08085,  53.1481 ,  52.11595,  52.16829,  52.09858,
          53.53316,  51.2622 ,  53.32599,  52.90649,  52.95174,  49.96028,
          47.72114,  47.06461,  44.40938,  47.37281],
        [ 24.45972,  26.64139,  27.01853,  27.98344,  27.57982,  29.58556,
          31.33608,  31.14565,  31.17672,  33.40518,  37.07125,  34.33839,
          36.48557,  37.13566,  38.89602,  37.77484,  39.20976,  39.92003,
          40.56478,  40.3905 ,  40.07303,  39.38249,  39.85148,  38.95962,
          41.86037,  40.04445,  39.71271,  39.15768,  39.61693,  39.80638,
          39.73092,  37.1605 ,  36.02599,  36.08269,  35.86916,  32.50931,
          32.14663,  29.35632,  29.13434,  28.82948,  27.67937,  22.16445,
          21.94117,  21.19765,  20.42547,  15.71376,  16.51621,  15.51254,
          16.05954,  12.90017,   9.12862,   8.47478,   8.86444,   7.69056,
          0.     ,   8.27573,   8.48397,  13.22617,  14.5959 ,  14.29243,
          17.74386,  20.29587,  20.04847,  25.72337,  23.44249,  26.57937,
          28.95484,  31.3744 ,  33.67799,  34.68713,  36.28302,  37.6514 ,
          37.46012,  42.17949,  41.8008 ,  43.46606,  44.62028,  46.06782,
          47.29764,  48.35452,  49.81537,  48.72589,  49.68722,  52.42257,
          51.63792,  51.8305 ,  52.84663,  51.78041,  52.05071,  51.83186,
          53.22438,  50.71905,  53.35513,  51.86422,  52.68216,  49.67751,
          47.40003,  46.87143,  43.90372,  47.26843],
        [ 21.55045,  24.28835,  24.69093,  25.49869,  25.10337,  27.53405,
          28.94501,  29.06828,  28.89607,  31.44167,  35.13839,  33.07445,
          35.26936,  36.62481,  38.43435,  36.36806,  38.61636,  39.6808 ,
          40.68159,  40.18733,  40.5409 ,  39.77171,  40.40163,  39.63135,
          42.90939,  40.78432,  40.82968,  40.26411,  41.10429,  40.83166,
          41.86321,  39.86674,  38.43108,  37.85734,  38.17342,  35.50764,
          35.16599,  32.37612,  32.23565,  32.05309,  30.67328,  25.45666,
          25.69766,  24.98392,  22.96086,  20.40996,  19.26168,  18.33828,
          18.55392,  15.09061,   9.36863,   8.49044,  10.50088,   9.58872,
          8.27573,   0.     ,   7.81203,   9.63841,  11.81341,  10.38626,
          14.34691,  16.65127,  16.01583,  22.86644,  18.67511,  22.78851,
          24.49932,  27.34599,  30.249  ,  30.89222,  32.98648,  35.07533,
          34.59757,  39.54874,  39.14111,  41.24033,  42.66911,  44.16304,
          45.54425,  47.06384,  48.51593,  47.55693,  48.77945,  51.948  ,
          50.60804,  51.67431,  52.94916,  52.10773,  52.46879,  52.27757,
          54.53359,  51.56906,  54.55259,  53.99784,  54.65517,  51.26881,
          49.40055,  49.64106,  46.62981,  49.95592],
        [ 21.69278,  23.54393,  24.94734,  26.08835,  25.22312,  26.86667,
          28.98748,  29.04268,  29.20958,  31.93944,  35.36933,  33.23999,
          35.32999,  36.8622 ,  38.31651,  37.32521,  39.27939,  39.62528,
          40.97394,  40.75477,  40.65161,  39.84257,  40.9679 ,  39.99892,
          43.56974,  42.24041,  41.59044,  41.81453,  41.69482,  41.71964,
          42.40135,  40.65224,  39.29054,  39.11931,  39.25199,  35.83888,
          35.88763,  33.42273,  33.74681,  33.66472,  31.99623,  27.04794,
          26.75678,  26.22855,  24.54862,  21.66767,  21.60589,  19.49451,
          19.55994,  17.41787,  12.44362,  11.99477,   9.15299,   7.27847,
          8.48397,   7.81203,   0.     ,   6.39087,   8.34311,   9.09498,
          12.01051,  14.03886,  14.66736,  19.35195,  18.37439,  21.53225,
          24.01021,  26.91727,  28.70851,  29.95311,  32.23778,  33.96847,
          33.87564,  38.86784,  38.83989,  40.22175,  41.76582,  43.56084,
          45.32808,  46.48406,  47.93843,  47.98325,  48.86364,  51.79319,
          51.20293,  51.97604,  53.74581,  52.60551,  52.8835 ,  53.24671,
          55.09278,  52.73899,  55.52021,  54.91969,  55.45876,  53.12569,
          50.8073 ,  50.61611,  47.78862,  51.26349],
        [ 19.95303,  21.14658,  23.21836,  24.3511 ,  22.84998,  25.00712,
          26.83509,  27.11562,  27.32181,  30.05815,  33.57977,  31.99141,
          33.72941,  35.93997,  37.10258,  35.80232,  38.1003 ,  38.71391,
          40.4026 ,  40.04084,  40.1262 ,  39.44919,  40.5153 ,  39.64319,
          43.4618 ,  42.36186,  41.89523,  42.1735 ,  42.04974,  41.67128,
          43.0919 ,  42.17263,  40.11502,  39.73362,  40.55388,  37.37873,
          37.34873,  35.02844,  35.77881,  36.01266,  33.83917,  29.67531,
          29.24043,  29.18584,  26.69301,  25.03361,  23.78436,  22.64066,
          22.19041,  20.38048,  14.25313,  14.44966,  11.56439,  11.07301,
          13.22617,   9.63841,   6.39087,   0.     ,   7.5008 ,   7.8237 ,
          10.40305,  10.70596,  11.78864,  17.10573,  14.52165,  18.11827,
          20.90729,  23.93647,  25.20954,  26.57818,  28.98693,  31.46102,
          31.12039,  35.92599,  36.4427 ,  37.60689,  39.32328,  41.32062,
          43.23691,  44.71995,  45.92899,  46.36053,  47.3359 ,  50.52313,
          49.48781,  50.80266,  53.15541,  51.87092,  52.39965,  52.58596,
          55.23165,  52.76786,  55.52018,  55.73155,  55.94518,  53.73325,
          51.74464,  51.99425,  49.21381,  52.79329],
        [ 16.26348,  19.0042 ,  20.37644,  21.22304,  20.28434,  21.74171,
          23.67883,  24.63125,  24.53975,  26.96615,  30.77296,  28.83607,
          31.33676,  33.1206 ,  34.93565,  33.52616,  35.6578 ,  36.21198,
          37.91905,  38.03854,  37.85329,  37.48819,  38.42327,  38.13686,
          42.34263,  40.86445,  40.82556,  41.17397,  41.08039,  41.61213,
          42.45519,  41.48734,  40.44974,  40.26473,  40.93513,  37.77828,
          38.05632,  35.98014,  37.02082,  37.14096,  35.09395,  31.04348,
          30.87281,  30.1669 ,  29.07142,  26.60748,  26.22532,  24.21162,
          24.20944,  22.61928,  17.25268,  17.32829,  15.31776,  13.97117,
          14.5959 ,  11.81341,   8.34311,   7.5008 ,   0.     ,   5.83413,
          5.46876,   8.07889,   8.10377,  12.28344,  11.70756,  14.58617,
          16.50391,  20.31629,  22.0821 ,  22.97453,  25.272  ,  27.72545,
          27.36277,  32.25835,  32.61786,  33.89607,  35.73057,  37.77336,
          39.95231,  41.07814,  42.85021,  43.44198,  44.85383,  47.6269 ,
          47.47827,  48.41191,  50.90451,  49.78713,  50.24847,  51.22179,
          53.41837,  51.29034,  54.5929 ,  54.6199 ,  55.51699,  53.60744,
          51.63282,  52.1621 ,  49.27814,  52.86302],
        [ 17.11013,  19.69926,  20.92257,  21.25266,  20.93006,  23.02809,
          25.4293 ,  25.08637,  25.21252,  27.64338,  31.75893,  30.27728,
          32.09544,  33.81829,  35.54241,  34.40962,  36.74788,  37.08048,
          39.08311,  39.0819 ,  38.93651,  38.87541,  40.1212 ,  39.73796,
          43.41177,  42.22587,  42.24267,  42.24356,  42.4485 ,  43.2428 ,
          44.1862 ,  42.91311,  41.86014,  41.36942,  42.5099 ,  39.79016,
          39.9811 ,  37.25958,  38.04921,  37.87527,  36.84287,  32.13853,
          31.9451 ,  31.64604,  29.81017,  27.25091,  26.73652,  25.72832,
          25.95339,  23.14501,  17.45389,  17.19026,  16.37099,  14.85007,
          14.29243,  10.38626,   9.09498,   7.8237 ,   5.83413,   0.     ,
          6.41631,   8.54307,   7.54798,  13.83722,  10.47169,  14.98237,
          16.51711,  19.64403,  21.76762,  22.8833 ,  25.40245,  27.78937,
          27.30865,  32.95778,  32.79115,  34.89289,  36.70972,  38.8788 ,
          41.05635,  42.15574,  44.18684,  44.13238,  45.71765,  48.95971,
          48.28665,  49.59359,  52.1083 ,  51.08147,  51.81738,  52.5753 ,
          55.01953,  52.46332,  56.32081,  55.78484,  57.09844,  54.71573,
          52.72249,  53.32   ,  50.79307,  54.50537],
        [ 14.32254,  17.01569,  17.85377,  18.87943,  18.50018,  19.62897,
          22.19619,  22.31814,  22.16274,  24.84473,  28.54674,  27.08538,
          29.33582,  31.46152,  33.22748,  32.12772,  34.53888,  34.29651,
          36.66186,  36.62329,  37.02688,  36.52095,  38.22838,  37.88513,
          41.79768,  40.89454,  40.88634,  41.4135 ,  41.31527,  42.36568,
          43.47623,  42.56542,  41.7082 ,  41.39021,  42.56349,  39.73051,
          40.13104,  38.02517,  39.25933,  38.78613,  37.83474,  33.7628 ,
          33.52238,  33.19261,  31.49645,  29.58843,  29.27758,  27.49107,
          27.98701,  25.76323,  20.41051,  20.41925,  19.20324,  17.3385 ,
          17.74386,  14.34691,  12.01051,  10.40305,   5.46876,   6.41631,
          0.     ,   6.56254,   5.82652,   9.42892,   8.76253,  11.01716,
          12.97536,  16.14407,  18.65999,  19.26615,  21.70973,  23.98596,
          23.83313,  29.46502,  29.31874,  31.04096,  32.71498,  35.20378,
          37.43086,  38.47346,  40.74117,  41.15986,  42.72724,  46.03943,
          45.7643 ,  46.92375,  49.81399,  49.07544,  49.48923,  50.83285,
          53.02921,  51.02381,  54.85708,  54.85699,  56.10978,  54.39723,
          52.29678,  53.08869,  50.68305,  54.16762],
        [ 17.62265,  17.70308,  20.91217,  21.25316,  19.27925,  22.0497 ,
          23.92894,  23.71491,  23.60181,  26.74278,  30.22502,  29.42086,
          31.07569,  33.72103,  34.83971,  33.40582,  36.56434,  36.10593,
          38.48701,  38.68787,  38.83153,  39.03388,  40.08247,  39.57072,
          43.79152,  43.17864,  43.2909 ,  43.87194,  43.35611,  44.39476,
          45.37599,  45.03955,  43.69002,  43.28881,  44.52465,  41.74234,
          42.11747,  40.01821,  41.2876 ,  41.51105,  39.87093,  36.48198,
          36.04839,  35.58516,  33.32921,  32.22904,  31.33041,  29.94017,
          29.72961,  27.71115,  22.31093,  22.11879,  20.11261,  18.54959,
          20.29587,  16.65127,  14.03886,  10.70596,   8.07889,   8.54307,
          6.56254,   0.     ,   4.33833,   8.76183,   7.88595,  10.96004,
          13.3731 ,  17.00054,  17.6708 ,  18.90909,  22.24521,  24.80605,
          24.44948,  29.94102,  30.21988,  31.68858,  33.75574,  35.95484,
          38.6216 ,  39.86389,  41.58399,  42.28369,  44.38077,  47.67845,
          47.02336,  48.24653,  51.67294,  50.62617,  51.37421,  52.55434,
          55.1481 ,  53.295  ,  56.77537,  57.33105,  58.35886,  56.29047,
          54.80877,  55.50578,  53.14199,  56.6705 ],
        [ 15.44168,  16.76036,  19.36837,  19.09945,  17.75401,  20.71073,
          22.48331,  22.41495,  22.19147,  24.89471,  28.99081,  28.13654,
          29.78355,  32.12859,  33.64244,  31.97045,  35.07799,  34.99984,
          37.36496,  37.66226,  37.52198,  38.04894,  38.99665,  38.9161 ,
          42.99372,  41.97252,  42.33337,  42.72225,  42.53551,  43.77865,
          44.76722,  44.26307,  43.19493,  42.72848,  44.12784,  41.66611,
          42.08783,  39.69333,  41.02127,  41.02762,  39.81846,  36.14058,
          35.83875,  35.3853 ,  33.38918,  31.80973,  31.04823,  30.09775,
          30.14266,  27.8258 ,  22.02977,  22.02562,  21.17791,  19.51911,
          20.04847,  16.01583,  14.66736,  11.78864,   8.10377,   7.54798,
          5.82652,   4.33833,   0.     ,   9.49269,   5.60066,  10.13634,
          11.30708,  15.06618,  16.60802,  17.5898 ,  20.66387,  23.36406,
          22.74647,  28.44725,  28.42199,  30.43171,  32.53739,  34.61086,
          37.28059,  38.61696,  40.54339,  40.91422,  43.13823,  46.37182,
          45.76609,  47.10957,  50.41253,  49.41508,  50.26066,  51.50842,
          54.21112,  52.03406,  56.08765,  56.26153,  57.72116,  55.39809,
          54.07596,  54.94413,  52.52346,  56.22352],
        [ 17.37134,  18.85088,  20.86528,  20.88305,  20.49716,  20.89719,
          23.70778,  23.87865,  23.8951 ,  26.39705,  29.49656,  28.78396,
          30.69899,  33.34453,  34.72378,  34.19075,  36.59537,  35.8496 ,
          38.4644 ,  39.09107,  39.07799,  39.2854 ,  41.12947,  40.94059,
          45.43309,  44.85097,  45.05862,  46.08496,  45.50379,  46.84558,
          47.773  ,  47.54766,  47.14492,  46.85017,  48.09543,  45.21051,
          46.05367,  44.39596,  45.92867,  45.8564 ,  44.45979,  41.01457,
          40.75469,  40.18287,  38.71385,  37.16025,  37.12763,  34.51412,
          35.2683 ,  33.66319,  28.4554 ,  28.80888,  26.23138,  24.47804,
          25.72337,  22.86644,  19.35195,  17.10573,  12.28344,  13.83722,
          9.42892,   8.76183,   9.49269,   0.     ,  10.77901,  10.05965,
          11.4491 ,  14.23453,  15.65154,  15.89031,  19.35493,  21.37071,
          21.35245,  26.88469,  27.14093,  28.27884,  30.5466 ,  33.50676,
          36.4934 ,  37.19752,  39.64894,  41.31134,  43.32302,  46.1664 ,
          46.66713,  48.02232,  51.58657,  50.8496 ,  51.44928,  53.70231,
          55.7896 ,  54.36972,  58.30467,  58.85498,  60.2241 ,  59.29777,
          57.3284 ,  58.22332,  56.01087,  59.61459],
        [ 13.90914,  15.67933,  17.38101,  16.98734,  16.24356,  18.9401 ,
          20.61034,  20.79483,  20.57865,  22.80323,  27.01958,  26.43445,
          27.88792,  30.4796 ,  32.11209,  30.2786 ,  33.28937,  33.74472,
          36.32379,  36.48663,  36.60449,  37.05129,  38.17204,  38.2891 ,
          42.39361,  41.45324,  42.17539,  42.30557,  42.54538,  43.53456,
          44.99764,  44.95504,  43.81483,  43.10439,  45.13455,  42.9827 ,
          43.28691,  40.98925,  42.53998,  42.62709,  41.3634 ,  37.91637,
          37.69173,  37.57579,  35.4746 ,  34.28055,  32.98749,  32.6424 ,
          32.68231,  30.48156,  24.40348,  24.85666,  24.1575 ,  23.22298,
          23.44249,  18.67511,  18.37439,  14.52165,  11.70756,  10.47169,
          8.76253,   7.88595,   5.60066,  10.77901,   0.     ,   7.37848,
          7.94763,  11.60285,  13.60009,  14.22662,  16.93863,  20.48684,
          19.57347,  25.10732,  25.49894,  27.55298,  29.7128 ,  32.13686,
          34.70808,  36.23865,  38.20019,  38.77183,  41.07158,  44.37704,
          43.59581,  45.48707,  49.01208,  48.08088,  49.19229,  50.28702,
          53.56762,  51.16563,  55.41252,  55.96844,  57.4112 ,  55.34975,
          54.10888,  55.4712 ,  53.09032,  56.86156],
        [ 11.73735,  13.11373,  14.14065,  14.43121,  13.95706,  14.67542,
          16.80414,  17.13811,  17.20223,  19.30856,  22.64011,  22.12388,
          23.6909 ,  26.68134,  28.69735,  26.83978,  29.56233,  29.52144,
          32.42384,  32.61225,  33.43265,  33.33446,  34.9892 ,  35.07866,
          39.51926,  38.91288,  39.71804,  40.15065,  40.30517,  41.47749,
          42.85482,  43.36693,  42.6301 ,  42.13604,  44.19635,  41.96344,
          42.38342,  40.81211,  42.80247,  42.66475,  41.50962,  38.79497,
          38.4327 ,  38.53515,  36.61224,  35.884  ,  35.06947,  34.1041 ,
          34.49442,  32.98226,  27.41917,  28.34247,  26.74297,  25.99818,
          26.57937,  22.78851,  21.53225,  18.11827,  14.58617,  14.98237,
          11.01716,  10.96004,  10.13634,  10.05965,   7.37848,   0.     ,
          6.85229,   8.33375,  10.64638,  10.34292,  12.47002,  15.48307,
          15.00604,  20.17726,  20.87708,  22.2614 ,  24.11224,  27.27657,
          29.58244,  31.1899 ,  33.13339,  34.40247,  36.49848,  39.87239,
          39.52611,  41.18787,  45.18565,  44.54115,  45.31625,  47.01201,
          50.01015,  48.42501,  52.3525 ,  53.37068,  54.80933,  53.68554,
          52.36036,  53.92575,  51.51095,  55.33784],
        [ 12.23879,  14.57384,  15.49992,  14.87293,  14.68697,  15.87359,
          17.54135,  18.05839,  17.67657,  19.43576,  23.11653,  23.17097,
          24.95077,  27.47971,  29.37637,  27.6592 ,  30.64956,  30.75883,
          33.65172,  34.05121,  34.30145,  34.86519,  36.38785,  36.89862,
          41.2064 ,  40.27944,  41.17056,  41.69059,  41.79641,  43.3667 ,
          45.0001 ,  45.22628,  44.81877,  43.99537,  46.17291,  44.45906,
          45.19904,  43.15676,  45.02922,  44.95803,  44.11761,  40.96397,
          40.95094,  40.71094,  39.11164,  38.25288,  37.28719,  36.48373,
          36.84283,  34.95939,  29.65847,  30.26402,  29.9642 ,  28.67918,
          28.95484,  24.49932,  24.01021,  20.90729,  16.50391,  16.51711,
          12.97536,  13.3731 ,  11.30708,  11.4491 ,   7.94763,   6.85229,
          0.     ,   7.42181,   9.81149,   8.48963,  11.54921,  15.39613,
          14.38347,  19.86861,  19.77106,  22.06307,  24.50788,  26.82158,
          29.77616,  30.96037,  33.5255 ,  34.52259,  36.99302,  40.18245,
          39.99496,  42.1269 ,  45.88592,  45.21708,  46.21675,  48.21974,
          51.36139,  49.18705,  54.05609,  54.84453,  56.72943,  55.20246,
          53.91346,  55.78262,  53.64081,  57.31579],
        [ 12.84236,  14.49709,  14.33989,  12.60412,  14.86848,  14.84921,
          17.64634,  16.67094,  16.61788,  18.22819,  21.4745 ,  21.90119,
          22.44497,  25.54979,  27.27617,  26.30551,  29.02811,  28.63502,
          31.82761,  32.23   ,  32.81646,  33.37436,  35.95878,  36.20281,
          40.11474,  39.6453 ,  40.67256,  41.24556,  41.68827,  43.24129,
          44.84355,  45.15693,  45.24839,  44.34038,  46.91914,  45.37185,
          46.24403,  44.3192 ,  46.2601 ,  45.70734,  45.79608,  42.64609,
          42.4804 ,  42.71524,  40.61639,  39.99024,  39.461  ,  38.65803,
          39.96906,  37.85604,  32.03859,  33.37055,  32.63265,  31.37243,
          31.3744 ,  27.34599,  26.91727,  23.93647,  20.31629,  19.64403,
          16.14407,  17.00054,  15.06618,  14.23453,  11.60285,   8.33375,
          7.42181,   0.     ,   9.27097,   6.7636 ,   9.28897,  10.82079,
          10.31003,  16.92184,  15.97901,  18.91758,  20.92638,  24.2509 ,
          26.79505,  28.28992,  30.96807,  32.00602,  34.44939,  37.75691,
          37.62064,  40.16677,  43.88795,  43.79662,  44.82826,  47.13516,
          50.10628,  48.05767,  53.25517,  53.82784,  55.9775 ,  54.96514,
          53.63403,  55.43629,  53.67147,  57.5573 ],
        [ 16.11693,  13.93834,  17.43602,  16.25858,  14.61363,  15.9765 ,
          18.13698,  16.67337,  17.05001,  18.64491,  21.88627,  23.31711,
          22.73515,  25.74229,  26.28932,  26.20587,  29.40351,  28.32294,
          32.1881 ,  32.67538,  32.20425,  33.51843,  35.6227 ,  36.05376,
          39.74911,  40.59724,  40.65653,  41.85591,  40.95449,  43.27906,
          44.80852,  45.74134,  44.99179,  44.26734,  47.23808,  45.70899,
          46.80226,  44.52264,  46.99824,  46.90492,  46.84759,  44.26794,
          43.60742,  44.28372,  42.02245,  41.63577,  40.85783,  41.22222,
          41.25252,  39.53608,  34.25637,  35.15239,  34.33692,  33.06567,
          33.67799,  30.249  ,  28.70851,  25.20954,  22.0821 ,  21.76762,
          18.65999,  17.6708 ,  16.60802,  15.65154,  13.60009,  10.64638,
          9.81149,   9.27097,   0.     ,   5.4579 ,   8.31392,  11.37399,
          10.06637,  15.80099,  16.19604,  17.81404,  20.35224,  22.68455,
          26.33321,  27.22424,  29.39485,  31.26857,  33.44303,  36.96176,
          36.64784,  38.92403,  43.95773,  42.77504,  44.24492,  46.45457,
          49.95585,  48.08682,  53.30444,  53.83046,  55.9695 ,  55.1559 ,
          54.03066,  55.76022,  54.37677,  58.38252],
        [ 14.78883,  13.97627,  15.89444,  14.52592,  14.13096,  14.6316 ,
          16.73796,  15.59013,  15.68349,  17.05169,  19.79573,  21.43302,
          21.53386,  24.75989,  25.69016,  25.12388,  28.14274,  27.26777,
          30.80285,  31.35308,  31.53711,  32.6792 ,  34.90092,  35.34433,
          39.34168,  39.49418,  40.19097,  41.23647,  40.88777,  42.89426,
          44.71783,  45.58144,  45.27901,  44.39004,  47.21417,  45.86452,
          47.00371,  45.11777,  47.39798,  47.20804,  47.06841,  44.55381,
          44.22534,  44.57255,  42.49394,  42.34816,  41.59448,  41.17685,
          41.86267,  40.08616,  34.87194,  36.01863,  35.4078 ,  34.08613,
          34.68713,  30.89222,  29.95311,  26.57818,  22.97453,  22.8833 ,
          19.26615,  18.90909,  17.5898 ,  15.89031,  14.22662,  10.34292,
          8.48963,   6.7636 ,   5.4579 ,   0.     ,   6.20725,   9.55298,
          8.01646,  13.88004,  13.47562,  15.73658,  18.32946,  21.00988,
          24.41039,  25.357  ,  28.05329,  29.56878,  32.10165,  35.5989 ,
          35.30488,  37.94608,  42.47888,  41.88941,  43.10642,  45.66534,
          48.94918,  47.14171,  52.39688,  53.39353,  55.47101,  54.71155,
          53.48973,  55.54874,  54.10548,  57.89195],
        [ 14.85241,  15.28133,  14.88863,  14.10743,  14.51717,  13.43337,
          15.0992 ,  15.29917,  15.30447,  14.82973,  18.19257,  19.21266,
          19.39791,  22.16485,  23.88593,  23.22648,  25.25644,  25.1948 ,
          28.93245,  29.36674,  29.60455,  30.40374,  32.5457 ,  33.67934,
          37.45432,  37.70761,  38.65435,  39.41798,  39.44077,  41.53307,
          43.31817,  44.57787,  44.24326,  43.65807,  46.86937,  45.49593,
          46.37995,  44.80329,  47.50405,  47.14969,  46.96281,  44.89301,
          44.42682,  45.13821,  43.59005,  43.03802,  42.32162,  42.52243,
          43.03579,  41.63043,  36.40332,  37.78748,  37.27436,  36.44189,
          36.28302,  32.98648,  32.23778,  28.98693,  25.272  ,  25.40245,
          21.70973,  22.24521,  20.66387,  19.35493,  16.93863,  12.47002,
          11.54921,   9.28897,   8.31392,   6.20725,   0.     ,   8.05145,
          5.69215,   9.9497 ,  11.36293,  12.71091,  14.59198,  18.34641,
          21.18762,  22.23008,  25.12185,  26.96778,  29.22174,  32.55304,
          32.67088,  35.01998,  40.03592,  39.3736 ,  40.65807,  43.06865,
          46.5909 ,  44.99134,  50.2539 ,  51.23541,  53.43403,  53.31284,
          52.11044,  54.48838,  52.87226,  56.74007],
        [ 16.81082,  15.43603,  15.37154,  13.84321,  15.68778,  14.09887,
          16.73965,  14.46026,  14.95815,  15.51568,  16.9958 ,  18.09438,
          17.15086,  20.06477,  21.52732,  22.09752,  24.3272 ,  22.50728,
          26.4393 ,  27.44256,  27.68888,  28.64096,  31.91806,  32.25061,
          35.8801 ,  36.65188,  37.60561,  38.64347,  38.47113,  41.05796,
          42.17357,  43.24457,  44.00885,  43.18833,  46.30617,  45.23056,
          46.44777,  44.7664 ,  47.43771,  46.86   ,  47.70312,  45.34457,
          44.91905,  45.55069,  43.80397,  43.69836,  43.57751,  43.43884,
          44.67317,  43.15796,  38.15373,  39.81268,  38.82324,  37.65905,
          37.6514 ,  35.07533,  33.96847,  31.46102,  27.72545,  27.78937,
          23.98596,  24.80605,  23.36406,  21.37071,  20.48684,  15.48307,
          15.39613,  10.82079,  11.37399,   9.55298,   8.05145,   0.     ,
          5.15882,  10.42401,   8.2677 ,  10.41686,  12.23247,  15.69246,
          18.50621,  19.6109 ,  22.38789,  24.44886,  26.89026,  29.8127 ,
          30.67153,  32.99654,  37.56207,  37.45707,  38.73435,  41.86474,
          44.60558,  43.27327,  48.91205,  49.33654,  52.18163,  52.20071,
          51.11608,  53.03856,  51.85091,  55.85643],
        [ 15.84987,  15.38908,  15.57648,  13.02127,  14.51018,  13.393  ,
          15.39915,  14.31921,  14.4235 ,  14.01205,  16.94848,  18.37291,
          17.26961,  20.06272,  21.55272,  21.38396,  23.56296,  23.05361,
          26.65776,  27.60226,  27.2861 ,  28.81112,  31.28384,  32.36628,
          35.90349,  36.33936,  37.35235,  38.26693,  38.21591,  40.77052,
          42.00564,  43.23535,  43.62399,  42.95227,  46.18952,  45.08133,
          46.32251,  44.57585,  47.28364,  46.8637 ,  47.32522,  45.22525,
          44.77389,  45.47875,  43.89376,  43.42436,  43.1737 ,  43.36506,
          44.36291,  42.86376,  37.65245,  39.32254,  38.79999,  37.7809 ,
          37.46012,  34.59757,  33.87564,  31.12039,  27.36277,  27.30865,
          23.83313,  24.44948,  22.74647,  21.35245,  19.57347,  15.00604,
          14.38347,  10.31003,  10.06637,   8.01646,   5.69215,   5.15882,
          0.     ,   7.97303,   7.41391,   9.92165,  12.10268,  15.51953,
          18.54691,  19.63637,  22.4477 ,  24.28556,  26.89341,  29.828  ,
          30.30008,  32.67363,  37.5192 ,  37.10411,  38.59252,  41.46073,
          44.64997,  43.08337,  48.79588,  49.29285,  52.03523,  51.96351,
          51.03286,  53.18936,  51.82288,  55.93366],
        [ 19.49531,  19.14731,  18.73803,  16.58691,  17.43174,  15.35339,
          15.3146 ,  16.68845,  16.70277,  14.33961,  16.33478,  17.67573,
          16.50911,  19.02226,  20.82185,  19.8089 ,  20.85461,  22.12662,
          25.03495,  26.2458 ,  25.60395,  27.30426,  28.86779,  30.7808 ,
          34.72309,  34.78051,  36.34129,  37.14527,  37.33843,  39.41463,
          40.73932,  43.03554,  43.42716,  42.93121,  46.3353 ,  45.40294,
          46.58154,  45.54288,  48.66654,  48.70376,  48.293  ,  47.30472,
          46.85295,  47.62256,  46.64783,  46.41609,  45.94993,  46.36946,
          47.1119 ,  46.50258,  41.47684,  43.59766,  42.81333,  42.43773,
          42.17949,  39.54874,  38.86784,  35.92599,  32.25835,  32.95778,
          29.46502,  29.94102,  28.44725,  26.88469,  25.10732,  20.17726,
          19.86861,  16.92184,  15.80099,  13.88004,   9.9497 ,  10.42401,
          7.97303,   0.     ,   7.5317 ,   5.31432,   7.67385,  11.29427,
          13.88518,  15.65731,  17.41581,  21.03678,  23.50462,  25.23083,
          26.39159,  28.81917,  34.13332,  33.45212,  35.14618,  38.06477,
          41.77849,  40.61566,  45.83126,  47.30105,  49.72211,  50.48444,
          50.07272,  52.69689,  50.98398,  55.16405],
        [ 19.10495,  18.0164 ,  17.66276,  15.13994,  16.76305,  15.15473,
          16.21818,  14.41634,  14.6234 ,  13.3435 ,  14.10467,  16.69031,
          14.97885,  17.40359,  18.79088,  18.83186,  20.80185,  19.74132,
          23.12291,  24.4287 ,  24.28611,  26.30338,  28.98518,  30.11484,
          33.54021,  33.80123,  35.23204,  36.28322,  36.35944,  39.1773 ,
          40.54667,  41.97252,  43.097  ,  42.14583,  45.46555,  45.13354,
          46.66496,  45.13382,  47.8922 ,  47.41032,  48.42568,  46.71893,
          46.45624,  47.08008,  45.65345,  45.84523,  45.7186 ,  45.84661,
          47.23168,  45.86231,  41.28355,  43.22273,  43.14353,  42.01543,
          41.8008 ,  39.14111,  38.83989,  36.4427 ,  32.61786,  32.79115,
          29.31874,  30.21988,  28.42199,  27.14093,  25.49894,  20.87708,
          19.77106,  15.97901,  16.19604,  13.47562,  11.36293,   8.2677 ,
          7.41391,   7.5317 ,   0.     ,   6.63347,   8.51215,  10.2156 ,
          13.17845,  14.2086 ,  17.41713,  18.82641,  21.82783,  24.56628,
          25.20903,  28.13747,  32.64308,  32.72029,  34.13216,  37.76093,
          40.74152,  39.28459,  45.54548,  46.22894,  49.39464,  49.45139,
          48.79067,  51.31535,  50.31884,  54.28067],
        [ 20.82333,  19.25691,  19.14902,  17.45726,  18.13449,  15.57783,
          15.90665,  16.10611,  16.24885,  14.52817,  14.58976,  16.42476,
          14.84698,  17.54345,  18.59526,  18.86371,  19.89348,  19.63274,
          22.70202,  24.17496,  23.68602,  25.2772 ,  27.6702 ,  29.01616,
          32.87432,  33.49258,  34.77337,  36.14132,  35.80693,  38.1895 ,
          39.4803 ,  41.7482 ,  42.57723,  41.96176,  45.29483,  44.55667,
          46.07288,  45.13769,  48.31191,  48.23058,  48.33951,  47.3816 ,
          46.96242,  47.68002,  46.63616,  46.92581,  46.70514,  46.8006 ,
          47.84897,  47.29211,  42.71965,  44.89829,  44.0194 ,  43.33093,
          43.46606,  41.24033,  40.22175,  37.60689,  33.89607,  34.89289,
          31.04096,  31.68858,  30.43171,  28.27884,  27.55298,  22.2614 ,
          22.06307,  18.91758,  17.81404,  15.73658,  12.71091,  10.41686,
          9.92165,   5.31432,   6.63347,   0.     ,   4.70483,   7.62293,
          10.77344,  12.04317,  14.09367,  18.36526,  20.64699,  22.23753,
          23.95215,  26.43932,  31.57022,  31.17569,  32.66191,  36.26804,
          39.40728,  38.57361,  43.9427 ,  45.43841,  47.97621,  49.1094 ,
          48.50627,  50.97824,  49.73738,  53.71283],
        [ 22.2353 ,  20.79821,  19.51857,  18.68005,  19.68793,  16.38066,
          16.80116,  16.76691,  16.87216,  14.70497,  14.07395,  15.74665,
          14.0348 ,  16.56831,  17.84671,  18.34015,  18.69289,  17.89876,
          21.31299,  22.32386,  22.83922,  23.65439,  26.58669,  27.92706,
          31.3026 ,  32.35566,  33.6225 ,  34.9677 ,  34.8564 ,  37.36602,
          38.72058,  41.05749,  41.90128,  41.49189,  44.96068,  44.24469,
          45.61367,  45.036  ,  48.29145,  47.81376,  48.32094,  47.69802,
          47.13319,  48.15121,  47.08335,  47.45754,  47.35142,  47.56391,
          48.73064,  48.17182,  43.82151,  46.04871,  45.29074,  44.64622,
          44.62028,  42.66911,  41.76582,  39.32328,  35.73057,  36.70972,
          32.71498,  33.75574,  32.53739,  30.5466 ,  29.7128 ,  24.11224,
          24.50788,  20.92638,  20.35224,  18.32946,  14.59198,  12.23247,
          12.10268,   7.67385,   8.51215,   4.70483,   0.     ,   7.52323,
          8.61132,   9.93048,  12.5578 ,  16.40777,  18.25766,  20.46284,
          22.14114,  24.25493,  29.68935,  29.77053,  30.84631,  34.5401 ,
          37.42484,  37.09933,  42.31915,  43.87867,  46.39273,  48.0183 ,
          47.23087,  49.8669 ,  48.80525,  52.57763],
        [ 24.10629,  21.17772,  21.56308,  20.17601,  19.75357,  18.12999,
          17.15962,  16.68857,  16.49137,  14.77414,  12.99207,  15.65608,
          13.16584,  15.07742,  15.16618,  15.42575,  17.03854,  15.79792,
          18.64901,  20.26882,  19.6321 ,  21.82505,  23.92989,  25.32419,
          28.63784,  29.75799,  30.92734,  32.65462,  31.85679,  34.97812,
          36.16405,  38.72517,  39.82617,  39.07646,  42.56432,  42.6187 ,
          44.385  ,  43.45157,  46.78708,  46.72845,  47.48303,  47.15203,
          46.71132,  47.49823,  46.48834,  47.51112,  47.22145,  47.96634,
          48.82056,  48.3848 ,  44.61234,  46.77149,  46.65033,  45.80397,
          46.06782,  44.16304,  43.56084,  41.32062,  37.77336,  38.8788 ,
          35.20378,  35.95484,  34.61086,  33.50676,  32.13686,  27.27657,
          26.82158,  24.2509 ,  22.68455,  21.00988,  18.34641,  15.69246,
          15.51953,  11.29427,  10.2156 ,   7.62293,   7.52323,   0.     ,
          5.61253,   7.21393,   8.09939,  12.2139 ,  14.96738,  16.37581,
          17.99627,  20.35805,  25.70473,  25.34467,  26.89611,  30.90733,
          34.04257,  33.31594,  39.15504,  40.74492,  43.65432,  44.59624,
          44.58934,  47.23448,  46.50554,  50.1937 ],
        [ 25.58022,  23.34925,  22.21288,  21.41715,  21.78947,  19.33544,
          18.1004 ,  18.02822,  17.85663,  15.56051,  12.74353,  14.72969,
          12.28025,  13.83543,  14.82818,  14.24007,  14.62848,  14.13342,
          16.46835,  17.63621,  18.43043,  19.44844,  21.86083,  23.29639,
          26.36769,  27.30116,  29.00015,  30.32245,  30.32951,  33.00745,
          34.29426,  37.14338,  38.47462,  37.79461,  41.36339,  41.59934,
          43.10472,  42.69738,  46.0658 ,  45.78045,  46.66074,  46.77432,
          46.36086,  47.35146,  46.45531,  47.68894,  47.41203,  48.21386,
          49.2878 ,  49.04825,  45.47536,  47.87025,  47.77203,  47.25139,
          47.29764,  45.54425,  45.32808,  43.23691,  39.95231,  41.05635,
          37.43086,  38.6216 ,  37.28059,  36.4934 ,  34.70808,  29.58244,
          29.77616,  26.79505,  26.33321,  24.41039,  21.18762,  18.50621,
          18.54691,  13.88518,  13.17845,  10.77344,   8.61132,   5.61253,
          0.     ,   6.28487,   5.75247,   9.62946,  11.75449,  13.17307,
          14.78111,  17.10354,  22.23733,  22.66218,  23.80291,  27.72151,
          30.83746,  30.51189,  35.9164 ,  37.93316,  40.70448,  42.1526 ,
          42.22162,  45.16766,  44.28871,  47.87966],
        [ 26.94421,  24.69467,  23.47894,  23.0355 ,  23.32496,  20.47957,
          20.22697,  19.23566,  19.18505,  16.74031,  13.92433,  16.18704,
          14.13143,  14.50581,  14.49505,  16.84456,  16.26612,  14.08034,
          16.81846,  18.1981 ,  18.32631,  19.69742,  22.75265,  24.12436,
          26.4844 ,  28.38011,  29.40958,  31.15585,  30.47848,  34.10653,
          35.27955,  37.61494,  39.17248,  38.59134,  42.23577,  42.40437,
          44.24015,  43.68518,  47.00178,  46.55168,  47.9282 ,  47.78838,
          47.34189,  48.3686 ,  47.75785,  48.68155,  48.74309,  49.40067,
          50.56509,  50.09211,  47.05548,  49.21038,  49.32322,  48.43046,
          48.35452,  47.06384,  46.48406,  44.71995,  41.07814,  42.15574,
          38.47346,  39.86389,  38.61696,  37.19752,  36.23865,  31.1899 ,
          30.96037,  28.28992,  27.22424,  25.357  ,  22.23008,  19.6109 ,
          19.63637,  15.65731,  14.2086 ,  12.04317,   9.93048,   7.21393,
          6.28487,   0.     ,   7.47856,   9.53171,  11.18018,  13.01788,
          15.47366,  17.28446,  22.4102 ,  22.68226,  23.79207,  28.38873,
          30.63132,  30.55106,  36.61026,  37.86975,  41.02305,  43.05683,
          42.18162,  45.17244,  45.04898,  48.29225],
        [ 29.15922,  25.91663,  25.86362,  25.07801,  24.54554,  22.53012,
          21.04317,  20.91886,  20.91421,  18.93591,  15.69868,  17.54084,
          14.59832,  15.50799,  15.15638,  15.52977,  15.56155,  14.92898,
          16.44223,  18.06242,  17.7009 ,  19.3097 ,  21.11808,  22.42396,
          25.34082,  27.09472,  28.36382,  30.05495,  29.27892,  32.18818,
          33.02234,  36.50124,  37.86386,  37.2521 ,  40.86225,  41.24915,
          42.9754 ,  42.70208,  46.27576,  46.44799,  47.12264,  47.81124,
          47.27088,  48.33511,  47.61879,  49.1594 ,  48.88315,  49.99774,
          50.75426,  50.93521,  47.78609,  50.23529,  49.88537,  49.49756,
          49.81537,  48.51593,  47.93843,  45.92899,  42.85021,  44.18684,
          40.74117,  41.58399,  40.54339,  39.64894,  38.20019,  33.13339,
          33.5255 ,  30.96807,  29.39485,  28.05329,  25.12185,  22.38789,
          22.4477 ,  17.41581,  17.41713,  14.09367,  12.5578 ,   8.09939,
          5.75247,   7.47856,   0.     ,   9.46928,  10.77391,  10.07175,
          12.78621,  14.47174,  20.14208,  19.79391,  21.44302,  25.49215,
          28.64581,  28.7825 ,  33.76637,  36.05478,  38.72334,  40.7433 ,
          41.16185,  43.95332,  43.33299,  46.9185 ],
        [ 29.35633,  26.0043 ,  25.36028,  24.73817,  24.18059,  23.41117,
          22.01882,  19.93191,  19.70914,  17.75143,  14.25548,  16.84414,
          13.82806,  13.55086,  12.82821,  13.17945,  13.83998,  11.06895,
          12.42447,  13.71252,  14.75941,  17.16471,  18.7693 ,  19.7537 ,
          21.25983,  23.18208,  25.0391 ,  26.14201,  25.8884 ,  29.92886,
          30.89456,  33.46255,  34.99443,  34.09993,  37.9703 ,  39.18714,
          40.85532,  40.23943,  43.40774,  43.06789,  45.05578,  45.64705,
          45.18382,  46.28713,  45.29908,  47.14392,  46.89426,  48.4731 ,
          49.53957,  48.90653,  46.48006,  48.6807 ,  49.61055,  48.83554,
          48.72589,  47.55693,  47.98325,  46.36053,  43.44198,  44.13238,
          41.15986,  42.28369,  40.91422,  41.31134,  38.77183,  34.40247,
          34.52259,  32.00602,  31.26857,  29.56878,  26.96778,  24.44886,
          24.28556,  21.03678,  18.82641,  18.36526,  16.40777,  12.2139 ,
          9.62946,   9.53171,   9.46928,   0.     ,   7.70034,  11.03984,
          9.3173 ,  11.00972,  16.06011,  16.8982 ,  18.3223 ,  22.22843,
          24.9604 ,  24.69864,  30.94594,  32.41159,  35.92687,  36.56528,
          36.93542,  40.15198,  40.34494,  43.38612],
        [ 30.44926,  27.48027,  26.33286,  26.67714,  26.19812,  23.94749,
          23.10616,  21.22647,  21.64589,  19.27456,  15.27649,  17.82539,
          14.44424,  13.77702,  12.71296,  15.12571,  13.72169,  11.02782,
          12.98025,  12.60611,  14.24738,  14.47088,  18.18955,  19.01006,
          19.4387 ,  22.41711,  22.59333,  24.6254 ,  23.90214,  27.45379,
          29.48465,  32.11582,  33.29005,  32.53784,  36.62617,  37.89513,
          39.73088,  39.23902,  42.66151,  41.80521,  44.3409 ,  44.93698,
          44.30438,  46.10429,  45.03967,  46.92675,  46.8966 ,  48.58388,
          49.65108,  49.34591,  47.17699,  49.53981,  50.40164,  49.72558,
          49.68722,  48.77945,  48.86364,  47.3359 ,  44.85383,  45.71765,
          42.72724,  44.38077,  43.13823,  43.32302,  41.07158,  36.49848,
          36.99302,  34.44939,  33.44303,  32.10165,  29.22174,  26.89026,
          26.89341,  23.50462,  21.82783,  20.64699,  18.25766,  14.96738,
          11.75449,  11.18018,  10.77391,   7.70034,   0.     ,   9.07328,
          6.77896,   9.73201,  14.62719,  15.04701,  15.37031,  19.6617 ,
          22.50593,  22.25054,  28.56357,  29.72752,  32.81706,  34.96093,
          34.29057,  37.67062,  38.17835,  41.31302],
        [ 33.44155,  31.09767,  29.98075,  29.31584,  29.52194,  27.14785,
          25.70386,  25.60087,  25.6927 ,  22.94456,  19.74988,  20.46911,
          17.8433 ,  16.34443,  15.97897,  17.63489,  14.82471,  15.65033,
          14.62265,  16.39878,  14.81143,  16.52024,  18.2176 ,  19.94131,
          21.35453,  22.75371,  24.07796,  25.64368,  25.36182,  28.27133,
          28.8475 ,  32.19497,  34.59372,  33.99566,  37.63698,  38.80147,
          40.79164,  40.71097,  44.23342,  44.2389 ,  45.66062,  46.70672,
          46.30564,  47.57535,  47.61192,  49.05016,  49.20629,  50.70632,
          51.8766 ,  52.28837,  49.92586,  52.72328,  52.96687,  52.67093,
          52.42257,  51.948  ,  51.79319,  50.52313,  47.6269 ,  48.95971,
          46.03943,  47.67845,  46.37182,  46.1664 ,  44.37704,  39.87239,
          40.18245,  37.75691,  36.96176,  35.5989 ,  32.55304,  29.8127 ,
          29.828  ,  25.23083,  24.56628,  22.23753,  20.46284,  16.37581,
          13.17307,  13.01788,  10.07175,  11.03984,   9.07328,   0.     ,
          8.87214,   9.85187,  12.31734,  12.2625 ,  14.04632,  18.81453,
          21.19061,  21.12454,  27.04242,  28.49102,  31.8115 ,  34.8203 ,
          35.12966,  38.15204,  38.01118,  41.47549],
        [ 33.20634,  29.88905,  29.33639,  29.02044,  28.20267,  27.12172,
          25.33855,  24.01222,  24.18448,  21.91537,  18.25877,  20.57828,
          16.98162,  16.4955 ,  14.73869,  15.48099,  14.34678,  14.30857,
          13.85173,  13.84417,  14.39659,  15.93936,  17.45544,  18.33339,
          18.66931,  20.88887,  21.93502,  23.38049,  23.14462,  25.75202,
          27.86781,  31.24603,  32.25062,  31.15287,  35.45185,  37.34563,
          39.14055,  38.75821,  42.09818,  41.92408,  43.92436,  45.20662,
          44.68842,  46.38933,  45.31081,  47.7489 ,  47.28112,  49.48718,
          50.44647,  50.39015,  48.24647,  50.9    ,  51.90866,  51.57562,
          51.63792,  50.60804,  51.20293,  49.48781,  47.47827,  48.28665,
          45.7643 ,  47.02336,  45.76609,  46.66713,  43.59581,  39.52611,
          39.99496,  37.62064,  36.64784,  35.30488,  32.67088,  30.67153,
          30.30008,  26.39159,  25.20903,  23.95215,  22.14114,  17.99627,
          14.78111,  15.47366,  12.78621,   9.3173 ,   6.77896,   8.87214,
          0.     ,   8.06218,  11.429  ,  11.46571,  13.13148,  16.10375,
          20.41288,  19.36076,  25.3713 ,  27.60118,  30.25563,  31.87386,
          32.4665 ,  36.03614,  36.48471,  39.63076],
        [ 35.10944,  31.87226,  31.30981,  31.28387,  30.01717,  29.01223,
          26.90823,  26.23519,  26.08005,  23.84675,  20.80091,  21.7296 ,
          19.04357,  17.40327,  16.7043 ,  16.55105,  15.01213,  14.46629,
          13.32047,  13.90252,  14.09233,  15.41702,  15.00264,  16.81857,
          16.58331,  19.50611,  20.62995,  21.94394,  21.09032,  25.34647,
          25.48297,  29.25163,  30.55199,  30.43379,  34.21791,  35.75256,
          37.3534 ,  37.46691,  41.14137,  40.96925,  42.83903,  44.90814,
          44.1482 ,  45.72293,  45.41523,  47.3948 ,  47.34997,  49.72993,
          50.26925,  50.58997,  49.03127,  51.39158,  52.35132,  52.08085,
          51.8305 ,  51.67431,  51.97604,  50.80266,  48.41191,  49.59359,
          46.92375,  48.24653,  47.10957,  48.02232,  45.48707,  41.18787,
          42.1269 ,  40.16677,  38.92403,  37.94608,  35.01998,  32.99654,
          32.67363,  28.81917,  28.13747,  26.43932,  24.25493,  20.35805,
          17.10354,  17.28446,  14.47174,  11.00972,   9.73201,   9.85187,
          8.06218,   0.     ,   9.67155,   9.04695,  10.17736,  13.59906,
          16.54233,  17.9564 ,  22.847  ,  24.60167,  27.9245 ,  29.98479,
          31.1793 ,  34.37541,  34.48999,  37.48156],
        [ 37.58041,  35.07482,  33.73965,  33.55744,  33.36934,  32.1432 ,
          30.27089,  29.55426,  29.35354,  27.42168,  23.91183,  24.02904,
          22.24141,  20.09447,  19.42872,  19.58731,  17.11687,  17.74227,
          13.81794,  14.58239,  14.84183,  15.60782,  15.51133,  15.99741,
          15.29044,  15.96133,  18.16191,  18.90934,  19.56871,  22.44188,
          22.56247,  25.58682,  28.63669,  27.85509,  31.08457,  33.50089,
          35.4027 ,  35.83383,  38.8066 ,  38.73615,  40.98259,  43.03585,
          42.80237,  43.99917,  44.16385,  46.55753,  46.70348,  48.60454,
          49.99599,  50.40001,  49.42958,  52.21003,  53.40064,  53.1481 ,
          52.84663,  52.94916,  53.74581,  53.15541,  50.90451,  52.1083 ,
          49.81399,  51.67294,  50.41253,  51.58657,  49.01208,  45.18565,
          45.88592,  43.88795,  43.95773,  42.47888,  40.03592,  37.56207,
          37.5192 ,  34.13332,  32.64308,  31.57022,  29.68935,  25.70473,
          22.23733,  22.4102 ,  20.14208,  16.06011,  14.62719,  12.31734,
          11.429  ,   9.67155,   0.     ,   6.56064,   6.38088,  10.37223,
          11.02495,  11.31594,  17.26136,  19.1381 ,  22.65982,  24.77406,
          25.9365 ,  29.3083 ,  29.80644,  32.34705],
        [ 36.97612,  34.08161,  33.6759 ,  33.39091,  32.26088,  31.53822,
          29.34631,  29.01695,  29.00965,  26.76934,  24.08524,  24.20871,
          22.05366,  19.53993,  18.50832,  18.96449,  16.34701,  17.97385,
          14.45423,  15.61773,  13.11227,  15.3568 ,  13.46033,  15.0617 ,
          14.5311 ,  15.86852,  17.02272,  18.07516,  17.40934,  20.82485,
          20.68579,  24.49213,  26.61145,  26.08889,  29.69294,  31.99846,
          33.98145,  33.96711,  37.42541,  37.92498,  39.58649,  41.8455 ,
          41.36941,  42.7842 ,  43.17606,  45.24034,  45.24956,  47.90274,
          48.57102,  49.3039 ,  48.33632,  51.04052,  52.18807,  52.11595,
          51.78041,  52.10773,  52.60551,  51.87092,  49.78713,  51.08147,
          49.07544,  50.62617,  49.41508,  50.8496 ,  48.08088,  44.54115,
          45.21708,  43.79662,  42.77504,  41.88941,  39.3736 ,  37.45707,
          37.10411,  33.45212,  32.72029,  31.17569,  29.77053,  25.34467,
          22.66218,  22.68226,  19.79391,  16.8982 ,  15.04701,  12.2625 ,
          11.46571,   9.04695,   6.56064,   0.     ,   5.98419,   8.35946,
          11.68013,  10.99161,  17.01812,  18.26248,  21.8055 ,  23.90279,
          25.4595 ,  28.64282,  28.83705,  32.02712],
        [ 37.4974 ,  34.96767,  34.04663,  34.49413,  33.40864,  31.97442,
          29.92087,  29.67471,  29.70327,  27.66108,  24.27307,  24.33682,
          22.98183,  20.64083,  20.11721,  20.24747,  17.47794,  18.06633,
          14.59398,  14.72379,  14.67681,  14.63636,  13.79958,  14.77595,
          14.07159,  14.98222,  15.54819,  17.34202,  16.72036,  19.82573,
          20.34994,  23.73966,  26.02174,  25.78955,  28.68309,  30.98915,
          32.97956,  33.65132,  36.96229,  36.83463,  38.84249,  41.35057,
          40.89437,  42.32976,  42.72795,  45.04445,  45.31637,  47.29044,
          48.20799,  49.05992,  48.54484,  51.18106,  52.39054,  52.16829,
          52.05071,  52.46879,  52.8835 ,  52.39965,  50.24847,  51.81738,
          49.48923,  51.37421,  50.26066,  51.44928,  49.19229,  45.31625,
          46.21675,  44.82826,  44.24492,  43.10642,  40.65807,  38.73435,
          38.59252,  35.14618,  34.13216,  32.66191,  30.84631,  26.89611,
          23.80291,  23.79207,  21.44302,  18.3223 ,  15.37031,  14.04632,
          13.13148,  10.17736,   6.38088,   5.98419,   0.     ,   7.87813,
          8.5264 ,  10.22297,  15.17486,  17.26896,  20.15363,  23.01967,
          23.76411,  27.20938,  27.40981,  30.03519],
        [ 39.19126,  36.59085,  35.63369,  36.29427,  34.83176,  34.20046,
          31.66778,  31.85062,  31.74665,  29.75946,  27.16596,  26.71437,
          25.33998,  23.14301,  22.55747,  21.6386 ,  19.00668,  21.34884,
          17.7774 ,  17.00739,  17.10835,  16.4597 ,  13.68436,  14.59106,
          12.69685,  13.66391,  14.56199,  14.70928,  15.08113,  16.70077,
          17.57016,  21.92186,  22.74625,  22.49509,  26.09517,  28.78806,
          30.08218,  30.88072,  34.28354,  34.6773 ,  36.13211,  39.45815,
          38.88697,  40.70953,  41.05225,  43.71142,  43.29447,  46.48555,
          46.79335,  47.89894,  47.60107,  50.27656,  51.76294,  52.09858,
          51.83186,  52.27757,  53.24671,  52.58596,  51.22179,  52.5753 ,
          50.83285,  52.55434,  51.50842,  53.70231,  50.28702,  47.01201,
          48.21974,  47.13516,  46.45457,  45.66534,  43.06865,  41.86474,
          41.46073,  38.06477,  37.76093,  36.26804,  34.5401 ,  30.90733,
          27.72151,  28.38873,  25.49215,  22.22843,  19.6617 ,  18.81453,
          16.10375,  13.59906,  10.37223,   8.35946,   7.87813,   0.     ,
          8.67141,   8.22265,  10.68938,  14.39115,  15.81638,  18.19258,
          20.24196,  24.13398,  23.94398,  26.50431],
        [ 41.96371,  39.56174,  38.24726,  39.09789,  38.18059,  36.96213,
          35.17056,  34.7836 ,  34.68077,  33.0935 ,  30.02343,  29.08875,
          28.35413,  25.73473,  25.22857,  25.58849,  22.61177,  22.96009,
          18.83897,  18.61744,  19.10648,  17.9459 ,  16.58338,  16.3054 ,
          13.75561,  14.86599,  15.3057 ,  16.17006,  16.01239,  18.83691,
          17.81885,  20.66609,  23.58481,  23.83891,  26.05857,  28.57053,
          30.29887,  31.70992,  34.64723,  34.46336,  36.84814,  40.11168,
          39.62182,  41.06713,  42.00461,  44.46337,  44.9994 ,  47.1459 ,
          48.1779 ,  49.234  ,  49.68564,  52.28684,  53.60591,  53.53316,
          53.22438,  54.53359,  55.09278,  55.23165,  53.41837,  55.01953,
          53.02921,  55.1481 ,  54.21112,  55.7896 ,  53.56762,  50.01015,
          51.36139,  50.10628,  49.95585,  48.94918,  46.5909 ,  44.60558,
          44.64997,  41.77849,  40.74152,  39.40728,  37.42484,  34.04257,
          30.83746,  30.63132,  28.64581,  24.9604 ,  22.50593,  21.19061,
          20.41288,  16.54233,  11.02495,  11.68013,   8.5264 ,   8.67141,
          0.     ,   8.20946,   9.70989,  11.26803,  13.99325,  18.01633,
          18.62262,  21.68822,  22.49918,  24.09327],
        [ 39.49224,  37.35437,  36.06871,  36.46602,  35.81903,  35.11644,
          33.31352,  32.77038,  32.64932,  30.98471,  28.55089,  27.8246 ,
          26.6982 ,  23.91935,  23.0396 ,  23.63285,  20.87814,  22.50932,
          18.33698,  17.9266 ,  17.05555,  16.78672,  15.70851,  15.56181,
          12.45704,  12.41707,  12.64367,  13.04202,  13.78221,  15.85836,
          16.39775,  18.42641,  21.28107,  20.37192,  23.59887,  27.01304,
          29.00976,  29.12309,  31.85059,  31.84197,  34.73249,  37.08534,
          36.88549,  38.47232,  39.14698,  41.62923,  41.76229,  44.6641 ,
          45.75658,  46.43048,  46.61442,  49.36971,  51.35824,  51.2622 ,
          50.71905,  51.56906,  52.73899,  52.76786,  51.29034,  52.46332,
          51.02381,  53.295  ,  52.03406,  54.36972,  51.16563,  48.42501,
          49.18705,  48.05767,  48.08682,  47.14171,  44.99134,  43.27327,
          43.08337,  40.61566,  39.28459,  38.57361,  37.09933,  33.31594,
          30.51189,  30.55106,  28.7825 ,  24.69864,  22.25054,  21.12454,
          19.36076,  17.9564 ,  11.31594,  10.99161,  10.22297,   8.22265,
          8.20946,   0.     ,  10.97595,  10.25467,  13.79501,  15.37994,
          15.98122,  19.6484 ,  20.7999 ,  23.08624],
        [ 44.24451,  42.00158,  40.78921,  41.84873,  40.65885,  39.86917,
          37.56416,  38.06911,  37.91062,  36.65424,  33.83448,  32.39523,
          32.11611,  30.1514 ,  29.71055,  28.70622,  25.97138,  28.30391,
          23.71274,  22.92496,  23.72982,  21.70309,  18.99807,  17.98122,
          16.48731,  15.52539,  16.45475,  15.86513,  17.09382,  15.60841,
          15.34486,  19.3634 ,  21.00584,  20.98593,  22.7285 ,  25.56683,
          26.63001,  28.97938,  31.58249,  32.48614,  33.17741,  37.64673,
          37.35607,  38.78739,  39.86511,  43.11111,  42.8692 ,  45.39504,
          46.03133,  47.85874,  48.6812 ,  51.53462,  52.66349,  53.32599,
          53.35513,  54.55259,  55.52021,  55.52018,  54.5929 ,  56.32081,
          54.85708,  56.77537,  56.08765,  58.30467,  55.41252,  52.3525 ,
          54.05609,  53.25517,  53.30444,  52.39688,  50.2539 ,  48.91205,
          48.79588,  45.83126,  45.54548,  43.9427 ,  42.31915,  39.15504,
          35.9164 ,  36.61026,  33.76637,  30.94594,  28.56357,  27.04242,
          25.3713 ,  22.847  ,  17.26136,  17.01812,  15.17486,  10.68938,
          9.70989,  10.97595,   0.     ,  11.45306,   8.11042,  12.83722,
          15.11178,  18.41451,  17.69405,  18.89004],
        [ 44.49713,  42.65467,  41.34813,  41.95262,  41.40321,  40.59916,
          39.27059,  38.63774,  38.78521,  37.30058,  35.47091,  33.86684,
          32.88203,  29.62866,  29.41731,  30.21742,  27.04819,  28.4628 ,
          24.45456,  24.15302,  22.93954,  21.98327,  20.56008,  20.15022,
          16.18279,  16.68747,  15.71403,  15.06125,  15.61569,  17.8028 ,
          15.15469,  16.24486,  19.89187,  20.20119,  22.24654,  25.4267 ,
          27.03646,  27.45576,  30.04064,  29.86623,  33.3556 ,  36.20666,
          35.71787,  37.64475,  39.12616,  40.95347,  41.88106,  45.2002 ,
          46.10588,  47.20917,  48.31756,  50.93333,  52.69263,  52.90649,
          51.86422,  53.99784,  54.91969,  55.73155,  54.6199 ,  55.78484,
          54.85699,  57.33105,  56.26153,  58.85498,  55.96844,  53.37068,
          54.84453,  53.82784,  53.83046,  53.39353,  51.23541,  49.33654,
          49.29285,  47.30105,  46.22894,  45.43841,  43.87867,  40.74492,
          37.93316,  37.86975,  36.05478,  32.41159,  29.72752,  28.49102,
          27.60118,  24.60167,  19.1381 ,  18.26248,  17.26896,  14.39115,
          11.26803,  10.25467,  11.45306,   0.     ,   9.27356,  12.57009,
          12.95849,  14.74353,  15.81852,  18.51871],
        [ 46.20998,  44.21824,  43.00012,  44.21519,  43.17206,  42.25278,
          40.62456,  40.78472,  40.83826,  39.65202,  37.51809,  35.84499,
          35.32819,  33.12758,  32.39176,  32.68447,  29.54295,  31.64773,
          27.512  ,  26.40181,  26.36839,  24.07691,  22.44251,  21.20001,
          18.19724,  18.30724,  16.86429,  16.67207,  17.24015,  15.28365,
          14.83316,  17.24548,  18.45627,  18.99761,  20.53253,  23.23683,
          24.48703,  26.55069,  28.92462,  29.37943,  31.06652,  35.37051,
          34.81861,  36.9269 ,  38.19473,  40.97874,  41.23793,  44.23507,
          44.94675,  46.79585,  48.12534,  50.99637,  52.29538,  52.95174,
          52.68216,  54.65517,  55.45876,  55.94518,  55.51699,  57.09844,
          56.10978,  58.35886,  57.72116,  60.2241 ,  57.4112 ,  54.80933,
          56.72943,  55.9775 ,  55.9695 ,  55.47101,  53.43403,  52.18163,
          52.03523,  49.72211,  49.39464,  47.97621,  46.39273,  43.65432,
          40.70448,  41.02305,  38.72334,  35.92687,  32.81706,  31.8115 ,
          30.25563,  27.9245 ,  22.65982,  21.8055 ,  20.15363,  15.81638,
          13.99325,  13.79501,   8.11042,   9.27356,   0.     ,  11.3311 ,
          10.74328,  12.86819,  13.30844,  14.52224],
        [ 45.17665,  42.7808 ,  42.36618,  43.15904,  41.53149,  42.35218,
          40.2062 ,  39.75408,  39.61926,  39.12975,  37.42083,  36.03478,
          35.61998,  33.46496,  32.91178,  31.55284,  30.34684,  32.1907 ,
          27.97503,  27.03924,  26.99544,  26.11801,  22.97965,  21.39029,
          18.82112,  16.95519,  16.85299,  15.02326,  16.33925,  15.19425,
          14.19401,  15.15315,  16.11799,  15.27863,  16.26812,  21.19257,
          22.05865,  22.69609,  24.27898,  25.34313,  27.70613,  31.85248,
          31.64177,  33.11543,  33.86518,  37.50522,  37.14262,  41.08682,
          41.40908,  42.67964,  44.56241,  47.03863,  49.4784 ,  49.96028,
          49.67751,  51.26881,  53.12569,  53.73325,  53.60744,  54.71573,
          54.39723,  56.29047,  55.39809,  59.29777,  55.34975,  53.68554,
          55.20246,  54.96514,  55.1559 ,  54.71155,  53.31284,  52.20071,
          51.96351,  50.48444,  49.45139,  49.1094 ,  48.0183 ,  44.59624,
          42.1526 ,  43.05683,  40.7433 ,  36.56528,  34.96093,  34.8203 ,
          31.87386,  29.98479,  24.77406,  23.90279,  23.01967,  18.19258,
          18.01633,  15.37994,  12.83722,  12.57009,  11.3311 ,   0.     ,
          9.90814,  11.78426,  11.47244,  12.76638],
        [ 43.34276,  41.49634,  40.24461,  41.86844,  40.71829,  40.45489,
          39.40489,  38.43139,  38.5705 ,  38.02632,  36.17692,  34.76023,
          34.74136,  32.47884,  31.62541,  32.34425,  30.10012,  31.04573,
          27.44909,  25.82034,  26.43948,  24.12467,  23.45606,  21.13788,
          17.69826,  17.37892,  15.00269,  14.43571,  15.18723,  13.84108,
          15.20368,  13.59916,  14.52011,  13.7462 ,  15.10008,  19.15064,
          20.62081,  21.31464,  22.53438,  22.18623,  26.09503,  29.10527,
          28.85684,  30.98764,  31.76617,  35.00647,  35.24283,  38.38866,
          39.40758,  40.30443,  42.7187 ,  45.1501 ,  47.59661,  47.72114,
          47.40003,  49.40055,  50.8073 ,  51.74464,  51.63282,  52.72249,
          52.29678,  54.80877,  54.07596,  57.3284 ,  54.10888,  52.36036,
          53.91346,  53.63403,  54.03066,  53.48973,  52.11044,  51.11608,
          51.03286,  50.07272,  48.79067,  48.50627,  47.23087,  44.58934,
          42.22162,  42.18162,  41.16185,  36.93542,  34.29057,  35.12966,
          32.4665 ,  31.1793 ,  25.9365 ,  25.4595 ,  23.76411,  20.24196,
          18.62262,  15.98122,  15.11178,  12.95849,  10.74328,   9.90814,
          0.     ,   6.63421,  10.22093,   9.98474],
        [ 45.20143,  42.89946,  42.30763,  43.70448,  42.49124,  42.53407,
          41.81369,  40.51321,  40.69567,  40.69416,  39.05643,  37.39742,
          37.0847 ,  35.00942,  33.79263,  35.03969,  33.17501,  33.47638,
          29.9473 ,  28.7832 ,  28.60162,  26.69992,  26.30876,  23.4717 ,
          20.07196,  20.49274,  17.43522,  17.62774,  17.0286 ,  16.11862,
          15.44059,  12.73676,  14.22711,  13.92431,  13.99427,  17.6646 ,
          19.57784,  19.94906,  20.85881,  20.58748,  25.22437,  28.10747,
          27.61326,  29.72708,  30.50207,  33.76313,  34.57233,  37.70556,
          38.86882,  39.8812 ,  42.53511,  44.98107,  47.05231,  47.06461,
          46.87143,  49.64106,  50.61611,  51.99425,  52.1621 ,  53.32   ,
          53.08869,  55.50578,  54.94413,  58.22332,  55.4712 ,  53.92575,
          55.78262,  55.43629,  55.76022,  55.54874,  54.48838,  53.03856,
          53.18936,  52.69689,  51.31535,  50.97824,  49.8669 ,  47.23448,
          45.16766,  45.17244,  43.95332,  40.15198,  37.67062,  38.15204,
          36.03614,  34.37541,  29.3083 ,  28.64282,  27.20938,  24.13398,
          21.68822,  19.6484 ,  18.41451,  14.74353,  12.86819,  11.78426,
          6.63421,   0.     ,   8.83043,   8.80103],
        [ 42.75318,  41.51576,  40.55066,  41.85398,  40.79031,  40.64863,
          39.33236,  39.43324,  39.56802,  39.21815,  38.09928,  35.57779,
          36.06984,  33.91675,  34.18837,  33.47656,  31.31277,  33.5043 ,
          29.47687,  28.60458,  28.39343,  26.15777,  24.09575,  22.23873,
          20.9814 ,  18.30611,  17.0517 ,  15.52057,  16.96968,  13.96013,
          11.80224,  10.23459,  12.12231,  12.80535,  10.96839,  13.95903,
          14.73243,  16.52504,  17.8264 ,  18.68724,  20.37247,  24.43796,
          24.23459,  25.83973,  27.94986,  30.48797,  31.19456,  34.12645,
          34.90814,  36.95114,  39.36061,  42.0262 ,  43.63606,  44.40938,
          43.90372,  46.62981,  47.78862,  49.21381,  49.27814,  50.79307,
          50.68305,  53.14199,  52.52346,  56.01087,  53.09032,  51.51095,
          53.64081,  53.67147,  54.37677,  54.10548,  52.87226,  51.85091,
          51.82288,  50.98398,  50.31884,  49.73738,  48.80525,  46.50554,
          44.28871,  45.04898,  43.33299,  40.34494,  38.17835,  38.01118,
          36.48471,  34.48999,  29.80644,  28.83705,  27.40981,  23.94398,
          22.49918,  20.7999 ,  17.69405,  15.81852,  13.30844,  11.47244,
          10.22093,   8.83043,   0.     ,   7.46263],
        [ 46.74111,  45.2993 ,  44.09355,  45.9426 ,  44.66045,  44.57547,
          43.20546,  43.19846,  43.04025,  43.02089,  41.43184,  39.06011,
          40.03816,  38.06303,  37.85652,  37.35049,  35.47796,  36.83706,
          32.87905,  31.58328,  32.42605,  29.63547,  27.8713 ,  25.49112,
          23.64271,  21.75684,  20.42138,  19.39125,  20.31666,  17.63429,
          16.78251,  14.84621,  15.73701,  16.20137,  13.95765,  16.88417,
          17.36648,  20.00963,  20.38759,  20.88898,  22.75393,  27.26505,
          27.25467,  28.4507 ,  30.43803,  33.78487,  34.11927,  36.59337,
          37.3594 ,  39.24277,  42.55081,  44.83658,  46.86818,  47.37281,
          47.26843,  49.95592,  51.26349,  52.79329,  52.86302,  54.50537,
          54.16762,  56.6705 ,  56.22352,  59.61459,  56.86156,  55.33784,
          57.31579,  57.5573 ,  58.38252,  57.89195,  56.74007,  55.85643,
          55.93366,  55.16405,  54.28067,  53.71283,  52.57763,  50.1937 ,
          47.87966,  48.29225,  46.9185 ,  43.38612,  41.31302,  41.47549,
          39.63076,  37.48156,  32.34705,  32.02712,  30.03519,  26.50431,
          24.09327,  23.08624,  18.89004,  18.51871,  14.52224,  12.76638,
          9.98474,   8.80103,   7.46263,   0.     ]])



class FastMetricScmdsScalingTests(TestCase):
    """test the functions to do metric scaling"""


    def setUp(self):
        """creates inputs"""

        self.dist_func = lambda x, y: (FULL_SYM_MATRIX[x, y])
        self.num_objects =  FULL_SYM_MATRIX.shape[0]


    def test_scmds_cmds_tzeng(self):
        """cmds_tzeng() should return eigenvectors and eigenvalues,
        sorted by the eigenvalues
        """

        dim = 3
        (eigvec, eigval) = cmds_tzeng(FULL_SYM_MATRIX, dim)
        self.assertTrue(len(eigval) == dim)
        self.assertTrue(eigvec.shape == (FULL_SYM_MATRIX.shape[0], dim))
        self.assertTrue(sorted(eigval, reverse=True) == eigval.tolist())

        self.assertFloatEqual(eigval[0], 27336.883436)
        self.assertFloatEqual(eigval[-1], 536.736247)
        self.assertFloatEqual(eigvec[0, 0], -14.978621)
        self.assertFloatEqual(eigvec[-1, -1], 0.673001)

        # full pcoa
        dim = FULL_SYM_MATRIX.shape[0]
        (eigvec, eigval) = cmds_tzeng(FULL_SYM_MATRIX, dim)
        self.assertTrue(len(eigval) == dim)
        self.assertTrue(eigvec.shape == (FULL_SYM_MATRIX.shape[0], dim))
        self.assertTrue(sorted(eigval, reverse=True) == eigval.tolist())

        self.assertFloatEqual(eigval[0], 27336.883436043929)
        self.assertFloatEqual(eigval[-1], 0.000000)
        self.assertFloatEqual(eigvec[0, 0], -14.978621)
        self.assertFloatEqual(eigvec[-1, -1], 0.000000)


    def test_scmds_rowmeans(self):
        """rowmeans() should return a vector of row-means for a 2d matrix.
        """

        rm = rowmeans(FULL_SYM_MATRIX[:10])
        self.assertTrue(rm.shape[0] == 10)
        self.assertFloatEqual(float(rm[0]),  25.983320)
        self.assertFloatEqual(float(rm[-1]), 23.967050)



    def test_scmds_recenter(self):
        """recenter() should recenter an mds solution
        """

        mds_coords = matrix([
                [-3.78333558, -2.90925004,  2.75333034],
                [ 5.18887751, -1.2130882 , -0.86476508],
                [-3.10404298, -0.6620052 , -3.91668873],
                [-2.53758526,  3.99102424,  0.86289149],
                [ 4.23608631,  0.7933192 ,  1.16523198]])
        
        centered_coords = recenter(mds_coords)
        self.assertTrue(centered_coords.shape == mds_coords.shape)
        center_of_gravity = sum([centered_coords[:, x].sum() \
                                     for x in range(centered_coords.shape[1])])
        self.assertFloatEqual(center_of_gravity, 0.0)


    def test_scmds_affine_mapping(self):
        """affine_mapping() should return a touple of two matrices of
        certain shape
        """

        matrix_x = matrix([
                [-24.03457111,  10.10355666, -23.17039728,  28.48438894,
                  22.57322482],
                [  0.62716392,  20.84502664,   6.42317521,  -7.66901011,
                   14.37923852],
                [ -2.60793417,   2.83532649,   2.91024821,   1.37414959,
                   -4.22916659]])
        matrix_y = matrix([
                [-29.81089477,  -2.01312927, -30.5925487 ,  23.05985801,
                  11.68581751],
                [ -4.68879117,  23.62633294,   1.07934315,   0.57461989,
                   20.52800221],
                [ -0.51503505,   1.18377044,   0.83671471,   1.81751358,
                   -3.28812925]])

        dim = matrix_x.shape[0]

        (tu, tb) = affine_mapping(matrix_x, matrix_y)
        self.assertTrue(tu.shape[0] == dim and tb.shape[0] == dim)
        self.assertTrue(tu.shape[0] == tu.shape[1])
        self.assertFloatEqual(tu[0, 0], 0.966653)
        self.assertFloatEqual(tu[-1, -1], 0.994816)
        self.assertFloatEqual(tb[0, 0], -6.480975)
        self.assertFloatEqual(tb[-1, -1], 0.686521)



    def test_scmds_adjust_mds_to_ref(self):
        """adjust_mds_to_ref() should return an adjusted mds solutions"""

        overlap = 5
        dim = 3
        size = 10
        fake_mds_coords_ref = FULL_SYM_MATRIX[:size, :dim]
        fake_mds_coords_add = FULL_SYM_MATRIX[overlap:size+overlap, :dim]

        mds_adj = adjust_mds_to_ref(fake_mds_coords_ref,
                                    fake_mds_coords_add, overlap)
        self.assertTrue(mds_adj.shape == fake_mds_coords_add.shape)
        self.assertFloatEqual(mds_adj[0, 0],  7.526609)
        self.assertFloatEqual(mds_adj[-1, -1], 18.009350)


        
    def test_scmds_combine_mds(self):
        """combine_mds() should merge two mds solutions
        """

        overlap = 3
        dim = 3
        mds_coords_1 = matrix([
                [-3.78333558, -2.90925004,  2.75333034],
                [ 5.18887751, -1.2130882 , -0.86476508],
                [-3.10404298, -0.6620052 , -3.91668873],
                [-2.53758526,  3.99102424,  0.86289149],
                [ 4.23608631,  0.7933192 ,  1.16523198]])
        mds_coords_2 = matrix([
                [-3.78333558, -2.90925004,  2.75333034],
                [ 5.18887751, -1.2130882 , -0.86476508],
                [-3.10404298, -0.6620052 , -3.91668873],
                [-2.53758526,  3.99102424,  0.86289149],
                [ 4.23608631,  0.7933192 ,  1.16523198]])

        comb_mds = combine_mds(mds_coords_1,
                               mds_coords_2, overlap)
        self.assertTrue(comb_mds.shape == (
                mds_coords_1.shape[0]*2-overlap, dim))
        self.assertFloatEqual(comb_mds[0, 0], -3.783335)
        #self.assertFloatEqual(comb_mds[-1, -1], 0.349951)


    def test_scmds_class_combinemds(self):
        """class CombineMds() should be able to join MDS solutions
        """

        # tmp note
        # tile1 = FULL_SYM_MATRIX[0:5, 0:5]
        # tile2 = FULL_SYM_MATRIX[2:7, 2:7]
        # mds_coords_1 = cmds_tzeng(tile1, 3)
        # mds_coords_2 = cmds_tzeng(tile2, 3)
        overlap = 3
        mds_coords_1 = matrix([
                [-3.78333558, -2.90925004,  2.75333034],
                [ 5.18887751, -1.2130882 , -0.86476508],
                [-3.10404298, -0.6620052 , -3.91668873],
                [-2.53758526,  3.99102424,  0.86289149],
                [ 4.23608631,  0.7933192 ,  1.16523198]])
        mds_coords_2 = matrix([
                [-3.78333558, -2.90925004,  2.75333034],
                [ 5.18887751, -1.2130882 , -0.86476508],
                [-3.10404298, -0.6620052 , -3.91668873],
                [-2.53758526,  3.99102424,  0.86289149],
                [ 4.23608631,  0.7933192 ,  1.16523198]])

        comb_mds = CombineMds()
        comb_mds.add(mds_coords_1, overlap)
        comb_mds.add(mds_coords_2, overlap)
        final_mds = comb_mds.getFinalMDS()

        self.assertTrue(final_mds.shape == (mds_coords_1.shape[0]*2-overlap, 
                                            mds_coords_1.shape[1]))
        #self.assertFloatEqual(final_mds[0, 0], 0.0393279)
        #self.assertFloatEqual(final_mds[-1, -1], -5.322599)




class FastMetricNystromScalingTests(TestCase):
    """test the functions to do metric scaling"""


    def setUp(self):
        """creates inputs"""

        self.big_seed_matrix = FULL_SYM_MATRIX[:49]
        self.small_seed_matrix = FULL_SYM_MATRIX[:25]


    def test_calc_matrix_a(self):
        """calc_matrix_a should calculate a k x k matrix of
        (predefined) association matrix K of certain (predefined)
        value"""

        nseeds = self.small_seed_matrix.shape[0]
        matrix_e = self.small_seed_matrix[:, 0:nseeds]
        matrix_a = calc_matrix_a(matrix_e)
        self.assertFloatEqual(matrix_a[0, 0], 250.032270)
        self.assertFloatEqual(matrix_a[-1][-1], 316.875461)


    def test_nystrom_build_seed_matrix(self):
        """build_seed_matrix() should return a seedmatrix and an order
        """
        
        seedmat_dim = 10
        dist_func = lambda x, y: (FULL_SYM_MATRIX[x, y])
        (seedmat, order) = build_seed_matrix(
            FULL_SYM_MATRIX.shape[0], seedmat_dim, dist_func)
        self.assertTrue(len(order) == FULL_SYM_MATRIX.shape[0])
        self.assertTrue(sorted(order) == range(FULL_SYM_MATRIX.shape[0]))
        self.assertTrue(seedmat.shape == (
                seedmat_dim, FULL_SYM_MATRIX.shape[0]))

        # build_seed_matrix randomises order
        ind = argsort(order)
        i =  random.randint(0, seedmat.shape[0])
        j =  random.randint(0, seedmat.shape[1])
        self.assertFloatEqual(seedmat[i, j], FULL_SYM_MATRIX[ind[i], ind[j]])
        

    def test_nystrom(self):
        """nystrom() should return an MDS approximation"""

        dim = 3
        mds_coords = nystrom(self.big_seed_matrix, dim)
        self.assertTrue(len(mds_coords.shape) == 2)
        self.assertTrue(mds_coords.shape[0] == self.big_seed_matrix.shape[1])
        self.assertTrue(mds_coords.shape[1] == dim)
        self.assertFloatEqual(mds_coords[0, 0], -10.709626)
        self.assertFloatEqual(mds_coords[-1, -1], -1.778160)


    def test_nystrom_seed_number(self):
        """nystrom() should give better MDS approximations the more
        seeds were used"""

        dim = 3
        mds_coords = nystrom(self.big_seed_matrix, dim)
        stress = goodness_of_fit.Stress(FULL_SYM_MATRIX, mds_coords)
        kruskal_stress_big_mat = stress.calcKruskalStress()
        if PRINT_STRESS:
            print("INFO: Kruskal stress for Nystrom MDS (big_seed_matrix, dim=%d) = %f" % \
                      (dim, kruskal_stress_big_mat))
        self.assertTrue(kruskal_stress_big_mat < 0.04)


        mds_coords = nystrom(self.small_seed_matrix, dim)
        stress = goodness_of_fit.Stress(FULL_SYM_MATRIX, mds_coords)
        kruskal_stress_small_mat = stress.calcKruskalStress()
        if PRINT_STRESS:
            print("INFO: Kruskal stress for Nystrom MDS (small_seed_matrix, dim=%d) = %f" % \
                      (dim, kruskal_stress_small_mat))
        self.assertTrue(kruskal_stress_small_mat < 0.06)

        self.assertTrue(kruskal_stress_small_mat > kruskal_stress_big_mat)

    def test_calc_matrix_b(self):
        """calc_matrix_b should calculate a k x n-k matrix of
        association matrix K
        """

        nseeds = self.small_seed_matrix.shape[0]
        matrix_e = self.small_seed_matrix[:, 0:nseeds]
        matrix_f = self.small_seed_matrix[:, nseeds:]        
        matrix_b = calc_matrix_b(matrix_e, matrix_f)

        self.assertTrue(matrix_b.shape == matrix_f.shape)
        self.assertFloatEqual(matrix_b[0, 0], -272.711227)
        self.assertFloatEqual(matrix_b[-1, -1], -64.898372)


#run if called from the command line
if __name__ == '__main__':
    main()

