/*--------------------------------------------------------------------------+
$Id: SimulinkLineConstraint.java 26285 2010-02-18 11:22:54Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.constraints;

import edu.tum.cs.commons.constraint.ConstraintViolationException;
import edu.tum.cs.commons.constraint.ILocalConstraint;
import edu.tum.cs.simulink.model.SimulinkLine;

/**
 * This constraint checks if a Simulink line crosses subsystem boundaries. This
 * is an optional constraint.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26285 $
 * @levd.rating GREEN Hash: 5014B1A31AD9F286E3B4A02852437876
 */
public class SimulinkLineConstraint implements ILocalConstraint<SimulinkLine> {

	/** See class comment. */
	public void checkLocalConstraint(SimulinkLine element)
			throws ConstraintViolationException {
		if (element.getSrcPort().getBlock().getParent() != element.getDstPort()
				.getBlock().getParent()) {
			throw new ConstraintViolationException("Line " + element
					+ " crosses subsystem boundaries.", element);
		}
	}

}