/*--------------------------------------------------------------------------+
$Id: IStateflowNodeContainer.java 26285 2010-02-18 11:22:54Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.model.stateflow;

import edu.tum.cs.commons.collections.UnmodifiableSet;

/**
 * This interface describes entities that contain {@link StateflowNodeBase}s.
 * 
 * @param
 * <P>
 * Type of the parent of this node.
 * 
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26285 $
 * @levd.rating GREEN Hash: A4F0D624963CD029B529664BBD7AE82C
 */
public interface IStateflowNodeContainer<P extends IStateflowElement<?>>
		extends IStateflowElement<P> {

	/** Add Stateflow node to this containter. */
	public void addNode(StateflowNodeBase node);

	/** Get nodes held by this container. */
	public UnmodifiableSet<StateflowNodeBase> getNodes();
}