/*--------------------------------------------------------------------------+
$Id: StateflowState.java 26285 2010-02-18 11:22:54Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.model.stateflow;

import edu.tum.cs.commons.assertion.CCSMPre;
import edu.tum.cs.commons.collections.CollectionUtils;
import edu.tum.cs.commons.collections.IdentityHashSet;
import edu.tum.cs.commons.collections.UnmodifiableSet;
import edu.tum.cs.simulink.model.SimulinkConstants;

/**
 * This class represents Stateflow states.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26285 $
 * @levd.rating GREEN Hash: 14862BB26963EB0EF15900847B6EE878
 */
public class StateflowState extends StateflowNodeBase implements
		IStateflowNodeContainer<IStateflowNodeContainer<?>> {

	/** Set of child states. */
	private final IdentityHashSet<StateflowNodeBase> nodes = new IdentityHashSet<StateflowNodeBase>();

	/** Create state. */
	public StateflowState() {
		super();
	}

	/** Create new state from existing one (for deep cloning). */
	private StateflowState(StateflowState orig) {
		super(orig);

		for (StateflowNodeBase child : orig.nodes) {
			addNode(child.deepClone());
		}

		TransitionCloneUtils.cloneTransitions(orig, this);
	}

	/** Add a node to this state. */
	public void addNode(StateflowNodeBase node) {
		nodes.add(node);
		node.setParent(this);
	}

	/** Get state label. */
	public String getLabel() {
		return getParameter(SimulinkConstants.PARAM_labelString);
	}

	/** Get child nodes. */
	public UnmodifiableSet<StateflowNodeBase> getNodes() {
		return CollectionUtils.asUnmodifiable(nodes);
	}

	/** Remove node. */
	/* package */void removeNode(StateflowNodeBase node) {
		CCSMPre.isTrue(node.getParent() == this,
				"Node does not belong to this chart.");
		nodes.remove(node);
		node.setParent(null);
	}

	/** Returns label and id. */
	@Override
	public String toString() {
		return getLabel() + " (" + getStateflowId() + ")";
	}

	/** Deep clone this state. */
	@Override
	public StateflowState deepClone() {
		return new StateflowState(this);
	}
}