/*
 * ClassReaderTest.java
 * JUnit based test
 *
 * Created on May 26, 2007, 9:09 PM
 */

package com.sun.tools.javac.jvm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import junit.framework.TestCase;

/**
 *
 * @author lahvac
 */
public class ClassReaderTest extends TestCase {
    
    public ClassReaderTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testX() throws Exception {
        byte[] array = "01234567890123456789012345678901234567890123456789".getBytes();
        InputStream ins = new TestInputStream(new ByteArrayInputStream(array));
        byte[] read = ClassReader.readInputStream(new byte[30], ins);
        byte[] readCanonical = new byte[array.length];
        
        System.arraycopy(read, 0, readCanonical, 0, array.length);
        assertTrue(Arrays.toString(read) + "vs." + Arrays.toString(array), Arrays.equals(array, readCanonical));
    }
    
    private static final class TestInputStream extends InputStream {

        private InputStream delegateTo;

        public TestInputStream(InputStream delegateTo) {
            this.delegateTo = delegateTo;
        }
        
        public int read() throws IOException {
            //not used by ClassReader.readInputStream:
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return delegateTo.read(b, off, Math.min(10, len));
        }

        @Override
        public int available() throws IOException {
            return 30;
        }
        
    }
}
