Name: docbook-utils
Version: 0.6
Release: 13
Group: Applications/Text

Summary: Shell scripts to manage DocBook documents.

License: GPL

Requires: docbook-style-dsssl >= 1.49
Requires: perl-SGMLSpm >= 1.03ii

BuildRoot: %{_tmppath}/%{name}-%{version}

BuildArch: noarch
Source0: %{name}-%{version}.tar.gz
Source1: db2html
Source2: gdp-both.dsl
Patch0: docbook-utils-0.6-..patch
Patch1: jw-custom.patch
Patch2: docbook-utils-0.6-@.patch
Patch3: docbook-utils-0.6-pdf.patch

Obsoletes: stylesheets


%Description
These little scripts are for easy conversion from DocBook files to
other formats (HTML, RTF, PostScript...), and to compare SGML files.

%package pdf
Requires: tetex-dvips jadetex >= 2.5
Requires: docbook-utils = %{version}
Group: Applications/Text
Obsoletes: stylesheets-db2pdf
Summary: A script to convert DocBook documents to PDF.

%description pdf
This package contains a script to convert DocBook documents to PDF.

%Prep
%setup -q
%patch0 -p1 -b ..
%patch1 -p1 -b .custom
%patch2 -p1 -b .@
%patch3 -p1 -b .pdf


%Build
./configure --prefix=%{_prefix} --mandir=%{_mandir}
make


%Install
export DESTDIR=$RPM_BUILD_ROOT
rm -rf $DESTDIR
make install prefix=$DESTDIR/%{_prefix} mandir=$DESTDIR/%{_mandir} docdir=/usr/share/doc
for util in dvi html pdf ps rtf
do
	ln -s docbook2$util $RPM_BUILD_ROOT/usr/bin/db2$util
	ln -s jw.1.gz $RPM_BUILD_ROOT/%{_mandir}/man1/db2$util.1
done
# db2html is not just a symlink, as it has to create the output directory
rm -f $RPM_BUILD_ROOT/usr/bin/db2html
install -c -m 775 %{SOURCE1} $RPM_BUILD_ROOT/usr/bin/db2html
install -c -m 644 %{SOURCE2} $RPM_BUILD_ROOT/usr/share/sgml/docbook/utils-%{version}/docbook-utils.dsl

%Clean
DESTDIR=$RPM_BUILD_ROOT
rm -rf $DESTDIR


%Files
%defattr (-,root,root)
%doc README COPYING TODO
/usr/bin/jw
/usr/bin/docbook2dvi
/usr/bin/docbook2html
/usr/bin/docbook2man
/usr/bin/docbook2ps
/usr/bin/docbook2rtf
/usr/bin/docbook2tex
/usr/bin/docbook2texi
/usr/bin/docbook2txt
/usr/bin/db2dvi
/usr/bin/db2html
/usr/bin/db2ps
/usr/bin/db2rtf
/usr/bin/sgmldiff
/usr/share/sgml/docbook/utils-%{version}
%{_mandir}/*/*

%files pdf
%defattr (-,root,root)
/usr/bin/docbook2pdf
/usr/bin/db2pdf

%changelog
* Sat Mar 24 2001 Tim Waugh <twaugh@redhat.com>
- Fix man pages (bug #32820).

* Mon Mar 12 2001 Tim Waugh <twaugh@redhat.com>
- Fix argument parsing in docbook2xxx (bug #31518).
- Fix argument passing in db2html (bug #31520).
- Fix pdf generation (bug #31524).

* Fri Feb 23 2001 Tim Waugh <twaugh@redhat.com>
- Allow the use of custom backends and frontends (bug #29067).

* Fri Feb 16 2001 Tim Waugh <twaugh@redhat.com>
- Use gdp-both.dsl as the default stylesheet.

* Mon Feb 12 2001 Tim Waugh <twaugh@redhat.com>
- REALLY only create output directory for db2html (duh).
- Handle filenames with dots in properly.

* Sun Feb 11 2001 Tim Waugh <twaugh@redhat.com>
- Only create output directory for db2html (bug #27092). (docbook2html
  does not create an output directory in the upstream version, but
  the compatibility script has been made to do so.)

* Mon Jan 22 2001 Tim Waugh <twaugh@redhat.com>
- Move the jadetex requirement to the -pdf subpackage.

* Tue Jan 16 2001 Tim Waugh <twaugh@redhat.com>
- Put output files in new directory instead of current directory.

* Mon Jan 15 2001 Tim Waugh <twaugh@redhat.com>
- Don't play so many macro games.
- Be sure to own utils directory.

* Fri Jan 12 2001 Tim Waugh <twaugh@redhat.com>
- Split off docbook2pdf into subpackage for dependency reasons.

* Mon Jan 08 2001 Tim Waugh <twaugh@redhat.com>
- Change group.
- Use %%{_mandir} and %%{_prefix}.
- db2* symlinks.
- Obsolete stylesheets (and -db2pdf).
- Change Copyright: to License:.
- Remove Packager: line.
- Reword description.

* Mon Jan 08 2001 Tim Waugh <twaugh@redhat.com>
- Based on Eric Bischoff's new-trials packages.
