/***************************************************************************
                          devicebutton.h  -  description
                             -------------------
    begin                : jeu jui 24 2003
    copyright            : (C) 2003 by ervin
    email                : ervin at tuxfamily dot org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DEVICEBUTTON_H
#define DEVICEBUTTON_H

#include <qbutton.h>
#include <qpoint.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qcursor.h>
#include <kfileitem.h>
#include <kpanelapplet.h>

class DeviceButton : public QButton
{
Q_OBJECT

public: 
	DeviceButton(QWidget *parent, const KFileItem &fileItem);
	~DeviceButton();
	const KFileItem &fileItem() const;
	void setFileItem(const KFileItem &fileItem);
	void setPopupDirection(KPanelApplet::Direction direction);

protected:
	void paintEvent(QPaintEvent *);
	void refreshIcon();
	void drawButton(QPainter *p);
	void drawButtonLabel(QPainter *p);
	void enterEvent(QEvent *e);
	void leaveEvent(QEvent *e);
	void resizeEvent(QResizeEvent *e);
	void mousePressEvent(QMouseEvent *e);

protected slots:
	void slotSettingsChanged(int);
	void slotIconChanged(int);

private:
	KFileItem mFileItem;
	
	QPixmap mIcon;
	QPixmap mIconHighlight;
	KPanelApplet::Direction mPopupDirection;
	bool mHighlight;
	bool mChangeCursorOverItem;
};

#endif
