/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.gcj.runtime.SharedLibHelper;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class URLClassLoader
extends SecureClassLoader {
    private static HashMap urlloaders = new HashMap();
    private static HashMap factoryCache = new HashMap(5);
    private final Vector urls;
    private final Vector urlinfos;
    private final URLStreamHandlerFactory factory;
    private final AccessControlContext securityContext;

    private /* synthetic */ void finit$() {
        this.urls = new Vector();
        this.urlinfos = new Vector();
    }

    public URLClassLoader(URL[] urls) throws SecurityException {
        this.finit$();
        this.factory = null;
        this.securityContext = null;
        this.addURLs(urls);
    }

    private URLClassLoader(AccessControlContext securityContext) {
        this.finit$();
        this.factory = null;
        this.securityContext = securityContext;
    }

    public URLClassLoader(URL[] urls, ClassLoader parent) throws SecurityException {
        super(parent);
        this.finit$();
        this.factory = null;
        this.securityContext = null;
        this.addURLs(urls);
    }

    private URLClassLoader(ClassLoader parent, AccessControlContext securityContext) {
        super(parent);
        this.finit$();
        this.factory = null;
        this.securityContext = securityContext;
    }

    public URLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) throws SecurityException {
        super(parent);
        this.finit$();
        this.securityContext = null;
        this.factory = factory;
        this.addURLs(urls);
        HashMap hashMap = factoryCache;
        synchronized (hashMap) {
            block3: {
                try {
                    if (factory == null || factoryCache.get(factory) != null) break block3;
                    factoryCache.put(factory, new HashMap(5));
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
            Object var5_5 = null;
        }
    }

    protected void addURL(URL newUrl) {
        this.addURLImpl(newUrl);
    }

    private void addURLImpl(URL newUrl) {
        HashMap hashMap = urlloaders;
        synchronized (hashMap) {
            try {
                if (newUrl == null) {
                    Object var3_3 = null;
                    return;
                }
                URLLoader loader = (URLLoader)urlloaders.get(newUrl);
                if (loader == null) {
                    String file = newUrl.getFile();
                    String protocol = newUrl.getProtocol();
                    loader = "gcjlib".equals(protocol) ? new SoURLLoader(this, newUrl) : (!file.endsWith("/") && !file.endsWith(File.separator) ? new JarURLLoader(this, newUrl) : ("file".equals(protocol) ? new FileURLLoader(this, newUrl) : new RemoteURLLoader(this, newUrl)));
                    urlloaders.put(newUrl, loader);
                }
                this.urls.add(newUrl);
                this.urlinfos.add(loader);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                throw throwable;
            }
            Object var3_4 = null;
        }
    }

    private void addURLs(URL[] newUrls) {
        for (int i = 0; i < newUrls.length; ++i) {
            this.addURLImpl(newUrls[i]);
        }
    }

    protected Package definePackage(String name, Manifest manifest, URL url) throws IllegalArgumentException {
        Attributes attr = manifest.getMainAttributes();
        String specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
        String specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
        String specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
        String implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        String implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        String implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        String sealed = attr.getValue(Attributes.Name.SEALED);
        if ("false".equals(sealed)) {
            url = null;
        }
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, url);
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        String resourceName = className.replace('.', '/') + ".class";
        int max = this.urls.size();
        Resource resource = null;
        for (int i = 0; i < max && resource == null; ++i) {
            URLLoader loader = (URLLoader)this.urlinfos.elementAt(i);
            if (loader == null) continue;
            Class k = loader.getClass(className);
            if (k != null) {
                return k;
            }
            resource = loader.getResource(resourceName);
        }
        if (resource == null) {
            throw new ClassNotFoundException(className + " not found in " + this.urls);
        }
        try {
            SecurityManager sm;
            byte[] data;
            InputStream in = resource.getInputStream();
            int length = resource.getLength();
            if (length != -1) {
                data = new byte[length];
                int pos = 0;
                while (length - pos > 0) {
                    int len = in.read(data, pos, length - pos);
                    if (len == -1) {
                        throw new EOFException("Not enough data reading from: " + in);
                    }
                    pos += len;
                }
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
                byte[] b = new byte[4096];
                int l = 0;
                while (l != -1) {
                    l = in.read(b);
                    if (l == -1) continue;
                    out.write(b, 0, l);
                }
                data = out.toByteArray();
            }
            byte[] classData = data;
            CodeSource source = resource.getCodeSource();
            String packageName = null;
            int lastDot = className.lastIndexOf(46);
            if (lastDot != -1) {
                packageName = className.substring(0, lastDot);
            }
            if (packageName != null && this.getPackage(packageName) == null) {
                Manifest manifest = resource.loader.getManifest();
                if (manifest == null) {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                } else {
                    this.definePackage(packageName, manifest, resource.loader.baseURL);
                }
            }
            if ((sm = System.getSecurityManager()) != null && this.securityContext != null) {
                return (Class)AccessController.doPrivileged(new PrivilegedAction(this, source, classData, className){
                    private /* synthetic */ URLClassLoader this$0;
                    private /* synthetic */ CodeSource val$source;
                    private /* synthetic */ byte[] val$classData;
                    private /* synthetic */ String val$className;
                    {
                        this.this$0 = this$0;
                        this.finit$(parm$source, parm$classData, parm$className);
                    }

                    private /* synthetic */ void finit$(CodeSource parm$source, byte[] parm$classData, String parm$className) {
                        this.val$className = parm$className;
                        this.val$classData = parm$classData;
                        this.val$source = parm$source;
                    }

                    public Object run() {
                        return this.this$0.defineClass(this.val$className, this.val$classData, 0, this.val$classData.length, this.val$source);
                    }
                }, this.securityContext);
            }
            return this.defineClass(className, classData, 0, classData.length, source);
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(className, ioe);
        }
    }

    private Resource findURLResource(String resourceName) {
        int max = this.urls.size();
        for (int i = 0; i < max; ++i) {
            Resource resource;
            URLLoader loader = (URLLoader)this.urlinfos.elementAt(i);
            if (loader == null || (resource = loader.getResource(resourceName)) == null) continue;
            return resource;
        }
        return null;
    }

    public URL findResource(String resourceName) {
        Resource resource = this.findURLResource(resourceName);
        if (resource != null) {
            return resource.getURL();
        }
        return null;
    }

    URLStreamHandler getURLStreamHandler(String protocol) {
        URLStreamHandler uRLStreamHandler;
        URLStreamHandler handler;
        if (this.factory == null) {
            return null;
        }
        HashMap hashMap = factoryCache;
        synchronized (hashMap) {
            block4: {
                try {
                    HashMap cache = (HashMap)factoryCache.get(this.factory);
                    handler = (URLStreamHandler)cache.get(protocol);
                    if (handler != null) break block4;
                    handler = this.factory.createURLStreamHandler(protocol);
                    cache.put(protocol, handler);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
            uRLStreamHandler = null;
        }
        uRLStreamHandler = handler;
        return uRLStreamHandler;
    }

    public Enumeration findResources(String resourceName) throws IOException {
        Vector resources = new Vector();
        int max = this.urls.size();
        for (int i = 0; i < max; ++i) {
            URLLoader loader = (URLLoader)this.urlinfos.elementAt(i);
            Resource resource = loader.getResource(resourceName);
            if (resource == null) continue;
            resources.add(resource.getURL());
        }
        return resources.elements();
    }

    protected PermissionCollection getPermissions(CodeSource source) {
        PermissionCollection permissions = super.getPermissions(source);
        URL url = source.getLocation();
        String protocol = url.getProtocol();
        if (protocol.equals("file")) {
            String file = url.getFile();
            if (file.endsWith("/") || file.endsWith(File.separator)) {
                permissions.add(new FilePermission(file + "-", "read"));
            } else {
                permissions.add(new FilePermission(file, "read"));
            }
        } else {
            String host = url.getHost();
            if (host != null) {
                permissions.add(new SocketPermission(host, "connect,accept"));
            }
        }
        return permissions;
    }

    public URL[] getURLs() {
        return (URL[])this.urls.toArray(new URL[this.urls.size()]);
    }

    public static URLClassLoader newInstance(URL[] urls) throws SecurityException {
        return URLClassLoader.newInstance(urls, null);
    }

    public static URLClassLoader newInstance(URL[] urls, ClassLoader parent) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return new URLClassLoader(urls, parent);
        }
        Object securityContext = sm.getSecurityContext();
        if (!(securityContext instanceof AccessControlContext)) {
            throw new SecurityException("securityContext must be AccessControlContext: " + securityContext);
        }
        URLClassLoader loader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(null, securityContext, parent){
            private /* synthetic */ URLClassLoader this$0;
            private /* synthetic */ Object val$securityContext;
            private /* synthetic */ ClassLoader val$parent;
            {
                this.this$0 = this$0;
                this.finit$(parm$securityContext, parm$parent);
            }

            private /* synthetic */ void finit$(Object parm$securityContext, ClassLoader parm$parent) {
                this.val$parent = parm$parent;
                this.val$securityContext = parm$securityContext;
            }

            public Object run() {
                return new URLClassLoader(this.val$parent, (AccessControlContext)this.val$securityContext);
            }
        });
        loader.addURLs(urls);
        return loader;
    }

    static final class FileResource
    extends Resource {
        final File file;

        FileResource(FileURLLoader loader, String name, File file) {
            super(loader, name);
            this.file = file;
        }

        InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        public int getLength() {
            return (int)this.file.length();
        }

        public URL getURL() {
            try {
                return new URL(this.loader.baseURL, this.name, this.loader.classloader.getURLStreamHandler("file"));
            }
            catch (MalformedURLException e) {
                InternalError ie = new InternalError();
                ie.initCause(e);
                throw ie;
            }
        }
    }

    static final class FileURLLoader
    extends URLLoader {
        File dir;

        FileURLLoader(URLClassLoader classloader, URL url) {
            super(classloader, url);
            this.dir = new File(this.baseURL.getFile());
        }

        Resource getResource(String name) {
            File file = new File(this.dir, name);
            if (file.exists() && !file.isDirectory()) {
                return new FileResource(this, name, file);
            }
            return null;
        }
    }

    static final class SoResource
    extends Resource {
        final URL url;

        SoResource(SoURLLoader loader, String name, URL url) {
            super(loader, name);
            this.url = url;
        }

        InputStream getInputStream() throws IOException {
            URLConnection conn = this.url.openConnection();
            return conn.getInputStream();
        }

        public int getLength() {
            return -1;
        }

        public URL getURL() {
            return this.url;
        }
    }

    static final class SoURLLoader
    extends URLLoader {
        SharedLibHelper helper;

        SoURLLoader(URLClassLoader classloader, URL url) {
            super(classloader, url);
            this.helper = SharedLibHelper.findHelper(classloader, url.getFile(), this.noCertCodeSource);
        }

        Class getClass(String className) {
            return this.helper.findClass(className);
        }

        Resource getResource(String name) {
            URL url = this.helper.findResource(name);
            if (url == null) {
                return null;
            }
            return new SoResource(this, name, url);
        }
    }

    static final class RemoteResource
    extends Resource {
        private final URL url;
        private final InputStream stream;
        private final int length;

        RemoteResource(RemoteURLLoader loader, String name, URL url, InputStream stream, int length) {
            super(loader, name);
            this.url = url;
            this.stream = stream;
            this.length = length;
        }

        InputStream getInputStream() throws IOException {
            return this.stream;
        }

        public int getLength() {
            return this.length;
        }

        public URL getURL() {
            return this.url;
        }
    }

    static final class RemoteURLLoader
    extends URLLoader {
        private final String protocol;

        RemoteURLLoader(URLClassLoader classloader, URL url) {
            super(classloader, url);
            this.protocol = url.getProtocol();
        }

        Resource getResource(String name) {
            try {
                int response;
                URL url = new URL(this.baseURL, name, this.classloader.getURLStreamHandler(this.protocol));
                URLConnection connection = url.openConnection();
                int length = connection.getContentLength();
                InputStream stream = connection.getInputStream();
                if (connection instanceof HttpURLConnection && (response = ((HttpURLConnection)connection).getResponseCode()) / 100 != 2) {
                    return null;
                }
                if (stream != null) {
                    return new RemoteResource(this, name, url, stream, length);
                }
                return null;
            }
            catch (IOException ioe) {
                return null;
            }
        }
    }

    static final class JarURLResource
    extends Resource {
        private final JarEntry entry;

        JarURLResource(JarURLLoader loader, String name, JarEntry entry) {
            super(loader, name);
            this.entry = entry;
        }

        InputStream getInputStream() throws IOException {
            return ((JarURLLoader)this.loader).jarfile.getInputStream(this.entry);
        }

        int getLength() {
            return (int)this.entry.getSize();
        }

        Certificate[] getCertificates() {
            return this.entry.getCertificates();
        }

        URL getURL() {
            try {
                return new URL(((JarURLLoader)this.loader).baseJarURL, this.name, this.loader.classloader.getURLStreamHandler("jar"));
            }
            catch (MalformedURLException e) {
                InternalError ie = new InternalError();
                ie.initCause(e);
                throw ie;
            }
        }
    }

    static final class JarURLLoader
    extends URLLoader {
        final JarFile jarfile;
        final URL baseJarURL;

        public JarURLLoader(URLClassLoader classloader, URL baseURL) {
            super(classloader, baseURL);
            String external = baseURL.toExternalForm();
            StringBuffer sb = new StringBuffer(external.length() + 6);
            sb.append("jar:");
            sb.append(external);
            sb.append("!/");
            String jarURL = sb.toString();
            URL baseJarURL = null;
            JarFile jarfile = null;
            try {
                baseJarURL = new URL(null, jarURL, classloader.getURLStreamHandler("jar"));
                jarfile = ((JarURLConnection)baseJarURL.openConnection()).getJarFile();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.baseJarURL = baseJarURL;
            this.jarfile = jarfile;
        }

        Resource getResource(String name) {
            JarEntry je;
            if (this.jarfile == null) {
                return null;
            }
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if ((je = this.jarfile.getJarEntry(name)) != null) {
                return new JarURLResource(this, name, je);
            }
            return null;
        }

        Manifest getManifest() {
            try {
                if (this.jarfile == null) {
                    return null;
                }
                return this.jarfile.getManifest();
            }
            catch (IOException ioe) {
                return null;
            }
        }
    }

    static abstract class Resource {
        final URLLoader loader;
        final String name;

        Resource(URLLoader loader, String name) {
            this.loader = loader;
            this.name = name;
        }

        CodeSource getCodeSource() {
            Certificate[] certs = this.getCertificates();
            if (certs == null) {
                return this.loader.noCertCodeSource;
            }
            return new CodeSource(this.loader.baseURL, certs);
        }

        Certificate[] getCertificates() {
            return null;
        }

        abstract URL getURL();

        abstract int getLength();

        abstract InputStream getInputStream() throws IOException;
    }

    static abstract class URLLoader {
        final URLClassLoader classloader;
        final URL baseURL;
        final CodeSource noCertCodeSource;

        URLLoader(URLClassLoader classloader, URL baseURL) {
            this.classloader = classloader;
            this.baseURL = baseURL;
            this.noCertCodeSource = new CodeSource(baseURL, null);
        }

        Class getClass(String className) {
            return null;
        }

        abstract Resource getResource(String var1);

        Manifest getManifest() {
            return null;
        }
    }
}

