/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.SQLObjectComboBoxModel;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.validation.Validator;
import ca.sqlpower.validation.swingui.FormValidationHandler;
import ca.sqlpower.validation.swingui.NotNullValidator;
import ca.sqlpower.validation.swingui.StatusComponent;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DimensionUsageEditPanel
implements DataEntryPanel {
    private final MondrianModel.DimensionUsage dimensionUsage;
    private final JPanel panel;
    private JTextField captionField;
    private JComboBox foreignKeyChooser;
    private FormValidationHandler handler;
    private StatusComponent status = new StatusComponent();

    public DimensionUsageEditPanel(MondrianModel.DimensionUsage dimensionUsage) throws SQLObjectException {
        this.dimensionUsage = dimensionUsage;
        FormLayout layout = new FormLayout("left:max(40dlu;pref), 3dlu, 80dlu:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)this.status, 3);
        this.captionField = new JTextField(dimensionUsage.getCaption());
        builder.append("Caption", (Component)this.captionField);
        this.foreignKeyChooser = new JComboBox();
        builder.append("Foreign Key", this.foreignKeyChooser);
        MondrianModel.Cube cube = (MondrianModel.Cube)dimensionUsage.getParent();
        SQLTable factTable = OLAPUtil.tableForCube(cube);
        if (factTable == null) {
            this.foreignKeyChooser.addItem("Parent Cube has no fact table");
            this.foreignKeyChooser.setEnabled(false);
        } else if (factTable.getColumns().isEmpty()) {
            this.foreignKeyChooser.addItem("Parent Cube Fact table has no columns");
            this.foreignKeyChooser.setEnabled(false);
        } else {
            this.foreignKeyChooser.setModel(new SQLObjectComboBoxModel((SQLObject)factTable, SQLColumn.class));
            for (SQLColumn col : factTable.getColumns()) {
                if (!col.getName().equals(dimensionUsage.getForeignKey())) continue;
                this.foreignKeyChooser.setSelectedItem(col);
            }
        }
        this.handler = new FormValidationHandler(this.status, true);
        this.handler.addValidateObject((JComponent)this.foreignKeyChooser, (Validator)new NotNullValidator("Foreign key"));
        this.panel = builder.getPanel();
    }

    public boolean applyChanges() {
        this.dimensionUsage.begin("Modify Dimension Usage Properties");
        if (!this.captionField.getText().equals("")) {
            this.dimensionUsage.setCaption(this.captionField.getText());
        } else {
            this.dimensionUsage.setCaption(null);
        }
        if (this.foreignKeyChooser.isEnabled()) {
            SQLColumn selectedCol = (SQLColumn)this.foreignKeyChooser.getSelectedItem();
            String pk = selectedCol.getName();
            this.dimensionUsage.setForeignKey(pk);
        }
        this.dimensionUsage.commit();
        return true;
    }

    public void discardChanges() {
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }
}

