/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.processfiles;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.processfiles.Messages;
import org.pentaho.di.trans.steps.processfiles.ProcessFilesData;
import org.pentaho.di.trans.steps.processfiles.ProcessFilesMeta;

public class ProcessFiles
extends BaseStep
implements StepInterface {
    private ProcessFilesMeta meta;
    private ProcessFilesData data;

    public ProcessFiles(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block34: {
            this.meta = (ProcessFilesMeta)smi;
            this.data = (ProcessFilesData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                if (Const.isEmpty((String)this.meta.getDynamicSourceFileNameField())) {
                    throw new KettleException(Messages.getString("ProcessFiles.Error.SourceFilenameFieldMissing"));
                }
                if (this.meta.getOperationType() != 2 && Const.isEmpty((String)this.meta.getDynamicTargetFileNameField())) {
                    throw new KettleException(Messages.getString("ProcessFiles.Error.TargetFilenameFieldMissing"));
                }
                if (this.data.indexOfSourceFilename < 0) {
                    this.data.indexOfSourceFilename = this.getInputRowMeta().indexOfValue(this.meta.getDynamicSourceFileNameField());
                    if (this.data.indexOfSourceFilename < 0) {
                        throw new KettleException(Messages.getString("ProcessFiles.Exception.CouldnotFindField", this.meta.getDynamicSourceFileNameField()));
                    }
                }
                if (this.meta.getOperationType() != 2 && this.data.indexOfTargetFilename < 0) {
                    this.data.indexOfTargetFilename = this.getInputRowMeta().indexOfValue(this.meta.getDynamicTargetFileNameField());
                    if (this.data.indexOfTargetFilename < 0) {
                        throw new KettleException(Messages.getString("ProcessFiles.Exception.CouldnotFindField", this.meta.getDynamicTargetFileNameField()));
                    }
                }
                if (this.meta.simulate && this.log.isBasic()) {
                    this.log.logBasic(this.toString(), Messages.getString("ProcessFiles.Log.SimulationModeON"), new Object[0]);
                }
            }
            try {
                String sourceFilename = this.getInputRowMeta().getString(r, this.data.indexOfSourceFilename);
                if (Const.isEmpty((String)sourceFilename)) {
                    this.log.logError(this.toString(), Messages.getString("ProcessFiles.Error.SourceFileEmpty"), new Object[0]);
                    throw new KettleException(Messages.getString("ProcessFiles.Error.SourceFileEmpty"));
                }
                this.data.sourceFile = KettleVFS.getFileObject((String)sourceFilename);
                boolean targetFileExists = false;
                if (!this.data.sourceFile.exists()) {
                    this.log.logError(this.toString(), Messages.getString("ProcessFiles.Error.SourceFileNotExist", sourceFilename), new Object[0]);
                    throw new KettleException(Messages.getString("ProcessFiles.Error.SourceFileNotExist", sourceFilename));
                }
                if (this.data.sourceFile.getType() != FileType.FILE) {
                    this.log.logError(this.toString(), Messages.getString("ProcessFiles.Error.SourceFileNotFile", sourceFilename), new Object[0]);
                    throw new KettleException(Messages.getString("ProcessFiles.Error.SourceFileNotFile", sourceFilename));
                }
                String targetFilename = null;
                if (this.meta.getOperationType() != 2) {
                    targetFilename = this.getInputRowMeta().getString(r, this.data.indexOfTargetFilename);
                    if (Const.isEmpty((String)targetFilename)) {
                        this.log.logError(this.toString(), Messages.getString("ProcessFiles.Error.TargetFileEmpty"), new Object[0]);
                        throw new KettleException(Messages.getString("ProcessFiles.Error.TargetFileEmpty"));
                    }
                    this.data.targetFile = KettleVFS.getFileObject((String)targetFilename);
                    if (this.data.targetFile.exists()) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), Messages.getString("ProcessFiles.Log.TargetFileExists", targetFilename), new Object[0]);
                        }
                    } else {
                        FileObject parentFolder = this.data.targetFile.getParent();
                        if (!parentFolder.exists()) {
                            if (!this.meta.isCreateParentFolder()) {
                                throw new KettleException(Messages.getString("ProcessFiles.Error.TargetParentFolderNotExists", parentFolder.toString()));
                            }
                            parentFolder.createFolder();
                        }
                        if (parentFolder != null) {
                            parentFolder.close();
                        }
                    }
                }
                switch (this.meta.getOperationType()) {
                    case 0: {
                        if ((this.meta.isOverwriteTargetFile() && targetFileExists || !targetFileExists) && !this.meta.simulate) {
                            this.data.targetFile.copyFrom(this.data.sourceFile, (FileSelector)new TextOneToOneFileSelector());
                        }
                        if (!this.log.isDetailed()) break;
                        this.log.logDetailed(this.toString(), Messages.getString("ProcessFiles.Log.SourceFileCopied", sourceFilename, targetFilename), new Object[0]);
                        break;
                    }
                    case 1: {
                        if ((this.meta.isOverwriteTargetFile() && targetFileExists || !targetFileExists) && !this.meta.simulate) {
                            this.data.sourceFile.moveTo(KettleVFS.getFileObject((String)targetFilename));
                        }
                        if (!this.log.isDetailed()) break;
                        this.log.logDetailed(this.toString(), Messages.getString("ProcessFiles.Log.SourceFileMoved", sourceFilename, targetFilename), new Object[0]);
                        break;
                    }
                    case 2: {
                        if (!this.meta.simulate && !this.data.sourceFile.delete()) {
                            throw new KettleException(Messages.getString("ProcessFiles.Error.CanNotDeleteFile", this.data.sourceFile.toString()));
                        }
                        if (!this.log.isDetailed()) break;
                        this.log.logDetailed(this.toString(), Messages.getString("ProcessFiles.Log.SourceFileDeleted", sourceFilename), new Object[0]);
                        break;
                    }
                }
                if (this.meta.isaddTargetFileNametoResult() && this.meta.getOperationType() != 2 && this.data.sourceFile.getType() == FileType.FILE) {
                    ResultFile resultFile = new ResultFile(0, this.data.targetFile, this.getTransMeta().getName(), this.getStepname());
                    resultFile.setComment(Messages.getString("ProcessFiles.Log.FileAddedResult"));
                    this.addResultFile(resultFile);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), Messages.getString("ProcessFiles.Log.FilenameAddResult", this.data.sourceFile.toString()), new Object[0]);
                    }
                }
                this.putRow(this.getInputRowMeta(), r);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic(Messages.getString("ProcessFiles.LineNumber") + this.getLinesRead());
                }
            }
            catch (Exception e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("ProcessFiles.ErrorInStepRunning") + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block34;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "ProcessFiles001");
            }
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ProcessFilesMeta)smi;
        this.data = (ProcessFilesData)sdi;
        return super.init(smi, sdi);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ProcessFilesMeta)smi;
        this.data = (ProcessFilesData)sdi;
        if (this.data.sourceFile != null) {
            try {
                this.data.sourceFile.close();
                this.data.sourceFile = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.data.targetFile != null) {
            try {
                this.data.targetFile.close();
                this.data.targetFile = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }

    public String toString() {
        return this.getClass().getName();
    }

    private class TextOneToOneFileSelector
    implements FileSelector {
        private TextOneToOneFileSelector() {
        }

        public boolean includeFile(FileSelectInfo info) throws Exception {
            return true;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return false;
        }
    }
}

