/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.math.MathContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.internal.Engine;

public final class JexlOptions {
    private static final int BOOLEAN_LOGICAL = 10;
    private static final int STRICT_INTERPOLATION = 9;
    private static final int CONST_CAPTURE = 8;
    private static final int SHARED = 7;
    private static final int SHADE = 6;
    private static final int ANTISH = 5;
    private static final int LEXICAL = 4;
    private static final int SAFE = 3;
    private static final int SILENT = 2;
    private static final int STRICT = 1;
    private static final int CANCELLABLE = 0;
    private static final String[] NAMES = new String[]{"cancellable", "strict", "silent", "safe", "lexical", "antish", "lexicalShade", "sharedInstance", "constCapture", "strictInterpolation", "booleanShortCircuit"};
    private static int DEFAULT = 43;
    private MathContext mathContext;
    private int mathScale = Integer.MIN_VALUE;
    private boolean strictArithmetic = true;
    private int flags = DEFAULT;
    private Map<String, Object> namespaces = Collections.emptyMap();
    private Collection<String> imports = Collections.emptySet();

    private static boolean isSet(int ordinal, int mask) {
        return (mask & 1 << ordinal) != 0;
    }

    public static int parseFlags(int initial, String ... flags) {
        int mask = initial;
        block0: for (String flag : flags) {
            String name;
            boolean b = true;
            if (flag.charAt(0) == '+') {
                name = flag.substring(1);
            } else if (flag.charAt(0) == '-') {
                name = flag.substring(1);
                b = false;
            } else {
                name = flag;
            }
            for (int f = 0; f < NAMES.length; ++f) {
                if (!NAMES[f].equals(name)) continue;
                if (b) {
                    mask |= 1 << f;
                    continue block0;
                }
                mask &= ~(1 << f);
                continue block0;
            }
        }
        return mask;
    }

    private static int set(int ordinal, int mask, boolean value) {
        return value ? mask | 1 << ordinal : mask & ~(1 << ordinal);
    }

    public static void setDefaultFlags(String ... flags) {
        DEFAULT = JexlOptions.parseFlags(DEFAULT, flags);
    }

    public JexlOptions copy() {
        return new JexlOptions().set(this);
    }

    public Collection<String> getImports() {
        return this.imports;
    }

    public MathContext getMathContext() {
        return this.mathContext;
    }

    public int getMathScale() {
        return this.mathScale;
    }

    public Map<String, Object> getNamespaces() {
        return this.namespaces;
    }

    public boolean isAntish() {
        return JexlOptions.isSet(5, this.flags);
    }

    public boolean isBooleanLogical() {
        return JexlOptions.isSet(10, this.flags);
    }

    public boolean isCancellable() {
        return JexlOptions.isSet(0, this.flags);
    }

    public boolean isConstCapture() {
        return JexlOptions.isSet(8, this.flags);
    }

    public boolean isLexical() {
        return JexlOptions.isSet(4, this.flags);
    }

    public boolean isLexicalShade() {
        return JexlOptions.isSet(6, this.flags);
    }

    public boolean isSafe() {
        return JexlOptions.isSet(3, this.flags);
    }

    public boolean isSharedInstance() {
        return JexlOptions.isSet(7, this.flags);
    }

    public boolean isSilent() {
        return JexlOptions.isSet(2, this.flags);
    }

    public boolean isStrict() {
        return JexlOptions.isSet(1, this.flags);
    }

    public boolean isStrictArithmetic() {
        return this.strictArithmetic;
    }

    public boolean isStrictInterpolation() {
        return JexlOptions.isSet(9, this.flags);
    }

    public JexlOptions set(JexlEngine jexl) {
        if (jexl instanceof Engine) {
            ((Engine)jexl).optionsSet(this);
        }
        return this;
    }

    public JexlOptions set(JexlOptions src) {
        this.mathContext = src.mathContext;
        this.mathScale = src.mathScale;
        this.strictArithmetic = src.strictArithmetic;
        this.flags = src.flags;
        this.namespaces = src.namespaces;
        this.imports = src.imports;
        return this;
    }

    public void setAntish(boolean flag) {
        this.flags = JexlOptions.set(5, this.flags, flag);
    }

    public void setBooleanLogical(boolean flag) {
        this.flags = JexlOptions.set(10, this.flags, flag);
    }

    public void setCancellable(boolean flag) {
        this.flags = JexlOptions.set(0, this.flags, flag);
    }

    public void setConstCapture(boolean flag) {
        this.flags = JexlOptions.set(8, this.flags, flag);
    }

    public void setFlags(String ... opts) {
        this.flags = JexlOptions.parseFlags(this.flags, opts);
    }

    public void setImports(Collection<String> imports) {
        this.imports = imports == null || imports.isEmpty() ? Collections.emptySet() : imports;
    }

    public void setLexical(boolean flag) {
        this.flags = JexlOptions.set(4, this.flags, flag);
    }

    public void setLexicalShade(boolean flag) {
        this.flags = JexlOptions.set(6, this.flags, flag);
        if (flag) {
            this.flags = JexlOptions.set(4, this.flags, true);
        }
    }

    public void setMathContext(MathContext mcontext) {
        this.mathContext = mcontext;
    }

    public void setMathScale(int mscale) {
        this.mathScale = mscale;
    }

    public void setNamespaces(Map<String, Object> ns) {
        this.namespaces = ns == null || ns.isEmpty() ? Collections.emptyMap() : ns;
    }

    public void setSafe(boolean flag) {
        this.flags = JexlOptions.set(3, this.flags, flag);
    }

    public void setSharedInstance(boolean flag) {
        this.flags = JexlOptions.set(7, this.flags, flag);
    }

    public void setSilent(boolean flag) {
        this.flags = JexlOptions.set(2, this.flags, flag);
    }

    public void setStrict(boolean flag) {
        this.flags = JexlOptions.set(1, this.flags, flag);
    }

    public void setStrictArithmetic(boolean stricta) {
        this.strictArithmetic = stricta;
    }

    public void setStrictInterpolation(boolean strict) {
        this.flags = JexlOptions.set(9, this.flags, strict);
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        for (int i = 0; i < NAMES.length; ++i) {
            if (i > 0) {
                strb.append(' ');
            }
            strb.append((this.flags & 1 << i) != 0 ? (char)'+' : '-');
            strb.append(NAMES[i]);
        }
        return strb.toString();
    }
}

