/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.kafka.common.TopicPartition;

public abstract class CommitEvent
extends CompletableApplicationEvent<Map<TopicPartition, OffsetAndMetadata>> {
    private final Optional<Map<TopicPartition, OffsetAndMetadata>> offsets;
    protected final CompletableFuture<Void> offsetsReady = new CompletableFuture();

    protected CommitEvent(ApplicationEvent.Type type, Optional<Map<TopicPartition, OffsetAndMetadata>> offsets, long deadlineMs) {
        super(type, deadlineMs);
        this.offsets = CommitEvent.validate(offsets);
    }

    private static Optional<Map<TopicPartition, OffsetAndMetadata>> validate(Optional<Map<TopicPartition, OffsetAndMetadata>> offsets) {
        if (offsets.isEmpty()) {
            return Optional.empty();
        }
        for (OffsetAndMetadata offsetAndMetadata : offsets.get().values()) {
            if (offsetAndMetadata.offset() >= 0L) continue;
            throw new IllegalArgumentException("Invalid offset: " + offsetAndMetadata.offset());
        }
        return Optional.of(Collections.unmodifiableMap(offsets.get()));
    }

    public Optional<Map<TopicPartition, OffsetAndMetadata>> offsets() {
        return this.offsets;
    }

    public CompletableFuture<Void> offsetsReady() {
        return this.offsetsReady;
    }

    public void markOffsetsReady() {
        this.offsetsReady.complete(null);
    }

    @Override
    protected String toStringBase() {
        return super.toStringBase() + ", offsets=" + String.valueOf(this.offsets);
    }
}

