/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.util.Objects;
import java.util.StringTokenizer;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderRobotstxtParser
extends SpiderParser {
    private static final String COMMENT_TOKEN = "#";
    private static final String PATTERNS_DISALLOW = "(?i)Disallow:.*";
    private static final String PATTERNS_ALLOW = "(?i)Allow:.*";
    private static final int PATTERNS_DISALLOW_LENGTH = 9;
    private static final int PATTERNS_ALLOW_LENGTH = 6;
    private SpiderParam params;

    public SpiderRobotstxtParser(SpiderParam params) {
        this.params = Objects.requireNonNull(params, "Parameter params must not be null.");
    }

    @Override
    public boolean parseResource(HttpMessage message, Source source, int depth) {
        if (!this.params.isParseRobotsTxt()) {
            return false;
        }
        this.getLogger().debug("Parsing a robots.txt resource...");
        String baseURL = message.getRequestHeader().getURI().toString();
        StringTokenizer st = new StringTokenizer(message.getResponseBody().toString(), "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            int commentStart = line.indexOf(COMMENT_TOKEN);
            if (commentStart != -1) {
                line = line.substring(0, commentStart);
            }
            line = line.replaceAll("<[^>]+>", "");
            if ((line = line.trim()).isEmpty()) continue;
            this.getLogger().debug("Processing robots.txt line: " + line);
            if (line.matches(PATTERNS_DISALLOW)) {
                this.processPath(message, depth, line.substring(9), baseURL);
                continue;
            }
            if (!line.matches(PATTERNS_ALLOW)) continue;
            this.processPath(message, depth, line.substring(6), baseURL);
        }
        return true;
    }

    private void processPath(HttpMessage message, int depth, String path, String baseURL) {
        String processedPath = path.trim();
        if (processedPath.endsWith("*")) {
            processedPath = processedPath.substring(0, processedPath.length() - 1).trim();
        }
        if (!processedPath.isEmpty()) {
            this.processURL(message, depth, processedPath, baseURL);
        }
    }

    @Override
    public boolean canParseResource(HttpMessage message, String path, boolean wasAlreadyParsed) {
        return "/robots.txt".equalsIgnoreCase(path);
    }
}

