This module just imports the context from a C file, since ghc falls down on
even moderately large string literals.  I mostly decided to make it a
literate file just to avoid conflicting with the previously autogenerated
``Context.hs''.  Lazy me.  It's copyright me (David Roundy) in the year
2004, and licensed under the GPL.

\begin{code}
{-# OPTIONS -fffi #-}
module Context ( context ) where

import Foreign.C.String ( peekCString, CString )
import System.IO.Unsafe ( unsafePerformIO )

foreign import ccall unsafe "c_context.h" context_string :: CString

context :: String
context = unsafePerformIO $ peekCString context_string
\end{code}
