#!/usr/bin/perl
#
# $Id: nuke-all.pl,v 1.2 2001/09/04 11:36:10 chris Exp $
#
# Drop all tables in the database so you can restart your logs
#
# looks for config file, ftpstats.ini in the current directory
#
# ----------------------------------------------------------------------------
# "THE BEER-WARE LICENSE" (Revision 43):
# <chris@shagged.org> & <freaky@aagh.net> wrote this file.  As long as you
# retain this notice you can do whatever you want with this stuff. If we 
# meet some day, and you think this stuff is worth it, you can buy us a
# beer in return. Chris Elsworth & Thomas Hurst
# ----------------------------------------------------------------------------


use DBI;

use diagnostics;

# Default config values {{{
%conf = (       'logfile' => 'xferlog',
                'db_name' => 'ftpstats',
                'db_host' => '127.0.0.1',
                'db_user' => 'ftpstats',
                'db_pass' => 'ftpstats'); # }}}
        
%conf = &parse_conf(); # read in config

$db_conn = DBI->connect( "DBI:mysql:$conf{'db_name'}:$conf{'db_host'}",
	$conf{'db_user'}, $conf{'db_pass'})
	or die ("Can't connect to MySQL server: $DBI::errstr\n");

@existing_tables = $db_conn->tables;

foreach $table (@existing_tables)
{
	$query = "DROP TABLE $table";
	&doQuery($query);

	print $table . " dropped\n";
}

exit 0;

sub doQuery # Do a MySQL query {{{
{
        my ($query, $callref) = @_;

        my $result = $db_conn->prepare($query) or
         error("Unable to prepare query:\n$query\n$DBI::errstr\n$callref");

        $result->execute or
         error("Unable to execute query:\n$query\n$DBI::errstr\n$callref");
                        
        return $result;
} # }}}                         

sub parse_conf # Parse .ini file {{{
{
        local *FILE;
        my $conf;
        open(FILE, "ftpstats.ini") or die "Can't open config";
                while(<FILE>) {
                        chomp($_);
                        if ($_ =~ m/^(.+)\s+=\s+(.+)$/) {
                                $conf{"$1"} = $2;
                        }
                }
        close(FILE);
        return(%conf);

} # }}}

