<?php
/*
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 43):
 * <chris@shagged.org> & <freaky@aagh.net> wrote this file.  As long as you
 * retain this notice you can do whatever you want with this stuff. If we 
 * meet some day, and you think this stuff is worth it, you can buy us a
 * beer in return. Chris Elsworth & Thomas Hurst
 * ----------------------------------------------------------------------------
 */


require 'lib/common.php';
if ($direction=="down") $direction = "Dn";
if ($direction=="up") $direction = "Up";

if ($HTTP_POST_VARS['daterange'])
{
	foreach ($HTTP_GET_VARS AS $key => $value)
	{
		if (($key != "from") && ($key != "to"))
			$args[] = "$key=$value";
	}

	$from = mktime( $HTTP_POST_VARS['f-hour'],
	$HTTP_POST_VARS['f-min'], 00, $HTTP_POST_VARS['f-month'],
	$HTTP_POST_VARS['f-day'], $HTTP_POST_VARS['f-year']);

	$to = mktime( $HTTP_POST_VARS['t-hour'],
	$HTTP_POST_VARS['t-min'], 59, $HTTP_POST_VARS['t-month'],
	$HTTP_POST_VARS['t-day'], $HTTP_POST_VARS['t-year']);

	$args = array();
	$args[] = "from=$from";
	$args[] = "to=$to";

	$url = "Location: http://" . $HTTP_SERVER_VARS['HTTP_HOST'];
	$url .= fs_URL($args);
	header($url);
}

if ($HTTP_POST_VARS['userinfo']) // we've got a custom query
{
	$url = "Location: http://" . $HTTP_SERVER_VARS['HTTP_HOST'];
	$args = array();
	if ($HTTP_POST_VARS['radiobutton'] == "users")
	{
		switch ($HTTP_POST_VARS['users_xferdirn']) {
			case "downloaded": $dirn = "D"; break;
			case "uploaded"; $dirn = "U"; break;
		}
		$sort = ($HTTP_POST_VARS['users_sortdirn'] == "the most" ? "R" : "");

		switch ($HTTP_POST_VARS['users_files']) {
			case "bytes": $dirn = ($dirn=="D" ? "DBytes" : "UBytes"); $args[]="sort=$dirn$sort"; break;	
			case "files": $dirn = ($dirn=="D" ? "Down" : "Up"); $args[]="sort=$dirn$sort"; break;

		}
		$url .= fs_URL($args, "", "");
		header($url);
	}
	elseif ($HTTP_POST_VARS['radiobutton'] == "other")
	{
		$args[]="xferlist=y";

		switch ($HTTP_POST_VARS['dirn']) {
			case "transfers": break;
			case "downloads": $args[]="dirn=Dn"; break;
			case "uploads": $args[]="dirn=Up"; break;

		}
		switch ($HTTP_POST_VARS['sort_option']) {
			case "biggest": $args[]="sort=SizeR"; break;
			case "smallest": $args[]="sort=Size"; break;
			case "most recent": $args[]="sort=TimeR"; break;
			case "oldest": $args[]="sort=Time"; break;
			case "fastest": $args[]="sort=SpeedR"; break;
			case "slowest": $args[]="sort=Speed"; break;
		}
		$url .= fs_URL($args, "", "");
		header($url);
	}
	elseif ($HTTP_POST_VARS['radiobutton'] == "user")
	{
		$user = $HTTP_POST_VARS['user_sel'];
		$args[] = "showuser=$user";
		$url .= fs_URL($args);
		header($url);
	}
	elseif ($HTTP_POST_VARS['radiobutton'] == "file")
	{
		$pattern = $HTTP_POST_VARS['file_pattern'];

	}
	else
	{
		$url .= dirname($PHP_SELF);
		header($url);
	}

}

if ($HTTP_POST_VARS['jump_xfer']) // Jump to specific xfer was pressed
	$first = $HTTP_POST_VARS['first'];

if ($HTTP_POST_VARS['jump_user']) // Jump to specific user was pressed
{
	$first = $HTTP_POST_VARS['first'];
	$last = $first + 15;
}

$timer = new Timer;
$timer->start();

$for = _("for");

if ($showuser) // specific User Info screen
{
	$user = $showuser;
	$who_for = ($user ? $user : _("all users"));
	$who_for .= show_from_to($from, $to);

	fs_Header(_("User Information"), _("Specific information") .  " $for $who_for");
	fs_UserInfo($user, $from, $to);
	print "<BR><HR><BR>";
	fs_DayDistribution($direction, $user, $from, $to);
	print "<BR>";
	fs_HourDistribution($direction, $user, $from, $to);
	print "<BR><HR><BR>";
	fs_IpUserSummary($user, $ip, $sort, $from, $to, $first, $last, 15);

	print "<BR><HR><BR>";
	fs_XferList($ip, $dirn, $file, $limit, $sort, $user, $from, $to, $first, $last, 15);

}
elseif ($file)
{
	$who_for = show_from_to($from, $to);
	fs_Header(_("File Information"), $who_for);

	fs_FileInfo($file);
	print "<BR>";
	fs_XferList($ip, $dirn, $file, $limit, $sort, $user, $from, $to, $first, $last, 15);
}
elseif ($monthly) // monthly breakdown
{
	// if list then show a table containing all the months (in the range)
	// if a specific month, show the table entry for that month then pretty graphs

	if ($monthly == "thismonth")
	{
		$from = strtotime(date("Y-m-1 00:00:00", time()));
		$to = strtotime(date("Y-m-t 23:59:59",  time()));
		$who_for .= show_from_to($from, $to);
		fs_Header(_("Monthly Breakdown List"), _("Monthly Breakdown") ." " . $who_for);
		fs_MonthDistributionTable($limit, $sort, $user, $from, $to, $first, $last);
		print "<BR>";
		fs_DayDistribution($direction, $user, $from, $to);

	}
	elseif ($monthly == "list")
	{
		$who_for .= show_from_to($from, $to);
		fs_Header(_("Monthly Breakdown List"), _("Monthly Breakdown") . " " . $who_for);
		fs_MonthDistributionTable($limit, $sort, $user, $from, $to, $first, $last);
		print "<BR>";
		fs_MonthDistributionGraph($from, $to);

	}

}
elseif ($serverstats) // server statistics
{
	$who_for = ($user ? $user : _("all users"));
	$who_for .= show_from_to($from, $to);
	fs_Header(_("Server Statistics"), _("Summary") . " $for $who_for");
	fs_UserInfo($foo, $from, $to);
	print "<BR>";
	fs_DayDistribution($direction, $user, $from, $to);
	print "<BR>";
	fs_HourDistribution($direction, $user, $from, $to);
	
}
elseif ($xferlist) // all-user xferlist
{
	$who_for = ($user ? $user : _("all users"));
	$who_for .= show_from_to($from, $to);

	fs_Header(_("Transfer List"), _("Transfer List") . " $for $who_for");
	fs_XferList($ip, $dirn, $file, $limit, $sort, $user, $from, $to, $first, $last, 15);

}
elseif ($ip_summ) // IP Summary
{
	$who_for = ($user ? $user : _("all users"));
	$who_for .= show_from_to($from, $to);
	fs_Header(_("IP Information"), _("IP Summary") . " $for $who_for");
	fs_IpUserSummary($user, $ip, $sort, $from, $to, $first, $last, 15);
}
elseif ($ip) // show information on a specific IP
{
	$who_for = $ip;
	$who_for .= show_from_to($from, $to);
	fs_Header(_("IP Information"), _("IP Usage") . " $for $who_for");
	fs_IpSummary($user, $ip, $from, $to);
	print "<BR>";
	fs_XferList($ip, $dirn, $file, $limit, $sort, $user, $from, $to, $first, $last, 15);

}
else // userlist - default screen
{
	$who_for = ($user ? $user : _("all users"));
	$who_for .= show_from_to($from, $to);

	fs_Header(_("Server Information"), _("Userlist") . " $for $who_for");
	fs_UserList($sort, $from, $to, $first, $last, 15);
}

print "<BR>";
$timer->stop();
query_took_seconds($timer->getElapsed());

fs_DateForm();

fs_Footer();
?>
</body>
</html>
