#ifndef __QTC_H__
#define __QTC_H__ 1

#include <config.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <sys/types.h>
#ifdef HAVE_ERR_H
# include <err.h>
#endif
#ifdef HAVE_POLL_H
# include <poll.h>
#endif
#include <sys/stat.h>
#include <sys/socket.h>
#ifdef HAVE_NETDB_H
# include <netdb.h>
#endif
#include <pthread.h>
#include <pcre.h>

#define MAX_LISTENING_SOCKETS 16
#define DEFAULT_BACKLOG 64
#define DEFAULT_PORT "7777"
#define LISTENER_TIMEOUT 60

#define CRLF "\r\n"
#define HTTP_READ_BUFFER_SIZE 65536U
#define HTTP_MAX_CLIENT_DATA_SIZE 100000U
#define HTTP_MAX_CLIENT_HEADER_SIZE 1000U
#define HTTP_CLIENT_DATA_GAP_SIZE 1U
#define HTTP_HEADER_BODY_SEP CRLF CRLF
#define HTTP_CONTENT_LENGTH_HEADER "Content-Length:"
#define HTTP_REPLY_HEADER \
    "HTTP/1.0 201 Processed" CRLF \
        "Connection: close" CRLF \
        "Content-Type: application/qtc" CRLF \
        "Server: " PACKAGE_STRING CRLF \
        CRLF
#define HTTP_ERROR_EXTRA_HEADER \
    "Connection: close" CRLF \
        CRLF
#define HTTP_ERROR_UNAVAILABLE "HTTP/1.0 503 Unavailable" CRLF \
    HTTP_ERROR_EXTRA_HEADER
#define HTTP_ERROR_TOO_LARGE "HTTP/1.0 413 Too large" CRLF \
    HTTP_ERROR_EXTRA_HEADER
#define HTTP_ERROR_LENGTH_REQUIRED "HTTP/1.0 411 Length required" CRLF \
    HTTP_ERROR_EXTRA_HEADER
#define HTTP_ERROR_BAD_REQUEST "HTTP/1.0 400 Bad request" CRLF \
    HTTP_ERROR_EXTRA_HEADER
#define HTTP_ERROR_PRECONDITION_FAILED "HTTP/1.0 412 Precondition failed" CRLF \
    HTTP_ERROR_EXTRA_HEADER

#define _(X) X
#define ARRAY_SIZE(A) ((sizeof A) / (sizeof A[0]))

typedef struct Client_ {
    struct Client_ *next;
    pthread_t thread;
    int socket;
} Client;

typedef struct ClientsSharedData_ {
    int listening_sockets[MAX_LISTENING_SOCKETS];
    struct pollfd pfds[MAX_LISTENING_SOCKETS];
    unsigned int nb_listening_sockets;
    Client *first_client;
    pthread_mutex_t mutex_clients_list;
} ClientsSharedData;

typedef struct ClientThreadData_ {
    ClientsSharedData *csd;
    Client *client;
} ClientThreadData;

#endif
