/*
  File autogenerated by gengetopt version 2.8.1
  generated with the following command:
  ../src/gengetopt --input=sample2.ggo --func-name=my_cmdline_parser --file-name=cmdline2 --unamed-opts --no-handle-help --no-handle-version 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
/* Check for configure's getopt check result.  */
#ifndef HAVE_GETOPT_LONG
#include "getopt.h"
#else
#include <getopt.h>
#endif

#ifndef HAVE_STRDUP
#define strdup gengetopt_strdup
#endif /* HAVE_STRDUP */

#include "cmdline2.h"


void
my_cmdline_parser_print_version (void)
{
  printf ("%s %s\n", PACKAGE, VERSION);
}

void
my_cmdline_parser_print_help (void)
{
  my_cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  this is just a test program for gengetopt\n"
  "\n"
  "Usage: %s [OPTIONS]... [FILES]...\n", PACKAGE);
  printf("   -h             --help                        Print help and exit\n");
  printf("   -V             --version                     Print version and exit\n");
  printf("   -sSTRING       --str-opt=STRING              A string option\n");
  printf("   -iINT          --int-opt=INT                 A int option\n");
  printf("   -SSHORT        --short-opt=SHORT             A short option\n");
  printf("   -lLONG         --long-opt=LONG               A long option\n");
  printf("   -fFLOAT        --float-opt=FLOAT             A float option\n");
  printf("   -dDOUBLE       --double-opt=DOUBLE           A double option\n");
  printf("   -LLONGDOUBLE   --long-double-opt=LONGDOUBLE  A long double option\n");
  printf("   -yLONGLONG     --long-long-opt=LONGLONG      A long long option\n");
  printf("   -F             --func-opt                    A function option\n");
  printf("   -x             --flag-opt                    A flag option (default=off)\n");
}


#ifndef HAVE_STRDUP
/* gengetopt_strdup(): automatically generated from strdup.c. */
/* strdup.c replacement of strdup, which is not standard */
static char *
gengetopt_strdup (const char *s)
{
  char *result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}
#endif /* HAVE_STRDUP */

int
my_cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->str_opt_given = 0 ;
  args_info->int_opt_given = 0 ;
  args_info->short_opt_given = 0 ;
  args_info->long_opt_given = 0 ;
  args_info->float_opt_given = 0 ;
  args_info->double_opt_given = 0 ;
  args_info->long_double_opt_given = 0 ;
  args_info->long_long_opt_given = 0 ;
  args_info->func_opt_given = 0 ;
  args_info->flag_opt_given = 0 ;
#define clear_args() { \
  args_info->str_opt_arg = NULL; \
  args_info->flag_opt_flag = 0;\
}

  clear_args();

  args_info->inputs = NULL;
  args_info->inputs_num = 0;

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;
      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "str-opt",	1, NULL, 's' },
        { "int-opt",	1, NULL, 'i' },
        { "short-opt",	1, NULL, 'S' },
        { "long-opt",	1, NULL, 'l' },
        { "float-opt",	1, NULL, 'f' },
        { "double-opt",	1, NULL, 'd' },
        { "long-double-opt",	1, NULL, 'L' },
        { "long-long-opt",	1, NULL, 'y' },
        { "func-opt",	0, NULL, 'F' },
        { "flag-opt",	0, NULL, 'x' },
        { NULL,	0, NULL, 0 }
      };

      c = getopt_long (argc, argv, "hVs:i:S:l:f:d:L:y:Fx", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          if (args_info->help_given)
            {
              fprintf (stderr, "%s: `--help' (`-h') option given more than once\n", PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->help_given = 1;
          return 0;

        case 'V':	/* Print version and exit.  */
          if (args_info->version_given)
            {
              fprintf (stderr, "%s: `--version' (`-V') option given more than once\n", PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->version_given = 1;
          return 0;

        case 's':	/* A string option.  */
          if (args_info->str_opt_given)
            {
              fprintf (stderr, "%s: `--str-opt' (`-s') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->str_opt_given = 1;
          args_info->str_opt_arg = strdup (optarg);
          break;

        case 'i':	/* A int option.  */
          if (args_info->int_opt_given)
            {
              fprintf (stderr, "%s: `--int-opt' (`-i') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->int_opt_given = 1;
          args_info->int_opt_arg = strtol (optarg,&stop_char,0);
          break;

        case 'S':	/* A short option.  */
          if (args_info->short_opt_given)
            {
              fprintf (stderr, "%s: `--short-opt' (`-S') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->short_opt_given = 1;
          args_info->short_opt_arg = (short)strtol (optarg,&stop_char,0);
          break;

        case 'l':	/* A long option.  */
          if (args_info->long_opt_given)
            {
              fprintf (stderr, "%s: `--long-opt' (`-l') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->long_opt_given = 1;
          args_info->long_opt_arg = strtol (optarg,&stop_char,0);
          break;

        case 'f':	/* A float option.  */
          if (args_info->float_opt_given)
            {
              fprintf (stderr, "%s: `--float-opt' (`-f') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->float_opt_given = 1;
          args_info->float_opt_arg = (float)strtod (optarg, NULL);
          break;

        case 'd':	/* A double option.  */
          if (args_info->double_opt_given)
            {
              fprintf (stderr, "%s: `--double-opt' (`-d') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->double_opt_given = 1;
          args_info->double_opt_arg = strtod (optarg, NULL);
          break;

        case 'L':	/* A long double option.  */
          if (args_info->long_double_opt_given)
            {
              fprintf (stderr, "%s: `--long-double-opt' (`-L') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->long_double_opt_given = 1;
          args_info->long_double_opt_arg = (long double)strtod (optarg, NULL);
          break;

        case 'y':	/* A long long option.  */
          if (args_info->long_long_opt_given)
            {
              fprintf (stderr, "%s: `--long-long-opt' (`-y') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->long_long_opt_given = 1;
          args_info->long_long_opt_arg = (long long)strtol (optarg,&stop_char,0);
          break;

        case 'F':	/* A function option.  */
          if (args_info->func_opt_given)
            {
              fprintf (stderr, "%s: `--func-opt' (`-F') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->func_opt_given = 1;
          break;

        case 'x':	/* A flag option.  */
          if (args_info->flag_opt_given)
            {
              fprintf (stderr, "%s: `--flag-opt' (`-x') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->flag_opt_given = 1;
          args_info->flag_opt_flag = !(args_info->flag_opt_flag);
          break;


        case 0:	/* Long option with no short option */

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */


  if (! args_info->int_opt_given)
    {
      fprintf (stderr, "%s: '--int-opt' ('-i') option required\n", PACKAGE);
      missing_required_options = 1;
    }
  if (! args_info->long_opt_given)
    {
      fprintf (stderr, "%s: '--long-opt' ('-l') option required\n", PACKAGE);
      missing_required_options = 1;
    }
  if ( missing_required_options )
    exit (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
  
      args_info->inputs_num = argc - optind ;
      args_info->inputs = 
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = strdup (argv[optind++]) ; 
    }
  
  return 0;
}
