/*
 * defs.h - Definitions for the curses helper library.
 *
 * Copyright (C) 2001  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef	_PNETCURSES_HELP_DEFS_H
#define	_PNETCURSES_HELP_DEFS_H

#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <ncurses.h>
#include <termios.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <errno.h>

#ifdef	__cplusplus
extern	"C" {
#endif

/*
 * Helper macros for dealing with Windows dll issues.
 */
#ifdef	_WIN32
#ifdef	DLL_EXPORT
#error "hello"
#define	CURSES_DLL_EXPORT(type)	__declspec(dllexport) type __cdecl
#else
#define	CURSES_DLL_EXPORT(type)	type
#endif
#else
#define	CURSES_DLL_EXPORT(type)	type
#endif

/*
 * Define a 64-bit integer type.
 */
#if defined(WIN32) && !defined(__CYGWIN__)
typedef	__int64 	CursesHelpInt64;
#else
typedef	long long 	CursesHelpInt64;
#endif

/*
 * A flag that is set whenever an interrupt or terminate
 * signal is received, so that the terminate request can
 * be reported to the application.
 */
extern volatile CURSES_DLL_EXPORT(int) CursesHelpSawInterrupt;

/*
 * A flag that is set whenever a window size change occurs,
 * so that the request can be reported to the application.
 */
extern volatile CURSES_DLL_EXPORT(int) CursesHelpSawSizeChange;

/*
 * Initialize curses.  Returns non-zero if OK.
 */
extern CURSES_DLL_EXPORT(int) CursesHelpInitialize(void);

/*
 * Terminate curses.
 */
extern CURSES_DLL_EXPORT(void) CursesHelpTerminate(void);

/*
 * Get the next character from the input stream,
 * returning to the caller after a specified timeout.
 * The "timeToFire" value is measured in tenths of
 * a microsecond since Jan 1, 0001, or is -1 to
 * indicate no timeout.
 */
extern CURSES_DLL_EXPORT(int) CursesHelpGetNextChar(CursesHelpInt64 timeToFire);

/*
 * Get the number of lines on the screen.
 */
extern CURSES_DLL_EXPORT(int) CursesHelpGetLines(void);

/*
 * Get the number of columns on the screen.
 */
extern CURSES_DLL_EXPORT(int) CursesHelpGetCols(void);

/*
 * Get the standard screen pointer.
 */
extern CURSES_DLL_EXPORT(void *) CursesHelpGetStdScr(void);

/*
 * Get the number of color pairs that are supported by the terminal.
 */
extern CURSES_DLL_EXPORT(int) CursesHelpGetColorPairs(void);

/*
 * Get the X co-ordinate of the upper-left corner of a specific window.
 */
extern CURSES_DLL_EXPORT(int) CursesHelpGetX(void *window);

/*
 * Get the Y co-ordinate of the upper-left corner of a specific window.
 */
extern CURSES_DLL_EXPORT(int) CursesHelpGetY(void *window);

/*
 * Get the width of a specific window.
 */
extern CURSES_DLL_EXPORT(int) CursesHelpGetWidth(void *window);

/*
 * Get the height of a specific window.
 */
extern CURSES_DLL_EXPORT(int) CursesHelpGetHeight(void *window);

/*
 * Add a line drawing character at the current position within a window.
 */
extern CURSES_DLL_EXPORT(void) CursesHelpAddLineChar(void *window, int ch);

#ifdef	__cplusplus
};
#endif

#endif	/* _PNETCURSES_HELP_DEFS_H */
