/*
 * Form.cs - Implementation of the
 *			"System.Windows.Forms.Form" class.
 *
 * Copyright (C) 2003  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace System.Windows.Forms
{

using System.Drawing;
using System.Drawing.Toolkit;
using System.ComponentModel;

public class Form : ContainerControl
{
	// Internal state.
	private IButtonControl acceptButton;
	private IButtonControl cancelButton;
	private bool autoScale;
	private bool isMdiChild;
	private bool isMdiContainer;
	private bool keyPreview;
	private bool topLevel;
	private Size autoScaleBaseSize;
	private DialogResult dialogResult;
	private FormBorderStyle borderStyle;
	private Icon icon;
	private ToolkitWindowFlags windowFlags;
	private Size maximumSize;
	private Size minimumSize;
	private Form[] mdiChildren;
	private Form[] ownedForms;
	private Form mdiParent;
	private Form owner;
	private MainMenu menu;
	private MainMenu mergedMenu;
	private double opacity;
	private SizeGripStyle sizeGripStyle;
	private FormStartPosition formStartPosition;
	private Color transparencyKey;
	private FormWindowState windowState;
	internal static Form activeForm;
	private bool showInTaskbar;
	private bool controlBox;
	
	// Constructor.
	public Form()
			{
				visible = false;
				autoScale = true;
				topLevel = true;
				borderStyle = FormBorderStyle.Sizable;
				mdiChildren = new Form [0];
				ownedForms = new Form [0];
				opacity = 1.0;
				windowFlags = ToolkitWindowFlags.Default;
				formStartPosition = FormStartPosition.WindowsDefaultLocation;
				windowState = FormWindowState.Normal;
			}

	// Get or set this control's properties.
	public IButtonControl AcceptButton
			{
				get
				{
					return acceptButton;
				}
				set
				{
					acceptButton = value;
				}
			}
	public static Form ActiveForm
			{
				get
				{
					return activeForm;
				}
			}
	[TODO]
	public Form ActiveMdiChild
			{
				get
				{
					// TODO
					return null;
				}
			}
	public bool AutoScale
			{
				get
				{
					return autoScale;
				}
				set
				{
					autoScale = value;
				}
			}
	public Size AutoScaleBaseSize
			{
				get
				{
					return autoScaleBaseSize;
				}
				set
				{
					autoScaleBaseSize = value;
				}
			}
	public override bool AutoScroll
			{
				get
				{
					return base.AutoScroll;
				}
				set
				{
					base.AutoScroll = value;
				}
			}
	public override Color BackColor
			{
				get
				{
					// The base implementation takes care of the default.
					return base.BackColor;
				}
				set
				{
					base.BackColor = value;
				}
			}
	public IButtonControl CancelButton
			{
				get
				{
					return cancelButton;
				}
				set
				{
					cancelButton = value;
				}
			}
	protected override CreateParams CreateParams
			{
				get
				{
					return base.CreateParams;
				}
			}
	protected override ImeMode DefaultImeMode
			{
				get
				{
					return ImeMode.NoControl;
				}
			}
	protected override Size DefaultSize
			{
				get
				{
					return new Size(300, 300);
				}
			}
	public Rectangle DesktopBounds
			{
				get
				{
					// Use the ordinary bounds.
					return Bounds;
				}
				set
				{
					Bounds = value;
				}
			}
	public Point DesktopLocation
			{
				get
				{
					// Use the ordinary location.
					return Location;
				}
				set
				{
					Location = value;
				}
			}
	public DialogResult DialogResult
			{
				get
				{
					return dialogResult;
				}
				set
				{
					dialogResult = value;
				}
			}
	public FormBorderStyle FormBorderStyle
			{
				get
				{
					return borderStyle;
				}
				set
				{
					if(borderStyle != value)
					{
						borderStyle = value;
						SetWindowFlag(0, true);
					}
				}
			}
	public bool HelpButton
			{
				get
				{
					return GetWindowFlag(ToolkitWindowFlags.Help);
				}
				set
				{
					SetWindowFlag(ToolkitWindowFlags.Help, value);
				}
			}
	[TODO]
	public Icon Icon
			{
				get
				{
					return icon;
				}
				set
				{
					// TODO: send the icon to the window manager.
					icon = value;
				}
			}
	public bool IsMdiChild
			{
				get
				{
					return isMdiChild;
				}
			}
	[TODO]
	public bool IsMdiContainer
			{
				get
				{
					return isMdiContainer;
				}
				set
				{
					// TODO: switch the form into MDI mode
					isMdiContainer = value;
				}
			}
	public bool KeyPreview
			{
				get
				{
					return keyPreview;
				}
				set
				{
					keyPreview = value;
				}
			}
	public bool MaximizeBox
			{
				get
				{
					return GetWindowFlag(ToolkitWindowFlags.Maximize);
				}
				set
				{
					SetWindowFlag(ToolkitWindowFlags.Maximize, value);
				}
			}
	[TODO]
	protected Rectangle MaximizedBounds
			{
				get
				{
					// TODO
					return Rectangle.Empty;
				}
				set
				{
					// TODO
				}
			}
	[TODO]
	public Size MaximumSize
			{
				get
				{
					return maximumSize;
				}
				set
				{
					// TODO: send the maximum size to the window manager.
					if(value.Width < 0)
					{
						throw new ArgumentOutOfRangeException
							("value.Width", S._("SWF_NonNegative"));
					}
					if(value.Height < 0)
					{
						throw new ArgumentOutOfRangeException
							("value.Height", S._("SWF_NonNegative"));
					}
					maximumSize = value;
				}
			}
	public Form[] MdiChildren
			{
				get
				{
					return mdiChildren;
				}
			}
	[TODO]
	public Form MdiParent
			{
				get
				{
					return mdiParent;
				}
				set
				{
					// TODO: validate the parent
					mdiParent = value;
				}
			}
	public bool MinimizeBox
			{
				get
				{
					return GetWindowFlag(ToolkitWindowFlags.Minimize);
				}
				set
				{
					SetWindowFlag(ToolkitWindowFlags.Minimize, value);
				}
			}
	[TODO]
	public Size MinimumSize
			{
				get
				{
					return minimumSize;
				}
				set
				{
					// TODO: send the minimum size to the window manager.
					if(value.Width < 0)
					{
						throw new ArgumentOutOfRangeException
							("value.Width", S._("SWF_NonNegative"));
					}
					if(value.Height < 0)
					{
						throw new ArgumentOutOfRangeException
							("value.Height", S._("SWF_NonNegative"));
					}
					minimumSize = value;
				}
			}
	public MainMenu Menu
			{
				get
				{
					return menu;
				}
				set
				{
					if(menu != value)
					{
						if(menu != null)
						{
							menu.RemoveFromForm();
							menu = null;
						}
						if(value != null)
						{
							Form other = value.GetForm();
							if(other != null)
							{
								other.Menu = null;
							}
						}
						// Get the ClientSize before we add the menu
						Size clientSize = ClientSize;
						menu = value;
						if(menu != null)
						{
							menu.AddToForm(this);
						}
						// The clientsize must be the same as the old one
						ClientSize = clientSize;
					}
				}
			}
	public MainMenu MergedMenu
			{
				get
				{
					return mergedMenu;
				}
			}
	public bool Modal
			{
				get
				{
					return GetWindowFlag(ToolkitWindowFlags.Modal);
				}
			}
	public double Opacity
			{
				get
				{
					return opacity;
				}
				set
				{
					// We don't support transparent windows,
					// so just save the value away for later.
					opacity = value;
				}
			}
	public Form[] OwnedForms
			{
				get
				{
					return ownedForms;
				}
			}
	[TODO]
	public Form Owner
			{
				get
				{
					return owner;
				}
				set
				{
					// TODO: update the owned child list
					owner = value;
				}
			}
	public bool ShowInTaskbar
			{
				get
				{
					return GetWindowFlag(ToolkitWindowFlags.ShowInTaskbar);
				}
				set
				{
					if (value != showInTaskbar)
					{
						showInTaskbar = value;
						SetWindowFlag(ToolkitWindowFlags.ShowInTaskbar, value);
					}
				}
			}
	public new Size Size
			{
				get
				{
					return base.Size;
				}
				set
				{
					base.Size = value;
				}
			}
	public SizeGripStyle SizeGripStyle
			{
				get
				{
					return sizeGripStyle;
				}
				set
				{
					sizeGripStyle = value;
				}
			}
	public FormStartPosition StartPosition
			{
				get
				{
					return formStartPosition;
				}
				set
				{
					formStartPosition = value;
				}
			}
	public bool TopLevel
			{
				get
				{
					return topLevel;
				}
				set
				{
					topLevel = value;
				}
			}
	public bool TopMost
			{
				get
				{
					return GetWindowFlag(ToolkitWindowFlags.TopMost);
				}
				set
				{
					SetWindowFlag(ToolkitWindowFlags.TopMost, value);
				}
			}
	public Color TransparencyKey
			{
				get
				{
					return transparencyKey;
				}
				set
				{
					transparencyKey = value;
				}
			}
	[TODO]
	public FormWindowState WindowState
			{
				get
				{
					return windowState;
				}
				set
				{
					// TODO: pass the state change to the window manager
					windowState = value;
				}
			}

	// Create the toolkit window underlying this control.
	internal override IToolkitWindow CreateToolkitWindow(IToolkitWindow parent)
			{
				// TODO: dialog forms
				CreateParams cp = CreateParams;

				// Create the window and set its initial caption.
				IToolkitWindow window =
					ToolkitManager.Toolkit.CreateTopLevelWindow
						(cp.Width - ToolkitDrawSize.Width, cp.Height - ToolkitDrawSize.Height, this);
				window.SetTitle(cp.Caption);

				// Adjust the window decorations to match our requirements.
				SetWindowFlags(window);

				// Center the window on-screen if necessary.
				if(formStartPosition == FormStartPosition.CenterScreen)
				{
					Size screenSize = ToolkitManager.Toolkit.GetScreenSize();
					window.MoveResize
							((screenSize.Width - cp.Width) / 2,
							 (screenSize.Height - cp.Height) / 2,
							 cp.Width, cp.Height);
				}
				return window;
			}

	// Determine if this is a top-level control which cannot have parents.
	internal override bool IsTopLevel
			{
				get
				{
					return true;
				}
			}

	// Get the current state of a window decoration flag.
	private bool GetWindowFlag(ToolkitWindowFlags flag)
			{
				return ((windowFlags & flag) == flag);
			}

	// Get the full set of window flags for this window.
	private ToolkitWindowFlags GetFullFlags()
			{
				ToolkitWindowFlags flags = windowFlags;
				switch(borderStyle)
				{
					case FormBorderStyle.None:
					{
						flags &= ~(ToolkitWindowFlags.Maximize |
								   ToolkitWindowFlags.ResizeHandles |
								   ToolkitWindowFlags.Resize |
								   ToolkitWindowFlags.Border);
					}
					break;

					case FormBorderStyle.Fixed3D:
					case FormBorderStyle.FixedDialog:
					case FormBorderStyle.FixedSingle:
					{
						flags &= ~(ToolkitWindowFlags.Maximize |
								   ToolkitWindowFlags.ResizeHandles |
								   ToolkitWindowFlags.Resize);
					}
					break;

					case FormBorderStyle.FixedToolWindow:
					{
						flags &= ~(ToolkitWindowFlags.Maximize |
								   ToolkitWindowFlags.ResizeHandles |
								   ToolkitWindowFlags.Resize |
								   ToolkitWindowFlags.ShowInTaskbar);
						flags |= ToolkitWindowFlags.ToolWindow;
					}
					break;

					case FormBorderStyle.Sizable: break;

					case FormBorderStyle.SizableToolWindow:
					{
						flags &= ~(ToolkitWindowFlags.ShowInTaskbar);
						flags |= ToolkitWindowFlags.ToolWindow;
					}
					break;
				}
				return flags;
			}

	// Set the current state of the window decoration flags on a window.
	private void SetWindowFlags(IToolkitWindow window)
			{
				window.SetWindowFlags(GetFullFlags());
			}

	// Set the current state of a window decoration flag.
	private void SetWindowFlag(ToolkitWindowFlags flag, bool value)
			{
				// Alter the flag setting.
				if(value)
				{
					windowFlags |= flag;
				}
				else
				{
					windowFlags &= ~flag;
				}

				// Pass the flags to the window manager.
				if(toolkitWindow != null)
				{
					SetWindowFlags(toolkitWindow);
				}
			}

	// Activate the form and give it focus.
	public void Activate()
			{
				BringToFront();
			}

	// Add an owned form to this form.
	public void AddOwnedForm(Form ownedForm)
			{
				if(ownedForm != null)
				{
					ownedForm.Owner = this;
				}
			}

	// Close this form.
	public void Close()
			{
				CloseRequest();
			}

	// Get the auto scale base size for a particular font.
	[TODO]
	public static SizeF GetAutoScaleSize(Font font)
			{
				// TODO
				return SizeF.Empty;
			}

	// Layout the MDI children of this form.
	[TODO]
	public void LayoutMdi(MdiLayout value)
			{
				// TODO
			}

	// Remove an owned form from this form.
	public void RemoveOwnedForm(Form ownedForm)
			{
				if(ownedForm != null && ownedForm.Owner == this)
				{
					ownedForm.Owner = null;
				}
			}

#if !CONFIG_COMPACT_FORMS

	// Set the desktop bounds of this form.
	public void SetDesktopBounds(int x, int y, int width, int height)
			{
				Rectangle workingArea = SystemInformation.WorkingArea;
				SetBoundsCore(workingArea.X + x, workingArea.Y + y,
							  width, height, BoundsSpecified.All);
			}

	// Set the desktop location of this form.
	public void SetDesktopLocation(int x, int y)
			{
				Rectangle workingArea = SystemInformation.WorkingArea;
				Location = new Point(workingArea.X + x, workingArea.Y + y);
			}

#endif // !CONFIG_COMPACT_FORMS

	// Show this form as a modal dialog.
	[TODO]
	private DialogResult ShowDialog(Form owner)
			{
				// TODO
				return DialogResult.None;
			}
	public DialogResult ShowDialog()
			{
				return ShowDialog(Owner);
			}
	public DialogResult ShowDialog(IWin32Window owner)
			{
				return ShowDialog(owner as Form);
			}

	// Convert this object into a string.
	public override String ToString()
			{
				return base.ToString() + ", Text: " + Text;
			}

	// Event that is emitted when this form is activated.
	public event EventHandler Activated
			{
				add
				{
					AddHandler(EventId.Activated, value);
				}
				remove
				{
					RemoveHandler(EventId.Activated, value);
				}
			}

	// Event that is emitted when this form is closed.
	public event EventHandler Closed
			{
				add
				{
					AddHandler(EventId.Closed, value);
				}
				remove
				{
					RemoveHandler(EventId.Closed, value);
				}
			}

	// Event that is emitted when this form is closing.
	public event CancelEventHandler Closing
			{
				add
				{
					AddHandler(EventId.Closing, value);
				}
				remove
				{
					RemoveHandler(EventId.Closing, value);
				}
			}

	// Event that is emitted when this form is deactivated.
	public event EventHandler Deactivate
			{
				add
				{
					AddHandler(EventId.Deactivate, value);
				}
				remove
				{
					RemoveHandler(EventId.Deactivate, value);
				}
			}

	// Event that is emitted when the input language of a form is changed.
	public event InputLanguageChangedEventHandler InputLanguageChanged
			{
				add
				{
					AddHandler(EventId.InputLanguageChanged, value);
				}
				remove
				{
					RemoveHandler(EventId.InputLanguageChanged, value);
				}
			}

	// Event that is emitted when the input language of a form is changing.
	public event InputLanguageChangingEventHandler InputLanguageChanging
			{
				add
				{
					AddHandler(EventId.InputLanguageChanging, value);
				}
				remove
				{
					RemoveHandler(EventId.InputLanguageChanging, value);
				}
			}

	// Event that is emitted when this form is first loaded.
	public event EventHandler Load
			{
				add
				{
					AddHandler(EventId.Load, value);
				}
				remove
				{
					RemoveHandler(EventId.Load, value);
				}
			}

	// Event that is emitted when the maximized bounds change.
	public event EventHandler MaximizedBoundsChanged
			{
				add
				{
					AddHandler(EventId.MaximizedBoundsChanged, value);
				}
				remove
				{
					RemoveHandler(EventId.MaximizedBoundsChanged, value);
				}
			}

	// Event that is emitted when the maximum size changes.
	public event EventHandler MaximumSizeChanged
			{
				add
				{
					AddHandler(EventId.MaximumSizeChanged, value);
				}
				remove
				{
					RemoveHandler(EventId.MaximumSizeChanged, value);
				}
			}

	// Event that is emitted when an MDI child is activated.
	public event EventHandler MdiChildActivate
			{
				add
				{
					AddHandler(EventId.MdiChildActivate, value);
				}
				remove
				{
					RemoveHandler(EventId.MdiChildActivate, value);
				}
			}

	// Event that is emitted at the end of processing a menu item.
	public event EventHandler MenuComplete
			{
				add
				{
					AddHandler(EventId.MenuComplete, value);
				}
				remove
				{
					RemoveHandler(EventId.MenuComplete, value);
				}
			}

	// Event that is emitted at the start of processing a menu item.
	public event EventHandler MenuStart
			{
				add
				{
					AddHandler(EventId.MenuStart, value);
				}
				remove
				{
					RemoveHandler(EventId.MenuStart, value);
				}
			}

	// Event that is emitted when the minimum size changes.
	public event EventHandler MinimumSizeChanged
			{
				add
				{
					AddHandler(EventId.MinimumSizeChanged, value);
				}
				remove
				{
					RemoveHandler(EventId.MinimumSizeChanged, value);
				}
			}

	// Create a new control collection for this instance.
	protected override Control.ControlCollection CreateControlsInstance()
			{
				return new ControlCollection(this);
			}

	// Create the handle for this control.
	protected override void CreateHandle()
			{
				// Let the base class do the work.
				base.CreateHandle();
			}

	// Dispose of this control.
	protected override void Dispose(bool disposing)
			{
				base.Dispose(disposing);
			}

	// Emit the "Activated" event.
	protected virtual void OnActivated(EventArgs e)
			{
				// This form is currently the active one.
				activeForm = this;

				// Dispatch the event to everyone who is listening.
				EventHandler handler;
				handler = (EventHandler)(GetHandler(EventId.Activated));
				if(handler != null)
				{
					handler(this, e);
				}
			}

	// Emit the "Closed" event.
	protected virtual void OnClosed(EventArgs e)
			{
				EventHandler handler;
				handler = (EventHandler)(GetHandler(EventId.Closed));
				if(handler != null)
				{
					handler(this, e);
				}
			}

	// Emit the "Closing" event.
	protected virtual void OnClosing(CancelEventArgs e)
			{
				CancelEventHandler handler;
				handler = (CancelEventHandler)(GetHandler(EventId.Closing));
				if(handler != null)
				{
					handler(this, e);
				}
			}

	// Handle initial control creation.
	protected override void OnCreateControl()
			{
				base.OnCreateControl();
				OnLoad(EventArgs.Empty);
			}

	// Emit the "Deactivate" event.
	protected virtual void OnDeactivate(EventArgs e)
			{
				// None of the application's forms are currently active.
				activeForm = null;

				// Dispatch the event to everyone who is listening.
				EventHandler handler;
				handler = (EventHandler)(GetHandler(EventId.Deactivate));
				if(handler != null)
				{
					handler(this, e);
				}
			}

	// Override the "FontChanged" event.
	protected override void OnFontChanged(EventArgs e)
			{
				base.OnFontChanged(e);
			}

	// Override the "HandleCreated" event.
	protected override void OnHandleCreated(EventArgs e)
			{
				base.OnHandleCreated(e);
			}

	// Override the "HandleDestroyed" event.
	protected override void OnHandleDestroyed(EventArgs e)
			{
				base.OnHandleDestroyed(e);
			}

	// Emit the "InputLanguageChanged" event.
	protected virtual void OnInputLanguageChanged
				(InputLanguageChangedEventArgs e)
			{
				InputLanguageChangedEventHandler handler;
				handler = (InputLanguageChangedEventHandler)
					(GetHandler(EventId.InputLanguageChanged));
				if(handler != null)
				{
					handler(this, e);
				}
			}

	// Emit the "InputLanguageChanging" event.
	protected virtual void OnInputLanguageChanging
				(InputLanguageChangingEventArgs e)
			{
				InputLanguageChangingEventHandler handler;
				handler = (InputLanguageChangingEventHandler)
					(GetHandler(EventId.InputLanguageChanging));
				if(handler != null)
				{
					handler(this, e);
				}
			}

	// Emit the "Load" event.
	protected virtual void OnLoad(EventArgs e)
			{
				EventHandler handler;
				handler = (EventHandler)(GetHandler(EventId.Load));
				if(handler != null)
				{
					handler(this, e);
				}
			}

	// Emit the "MaximizedBoundsChanged" event.
	protected virtual void OnMaximizedBoundsChanged(EventArgs e)
			{
				EventHandler handler;
				handler = (EventHandler)
					(GetHandler(EventId.MaximizedBoundsChanged));
				if(handler != null)
				{
					handler(this, e);
				}
			}

	// Emit the "MaximumSizeChanged" event.
	protected virtual void OnMaximumSizeChanged(EventArgs e)
			{
				EventHandler handler;
				handler = (EventHandler)
					(GetHandler(EventId.MaximumSizeChanged));
				if(handler != null)
				{
					handler(this, e);
				}
			}

	// Emit the "MdiChildActivate" event.
	protected virtual void OnMdiChildActivate(EventArgs e)
			{
				EventHandler handler;
				handler = (EventHandler)(GetHandler(EventId.MdiChildActivate));
				if(handler != null)
				{
					handler(this, e);
				}
			}

	// Emit the "MenuComplete" event.
	protected virtual void OnMenuComplete(EventArgs e)
			{
				EventHandler handler;
				handler = (EventHandler)(GetHandler(EventId.MenuComplete));
				if(handler != null)
				{
					handler(this, e);
				}
			}

	// Emit the "MenuStart" event.
	protected virtual void OnMenuStart(EventArgs e)
			{
				EventHandler handler;
				handler = (EventHandler)(GetHandler(EventId.MenuStart));
				if(handler != null)
				{
					handler(this, e);
				}
			}

	// Emit the "MinimumSizeChanged" event.
	protected virtual void OnMinimumSizeChanged(EventArgs e)
			{
				EventHandler handler;
				handler = (EventHandler)
					(GetHandler(EventId.MinimumSizeChanged));
				if(handler != null)
				{
					handler(this, e);
				}
			}

	// Override the "Paint" event.
	protected override void OnPaint(PaintEventArgs e)
			{
				base.OnPaint(e);
				if (menu != null)
					menu.OnPaint();
			}

	// Override the "PrimaryEnter" event.
	internal override void OnPrimaryEnter(EventArgs e)
			{
				OnActivated(e);
			}

	// Override the "PrimaryLeave" event.
	internal override void OnPrimaryLeave(EventArgs e)
			{
				OnDeactivate(e);
			}

	// Override the "Resize" event.
	protected override void OnResize(EventArgs e)
			{
				base.OnResize(e);
			}

	// Override the "StyleChanged" event.
	protected override void OnStyleChanged(EventArgs e)
			{
				base.OnStyleChanged(e);
			}

	// Override the "TextChanged" event.
	protected override void OnTextChanged(EventArgs e)
			{
				if(toolkitWindow != null)
				{
					toolkitWindow.SetTitle(Text);
				}
				base.OnTextChanged(e);
			}

	// Override the "VisibleChanged" event.
	protected override void OnVisibleChanged(EventArgs e)
			{
				base.OnVisibleChanged(e);
			}

	// Process a command key.
	[TODO]
	protected override bool ProcessCmdKey(ref Message msg, Keys keyData)
			{
				// TODO
				return base.ProcessCmdKey(ref msg, keyData);
			}

	// Process a dialog key.
	[TODO]
	protected override bool ProcessDialogKey(Keys keyData)
			{
				// TODO
				return base.ProcessDialogKey(keyData);
			}

	// Preview a keyboard message.
	protected override bool ProcessKeyPreview(ref Message msg)
			{
				if(keyPreview)
				{
					// The form wants first crack at the key message.
					if(ProcessKeyEventArgs(ref msg))
					{
						return true;
					}
				}
				return base.ProcessKeyPreview(ref msg);
			}

	// Process the tab key.
	[TODO]
	protected override bool ProcessTabKey(bool forward)
			{
				// TODO
				return base.ProcessTabKey(forward);
			}

	// Inner core of "Scale".
	[TODO]
	protected override void ScaleCore(float dx, float dy)
			{
				// TODO
				base.ScaleCore(dx, dy);
			}

	// Select this control.
	[TODO]
	protected override void Select(bool directed, bool forward)
			{
				// TODO
				base.Select(directed, forward);
			}

	// Inner core of "SetBounds".
	protected override void SetBoundsCore
				(int x, int y, int width, int height,
				 BoundsSpecified specified)
			{
				base.SetBoundsCore(x, y, width, height, specified);
			}

	public override Point ClientOrigin
			{
				get 
				{
					if (menu != null)
						return ToolkitDrawOrigin + new Size(0, SystemInformation.MenuHeight);
					else
						return ToolkitDrawOrigin;
				}
			}

	protected override Point ToolkitDrawOrigin
			{
				get
				{
					int leftAdjust, topAdjust, rightAdjust, bottomAdjust;
					ToolkitManager.Toolkit.GetWindowAdjust
						(out leftAdjust, out topAdjust,
						out rightAdjust, out bottomAdjust, GetFullFlags());
					return new Point(leftAdjust, topAdjust);
				}
			}

	protected override Size ToolkitDrawSize
			{
				get
				{
					int leftAdjust, topAdjust, rightAdjust, bottomAdjust;
					ToolkitManager.Toolkit.GetWindowAdjust
						(out leftAdjust, out topAdjust,
						out rightAdjust, out bottomAdjust, GetFullFlags());
					return new Size(leftAdjust + rightAdjust, topAdjust + bottomAdjust);
				}
			}
	
	// Convert a client size into a window bounds size.
	internal override Size ClientToBounds(Size size)
			{
				int leftAdjust, topAdjust, rightAdjust, bottomAdjust;
				ToolkitManager.Toolkit.GetWindowAdjust
					(out leftAdjust, out topAdjust,
					out rightAdjust, out bottomAdjust, GetFullFlags());
				if (Menu != null)
					topAdjust += SystemInformation.MenuHeight;
				return new Size(size.Width + leftAdjust + rightAdjust,
					size.Height + topAdjust + bottomAdjust);
			}

	// Inner core of setting the visibility state.
	protected override void SetVisibleCore(bool value)
			{
				base.SetVisibleCore(value);
			}

	// Close request received from "Control.ToolkitClose".
	internal override void CloseRequest()
			{
				CancelEventArgs args = new CancelEventArgs();
				OnClosing(args);
				if(!(args.Cancel))
				{
					OnClosed(EventArgs.Empty);
					DestroyHandle();
				}
			}

	

#if !CONFIG_COMPACT_FORMS

	// Default window procedure for this control class.
	protected override void DefWndProc(ref Message msg)
			{
				base.DefWndProc(ref msg);
			}

	// Process a message.
	protected override void WndProc(ref Message m)
			{
				base.WndProc(ref m);
			}

#endif // !CONFIG_COMPACT_FORMS

	// Collection of child controls.
	public new class ControlCollection : Control.ControlCollection
	{
		// Internal state.
		private Form formOwner;

		// Constructor.
		public ControlCollection(Form owner) : base(owner)
				{
					this.formOwner = owner;
				}

		// Override the "Add" and "Remove" behavior.
		[TODO]
		public override void Add(Control control)
				{
					// TODO
					base.Add(control);
				}
		[TODO]
		public override void Remove(Control control)
				{
					// TODO
					base.Remove(control);
				}

	}; // class ControlCollection


	protected override void OnMouseDown(MouseEventArgs e)
			{
				// If the mouse is in the non client area,
				// it must be over the menu
				if (e.Y < 0 && menu != null)
					menu.OnMouseDown(e);
						
				base.OnMouseDown (e);
			}

	protected override void OnMouseLeave(EventArgs e)
			{
				// The menu needs to remove the highlighting
				if (menu != null)
					menu.OnMouseLeave();
				base.OnMouseLeave (e);
			}


	protected override void OnMouseMove(MouseEventArgs e)
			{
				// If the mouse is in the non client area,
				// it must be over the menu
				if (e.Y < 0 && menu != null)
					menu.OnMouseMove(e);
				base.OnMouseMove (e);
			}

	public bool ControlBox
			{
				get
				{
					return controlBox;
				}
				set
				{
					if (value != controlBox)
					{
						controlBox = value;
						//TODO
					}
				}
			}

}; // class Form

}; // namespace System.Windows.Forms
