#
# Copyright 2002-2009 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id:$

import win32ui
from pywin.mfc import window, dialog

PRINTDLGORD = 1538
PRINTER = 1139

class PrintDialog(dialog.Dialog):
  def __init__(self, dlgID=PRINTDLGORD, dllid=None):
    printSetupOnly = 0
    flags=(win32ui.PD_ALLPAGES|
              win32ui.PD_USEDEVMODECOPIES|
              win32ui.PD_NOPAGENUMS|
              win32ui.PD_HIDEPRINTTOFILE|
              win32ui.PD_NOSELECTION)

    parent=None
    dlg = win32ui.CreatePrintDialog(dlgID, printSetupOnly, flags, parent, dllid)
    window.Wnd.__init__(self, dlg)
    self.HookCommands()
    self.bHaveInit = None

  def OnOK(self):
    self._obj_.OnOK()
    self['deviceName'] = self.GetDlgItem(PRINTER).GetWindowText()
