# GNU Enterprise Reports
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: __init__.py 10140 2009-12-26 21:07:44Z reinhard $
"""
Report generator.
"""

from gnue.common.utils import version

try:
    import svnrev
    __svn_revision__ = svnrev.svnrev
except ImportError:
    __svn_revision__ = None

__version__ = version.Version(0, 2, 'final', 0, __svn_revision__)

PACKAGE = "GNUe-Reports"
TITLE = "GNU Enterprise Reports"
VERSION = __version__.get_version()
HEXVERSION = __version__.get_hexversion()

__gettext_domain__ = "gnue-reports"
