#
# Copyright 2002-2009 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: gdi.py 9958 2009-10-11 18:56:59Z reinhard $

"""
Basic destination adapter for writing xml data
based on Char layout to win32 GDI printers
"""

import xml.sax
import math, string, sys, os

import win32ui, win32con

from gnue.reports.base.GROutputAdapter import DestinationAdapter as Base
from gnue.common.apps import GDebug
from gnue.forms.uidrivers.win32.PrintDialog import PrintDialog


class DestinationAdapter(Base, xml.sax.ContentHandler):

  #
  # Typically, a transform adapter will call EITHER
  # getOutputHandle or getOutputFile, not both.
  #
  # return a stream handle for outut by
  # the transform adapter
  #
  def getOutputHandle(self):
    self.usingHandle = 1
    self.input, self.tempfile = self.createTempFile()
    return self.input

  #
  # return a file name for outut by the
  # transform adapter
  #
  def getOutputFile(self):
    self.usingHandle = 0
    self.input, self.tempfile = self.createTempFile()
    self.input.close()
    return self.tempfile

  #
  # Wrap up
  #
  def close(self, mimetype='plain/text'):

    if self.usingHandle:
      self.input.close()

    file = self.tempfile

    print_to = string.replace(string.replace(self.destination, "`",""),';','')
    if print_to == '-':
      pDialog = PrintDialog()
      pDialog.DoModal()
      try:
        # OK selected
        print_to = pDialog['deviceName']
      except KeyError:
        # Cancel selected
        self.deleteTempFile(self.tempfile)
        return

    self.setup(print_to)

    infile = open(file, 'r')

    # Create a parser
    parser = xml.sax.make_parser()

    # Tell the parser to use our handler
    parser.setContentHandler(self)
    parser.parse(infile)

    infile.close()

    self.deleteTempFile(self.tempfile)


  # XML handling stuff
  def startElement(self, name, attrs):
    if name == "report":
      self.dc.StartDoc(name)

    elif name == "page":
      self.dc.StartPage()

    elif name == "line":
      self._y = int(attrs['y'])

    elif name == "label":
      self._attrs = attrs
      self.dc.SelectObject(FONTS['normal'])

    elif name == "b":
      self.dc.SelectObject(FONTS['bold'])

    elif name == "i":
      self.dc.SelectObject(FONTS['italic'])

    self._text = ''


  def characters(self, text):
    self._text += text


  def endElement(self, name):
    if name == "report":
      self.dc.EndDoc()

    elif name == "page":
      self.dc.EndPage()

    elif name == "label":
      h = self.metrics['height']
      w = self.metrics['width']
      self.dc.TextOut(int(w * int(self._attrs['x'])),
                      int( - h * 1.3 * self._y),
                      self._text.encode(_encoding, 'replace'))

  def setup(self, printer):
    self.dc = win32ui.CreateDC()
    self.dc.CreatePrinterDC(printer)
    self.dc.SetMapMode(win32con.MM_TWIPS)
    
    self.dc.SelectObject(FONTS['normal'])
    m = self.dc.GetTextMetrics()
    
    self.metrics = {}  
    self.metrics['width']  = m['tmAveCharWidth']
    self.metrics['height'] = m['tmHeight']


def createFonts():
  fonts = {}
  font_specs = {
    'normal' : {
      'name': 'Courier New',
        'size': 12,
        'weight': 400},
    'bold' : {
      'name': 'Courier New',
        'size': 12,
        'weight': 800},
    'italic' : {
      'name': 'Courier New',
        'size': 12,
        'weight': 400,
        'italic': 1}
    }
  for spec in ['normal', 'bold', 'italic']:
    fonts[spec] = win32ui.CreateFont(font_specs[spec])
  return fonts
  
FONTS = createFonts()

_encoding = gConfig('textEncoding')