#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2009 Free Software Foundation
#
# FILE:
# Parser.py
#
# DESCRIPTION:
# Class that contains a SAX-based xml processor for GNUe Reports'
# "Universal" markup.
#
# NOTES:
#

__all__ = ['loadFile','getXMLelements','XmlStyleHandler']

from gnue.common.datasources import GDataSource
from gnue.common.formatting import GTypecast
from gnue.common.definitions import GParser
from gnue.reports.adapters.filters.Universal.Base.ParserTypes import *
from Objects import Styles, TextStyle, StyleSet, Color
import copy, types






########
########  Please keep this file neat !!!
########







#######################################################
# This method loads a report from an XML file and returns
# a GRReport object.  If initialize is 1 (default), then
# the report is initialized and ready to go.
#######################################################

def loadFile(buffer, initialize=0):
  return GParser.loadXMLObject (buffer, xmlStyleHandler, 'SSStyles', 'styles',
           initialize, attributes={})



xmlElements = None


def getXMLelements():

  global xmlElements

  if xmlElements == None:

    #
    #
    xmlElements = {
      'styles':       {
         'BaseClass': Styles.Styles,
         'Required': 1,
         'SingleInstance': 1,
         'Attributes':  { },
         'ParentTags':  None },

      'styleset':       {
         'BaseClass': StyleSet.StyleSet,
         'Required': 1,
         'SingleInstance': 1,
         'Attributes': {
            "name":   {
               'Required': 1,
               'Typecast': GTypecast.name  },
         },
         'ParentTags':  ('styles',) },

      'color':       {
         'BaseClass': Color.Color,
         'Required': 1,
         'SingleInstance': 1,
         'Attributes': {
            "name":   {
               'Required': 1,
               'Typecast': GTypecast.name  },
            "value":   {
               'Required': 1,
               'Typecast': color  },
         },
         'ParentTags':  ('styleset',) },


      'textstyle':         {
         'BaseClass': TextStyle.TextStyle,
         'Attributes': {
            "name":   {
               'Required': 1,
               'Typecast': GTypecast.name  },
            "objects":   {
               'Required': 1,
               'Typecast': GTypecast.names },
            "font-family":   {
               'Typecast': GTypecast.text },
            "font-style":   {
               'Typecast': GTypecast.text },
            "font-weight":   {
               'Typecast': GTypecast.text },
            "font-horiz-scale":   {
               'Typecast': percentage },
            "font-vert-scale":   {
               'Typecast': percentage },
            "text-size":   {
               'Typecast': textmeasurement },
            "text-underline":   {
               'ValueSet': _lineSet(),
               'Typecast': GTypecast.text },
            "text-underline-color":   {
               'Typecast': color },
            "text-underline-size":   {
               'Typecast': textmeasurement },
            "text-overline":   {
               'ValueSet': _lineSet(),
               'Typecast': GTypecast.text },
            "text-overline-color":   {
               'Typecast': color },
            "text-overline-size":   {
               'Typecast': textmeasurement },
            "text-strikeout":   {
               'ValueSet': _lineSet(),
               'Typecast': GTypecast.text },
            "text-strikeout-color":   {
               'Typecast': color },
            "text-strikeout-size":   {
               'Typecast': textmeasurement },
            "text-case":   {
               'ValueSet':  {
                  'none': {},
                  'upper': {},
                  'lower': {},
                  'capitalize': {},
                  'smallcaps': {}  },
               'Typecast': GTypecast.text },
            "text-color":   {
               'Typecast': color },
            "text-leading":   {
               'Typecast': GTypecast.text },
            "text-tracking":   {
               'Typecast': GTypecast.text },
            "text-indent":   {
               'Typecast': GTypecast.text },
            "text-justification":   {
               'ValueSet': {
                  'left': {},
                  'right': {},
                  'center': {},
                  'justified': {}  },
               'Typecast': GTypecast.text },
            "word-spacing":   {
               'Typecast': textmeasurement },
            "line-spacing":   {
               'Typecast': textmeasurement },

            "background-color":   {
               'Typecast': color },
            "background-fill":   {
               'Typecast': GTypecast.text },

            "margin":    {
               'Typecast': textmeasurement },
            "margin-left":  {
               'Typecast': textmeasurement },
            "margin-right":  {
               'Typecast': textmeasurement },
            "margin-top":  {
               'Typecast': textmeasurement },
            "margin-bottom":  {
               'Typecast': textmeasurement },

            "padding":  {
               'Typecast': textmeasurement },
            "padding-left":  {
               'Typecast': textmeasurement },
            "padding-right": {
               'Typecast': textmeasurement },
            "padding-top":   {
               'Typecast': textmeasurement },
            "padding-botton": {
               'Typecast': textmeasurement },

            "border":   {
               'ValueSet': _lineSet(),
               'Typecast': GTypecast.text },
            "border-left":   {
               'ValueSet': _lineSet(),
               'Typecast': GTypecast.text },
            "border-right":   {
               'ValueSet': _lineSet(),
               'Typecast': GTypecast.text },
            "border-top":   {
               'ValueSet': _lineSet(),
               'Typecast': GTypecast.text },
            "border-bottom":   {
               'ValueSet': _lineSet(),
               'Typecast': GTypecast.text },
            "border-horiz":   {
               'ValueSet': _lineSet(),
               'Typecast': GTypecast.text },
            "border-vert":   {
               'ValueSet': _lineSet(),
               'Typecast': GTypecast.text },

            "border-color":   {
               'Typecast': color },
            "border-left-color":   {
               'Typecast': color },
            "border-right-color":   {
               'Typecast': color },
            "border-top-color":   {
               'Typecast': color },
            "border-bottom-color":   {
               'Typecast': color },
            "border-horiz-color":   {
               'Typecast': color },
            "border-vert-color":   {
               'Typecast': color },

            "border-size":   {
               'Typecast': textmeasurement },
            "border-left-size":   {
               'Typecast': textmeasurement },
            "border-right-size":   {
               'Typecast': textmeasurement },
            "border-top-size":   {
               'Typecast': textmeasurement },
            "border-bottom-size":   {
               'Typecast': textmeasurement },
            "border-horiz-size":   {
               'Typecast': textmeasurement },
            "border-vert-size":   {
               'Typecast': textmeasurement }, },


         'ParentTags':  ('styleset',) },

    }


  return GParser.buildImportableTags('styles',xmlElements)




#######################################################
#
# xmlStyleHandler
#
# This class is called by the XML parser to
# process the xml file.
#
#######################################################

class xmlStyleHandler (GParser.xmlHandler):
  def __init__(self):
    GParser.xmlHandler.__init__(self)
    self.xmlElements = getXMLelements()




def _lineSet():
  return {
   'none': {},
   'dotted': {},
   'dashed': {},
   'solid': {},
   'double': {},
   'groove': {},
   'ridge': {},
   'inset': {},
   'outset': {},
  }

_marginDef = {
    'Typecast': textmeasurement },
