/*
     This file is part of GNUnet.
     (C) 2010 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/fs/gnunet-fs-gtk.h
 * @brief Globals for gnunet-fs-gtk
 * @author Christian Grothoff
 */
#ifndef GNUNET_FS_GTK_H
#define GNUNET_FS_GTK_H

#include "gnunet_gtk.h"
#include <gnunet/gnunet_fs_service.h>
#include <extractor.h>

struct GNUNET_GTK_MainWindowContext
{
  GtkBuilder *builder;

  const struct GNUNET_CONFIGURATION_Handle *cfg;

  GtkTreeStore *search_ns_treestore;
  GtkTreeView *ns_selector_treeview;
  GtkWidget *ns_selector_window;
  GtkToggleButton *ns_dropdown_button;
  GtkLabel *search_ns_label;

  GtkEntry *search_entry;

  GtkComboBox *anonymity_combo;
  GtkListStore *anonymity_level_liststore;

  GtkImage *preview_image;
  GtkListStore *md_liststore;
  GtkTreeView *md_treeview;

  GtkWidget *main_window;

  GtkTreeRowReference *ns_selector_pushed_row;
  GtkTreeRowReference *selected_ns_row;
  int ns_callback_registered;
  GtkWindow *ns_manager;
  gulong ns_manager_delete_handler_id;

  GtkFileChooser *download_location_chooser;
  GtkEntry *download_name_entry;
  GtkComboBox *download_anonymity_combo;
  GtkCheckButton *download_recursive_checkbutton;
  GtkButton *download_download_button;
  GtkVBox *download_panel;

  GtkNotebook *notebook;
};


/**
 * Columns in the search namespace model.
 */
enum GNUNET_GTK_FS_MAIN_WINDOW_SearchNamespaceModelColumns
  {
    /**
     * A gchararray.
     */
    GNUNET_GTK_FS_MAIN_WINDOW_SEARCH_NAMESPACE_MC_NAME = 0,

    /**
     * A gpointer.
     */
    GNUNET_GTK_FS_MAIN_WINDOW_SEARCH_NAMESPACE_MC_KEY = 1,
    
    /**
     * A gchararray.
     */
    GNUNET_GTK_FS_MAIN_WINDOW_SEARCH_NAMESPACE_MC_ROOT = 2,
    
    /**
     * A gchararray.
     */
    GNUNET_GTK_FS_MAIN_WINDOW_SEARCH_NAMESPACE_MC_TOOLTIP = 3,
  };


/**
 * Columns in the meta data model.
 */
enum GNUNET_GTK_FS_MAIN_WINDOW_MetaDataModelColumns
  {
    /**
     * A guint.
     */
    GNUNET_GTK_FS_MAIN_WINDOW_META_DATA_MC_META_TYPE = 0,

    /**
     * A guint.
     */
    GNUNET_GTK_FS_MAIN_WINDOW_META_DATA_MC_META_FORMAT = 1,
    
    /**
     * A gchararray.
     */
    GNUNET_GTK_FS_MAIN_WINDOW_META_DATA_MC_META_TYPE_STRING = 2,
    
    /**
     * A gchararray.
     */
    GNUNET_GTK_FS_MAIN_WINDOW_META_DATA_MC_META_VALUE = 3,
  };


/**
 * Columns in the anonymity level model.
 */
enum GNUNET_GTK_FS_MAIN_WINDOW_AnonymityLevelModelColumns
  {
    /**
     * A gchararray.
     */
    GNUNET_GTK_FS_MAIN_WINDOW_ANONYMITY_LEVEL_MC_NAME = 0,

    /**
     * A guint.
     */
    GNUNET_GTK_FS_MAIN_WINDOW_ANONYMITY_LEVEL_MC_LEVEL = 1,
    
    /**
     * A gchararray.
     */
    GNUNET_GTK_FS_MAIN_WINDOW_ANONYMITY_LEVEL_MC_COLOR = 2,
  };


/**
 * Columns in the search mime model.
 */
enum GNUNET_GTK_FS_MAIN_WINDOW_SearchMimeModelColumns
  {
    /**
     * A gchararray.
     */
    GNUNET_GTK_FS_MAIN_WINDOW_SEARCH_MIME_MC_MIME = 0,

    /**
     * A gchararray.
     */
    GNUNET_GTK_FS_MAIN_WINDOW_SEARCH_MIME_MC_TYPE = 1,

    /**
     * A gchararray.
     */
    GNUNET_GTK_FS_MAIN_WINDOW_SEARCH_MIME_MC_EXTENSION = 2,

    /**
     * A gchararray.
     */
    GNUNET_GTK_FS_MAIN_WINDOW_SEARCH_MIME_MC_LOSSYNESS = 3,

    /**
     * A gchararray.
     */
    GNUNET_GTK_FS_MAIN_WINDOW_SEARCH_MIME_MC_FREEDOM = 4,
  };

/**
 * Get main context.
 */
struct GNUNET_GTK_MainWindowContext *
GNUNET_FS_GTK_get_main_context ();


/**
 * Get our configuration.
 */
const struct GNUNET_CONFIGURATION_Handle *
GNUNET_FS_GTK_get_configuration (void);


/**
 * Return the list store with anonymity levels.
 *
 * @return the list store
 */
GtkTreeModel *
GNUNET_FS_GTK_get_anonymity_level_list_store (void);


/**
 * Return our handle for file-sharing operations.
 *
 * @return NULL on error
 */
struct GNUNET_FS_Handle *
GNUNET_FS_GTK_get_fs_handle (void);


/**
 * Get an object from the main window.
 *
 * @param name name of the object
 * @return NULL on error
 */
GObject *
GNUNET_FS_GTK_get_main_window_object (const char *name);


/**
 * Get the selected anonymity level.
 *
 * @param builder builder object for the window
 * @param combo_name name of the combobox widget to get anonymity from
 * @param p_level pointer to a guint to receive the level value
 * @return TRUE on success, FALSE on error
 */
gboolean
GNUNET_GTK_get_selected_anonymity_level (GtkBuilder * builder,
                                         gchar * combo_name, guint * p_level);


/**
 * Get the selected anonymity level.
 *
 * @param combo combo box widget to get anonymity from
 * @param p_level pointer to a guint to receive the level value
 * @return TRUE on success, FALSE on error
 */
gboolean
GNUNET_GTK_get_selected_anonymity_combo_level (GtkComboBox *combo, guint *p_level);

/**
 * Set the selected anonymity level.
 * For dialogue initialization.
 *
 * @param builder builder object for the window
 * @param combo_name name of the combobox widget to set anonymity in
 * @param sel_level the level value to select
 * @return TRUE on success, FALSE on error (no item with such level)
 */
gboolean
GNUNET_GTK_select_anonymity_level (GtkBuilder * builder, gchar * combo_name,
                                   guint sel_level);


/**
 * Set the selected anonymity level.
 * For dialogue initialization.
 *
 * @param combo the combobox widget to set anonymity in
 * @param sel_level the level value to select
 * @return TRUE on success, FALSE on error (no item with such level)
 */
gboolean
GNUNET_GTK_select_anonymity_combo_level (GtkComboBox *combo, guint sel_level);

void
GNUNET_GTK_main_window_refresh_ns_list (struct GNUNET_GTK_MainWindowContext *main_ctx);

#endif
/* end of gnunet-fs-gtk.h */
