/*
     This file is part of GNUnet
     (C) 2005, 2006, 2010, 2012 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/fs/gnunet-fs-gtk_create-pseudonym.c
 * @author Christian Grothoff
 * @brief code to handle the main menu action to create a pseudonym
 */
#include "gnunet-fs-gtk_common.h"
#include "gnunet-fs-gtk.h"


/**
 * Function called whenever text is added to the GtkEntry
 * with the name of the namespace.  Here, we check that only
 * "valid" characters are used (as the result must be a valid
 * filename on most OSes).
 *
 * @param entry GtkEntry being edited
 * @param text the text
 * @param length length of the text
 * @param position where the text is being inserted
 * @param data the builder of the dialog (unused)
 */
void
GNUNET_FS_GTK_create_namespace_insert_text_cb (GtkEntry    *entry,
					       const gchar *text,
					       gint         length,
					       gint        *position,
					       gpointer     data)
{
  GtkEditable *editable = GTK_EDITABLE(entry);
  gint i;

  for (i=0; i < length; i++) 
    if ( (! isalnum((int) text[i])) && (text[i] != '_') && (text[i] != '-') )
      g_signal_stop_emission_by_name (G_OBJECT (editable), "insert_text");
}


/**
 * User completed the 'create pseudonym' dialog.  Run the desired action.
 *
 * @param dialog the dialog
 * @param response_id GTK_RESPONSE_OK on "OK"
 * @param user_data the builder of the dialog
 */
void
GNUNET_GTK_create_namespace_dialog_response_cb (GtkDialog * dialog,
                                                gint response_id,
                                                gpointer user_data)
{
  GtkBuilder *builder = GTK_BUILDER (user_data);
  const char *name;
  struct GNUNET_FS_Namespace *ns;

  if (GTK_RESPONSE_OK != response_id)
  {
    gtk_widget_destroy (GTK_WIDGET (dialog));
    g_object_unref (G_OBJECT (builder));
    return;
  }
  name = gtk_entry_get_text (GTK_ENTRY (gtk_builder_get_object (builder, 
								"GNUNET_GTK_create_namespace_name_entry")));
  /* FIXME-FEATURE: show busy dialog while doing key creation */
  if (NULL != name)
  {
    ns = GNUNET_FS_namespace_create (GNUNET_FS_GTK_get_fs_handle (), name);
    GNUNET_break (NULL != ns);
    if (NULL != ns)
      GNUNET_FS_namespace_delete (ns, GNUNET_NO);
  }
  gtk_widget_destroy (GTK_WIDGET (dialog));
  g_object_unref (G_OBJECT (builder));
}


/**
 * User selected "create pseudonym" in the menu of the main window.
 *
 * @param dummy the menu entry
 * @param user_data the main dialog builder, unused
 */
void
GNUNET_GTK_main_menu_create_pseudonym_activate_cb (GtkWidget * dummy,
                                                   gpointer user_data)
{
  GtkWidget *ad;
  GtkWidget *toplevel;
  GtkBuilder *builder;

  builder = GNUNET_GTK_get_new_builder ("gnunet_fs_gtk_create_namespace_dialog.glade", NULL);
  if (NULL == builder)
  {
    GNUNET_break (0);
    return;
  }
  ad = GTK_WIDGET (gtk_builder_get_object
                   (builder, "GNUNET_GTK_create_namespace_dialog"));
  toplevel = gtk_widget_get_toplevel (dummy);
  if (GTK_IS_WINDOW (toplevel))
    gtk_window_set_transient_for (GTK_WINDOW (ad), GTK_WINDOW (toplevel));
  gtk_window_present (GTK_WINDOW (ad));
}


/* end of gnunet-fs-gtk_create-pseudonym.c */
