/* Copyright 2021 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */
#ifndef __CROS_EC_USB_PD_TCPM_RT1718S_H
#define __CROS_EC_USB_PD_TCPM_RT1718S_H

#include "util.h"
#include "usb_charge.h"
#include "usb_pd_tcpm.h"

/* RT1718S Private RegMap */
#define RT1718S_I2C_ADDR_FLAGS				0x43

#define RT1718S_VID					0x29CF
#define RT1718S_PID					0x1718

#define RT1718S_PHYCTRL1				0x80
#define RT1718S_PHYCTRL2				0x81
#define RT1718S_PHYCTRL3				0x82
#define RT1718S_PHYCTRL7				0x86
#define RT1718S_VCON_CTRL1				0x8A
#define RT1718S_VCON_CTRL3				0x8C
#define RT1718S_SYS_CTRL1				0x8F
#define RT1718S_SYS_CTRL1_TCPC_CONN_INVALID		BIT(6)
#define RT1718S_SYS_CTRL1_SHIPPING_OFF			BIT(5)

#define RT1718S_RT_MASK1				0x91
#define RT1718S_RT_MASK1_M_VBUS_FRS_LOW			BIT(7)
#define RT1718S_RT_MASK1_M_RX_FRS			BIT(6)
#define RT1718S_RT_MASK2				0x92
#define RT1718S_RT_MASK3				0x93
#define RT1718S_RT_MASK4				0x94
#define RT1718S_RT_MASK5				0x95
#define RT1718S_RT_MASK6				0x96
#define RT1718S_RT_MASK6_M_BC12_SNK_DONE		BIT(7)
#define RT1718S_RT_MASK6_M_HVDCP_CHK_DONE		BIT(6)
#define RT1718S_RT_MASK6_M_BC12_TA_CHG			BIT(5)
#define RT1718S_RT_MASK7				0x97

#define RT1718S_RT_INT6					0x9D
#define RT1718S_RT_INT6_INT_BC12_SNK_DONE		BIT(7)
#define RT1718S_RT_INT6_INT_HVDCP_CHK_DONE		BIT(6)
#define RT1718S_RT_INT6_INT_BC12_TA_CHG			BIT(5)

#define RT1718S_RT_ST6					0xA4
#define RT1718S_RT_ST6_BC12_SNK_DONE			BIT(7)
#define RT1718S_RT_ST6_HVDCP_CHK_DONE			BIT(6)
#define RT1718S_RT_ST6_BC12_TA_CHG			BIT(5)

#define RT1718S_PHYCTRL9				0xAC

#define RT1718S_SYS_CTRL3				0xB0
#define RT1718S_TCPC_CTRL1				0xB1
#define RT1718S_TCPC_CTRL2				0xB2
#define RT1718S_TCPC_CTRL3				0xB3
#define RT1718S_SWRESET_MASK				BIT(0)
#define RT1718S_TCPC_CTRL4				0xB4
#define RT1718S_SYS_CTRL4				0xB8
#define RT1718S_WATCHDOG_CTRL				0xBE
#define RT1718S_I2C_RST_CTRL				0xBF

#define RT1718S_HILO_CTRL9				0xC8
#define RT1718S_SHILED_CTRL1				0xCA

#define RT1718S_DIS_SRC_VBUS_CTRL			0xE0
#define RT1718S_ENA_SRC_VBUS_CTRL			0xE1
#define RT1718S_FAULT_OC1_VBUS_CTRL			0xE3
#define RT1718S_GPIO2_VBUS_CTRL				0xEB
#define RT1718S_GPIO1_CTRL				0xED
#define RT1718S_GPIO2_CTRL				0xEE

#define RT1718S_UNLOCK_PW_2				0xF0
#define RT1718S_UNLOCK_PW_1				0xF1

#define RT1718S_RT2_SYS_CTRL5				0xF210

#define RT1718S_VBUS_VOL_TO_REG(_vol)			(CLAMP(_vol, 5, 20) - 5)
#define RT1718S_VBUS_PCT_TO_REG(_pct)			(CLAMP(_pct, 5, 20) \
							/ 5 - 1)
#define RT1718S_RT2_VBUS_VOL_CTRL			0xF213
#define RT1718S_RT2_VBUS_VOL_CTRL_OVP_SEL		(BIT(5) | BIT(4))
#define RT1718S_RT2_VBUS_VOL_CTRL_VOL_SEL		0x0F

#define RT1718S_RT2_VBUS_OCRC_EN			0xF214
#define RT1718S_RT2_VBUS_OCRC_EN_VBUS_OCP1_EN		BIT(0)
#define RT1718S_RT2_VBUS_OCP_CTRL1			0xF216
#define RT1718S_RT2_VBUS_OCP_CTRL4			0xF219

#define RT1718S_RT2_SBU_CTRL_01				0xF23A
#define RT1718S_RT2_SBU_CTRL_01_SBU_VIEN		BIT(7)
#define RT1718S_RT2_SBU_CTRL_01_DPDM_VIEN		BIT(6)
#define RT1718S_RT2_SBU_CTRL_01_SBU2_SWEN		BIT(3)
#define RT1718S_RT2_SBU_CTRL_01_SBU1_SWEN		BIT(2)
#define RT1718S_RT2_SBU_CTRL_01_DM_SWEN			BIT(1)
#define RT1718S_RT2_SBU_CTRL_01_DP_SWEN			BIT(0)

#define RT1718S_RT2_BC12_SNK_FUNC			0xF260
#define RT1718S_RT2_BC12_SNK_FUNC_BC12_SNK_EN		BIT(7)
#define RT1718S_RT2_BC12_SNK_FUNC_SPEC_TA_EN		BIT(6)
#define RT1718S_RT2_BC12_SNK_FUNC_DCDT_SEL_MASK		0x30
#define RT1718S_RT2_BC12_SNK_FUNC_DCDT_SEL_DISABLE	0x00
#define RT1718S_RT2_BC12_SNK_FUNC_DCDT_SEL_300MS	0x10
#define RT1718S_RT2_BC12_SNK_FUNC_DCDT_SEL_600MS	0x20
#define RT1718S_RT2_BC12_SNK_FUNC_DCDT_SEL_WAIT_DATA	0x30
#define RT1718S_RT2_BC12_SNK_FUNC_VLGC_OPT		BIT(3)
#define RT1718S_RT2_BC12_SNK_FUNC_VPORT_SEL		BIT(2)
#define RT1718S_RT2_BC12_SNK_FUNC_BC12_WAIT_VBUS	BIT(1)

#define RT1718S_RT2_BC12_STAT				0xF261
#define RT1718S_RT2_BC12_STAT_DCDT			BIT(4)
#define RT1718S_RT2_BC12_STAT_PORT_STATUS_MASK		0x0F
#define RT1718S_RT2_BC12_STAT_PORT_STATUS_NONE		0x00
#define RT1718S_RT2_BC12_STAT_PORT_STATUS_SDP		0x0D
#define RT1718S_RT2_BC12_STAT_PORT_STATUS_CDP		0x0E
#define RT1718S_RT2_BC12_STAT_PORT_STATUS_DCP		0x0F


#define RT1718S_RT2_DPDM_CTR1_DPDM_SET			0xF263
#define RT1718S_RT2_DPDM_CTR1_DPDM_SET_DPDM_VSRC_SEL_MASK	0x03
#define RT1718S_RT2_DPDM_CTR1_DPDM_SET_DPDM_VSRC_SEL_0_55V	0x00
#define RT1718S_RT2_DPDM_CTR1_DPDM_SET_DPDM_VSRC_SEL_0_60V	0x01
#define RT1718S_RT2_DPDM_CTR1_DPDM_SET_DPDM_VSRC_SEL_0_65V	0x02
#define RT1718S_RT2_DPDM_CTR1_DPDM_SET_DPDM_VSRC_SEL_0_70V	0x03

#define RT1718S_RT2_BC12_SRC_FUNC			0xF26D
#define RT1718S_RT2_BC12_SRC_FUNC_BC12_SRC_EN		BIT(7)
#define RT1718S_RT2_BC12_SRC_FUNC_SRC_MODE_SEL_MASK	0x70
#define RT1718S_RT2_BC12_SRC_FUNC_SRC_MODE_SEL_BC12_SDP	0x00
#define RT1718S_RT2_BC12_SRC_FUNC_SRC_MODE_SEL_BC12_CDP	0x10
#define RT1718S_RT2_BC12_SRC_FUNC_SRC_MODE_SEL_BC12_DCP	0x20
#define RT1718S_RT2_BC12_SRC_FUNC_WAIT_VBUS_ON		BIT(0)

extern const struct tcpm_drv rt1718s_tcpm_drv;
extern const struct bc12_drv rt1718s_bc12_drv;

int rt1718s_write8(int port, int reg, int val);
int rt1718s_read8(int port, int reg, int *val);
int rt1718s_update_bits8(int port, int reg, int mask, int val);
__override_proto int board_rt1718s_init(int port);

#endif /* __CROS_EC_USB_PD_TCPM_MT6370_H */
