/*
 * socket.c - Create a new socket.
 *
 * This file is part of the Portable.NET C library.
 * Copyright (C) 2004  Southern Storm Software, Pty Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "socket-glue.h"

extern int __syscall_socket (int domain, int type);

int
__socket (int domain, int type, int protocol)
{
  int fd;

  /* Validate the parameters */
  if (domain != AF_INET && domain != AF_INET6)
    {
      errno = EAFNOSUPPORT;
      return -1;
    }
  if (type == SOCK_STREAM)
    {
      if (protocol != 0 && protocol != IPPROTO_TCP)
        {
	  errno = EPROTONOSUPPORT;
	  return -1;
	}
    }
  else if (type == SOCK_DGRAM)
    {
      if (protocol != 0 && protocol != IPPROTO_UDP)
        {
	  errno = EPROTONOSUPPORT;
	  return -1;
	}
    }
  else
    {
      errno = EACCES;
      return -1;
    }

  /* Create the socket and bind it to a file descriptor */
  fd = __syscall_socket (domain, type);
  if (fd < 0)
    {
      errno = -fd;
      return -1;
    }
  return fd;
}

weak_alias (__socket, socket)
