/*
 * Copyright (c) 2010-2011 Atheros Communications Inc.
 * Copyright (c) 2011-2012 Qualcomm Atheros Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef INITVALS_9003_2P2_H
#define INITVALS_9003_2P2_H

/* AR9003 2.2 */

static const u32 ar9300_2p2_radio_postamble[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x0001609c, 0x0dd08f29, 0x0dd08f29, 0x0b283f31, 0x0b283f31},
	{0x000160ac, 0xa4653c00, 0xa4653c00, 0x24652800, 0x24652800},
	{0x000160b0, 0x03284f3e, 0x03284f3e, 0x05d08f20, 0x05d08f20},
	{0x0001610c, 0xc8000000, 0xc0000000, 0xc0000000, 0xc0000000},
	{0x00016140, 0x10804008, 0x10804008, 0x50804008, 0x50804008},
	{0x0001650c, 0xc8000000, 0xc0000000, 0xc0000000, 0xc0000000},
	{0x00016540, 0x10804008, 0x10804008, 0x50804008, 0x50804008},
	{0x0001690c, 0xc8000000, 0xc0000000, 0xc0000000, 0xc0000000},
	{0x00016940, 0x10804008, 0x10804008, 0x50804008, 0x50804008},
};

static const u32 ar9300Modes_lowest_ob_db_tx_gain_table_2p2[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x0000a2dc, 0x00033800, 0x00033800, 0x03aaa352, 0x03aaa352},
	{0x0000a2e0, 0x0003c000, 0x0003c000, 0x03ccc584, 0x03ccc584},
	{0x0000a2e4, 0x03fc0000, 0x03fc0000, 0x03f0f800, 0x03f0f800},
	{0x0000a2e8, 0x00000000, 0x00000000, 0x03ff0000, 0x03ff0000},
	{0x0000a410, 0x000050d9, 0x000050d9, 0x000050d9, 0x000050d9},
	{0x0000a500, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a504, 0x06000003, 0x06000003, 0x04000002, 0x04000002},
	{0x0000a508, 0x0a000020, 0x0a000020, 0x08000004, 0x08000004},
	{0x0000a50c, 0x10000023, 0x10000023, 0x0b000200, 0x0b000200},
	{0x0000a510, 0x16000220, 0x16000220, 0x0f000202, 0x0f000202},
	{0x0000a514, 0x1c000223, 0x1c000223, 0x12000400, 0x12000400},
	{0x0000a518, 0x21002220, 0x21002220, 0x16000402, 0x16000402},
	{0x0000a51c, 0x27002223, 0x27002223, 0x19000404, 0x19000404},
	{0x0000a520, 0x2b022220, 0x2b022220, 0x1c000603, 0x1c000603},
	{0x0000a524, 0x2f022222, 0x2f022222, 0x21000a02, 0x21000a02},
	{0x0000a528, 0x34022225, 0x34022225, 0x25000a04, 0x25000a04},
	{0x0000a52c, 0x3a02222a, 0x3a02222a, 0x28000a20, 0x28000a20},
	{0x0000a530, 0x3e02222c, 0x3e02222c, 0x2c000e20, 0x2c000e20},
	{0x0000a534, 0x4202242a, 0x4202242a, 0x30000e22, 0x30000e22},
	{0x0000a538, 0x4702244a, 0x4702244a, 0x34000e24, 0x34000e24},
	{0x0000a53c, 0x4b02244c, 0x4b02244c, 0x38001640, 0x38001640},
	{0x0000a540, 0x4e02246c, 0x4e02246c, 0x3c001660, 0x3c001660},
	{0x0000a544, 0x52022470, 0x52022470, 0x3f001861, 0x3f001861},
	{0x0000a548, 0x55022490, 0x55022490, 0x43001a81, 0x43001a81},
	{0x0000a54c, 0x59022492, 0x59022492, 0x47001a83, 0x47001a83},
	{0x0000a550, 0x5d022692, 0x5d022692, 0x4a001c84, 0x4a001c84},
	{0x0000a554, 0x61022892, 0x61022892, 0x4e001ce3, 0x4e001ce3},
	{0x0000a558, 0x65024890, 0x65024890, 0x52001ce5, 0x52001ce5},
	{0x0000a55c, 0x69024892, 0x69024892, 0x56001ce9, 0x56001ce9},
	{0x0000a560, 0x6e024c92, 0x6e024c92, 0x5a001ceb, 0x5a001ceb},
	{0x0000a564, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a568, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a56c, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a570, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a574, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a578, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a57c, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a580, 0x00800000, 0x00800000, 0x00800000, 0x00800000},
	{0x0000a584, 0x06800003, 0x06800003, 0x04800002, 0x04800002},
	{0x0000a588, 0x0a800020, 0x0a800020, 0x08800004, 0x08800004},
	{0x0000a58c, 0x10800023, 0x10800023, 0x0b800200, 0x0b800200},
	{0x0000a590, 0x16800220, 0x16800220, 0x0f800202, 0x0f800202},
	{0x0000a594, 0x1c800223, 0x1c800223, 0x12800400, 0x12800400},
	{0x0000a598, 0x21802220, 0x21802220, 0x16800402, 0x16800402},
	{0x0000a59c, 0x27802223, 0x27802223, 0x19800404, 0x19800404},
	{0x0000a5a0, 0x2b822220, 0x2b822220, 0x1c800603, 0x1c800603},
	{0x0000a5a4, 0x2f822222, 0x2f822222, 0x21800a02, 0x21800a02},
	{0x0000a5a8, 0x34822225, 0x34822225, 0x25800a04, 0x25800a04},
	{0x0000a5ac, 0x3a82222a, 0x3a82222a, 0x28800a20, 0x28800a20},
	{0x0000a5b0, 0x3e82222c, 0x3e82222c, 0x2c800e20, 0x2c800e20},
	{0x0000a5b4, 0x4282242a, 0x4282242a, 0x30800e22, 0x30800e22},
	{0x0000a5b8, 0x4782244a, 0x4782244a, 0x34800e24, 0x34800e24},
	{0x0000a5bc, 0x4b82244c, 0x4b82244c, 0x38801640, 0x38801640},
	{0x0000a5c0, 0x4e82246c, 0x4e82246c, 0x3c801660, 0x3c801660},
	{0x0000a5c4, 0x52822470, 0x52822470, 0x3f801861, 0x3f801861},
	{0x0000a5c8, 0x55822490, 0x55822490, 0x43801a81, 0x43801a81},
	{0x0000a5cc, 0x59822492, 0x59822492, 0x47801a83, 0x47801a83},
	{0x0000a5d0, 0x5d822692, 0x5d822692, 0x4a801c84, 0x4a801c84},
	{0x0000a5d4, 0x61822892, 0x61822892, 0x4e801ce3, 0x4e801ce3},
	{0x0000a5d8, 0x65824890, 0x65824890, 0x52801ce5, 0x52801ce5},
	{0x0000a5dc, 0x69824892, 0x69824892, 0x56801ce9, 0x56801ce9},
	{0x0000a5e0, 0x6e824c92, 0x6e824c92, 0x5a801ceb, 0x5a801ceb},
	{0x0000a5e4, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5e8, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5ec, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5f0, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5f4, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5f8, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5fc, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a600, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a604, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a608, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a60c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a610, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a614, 0x02004000, 0x02004000, 0x01404000, 0x01404000},
	{0x0000a618, 0x02004801, 0x02004801, 0x01404501, 0x01404501},
	{0x0000a61c, 0x02808a02, 0x02808a02, 0x02008501, 0x02008501},
	{0x0000a620, 0x0380ce03, 0x0380ce03, 0x0280ca03, 0x0280ca03},
	{0x0000a624, 0x04411104, 0x04411104, 0x03010c04, 0x03010c04},
	{0x0000a628, 0x04411104, 0x04411104, 0x04014c04, 0x04014c04},
	{0x0000a62c, 0x04411104, 0x04411104, 0x04015005, 0x04015005},
	{0x0000a630, 0x04411104, 0x04411104, 0x04015005, 0x04015005},
	{0x0000a634, 0x04411104, 0x04411104, 0x04015005, 0x04015005},
	{0x0000a638, 0x04411104, 0x04411104, 0x04015005, 0x04015005},
	{0x0000a63c, 0x04411104, 0x04411104, 0x04015005, 0x04015005},
	{0x0000b2dc, 0x00033800, 0x00033800, 0x03aaa352, 0x03aaa352},
	{0x0000b2e0, 0x0003c000, 0x0003c000, 0x03ccc584, 0x03ccc584},
	{0x0000b2e4, 0x03fc0000, 0x03fc0000, 0x03f0f800, 0x03f0f800},
	{0x0000b2e8, 0x00000000, 0x00000000, 0x03ff0000, 0x03ff0000},
	{0x0000c2dc, 0x00033800, 0x00033800, 0x03aaa352, 0x03aaa352},
	{0x0000c2e0, 0x0003c000, 0x0003c000, 0x03ccc584, 0x03ccc584},
	{0x0000c2e4, 0x03fc0000, 0x03fc0000, 0x03f0f800, 0x03f0f800},
	{0x0000c2e8, 0x00000000, 0x00000000, 0x03ff0000, 0x03ff0000},
	{0x00016044, 0x012492d4, 0x012492d4, 0x012492d4, 0x012492d4},
	{0x00016048, 0x62480001, 0x62480001, 0x62480001, 0x62480001},
	{0x00016068, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c},
	{0x00016444, 0x012492d4, 0x012492d4, 0x012492d4, 0x012492d4},
	{0x00016448, 0x62480001, 0x62480001, 0x62480001, 0x62480001},
	{0x00016468, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c},
	{0x00016844, 0x012492d4, 0x012492d4, 0x012492d4, 0x012492d4},
	{0x00016848, 0x62480001, 0x62480001, 0x62480001, 0x62480001},
	{0x00016868, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c},
};

static const u32 ar9300Modes_fast_clock_2p2[][3] = {
	/* Addr      5G_HT20     5G_HT40   */
	{0x00001030, 0x00000268, 0x000004d0},
	{0x00001070, 0x0000018c, 0x00000318},
	{0x000010b0, 0x00000fd0, 0x00001fa0},
	{0x00008014, 0x044c044c, 0x08980898},
	{0x0000801c, 0x148ec02b, 0x148ec057},
	{0x00008318, 0x000044c0, 0x00008980},
	{0x00009e00, 0x0372131c, 0x0372131c},
	{0x0000a230, 0x0000000b, 0x00000016},
	{0x0000a254, 0x00000898, 0x00001130},
};

static const u32 ar9300_2p2_radio_core[][2] = {
	/* Addr      allmodes  */
	{0x00016000, 0x36db6db6},
	{0x00016004, 0x6db6db40},
	{0x00016008, 0x73f00000},
	{0x0001600c, 0x00000000},
	{0x00016040, 0x7f80fff8},
	{0x0001604c, 0x76d005b5},
	{0x00016050, 0x556cf031},
	{0x00016054, 0x13449440},
	{0x00016058, 0x0c51c92c},
	{0x0001605c, 0x3db7fffc},
	{0x00016060, 0xfffffffc},
	{0x00016064, 0x000f0278},
	{0x0001606c, 0x6db60000},
	{0x00016080, 0x00000000},
	{0x00016084, 0x0e48048c},
	{0x00016088, 0x54214514},
	{0x0001608c, 0x119f481e},
	{0x00016090, 0x24926490},
	{0x00016098, 0xd2888888},
	{0x000160a0, 0x0a108ffe},
	{0x000160a4, 0x812fc370},
	{0x000160a8, 0x423c8000},
	{0x000160b4, 0x92480080},
	{0x000160c0, 0x00adb6d0},
	{0x000160c4, 0x6db6db60},
	{0x000160c8, 0x6db6db6c},
	{0x000160cc, 0x01e6c000},
	{0x00016100, 0x3fffbe01},
	{0x00016104, 0xfff80000},
	{0x00016108, 0x00080010},
	{0x00016144, 0x02084080},
	{0x00016148, 0x00000000},
	{0x00016280, 0x058a0001},
	{0x00016284, 0x3d840208},
	{0x00016288, 0x05a20408},
	{0x0001628c, 0x00038c07},
	{0x00016290, 0x00000004},
	{0x00016294, 0x458a214f},
	{0x00016380, 0x00000000},
	{0x00016384, 0x00000000},
	{0x00016388, 0x00800700},
	{0x0001638c, 0x00800700},
	{0x00016390, 0x00800700},
	{0x00016394, 0x00000000},
	{0x00016398, 0x00000000},
	{0x0001639c, 0x00000000},
	{0x000163a0, 0x00000001},
	{0x000163a4, 0x00000001},
	{0x000163a8, 0x00000000},
	{0x000163ac, 0x00000000},
	{0x000163b0, 0x00000000},
	{0x000163b4, 0x00000000},
	{0x000163b8, 0x00000000},
	{0x000163bc, 0x00000000},
	{0x000163c0, 0x000000a0},
	{0x000163c4, 0x000c0000},
	{0x000163c8, 0x14021402},
	{0x000163cc, 0x00001402},
	{0x000163d0, 0x00000000},
	{0x000163d4, 0x00000000},
	{0x00016400, 0x36db6db6},
	{0x00016404, 0x6db6db40},
	{0x00016408, 0x73f00000},
	{0x0001640c, 0x00000000},
	{0x00016440, 0x7f80fff8},
	{0x0001644c, 0x76d005b5},
	{0x00016450, 0x556cf031},
	{0x00016454, 0x13449440},
	{0x00016458, 0x0c51c92c},
	{0x0001645c, 0x3db7fffc},
	{0x00016460, 0xfffffffc},
	{0x00016464, 0x000f0278},
	{0x0001646c, 0x6db60000},
	{0x00016500, 0x3fffbe01},
	{0x00016504, 0xfff80000},
	{0x00016508, 0x00080010},
	{0x00016544, 0x02084080},
	{0x00016548, 0x00000000},
	{0x00016780, 0x00000000},
	{0x00016784, 0x00000000},
	{0x00016788, 0x00800700},
	{0x0001678c, 0x00800700},
	{0x00016790, 0x00800700},
	{0x00016794, 0x00000000},
	{0x00016798, 0x00000000},
	{0x0001679c, 0x00000000},
	{0x000167a0, 0x00000001},
	{0x000167a4, 0x00000001},
	{0x000167a8, 0x00000000},
	{0x000167ac, 0x00000000},
	{0x000167b0, 0x00000000},
	{0x000167b4, 0x00000000},
	{0x000167b8, 0x00000000},
	{0x000167bc, 0x00000000},
	{0x000167c0, 0x000000a0},
	{0x000167c4, 0x000c0000},
	{0x000167c8, 0x14021402},
	{0x000167cc, 0x00001402},
	{0x000167d0, 0x00000000},
	{0x000167d4, 0x00000000},
	{0x00016800, 0x36db6db6},
	{0x00016804, 0x6db6db40},
	{0x00016808, 0x73f00000},
	{0x0001680c, 0x00000000},
	{0x00016840, 0x7f80fff8},
	{0x0001684c, 0x76d005b5},
	{0x00016850, 0x556cf031},
	{0x00016854, 0x13449440},
	{0x00016858, 0x0c51c92c},
	{0x0001685c, 0x3db7fffc},
	{0x00016860, 0xfffffffc},
	{0x00016864, 0x000f0278},
	{0x0001686c, 0x6db60000},
	{0x00016900, 0x3fffbe01},
	{0x00016904, 0xfff80000},
	{0x00016908, 0x00080010},
	{0x00016944, 0x02084080},
	{0x00016948, 0x00000000},
	{0x00016b80, 0x00000000},
	{0x00016b84, 0x00000000},
	{0x00016b88, 0x00800700},
	{0x00016b8c, 0x00800700},
	{0x00016b90, 0x00800700},
	{0x00016b94, 0x00000000},
	{0x00016b98, 0x00000000},
	{0x00016b9c, 0x00000000},
	{0x00016ba0, 0x00000001},
	{0x00016ba4, 0x00000001},
	{0x00016ba8, 0x00000000},
	{0x00016bac, 0x00000000},
	{0x00016bb0, 0x00000000},
	{0x00016bb4, 0x00000000},
	{0x00016bb8, 0x00000000},
	{0x00016bbc, 0x00000000},
	{0x00016bc0, 0x000000a0},
	{0x00016bc4, 0x000c0000},
	{0x00016bc8, 0x14021402},
	{0x00016bcc, 0x00001402},
	{0x00016bd0, 0x00000000},
	{0x00016bd4, 0x00000000},
};

static const u32 ar9300_2p2_mac_postamble[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x00001030, 0x00000230, 0x00000460, 0x000002c0, 0x00000160},
	{0x00001070, 0x00000168, 0x000002d0, 0x00000318, 0x0000018c},
	{0x000010b0, 0x00000e60, 0x00001cc0, 0x00007c70, 0x00003e38},
	{0x00008014, 0x03e803e8, 0x07d007d0, 0x10801600, 0x08400b00},
	{0x0000801c, 0x128d8027, 0x128d804f, 0x12e00057, 0x12e0002b},
	{0x00008120, 0x08f04800, 0x08f04800, 0x08f04810, 0x08f04810},
	{0x000081d0, 0x00003210, 0x00003210, 0x0000320a, 0x0000320a},
	{0x00008318, 0x00003e80, 0x00007d00, 0x00006880, 0x00003440},
};

static const u32 ar9300_2p2_soc_postamble[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x00007010, 0x00000023, 0x00000023, 0x00000023, 0x00000023},
};

static const u32 ar9300_2p2_baseband_postamble[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x00009810, 0xd00a8005, 0xd00a8005, 0xd00a8011, 0xd00a8011},
	{0x00009820, 0x206a022e, 0x206a022e, 0x206a012e, 0x206a012e},
	{0x00009824, 0x5ac640d0, 0x5ac640d0, 0x5ac640d0, 0x5ac640d0},
	{0x00009828, 0x06903081, 0x06903081, 0x06903881, 0x06903881},
	{0x0000982c, 0x05eea6d4, 0x05eea6d4, 0x05eea6d4, 0x05eea6d4},
	{0x00009830, 0x0000059c, 0x0000059c, 0x0000119c, 0x0000119c},
	{0x00009c00, 0x000000c4, 0x000000c4, 0x000000c4, 0x000000c4},
	{0x00009e00, 0x0372111a, 0x0372111a, 0x037216a0, 0x037216a0},
	{0x00009e04, 0x001c2020, 0x001c2020, 0x001c2020, 0x001c2020},
	{0x00009e0c, 0x6c4000e2, 0x6d4000e2, 0x6d4000e2, 0x6c4000e2},
	{0x00009e10, 0x7ec88d2e, 0x7ec88d2e, 0x7ec84d2e, 0x7ec84d2e},
	{0x00009e14, 0x37b95d5e, 0x37b9605e, 0x3379605e, 0x33795d5e},
	{0x00009e18, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x00009e1c, 0x0001cf9c, 0x0001cf9c, 0x00021f9c, 0x00021f9c},
	{0x00009e20, 0x000003b5, 0x000003b5, 0x000003ce, 0x000003ce},
	{0x00009e2c, 0x0000001c, 0x0000001c, 0x00000021, 0x00000021},
	{0x00009e3c, 0xcf946220, 0xcf946220, 0xcf946222, 0xcf946222},
	{0x00009e44, 0x02321e27, 0x02321e27, 0x02291e27, 0x02291e27},
	{0x00009e48, 0x5030201a, 0x5030201a, 0x50302012, 0x50302012},
	{0x00009fc8, 0x0003f000, 0x0003f000, 0x0001a000, 0x0001a000},
	{0x0000a204, 0x000036c0, 0x000036c4, 0x000036c4, 0x000036c0},
	{0x0000a208, 0x00000104, 0x00000104, 0x00000004, 0x00000004},
	{0x0000a22c, 0x01026a2f, 0x01026a2f, 0x01026a2f, 0x01026a2f},
	{0x0000a230, 0x0000000a, 0x00000014, 0x00000016, 0x0000000b},
	{0x0000a234, 0x00000fff, 0x10000fff, 0x10000fff, 0x00000fff},
	{0x0000a238, 0xffb81018, 0xffb81018, 0xffb81018, 0xffb81018},
	{0x0000a250, 0x00000000, 0x00000000, 0x00000210, 0x00000108},
	{0x0000a254, 0x000007d0, 0x00000fa0, 0x00001130, 0x00000898},
	{0x0000a258, 0x02020002, 0x02020002, 0x02020002, 0x02020002},
	{0x0000a25c, 0x01000e0e, 0x01000e0e, 0x01000e0e, 0x01000e0e},
	{0x0000a260, 0x0a021501, 0x0a021501, 0x3a021501, 0x3a021501},
	{0x0000a264, 0x00000e0e, 0x00000e0e, 0x00000e0e, 0x00000e0e},
	{0x0000a280, 0x00000007, 0x00000007, 0x0000000b, 0x0000000b},
	{0x0000a284, 0x00000000, 0x00000000, 0x00000150, 0x00000150},
	{0x0000a288, 0x00000110, 0x00000110, 0x00000110, 0x00000110},
	{0x0000a28c, 0x00022222, 0x00022222, 0x00022222, 0x00022222},
	{0x0000a2c4, 0x00158d18, 0x00158d18, 0x00158d18, 0x00158d18},
	{0x0000a2d0, 0x00041981, 0x00041981, 0x00041981, 0x00041982},
	{0x0000a2d8, 0x7999a83b, 0x7999a83b, 0x7999a83b, 0x7999a83b},
	{0x0000a358, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a830, 0x0000019c, 0x0000019c, 0x0000019c, 0x0000019c},
	{0x0000ae04, 0x001c0000, 0x001c0000, 0x001c0000, 0x001c0000},
	{0x0000ae18, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000ae1c, 0x0000019c, 0x0000019c, 0x0000019c, 0x0000019c},
	{0x0000ae20, 0x000001b5, 0x000001b5, 0x000001ce, 0x000001ce},
	{0x0000b284, 0x00000000, 0x00000000, 0x00000150, 0x00000150},
	{0x0000b830, 0x0000019c, 0x0000019c, 0x0000019c, 0x0000019c},
	{0x0000be04, 0x001c0000, 0x001c0000, 0x001c0000, 0x001c0000},
	{0x0000be18, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000be1c, 0x0000019c, 0x0000019c, 0x0000019c, 0x0000019c},
	{0x0000be20, 0x000001b5, 0x000001b5, 0x000001ce, 0x000001ce},
	{0x0000c284, 0x00000000, 0x00000000, 0x00000150, 0x00000150},
};

static const u32 ar9300_2p2_baseband_core[][2] = {
	/* Addr      allmodes  */
	{0x00009800, 0xafe68e30},
	{0x00009804, 0xfd14e000},
	{0x00009808, 0x9c0a9f6b},
	{0x0000980c, 0x04900000},
	{0x00009814, 0x9280c00a},
	{0x00009818, 0x00000000},
	{0x0000981c, 0x00020028},
	{0x00009834, 0x6400a290},
	{0x00009838, 0x0108ecff},
	{0x0000983c, 0x0d000600},
	{0x00009880, 0x201fff00},
	{0x00009884, 0x00001042},
	{0x000098a4, 0x00200400},
	{0x000098b0, 0x32840bbe},
	{0x000098d0, 0x004b6a8e},
	{0x000098d4, 0x00000820},
	{0x000098dc, 0x00000000},
	{0x000098f0, 0x00000000},
	{0x000098f4, 0x00000000},
	{0x00009c04, 0xff55ff55},
	{0x00009c08, 0x0320ff55},
	{0x00009c0c, 0x00000000},
	{0x00009c10, 0x00000000},
	{0x00009c14, 0x00046384},
	{0x00009c18, 0x05b6b440},
	{0x00009c1c, 0x00b6b440},
	{0x00009d00, 0xc080a333},
	{0x00009d04, 0x40206c10},
	{0x00009d08, 0x009c4060},
	{0x00009d0c, 0x9883800a},
	{0x00009d10, 0x01834061},
	{0x00009d14, 0x00c0040b},
	{0x00009d18, 0x00000000},
	{0x00009e08, 0x0038230c},
	{0x00009e24, 0x990bb515},
	{0x00009e28, 0x0c6f0000},
	{0x00009e30, 0x06336f77},
	{0x00009e34, 0x6af6532f},
	{0x00009e38, 0x0cc80c00},
	{0x00009e40, 0x0d261820},
	{0x00009e4c, 0x00001004},
	{0x00009e50, 0x00ff03f1},
	{0x00009e54, 0x00000000},
	{0x00009fc0, 0x803e4788},
	{0x00009fc4, 0x0001efb5},
	{0x00009fcc, 0x40000014},
	{0x00009fd0, 0x01193b93},
	{0x0000a20c, 0x00000000},
	{0x0000a220, 0x00000000},
	{0x0000a224, 0x00000000},
	{0x0000a228, 0x10002310},
	{0x0000a23c, 0x00000000},
	{0x0000a244, 0x0c000000},
	{0x0000a2a0, 0x00000001},
	{0x0000a2c0, 0x00000001},
	{0x0000a2c8, 0x00000000},
	{0x0000a2cc, 0x18c43433},
	{0x0000a2d4, 0x00000000},
	{0x0000a2ec, 0x00000000},
	{0x0000a2f0, 0x00000000},
	{0x0000a2f4, 0x00000000},
	{0x0000a2f8, 0x00000000},
	{0x0000a344, 0x00000000},
	{0x0000a34c, 0x00000000},
	{0x0000a350, 0x0000a000},
	{0x0000a364, 0x00000000},
	{0x0000a370, 0x00000000},
	{0x0000a390, 0x00000001},
	{0x0000a394, 0x00000444},
	{0x0000a398, 0x001f0e0f},
	{0x0000a39c, 0x0075393f},
	{0x0000a3a0, 0xb79f6427},
	{0x0000a3a4, 0x00000000},
	{0x0000a3a8, 0xaaaaaaaa},
	{0x0000a3ac, 0x3c466478},
	{0x0000a3c0, 0x20202020},
	{0x0000a3c4, 0x22222220},
	{0x0000a3c8, 0x20200020},
	{0x0000a3cc, 0x20202020},
	{0x0000a3d0, 0x20202020},
	{0x0000a3d4, 0x20202020},
	{0x0000a3d8, 0x20202020},
	{0x0000a3dc, 0x20202020},
	{0x0000a3e0, 0x20202020},
	{0x0000a3e4, 0x20202020},
	{0x0000a3e8, 0x20202020},
	{0x0000a3ec, 0x20202020},
	{0x0000a3f0, 0x00000000},
	{0x0000a3f4, 0x00000246},
	{0x0000a3f8, 0x0c9bd380},
	{0x0000a3fc, 0x000f0f01},
	{0x0000a400, 0x8fa91f01},
	{0x0000a404, 0x00000000},
	{0x0000a408, 0x0e79e5c6},
	{0x0000a40c, 0x00820820},
	{0x0000a414, 0x1ce739ce},
	{0x0000a418, 0x2d001dce},
	{0x0000a41c, 0x1ce739ce},
	{0x0000a420, 0x000001ce},
	{0x0000a424, 0x1ce739ce},
	{0x0000a428, 0x000001ce},
	{0x0000a42c, 0x1ce739ce},
	{0x0000a430, 0x1ce739ce},
	{0x0000a434, 0x00000000},
	{0x0000a438, 0x00001801},
	{0x0000a43c, 0x00100000},
	{0x0000a440, 0x00000000},
	{0x0000a444, 0x00000000},
	{0x0000a448, 0x05000080},
	{0x0000a44c, 0x00000001},
	{0x0000a450, 0x00010000},
	{0x0000a458, 0x00000000},
	{0x0000a640, 0x00000000},
	{0x0000a644, 0x3fad9d74},
	{0x0000a648, 0x0048060a},
	{0x0000a64c, 0x00003c37},
	{0x0000a670, 0x03020100},
	{0x0000a674, 0x09080504},
	{0x0000a678, 0x0d0c0b0a},
	{0x0000a67c, 0x13121110},
	{0x0000a680, 0x31301514},
	{0x0000a684, 0x35343332},
	{0x0000a688, 0x00000036},
	{0x0000a690, 0x00000838},
	{0x0000a7c0, 0x00000000},
	{0x0000a7c4, 0xfffffffc},
	{0x0000a7c8, 0x00000000},
	{0x0000a7cc, 0x00000000},
	{0x0000a7d0, 0x00000000},
	{0x0000a7d4, 0x00000004},
	{0x0000a7dc, 0x00000001},
	{0x0000a8d0, 0x004b6a8e},
	{0x0000a8d4, 0x00000820},
	{0x0000a8dc, 0x00000000},
	{0x0000a8f0, 0x00000000},
	{0x0000a8f4, 0x00000000},
	{0x0000b2d0, 0x00000080},
	{0x0000b2d4, 0x00000000},
	{0x0000b2ec, 0x00000000},
	{0x0000b2f0, 0x00000000},
	{0x0000b2f4, 0x00000000},
	{0x0000b2f8, 0x00000000},
	{0x0000b408, 0x0e79e5c0},
	{0x0000b40c, 0x00820820},
	{0x0000b420, 0x00000000},
	{0x0000b8d0, 0x004b6a8e},
	{0x0000b8d4, 0x00000820},
	{0x0000b8dc, 0x00000000},
	{0x0000b8f0, 0x00000000},
	{0x0000b8f4, 0x00000000},
	{0x0000c2d0, 0x00000080},
	{0x0000c2d4, 0x00000000},
	{0x0000c2ec, 0x00000000},
	{0x0000c2f0, 0x00000000},
	{0x0000c2f4, 0x00000000},
	{0x0000c2f8, 0x00000000},
	{0x0000c408, 0x0e79e5c0},
	{0x0000c40c, 0x00820820},
	{0x0000c420, 0x00000000},
};

static const u32 ar9300Modes_high_power_tx_gain_table_2p2[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x0000a2dc, 0x00033800, 0x00033800, 0x03aaa352, 0x03aaa352},
	{0x0000a2e0, 0x0003c000, 0x0003c000, 0x03ccc584, 0x03ccc584},
	{0x0000a2e4, 0x03fc0000, 0x03fc0000, 0x03f0f800, 0x03f0f800},
	{0x0000a2e8, 0x00000000, 0x00000000, 0x03ff0000, 0x03ff0000},
	{0x0000a410, 0x000050d9, 0x000050d9, 0x000050d9, 0x000050d9},
	{0x0000a500, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a504, 0x06000003, 0x06000003, 0x04000002, 0x04000002},
	{0x0000a508, 0x0a000020, 0x0a000020, 0x08000004, 0x08000004},
	{0x0000a50c, 0x10000023, 0x10000023, 0x0b000200, 0x0b000200},
	{0x0000a510, 0x16000220, 0x16000220, 0x0f000202, 0x0f000202},
	{0x0000a514, 0x1c000223, 0x1c000223, 0x12000400, 0x12000400},
	{0x0000a518, 0x21002220, 0x21002220, 0x16000402, 0x16000402},
	{0x0000a51c, 0x27002223, 0x27002223, 0x19000404, 0x19000404},
	{0x0000a520, 0x2b022220, 0x2b022220, 0x1c000603, 0x1c000603},
	{0x0000a524, 0x2f022222, 0x2f022222, 0x21000a02, 0x21000a02},
	{0x0000a528, 0x34022225, 0x34022225, 0x25000a04, 0x25000a04},
	{0x0000a52c, 0x3a02222a, 0x3a02222a, 0x28000a20, 0x28000a20},
	{0x0000a530, 0x3e02222c, 0x3e02222c, 0x2c000e20, 0x2c000e20},
	{0x0000a534, 0x4202242a, 0x4202242a, 0x30000e22, 0x30000e22},
	{0x0000a538, 0x4702244a, 0x4702244a, 0x34000e24, 0x34000e24},
	{0x0000a53c, 0x4b02244c, 0x4b02244c, 0x38001640, 0x38001640},
	{0x0000a540, 0x4e02246c, 0x4e02246c, 0x3c001660, 0x3c001660},
	{0x0000a544, 0x52022470, 0x52022470, 0x3f001861, 0x3f001861},
	{0x0000a548, 0x55022490, 0x55022490, 0x43001a81, 0x43001a81},
	{0x0000a54c, 0x59022492, 0x59022492, 0x47001a83, 0x47001a83},
	{0x0000a550, 0x5d022692, 0x5d022692, 0x4a001c84, 0x4a001c84},
	{0x0000a554, 0x61022892, 0x61022892, 0x4e001ce3, 0x4e001ce3},
	{0x0000a558, 0x65024890, 0x65024890, 0x52001ce5, 0x52001ce5},
	{0x0000a55c, 0x69024892, 0x69024892, 0x56001ce9, 0x56001ce9},
	{0x0000a560, 0x6e024c92, 0x6e024c92, 0x5a001ceb, 0x5a001ceb},
	{0x0000a564, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a568, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a56c, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a570, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a574, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a578, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a57c, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a580, 0x00800000, 0x00800000, 0x00800000, 0x00800000},
	{0x0000a584, 0x06800003, 0x06800003, 0x04800002, 0x04800002},
	{0x0000a588, 0x0a800020, 0x0a800020, 0x08800004, 0x08800004},
	{0x0000a58c, 0x10800023, 0x10800023, 0x0b800200, 0x0b800200},
	{0x0000a590, 0x16800220, 0x16800220, 0x0f800202, 0x0f800202},
	{0x0000a594, 0x1c800223, 0x1c800223, 0x12800400, 0x12800400},
	{0x0000a598, 0x21802220, 0x21802220, 0x16800402, 0x16800402},
	{0x0000a59c, 0x27802223, 0x27802223, 0x19800404, 0x19800404},
	{0x0000a5a0, 0x2b822220, 0x2b822220, 0x1c800603, 0x1c800603},
	{0x0000a5a4, 0x2f822222, 0x2f822222, 0x21800a02, 0x21800a02},
	{0x0000a5a8, 0x34822225, 0x34822225, 0x25800a04, 0x25800a04},
	{0x0000a5ac, 0x3a82222a, 0x3a82222a, 0x28800a20, 0x28800a20},
	{0x0000a5b0, 0x3e82222c, 0x3e82222c, 0x2c800e20, 0x2c800e20},
	{0x0000a5b4, 0x4282242a, 0x4282242a, 0x30800e22, 0x30800e22},
	{0x0000a5b8, 0x4782244a, 0x4782244a, 0x34800e24, 0x34800e24},
	{0x0000a5bc, 0x4b82244c, 0x4b82244c, 0x38801640, 0x38801640},
	{0x0000a5c0, 0x4e82246c, 0x4e82246c, 0x3c801660, 0x3c801660},
	{0x0000a5c4, 0x52822470, 0x52822470, 0x3f801861, 0x3f801861},
	{0x0000a5c8, 0x55822490, 0x55822490, 0x43801a81, 0x43801a81},
	{0x0000a5cc, 0x59822492, 0x59822492, 0x47801a83, 0x47801a83},
	{0x0000a5d0, 0x5d822692, 0x5d822692, 0x4a801c84, 0x4a801c84},
	{0x0000a5d4, 0x61822892, 0x61822892, 0x4e801ce3, 0x4e801ce3},
	{0x0000a5d8, 0x65824890, 0x65824890, 0x52801ce5, 0x52801ce5},
	{0x0000a5dc, 0x69824892, 0x69824892, 0x56801ce9, 0x56801ce9},
	{0x0000a5e0, 0x6e824c92, 0x6e824c92, 0x5a801ceb, 0x5a801ceb},
	{0x0000a5e4, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5e8, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5ec, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5f0, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5f4, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5f8, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5fc, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a600, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a604, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a608, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a60c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a610, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a614, 0x02004000, 0x02004000, 0x01404000, 0x01404000},
	{0x0000a618, 0x02004801, 0x02004801, 0x01404501, 0x01404501},
	{0x0000a61c, 0x02808a02, 0x02808a02, 0x02008501, 0x02008501},
	{0x0000a620, 0x0380ce03, 0x0380ce03, 0x0280ca03, 0x0280ca03},
	{0x0000a624, 0x04411104, 0x04411104, 0x03010c04, 0x03010c04},
	{0x0000a628, 0x04411104, 0x04411104, 0x04014c04, 0x04014c04},
	{0x0000a62c, 0x04411104, 0x04411104, 0x04015005, 0x04015005},
	{0x0000a630, 0x04411104, 0x04411104, 0x04015005, 0x04015005},
	{0x0000a634, 0x04411104, 0x04411104, 0x04015005, 0x04015005},
	{0x0000a638, 0x04411104, 0x04411104, 0x04015005, 0x04015005},
	{0x0000a63c, 0x04411104, 0x04411104, 0x04015005, 0x04015005},
	{0x0000b2dc, 0x00033800, 0x00033800, 0x03aaa352, 0x03aaa352},
	{0x0000b2e0, 0x0003c000, 0x0003c000, 0x03ccc584, 0x03ccc584},
	{0x0000b2e4, 0x03fc0000, 0x03fc0000, 0x03f0f800, 0x03f0f800},
	{0x0000b2e8, 0x00000000, 0x00000000, 0x03ff0000, 0x03ff0000},
	{0x0000c2dc, 0x00033800, 0x00033800, 0x03aaa352, 0x03aaa352},
	{0x0000c2e0, 0x0003c000, 0x0003c000, 0x03ccc584, 0x03ccc584},
	{0x0000c2e4, 0x03fc0000, 0x03fc0000, 0x03f0f800, 0x03f0f800},
	{0x0000c2e8, 0x00000000, 0x00000000, 0x03ff0000, 0x03ff0000},
	{0x00016044, 0x012492d4, 0x012492d4, 0x012492d4, 0x012492d4},
	{0x00016048, 0x66480001, 0x66480001, 0x66480001, 0x66480001},
	{0x00016068, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c},
	{0x00016444, 0x012492d4, 0x012492d4, 0x012492d4, 0x012492d4},
	{0x00016448, 0x66480001, 0x66480001, 0x66480001, 0x66480001},
	{0x00016468, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c},
	{0x00016844, 0x012492d4, 0x012492d4, 0x012492d4, 0x012492d4},
	{0x00016848, 0x66480001, 0x66480001, 0x66480001, 0x66480001},
	{0x00016868, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c},
};

static const u32 ar9300Modes_high_ob_db_tx_gain_table_2p2[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x0000a2dc, 0x01feee00, 0x01feee00, 0x03aaa352, 0x03aaa352},
	{0x0000a2e0, 0x0000f000, 0x0000f000, 0x03ccc584, 0x03ccc584},
	{0x0000a2e4, 0x01ff0000, 0x01ff0000, 0x03f0f800, 0x03f0f800},
	{0x0000a2e8, 0x00000000, 0x00000000, 0x03ff0000, 0x03ff0000},
	{0x0000a410, 0x000050d8, 0x000050d8, 0x000050d9, 0x000050d9},
	{0x0000a500, 0x00002220, 0x00002220, 0x00000000, 0x00000000},
	{0x0000a504, 0x04002222, 0x04002222, 0x04000002, 0x04000002},
	{0x0000a508, 0x09002421, 0x09002421, 0x08000004, 0x08000004},
	{0x0000a50c, 0x0d002621, 0x0d002621, 0x0b000200, 0x0b000200},
	{0x0000a510, 0x13004620, 0x13004620, 0x0f000202, 0x0f000202},
	{0x0000a514, 0x19004a20, 0x19004a20, 0x11000400, 0x11000400},
	{0x0000a518, 0x1d004e20, 0x1d004e20, 0x15000402, 0x15000402},
	{0x0000a51c, 0x21005420, 0x21005420, 0x19000404, 0x19000404},
	{0x0000a520, 0x26005e20, 0x26005e20, 0x1b000603, 0x1b000603},
	{0x0000a524, 0x2b005e40, 0x2b005e40, 0x1f000a02, 0x1f000a02},
	{0x0000a528, 0x2f005e42, 0x2f005e42, 0x23000a04, 0x23000a04},
	{0x0000a52c, 0x33005e44, 0x33005e44, 0x26000a20, 0x26000a20},
	{0x0000a530, 0x38005e65, 0x38005e65, 0x2a000e20, 0x2a000e20},
	{0x0000a534, 0x3c005e69, 0x3c005e69, 0x2e000e22, 0x2e000e22},
	{0x0000a538, 0x40005e6b, 0x40005e6b, 0x31000e24, 0x31000e24},
	{0x0000a53c, 0x44005e6d, 0x44005e6d, 0x34001640, 0x34001640},
	{0x0000a540, 0x49005e72, 0x49005e72, 0x38001660, 0x38001660},
	{0x0000a544, 0x4e005eb2, 0x4e005eb2, 0x3b001861, 0x3b001861},
	{0x0000a548, 0x53005f12, 0x53005f12, 0x3e001a81, 0x3e001a81},
	{0x0000a54c, 0x59025eb2, 0x59025eb2, 0x42001a83, 0x42001a83},
	{0x0000a550, 0x5e025f12, 0x5e025f12, 0x44001c84, 0x44001c84},
	{0x0000a554, 0x61027f12, 0x61027f12, 0x48001ce3, 0x48001ce3},
	{0x0000a558, 0x6702bf12, 0x6702bf12, 0x4c001ce5, 0x4c001ce5},
	{0x0000a55c, 0x6b02bf14, 0x6b02bf14, 0x50001ce9, 0x50001ce9},
	{0x0000a560, 0x6f02bf16, 0x6f02bf16, 0x54001ceb, 0x54001ceb},
	{0x0000a564, 0x6f02bf16, 0x6f02bf16, 0x56001eec, 0x56001eec},
	{0x0000a568, 0x6f02bf16, 0x6f02bf16, 0x56001eec, 0x56001eec},
	{0x0000a56c, 0x6f02bf16, 0x6f02bf16, 0x56001eec, 0x56001eec},
	{0x0000a570, 0x6f02bf16, 0x6f02bf16, 0x56001eec, 0x56001eec},
	{0x0000a574, 0x6f02bf16, 0x6f02bf16, 0x56001eec, 0x56001eec},
	{0x0000a578, 0x6f02bf16, 0x6f02bf16, 0x56001eec, 0x56001eec},
	{0x0000a57c, 0x6f02bf16, 0x6f02bf16, 0x56001eec, 0x56001eec},
	{0x0000a580, 0x00802220, 0x00802220, 0x00800000, 0x00800000},
	{0x0000a584, 0x04802222, 0x04802222, 0x04800002, 0x04800002},
	{0x0000a588, 0x09802421, 0x09802421, 0x08800004, 0x08800004},
	{0x0000a58c, 0x0d802621, 0x0d802621, 0x0b800200, 0x0b800200},
	{0x0000a590, 0x13804620, 0x13804620, 0x0f800202, 0x0f800202},
	{0x0000a594, 0x19804a20, 0x19804a20, 0x11800400, 0x11800400},
	{0x0000a598, 0x1d804e20, 0x1d804e20, 0x15800402, 0x15800402},
	{0x0000a59c, 0x21805420, 0x21805420, 0x19800404, 0x19800404},
	{0x0000a5a0, 0x26805e20, 0x26805e20, 0x1b800603, 0x1b800603},
	{0x0000a5a4, 0x2b805e40, 0x2b805e40, 0x1f800a02, 0x1f800a02},
	{0x0000a5a8, 0x2f805e42, 0x2f805e42, 0x23800a04, 0x23800a04},
	{0x0000a5ac, 0x33805e44, 0x33805e44, 0x26800a20, 0x26800a20},
	{0x0000a5b0, 0x38805e65, 0x38805e65, 0x2a800e20, 0x2a800e20},
	{0x0000a5b4, 0x3c805e69, 0x3c805e69, 0x2e800e22, 0x2e800e22},
	{0x0000a5b8, 0x40805e6b, 0x40805e6b, 0x31800e24, 0x31800e24},
	{0x0000a5bc, 0x44805e6d, 0x44805e6d, 0x34801640, 0x34801640},
	{0x0000a5c0, 0x49805e72, 0x49805e72, 0x38801660, 0x38801660},
	{0x0000a5c4, 0x4e805eb2, 0x4e805eb2, 0x3b801861, 0x3b801861},
	{0x0000a5c8, 0x53805f12, 0x53805f12, 0x3e801a81, 0x3e801a81},
	{0x0000a5cc, 0x59825eb2, 0x59825eb2, 0x42801a83, 0x42801a83},
	{0x0000a5d0, 0x5e825f12, 0x5e825f12, 0x44801c84, 0x44801c84},
	{0x0000a5d4, 0x61827f12, 0x61827f12, 0x48801ce3, 0x48801ce3},
	{0x0000a5d8, 0x6782bf12, 0x6782bf12, 0x4c801ce5, 0x4c801ce5},
	{0x0000a5dc, 0x6b82bf14, 0x6b82bf14, 0x50801ce9, 0x50801ce9},
	{0x0000a5e0, 0x6f82bf16, 0x6f82bf16, 0x54801ceb, 0x54801ceb},
	{0x0000a5e4, 0x6f82bf16, 0x6f82bf16, 0x56801eec, 0x56801eec},
	{0x0000a5e8, 0x6f82bf16, 0x6f82bf16, 0x56801eec, 0x56801eec},
	{0x0000a5ec, 0x6f82bf16, 0x6f82bf16, 0x56801eec, 0x56801eec},
	{0x0000a5f0, 0x6f82bf16, 0x6f82bf16, 0x56801eec, 0x56801eec},
	{0x0000a5f4, 0x6f82bf16, 0x6f82bf16, 0x56801eec, 0x56801eec},
	{0x0000a5f8, 0x6f82bf16, 0x6f82bf16, 0x56801eec, 0x56801eec},
	{0x0000a5fc, 0x6f82bf16, 0x6f82bf16, 0x56801eec, 0x56801eec},
	{0x0000a600, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a604, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a608, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a60c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a610, 0x00804000, 0x00804000, 0x00000000, 0x00000000},
	{0x0000a614, 0x00804201, 0x00804201, 0x01404000, 0x01404000},
	{0x0000a618, 0x0280c802, 0x0280c802, 0x01404501, 0x01404501},
	{0x0000a61c, 0x0280ca03, 0x0280ca03, 0x02008501, 0x02008501},
	{0x0000a620, 0x04c15104, 0x04c15104, 0x0280ca03, 0x0280ca03},
	{0x0000a624, 0x04c15305, 0x04c15305, 0x03010c04, 0x03010c04},
	{0x0000a628, 0x04c15305, 0x04c15305, 0x04014c04, 0x04014c04},
	{0x0000a62c, 0x04c15305, 0x04c15305, 0x04015005, 0x04015005},
	{0x0000a630, 0x04c15305, 0x04c15305, 0x04015005, 0x04015005},
	{0x0000a634, 0x04c15305, 0x04c15305, 0x04015005, 0x04015005},
	{0x0000a638, 0x04c15305, 0x04c15305, 0x04015005, 0x04015005},
	{0x0000a63c, 0x04c15305, 0x04c15305, 0x04015005, 0x04015005},
	{0x0000b2dc, 0x01feee00, 0x01feee00, 0x03aaa352, 0x03aaa352},
	{0x0000b2e0, 0x0000f000, 0x0000f000, 0x03ccc584, 0x03ccc584},
	{0x0000b2e4, 0x01ff0000, 0x01ff0000, 0x03f0f800, 0x03f0f800},
	{0x0000b2e8, 0x00000000, 0x00000000, 0x03ff0000, 0x03ff0000},
	{0x0000c2dc, 0x01feee00, 0x01feee00, 0x03aaa352, 0x03aaa352},
	{0x0000c2e0, 0x0000f000, 0x0000f000, 0x03ccc584, 0x03ccc584},
	{0x0000c2e4, 0x01ff0000, 0x01ff0000, 0x03f0f800, 0x03f0f800},
	{0x0000c2e8, 0x00000000, 0x00000000, 0x03ff0000, 0x03ff0000},
	{0x00016044, 0x056db2e4, 0x056db2e4, 0x056db2e4, 0x056db2e4},
	{0x00016048, 0x8e480001, 0x8e480001, 0x8e480001, 0x8e480001},
	{0x00016068, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c},
	{0x00016444, 0x056db2e4, 0x056db2e4, 0x056db2e4, 0x056db2e4},
	{0x00016448, 0x8e480001, 0x8e480001, 0x8e480001, 0x8e480001},
	{0x00016468, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c},
	{0x00016844, 0x056db2e4, 0x056db2e4, 0x056db2e4, 0x056db2e4},
	{0x00016848, 0x8e480001, 0x8e480001, 0x8e480001, 0x8e480001},
	{0x00016868, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c},
};

static const u32 ar9300Common_rx_gain_table_2p2[][2] = {
	/* Addr      allmodes  */
	{0x0000a000, 0x00010000},
	{0x0000a004, 0x00030002},
	{0x0000a008, 0x00050004},
	{0x0000a00c, 0x00810080},
	{0x0000a010, 0x00830082},
	{0x0000a014, 0x01810180},
	{0x0000a018, 0x01830182},
	{0x0000a01c, 0x01850184},
	{0x0000a020, 0x01890188},
	{0x0000a024, 0x018b018a},
	{0x0000a028, 0x018d018c},
	{0x0000a02c, 0x01910190},
	{0x0000a030, 0x01930192},
	{0x0000a034, 0x01950194},
	{0x0000a038, 0x038a0196},
	{0x0000a03c, 0x038c038b},
	{0x0000a040, 0x0390038d},
	{0x0000a044, 0x03920391},
	{0x0000a048, 0x03940393},
	{0x0000a04c, 0x03960395},
	{0x0000a050, 0x00000000},
	{0x0000a054, 0x00000000},
	{0x0000a058, 0x00000000},
	{0x0000a05c, 0x00000000},
	{0x0000a060, 0x00000000},
	{0x0000a064, 0x00000000},
	{0x0000a068, 0x00000000},
	{0x0000a06c, 0x00000000},
	{0x0000a070, 0x00000000},
	{0x0000a074, 0x00000000},
	{0x0000a078, 0x00000000},
	{0x0000a07c, 0x00000000},
	{0x0000a080, 0x1a1a1a1a},
	{0x0000a084, 0x1a1a1a1a},
	{0x0000a088, 0x1a1a1a1a},
	{0x0000a08c, 0x1a1a1a1a},
	{0x0000a090, 0x171a1a1a},
	{0x0000a094, 0x11111717},
	{0x0000a098, 0x00030311},
	{0x0000a09c, 0x00000000},
	{0x0000a0a0, 0x00000000},
	{0x0000a0a4, 0x00000000},
	{0x0000a0a8, 0x00000000},
	{0x0000a0ac, 0x00000000},
	{0x0000a0b0, 0x00000000},
	{0x0000a0b4, 0x00000000},
	{0x0000a0b8, 0x00000000},
	{0x0000a0bc, 0x00000000},
	{0x0000a0c0, 0x001f0000},
	{0x0000a0c4, 0x01000101},
	{0x0000a0c8, 0x011e011f},
	{0x0000a0cc, 0x011c011d},
	{0x0000a0d0, 0x02030204},
	{0x0000a0d4, 0x02010202},
	{0x0000a0d8, 0x021f0200},
	{0x0000a0dc, 0x0302021e},
	{0x0000a0e0, 0x03000301},
	{0x0000a0e4, 0x031e031f},
	{0x0000a0e8, 0x0402031d},
	{0x0000a0ec, 0x04000401},
	{0x0000a0f0, 0x041e041f},
	{0x0000a0f4, 0x0502041d},
	{0x0000a0f8, 0x05000501},
	{0x0000a0fc, 0x051e051f},
	{0x0000a100, 0x06010602},
	{0x0000a104, 0x061f0600},
	{0x0000a108, 0x061d061e},
	{0x0000a10c, 0x07020703},
	{0x0000a110, 0x07000701},
	{0x0000a114, 0x00000000},
	{0x0000a118, 0x00000000},
	{0x0000a11c, 0x00000000},
	{0x0000a120, 0x00000000},
	{0x0000a124, 0x00000000},
	{0x0000a128, 0x00000000},
	{0x0000a12c, 0x00000000},
	{0x0000a130, 0x00000000},
	{0x0000a134, 0x00000000},
	{0x0000a138, 0x00000000},
	{0x0000a13c, 0x00000000},
	{0x0000a140, 0x001f0000},
	{0x0000a144, 0x01000101},
	{0x0000a148, 0x011e011f},
	{0x0000a14c, 0x011c011d},
	{0x0000a150, 0x02030204},
	{0x0000a154, 0x02010202},
	{0x0000a158, 0x021f0200},
	{0x0000a15c, 0x0302021e},
	{0x0000a160, 0x03000301},
	{0x0000a164, 0x031e031f},
	{0x0000a168, 0x0402031d},
	{0x0000a16c, 0x04000401},
	{0x0000a170, 0x041e041f},
	{0x0000a174, 0x0502041d},
	{0x0000a178, 0x05000501},
	{0x0000a17c, 0x051e051f},
	{0x0000a180, 0x06010602},
	{0x0000a184, 0x061f0600},
	{0x0000a188, 0x061d061e},
	{0x0000a18c, 0x07020703},
	{0x0000a190, 0x07000701},
	{0x0000a194, 0x00000000},
	{0x0000a198, 0x00000000},
	{0x0000a19c, 0x00000000},
	{0x0000a1a0, 0x00000000},
	{0x0000a1a4, 0x00000000},
	{0x0000a1a8, 0x00000000},
	{0x0000a1ac, 0x00000000},
	{0x0000a1b0, 0x00000000},
	{0x0000a1b4, 0x00000000},
	{0x0000a1b8, 0x00000000},
	{0x0000a1bc, 0x00000000},
	{0x0000a1c0, 0x00000000},
	{0x0000a1c4, 0x00000000},
	{0x0000a1c8, 0x00000000},
	{0x0000a1cc, 0x00000000},
	{0x0000a1d0, 0x00000000},
	{0x0000a1d4, 0x00000000},
	{0x0000a1d8, 0x00000000},
	{0x0000a1dc, 0x00000000},
	{0x0000a1e0, 0x00000000},
	{0x0000a1e4, 0x00000000},
	{0x0000a1e8, 0x00000000},
	{0x0000a1ec, 0x00000000},
	{0x0000a1f0, 0x00000396},
	{0x0000a1f4, 0x00000396},
	{0x0000a1f8, 0x00000396},
	{0x0000a1fc, 0x00000196},
	{0x0000b000, 0x00010000},
	{0x0000b004, 0x00030002},
	{0x0000b008, 0x00050004},
	{0x0000b00c, 0x00810080},
	{0x0000b010, 0x00830082},
	{0x0000b014, 0x01810180},
	{0x0000b018, 0x01830182},
	{0x0000b01c, 0x01850184},
	{0x0000b020, 0x02810280},
	{0x0000b024, 0x02830282},
	{0x0000b028, 0x02850284},
	{0x0000b02c, 0x02890288},
	{0x0000b030, 0x028b028a},
	{0x0000b034, 0x0388028c},
	{0x0000b038, 0x038a0389},
	{0x0000b03c, 0x038c038b},
	{0x0000b040, 0x0390038d},
	{0x0000b044, 0x03920391},
	{0x0000b048, 0x03940393},
	{0x0000b04c, 0x03960395},
	{0x0000b050, 0x00000000},
	{0x0000b054, 0x00000000},
	{0x0000b058, 0x00000000},
	{0x0000b05c, 0x00000000},
	{0x0000b060, 0x00000000},
	{0x0000b064, 0x00000000},
	{0x0000b068, 0x00000000},
	{0x0000b06c, 0x00000000},
	{0x0000b070, 0x00000000},
	{0x0000b074, 0x00000000},
	{0x0000b078, 0x00000000},
	{0x0000b07c, 0x00000000},
	{0x0000b080, 0x2a2d2f32},
	{0x0000b084, 0x21232328},
	{0x0000b088, 0x19191c1e},
	{0x0000b08c, 0x12141417},
	{0x0000b090, 0x07070e0e},
	{0x0000b094, 0x03030305},
	{0x0000b098, 0x00000003},
	{0x0000b09c, 0x00000000},
	{0x0000b0a0, 0x00000000},
	{0x0000b0a4, 0x00000000},
	{0x0000b0a8, 0x00000000},
	{0x0000b0ac, 0x00000000},
	{0x0000b0b0, 0x00000000},
	{0x0000b0b4, 0x00000000},
	{0x0000b0b8, 0x00000000},
	{0x0000b0bc, 0x00000000},
	{0x0000b0c0, 0x003f0020},
	{0x0000b0c4, 0x00400041},
	{0x0000b0c8, 0x0140005f},
	{0x0000b0cc, 0x0160015f},
	{0x0000b0d0, 0x017e017f},
	{0x0000b0d4, 0x02410242},
	{0x0000b0d8, 0x025f0240},
	{0x0000b0dc, 0x027f0260},
	{0x0000b0e0, 0x0341027e},
	{0x0000b0e4, 0x035f0340},
	{0x0000b0e8, 0x037f0360},
	{0x0000b0ec, 0x04400441},
	{0x0000b0f0, 0x0460045f},
	{0x0000b0f4, 0x0541047f},
	{0x0000b0f8, 0x055f0540},
	{0x0000b0fc, 0x057f0560},
	{0x0000b100, 0x06400641},
	{0x0000b104, 0x0660065f},
	{0x0000b108, 0x067e067f},
	{0x0000b10c, 0x07410742},
	{0x0000b110, 0x075f0740},
	{0x0000b114, 0x077f0760},
	{0x0000b118, 0x07800781},
	{0x0000b11c, 0x07a0079f},
	{0x0000b120, 0x07c107bf},
	{0x0000b124, 0x000007c0},
	{0x0000b128, 0x00000000},
	{0x0000b12c, 0x00000000},
	{0x0000b130, 0x00000000},
	{0x0000b134, 0x00000000},
	{0x0000b138, 0x00000000},
	{0x0000b13c, 0x00000000},
	{0x0000b140, 0x003f0020},
	{0x0000b144, 0x00400041},
	{0x0000b148, 0x0140005f},
	{0x0000b14c, 0x0160015f},
	{0x0000b150, 0x017e017f},
	{0x0000b154, 0x02410242},
	{0x0000b158, 0x025f0240},
	{0x0000b15c, 0x027f0260},
	{0x0000b160, 0x0341027e},
	{0x0000b164, 0x035f0340},
	{0x0000b168, 0x037f0360},
	{0x0000b16c, 0x04400441},
	{0x0000b170, 0x0460045f},
	{0x0000b174, 0x0541047f},
	{0x0000b178, 0x055f0540},
	{0x0000b17c, 0x057f0560},
	{0x0000b180, 0x06400641},
	{0x0000b184, 0x0660065f},
	{0x0000b188, 0x067e067f},
	{0x0000b18c, 0x07410742},
	{0x0000b190, 0x075f0740},
	{0x0000b194, 0x077f0760},
	{0x0000b198, 0x07800781},
	{0x0000b19c, 0x07a0079f},
	{0x0000b1a0, 0x07c107bf},
	{0x0000b1a4, 0x000007c0},
	{0x0000b1a8, 0x00000000},
	{0x0000b1ac, 0x00000000},
	{0x0000b1b0, 0x00000000},
	{0x0000b1b4, 0x00000000},
	{0x0000b1b8, 0x00000000},
	{0x0000b1bc, 0x00000000},
	{0x0000b1c0, 0x00000000},
	{0x0000b1c4, 0x00000000},
	{0x0000b1c8, 0x00000000},
	{0x0000b1cc, 0x00000000},
	{0x0000b1d0, 0x00000000},
	{0x0000b1d4, 0x00000000},
	{0x0000b1d8, 0x00000000},
	{0x0000b1dc, 0x00000000},
	{0x0000b1e0, 0x00000000},
	{0x0000b1e4, 0x00000000},
	{0x0000b1e8, 0x00000000},
	{0x0000b1ec, 0x00000000},
	{0x0000b1f0, 0x00000396},
	{0x0000b1f4, 0x00000396},
	{0x0000b1f8, 0x00000396},
	{0x0000b1fc, 0x00000196},
};

static const u32 ar9300Modes_low_ob_db_tx_gain_table_2p2[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x0000a2dc, 0x00033800, 0x00033800, 0x03aaa352, 0x03aaa352},
	{0x0000a2e0, 0x0003c000, 0x0003c000, 0x03ccc584, 0x03ccc584},
	{0x0000a2e4, 0x03fc0000, 0x03fc0000, 0x03f0f800, 0x03f0f800},
	{0x0000a2e8, 0x00000000, 0x00000000, 0x03ff0000, 0x03ff0000},
	{0x0000a410, 0x000050d9, 0x000050d9, 0x000050d9, 0x000050d9},
	{0x0000a500, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a504, 0x06000003, 0x06000003, 0x04000002, 0x04000002},
	{0x0000a508, 0x0a000020, 0x0a000020, 0x08000004, 0x08000004},
	{0x0000a50c, 0x10000023, 0x10000023, 0x0b000200, 0x0b000200},
	{0x0000a510, 0x16000220, 0x16000220, 0x0f000202, 0x0f000202},
	{0x0000a514, 0x1c000223, 0x1c000223, 0x12000400, 0x12000400},
	{0x0000a518, 0x21002220, 0x21002220, 0x16000402, 0x16000402},
	{0x0000a51c, 0x27002223, 0x27002223, 0x19000404, 0x19000404},
	{0x0000a520, 0x2b022220, 0x2b022220, 0x1c000603, 0x1c000603},
	{0x0000a524, 0x2f022222, 0x2f022222, 0x21000a02, 0x21000a02},
	{0x0000a528, 0x34022225, 0x34022225, 0x25000a04, 0x25000a04},
	{0x0000a52c, 0x3a02222a, 0x3a02222a, 0x28000a20, 0x28000a20},
	{0x0000a530, 0x3e02222c, 0x3e02222c, 0x2c000e20, 0x2c000e20},
	{0x0000a534, 0x4202242a, 0x4202242a, 0x30000e22, 0x30000e22},
	{0x0000a538, 0x4702244a, 0x4702244a, 0x34000e24, 0x34000e24},
	{0x0000a53c, 0x4b02244c, 0x4b02244c, 0x38001640, 0x38001640},
	{0x0000a540, 0x4e02246c, 0x4e02246c, 0x3c001660, 0x3c001660},
	{0x0000a544, 0x52022470, 0x52022470, 0x3f001861, 0x3f001861},
	{0x0000a548, 0x55022490, 0x55022490, 0x43001a81, 0x43001a81},
	{0x0000a54c, 0x59022492, 0x59022492, 0x47001a83, 0x47001a83},
	{0x0000a550, 0x5d022692, 0x5d022692, 0x4a001c84, 0x4a001c84},
	{0x0000a554, 0x61022892, 0x61022892, 0x4e001ce3, 0x4e001ce3},
	{0x0000a558, 0x65024890, 0x65024890, 0x52001ce5, 0x52001ce5},
	{0x0000a55c, 0x69024892, 0x69024892, 0x56001ce9, 0x56001ce9},
	{0x0000a560, 0x6e024c92, 0x6e024c92, 0x5a001ceb, 0x5a001ceb},
	{0x0000a564, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a568, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a56c, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a570, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a574, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a578, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a57c, 0x74026e92, 0x74026e92, 0x5d001eec, 0x5d001eec},
	{0x0000a580, 0x00800000, 0x00800000, 0x00800000, 0x00800000},
	{0x0000a584, 0x06800003, 0x06800003, 0x04800002, 0x04800002},
	{0x0000a588, 0x0a800020, 0x0a800020, 0x08800004, 0x08800004},
	{0x0000a58c, 0x10800023, 0x10800023, 0x0b800200, 0x0b800200},
	{0x0000a590, 0x16800220, 0x16800220, 0x0f800202, 0x0f800202},
	{0x0000a594, 0x1c800223, 0x1c800223, 0x12800400, 0x12800400},
	{0x0000a598, 0x21802220, 0x21802220, 0x16800402, 0x16800402},
	{0x0000a59c, 0x27802223, 0x27802223, 0x19800404, 0x19800404},
	{0x0000a5a0, 0x2b822220, 0x2b822220, 0x1c800603, 0x1c800603},
	{0x0000a5a4, 0x2f822222, 0x2f822222, 0x21800a02, 0x21800a02},
	{0x0000a5a8, 0x34822225, 0x34822225, 0x25800a04, 0x25800a04},
	{0x0000a5ac, 0x3a82222a, 0x3a82222a, 0x28800a20, 0x28800a20},
	{0x0000a5b0, 0x3e82222c, 0x3e82222c, 0x2c800e20, 0x2c800e20},
	{0x0000a5b4, 0x4282242a, 0x4282242a, 0x30800e22, 0x30800e22},
	{0x0000a5b8, 0x4782244a, 0x4782244a, 0x34800e24, 0x34800e24},
	{0x0000a5bc, 0x4b82244c, 0x4b82244c, 0x38801640, 0x38801640},
	{0x0000a5c0, 0x4e82246c, 0x4e82246c, 0x3c801660, 0x3c801660},
	{0x0000a5c4, 0x52822470, 0x52822470, 0x3f801861, 0x3f801861},
	{0x0000a5c8, 0x55822490, 0x55822490, 0x43801a81, 0x43801a81},
	{0x0000a5cc, 0x59822492, 0x59822492, 0x47801a83, 0x47801a83},
	{0x0000a5d0, 0x5d822692, 0x5d822692, 0x4a801c84, 0x4a801c84},
	{0x0000a5d4, 0x61822892, 0x61822892, 0x4e801ce3, 0x4e801ce3},
	{0x0000a5d8, 0x65824890, 0x65824890, 0x52801ce5, 0x52801ce5},
	{0x0000a5dc, 0x69824892, 0x69824892, 0x56801ce9, 0x56801ce9},
	{0x0000a5e0, 0x6e824c92, 0x6e824c92, 0x5a801ceb, 0x5a801ceb},
	{0x0000a5e4, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5e8, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5ec, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5f0, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5f4, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5f8, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a5fc, 0x74826e92, 0x74826e92, 0x5d801eec, 0x5d801eec},
	{0x0000a600, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a604, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a608, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a60c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a610, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a614, 0x02004000, 0x02004000, 0x01404000, 0x01404000},
	{0x0000a618, 0x02004801, 0x02004801, 0x01404501, 0x01404501},
	{0x0000a61c, 0x02808a02, 0x02808a02, 0x02008501, 0x02008501},
	{0x0000a620, 0x0380ce03, 0x0380ce03, 0x0280ca03, 0x0280ca03},
	{0x0000a624, 0x04411104, 0x04411104, 0x03010c04, 0x03010c04},
	{0x0000a628, 0x04411104, 0x04411104, 0x04014c04, 0x04014c04},
	{0x0000a62c, 0x04411104, 0x04411104, 0x04015005, 0x04015005},
	{0x0000a630, 0x04411104, 0x04411104, 0x04015005, 0x04015005},
	{0x0000a634, 0x04411104, 0x04411104, 0x04015005, 0x04015005},
	{0x0000a638, 0x04411104, 0x04411104, 0x04015005, 0x04015005},
	{0x0000a63c, 0x04411104, 0x04411104, 0x04015005, 0x04015005},
	{0x0000b2dc, 0x00033800, 0x00033800, 0x03aaa352, 0x03aaa352},
	{0x0000b2e0, 0x0003c000, 0x0003c000, 0x03ccc584, 0x03ccc584},
	{0x0000b2e4, 0x03fc0000, 0x03fc0000, 0x03f0f800, 0x03f0f800},
	{0x0000b2e8, 0x00000000, 0x00000000, 0x03ff0000, 0x03ff0000},
	{0x0000c2dc, 0x00033800, 0x00033800, 0x03aaa352, 0x03aaa352},
	{0x0000c2e0, 0x0003c000, 0x0003c000, 0x03ccc584, 0x03ccc584},
	{0x0000c2e4, 0x03fc0000, 0x03fc0000, 0x03f0f800, 0x03f0f800},
	{0x0000c2e8, 0x00000000, 0x00000000, 0x03ff0000, 0x03ff0000},
	{0x00016044, 0x012492d4, 0x012492d4, 0x012492d4, 0x012492d4},
	{0x00016048, 0x66480001, 0x66480001, 0x66480001, 0x66480001},
	{0x00016068, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c},
	{0x00016444, 0x012492d4, 0x012492d4, 0x012492d4, 0x012492d4},
	{0x00016448, 0x66480001, 0x66480001, 0x66480001, 0x66480001},
	{0x00016468, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c},
	{0x00016844, 0x012492d4, 0x012492d4, 0x012492d4, 0x012492d4},
	{0x00016848, 0x66480001, 0x66480001, 0x66480001, 0x66480001},
	{0x00016868, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c, 0x6db6db6c},
};

static const u32 ar9300_2p2_mac_core[][2] = {
	/* Addr      allmodes  */
	{0x00000008, 0x00000000},
	{0x00000030, 0x00020085},
	{0x00000034, 0x00000005},
	{0x00000040, 0x00000000},
	{0x00000044, 0x00000000},
	{0x00000048, 0x00000008},
	{0x0000004c, 0x00000010},
	{0x00000050, 0x00000000},
	{0x00001040, 0x002ffc0f},
	{0x00001044, 0x002ffc0f},
	{0x00001048, 0x002ffc0f},
	{0x0000104c, 0x002ffc0f},
	{0x00001050, 0x002ffc0f},
	{0x00001054, 0x002ffc0f},
	{0x00001058, 0x002ffc0f},
	{0x0000105c, 0x002ffc0f},
	{0x00001060, 0x002ffc0f},
	{0x00001064, 0x002ffc0f},
	{0x000010f0, 0x00000100},
	{0x00001270, 0x00000000},
	{0x000012b0, 0x00000000},
	{0x000012f0, 0x00000000},
	{0x0000143c, 0x00000000},
	{0x0000147c, 0x00000000},
	{0x00008000, 0x00000000},
	{0x00008004, 0x00000000},
	{0x00008008, 0x00000000},
	{0x0000800c, 0x00000000},
	{0x00008018, 0x00000000},
	{0x00008020, 0x00000000},
	{0x00008038, 0x00000000},
	{0x0000803c, 0x00000000},
	{0x00008040, 0x00000000},
	{0x00008044, 0x00000000},
	{0x00008048, 0x00000000},
	{0x0000804c, 0xffffffff},
	{0x00008054, 0x00000000},
	{0x00008058, 0x00000000},
	{0x0000805c, 0x000fc78f},
	{0x00008060, 0x0000000f},
	{0x00008064, 0x00000000},
	{0x00008070, 0x00000310},
	{0x00008074, 0x00000020},
	{0x00008078, 0x00000000},
	{0x0000809c, 0x0000000f},
	{0x000080a0, 0x00000000},
	{0x000080a4, 0x02ff0000},
	{0x000080a8, 0x0e070605},
	{0x000080ac, 0x0000000d},
	{0x000080b0, 0x00000000},
	{0x000080b4, 0x00000000},
	{0x000080b8, 0x00000000},
	{0x000080bc, 0x00000000},
	{0x000080c0, 0x2a800000},
	{0x000080c4, 0x06900168},
	{0x000080c8, 0x13881c20},
	{0x000080cc, 0x01f40000},
	{0x000080d0, 0x00252500},
	{0x000080d4, 0x00a00000},
	{0x000080d8, 0x00400000},
	{0x000080dc, 0x00000000},
	{0x000080e0, 0xffffffff},
	{0x000080e4, 0x0000ffff},
	{0x000080e8, 0x3f3f3f3f},
	{0x000080ec, 0x00000000},
	{0x000080f0, 0x00000000},
	{0x000080f4, 0x00000000},
	{0x000080fc, 0x00020000},
	{0x00008100, 0x00000000},
	{0x00008108, 0x00000052},
	{0x0000810c, 0x00000000},
	{0x00008110, 0x00000000},
	{0x00008114, 0x000007ff},
	{0x00008118, 0x000000aa},
	{0x0000811c, 0x00003210},
	{0x00008124, 0x00000000},
	{0x00008128, 0x00000000},
	{0x0000812c, 0x00000000},
	{0x00008130, 0x00000000},
	{0x00008134, 0x00000000},
	{0x00008138, 0x00000000},
	{0x0000813c, 0x0000ffff},
	{0x00008144, 0xffffffff},
	{0x00008168, 0x00000000},
	{0x0000816c, 0x00000000},
	{0x000081c0, 0x00000000},
	{0x000081c4, 0x33332210},
	{0x000081ec, 0x00000000},
	{0x000081f0, 0x00000000},
	{0x000081f4, 0x00000000},
	{0x000081f8, 0x00000000},
	{0x000081fc, 0x00000000},
	{0x00008240, 0x00100000},
	{0x00008244, 0x0010f424},
	{0x00008248, 0x00000800},
	{0x0000824c, 0x0001e848},
	{0x00008250, 0x00000000},
	{0x00008254, 0x00000000},
	{0x00008258, 0x00000000},
	{0x0000825c, 0x40000000},
	{0x00008260, 0x00080922},
	{0x00008264, 0x9d400010},
	{0x00008268, 0xffffffff},
	{0x0000826c, 0x0000ffff},
	{0x00008270, 0x00000000},
	{0x00008274, 0x40000000},
	{0x00008278, 0x003e4180},
	{0x0000827c, 0x00000004},
	{0x00008284, 0x0000002c},
	{0x00008288, 0x0000002c},
	{0x0000828c, 0x000000ff},
	{0x00008294, 0x00000000},
	{0x00008298, 0x00000000},
	{0x0000829c, 0x00000000},
	{0x00008300, 0x00000140},
	{0x00008314, 0x00000000},
	{0x0000831c, 0x0000010d},
	{0x00008328, 0x00000000},
	{0x0000832c, 0x00000007},
	{0x00008330, 0x00000302},
	{0x00008334, 0x00000700},
	{0x00008338, 0x00ff0000},
	{0x0000833c, 0x02400000},
	{0x00008340, 0x000107ff},
	{0x00008344, 0xaa48105b},
	{0x00008348, 0x008f0000},
	{0x0000835c, 0x00000000},
	{0x00008360, 0xffffffff},
	{0x00008364, 0xffffffff},
	{0x00008368, 0x00000000},
	{0x00008370, 0x00000000},
	{0x00008374, 0x000000ff},
	{0x00008378, 0x00000000},
	{0x0000837c, 0x00000000},
	{0x00008380, 0xffffffff},
	{0x00008384, 0xffffffff},
	{0x00008390, 0xffffffff},
	{0x00008394, 0xffffffff},
	{0x00008398, 0x00000000},
	{0x0000839c, 0x00000000},
	{0x000083a0, 0x00000000},
	{0x000083a4, 0x0000fa14},
	{0x000083a8, 0x000f0c00},
	{0x000083ac, 0x33332210},
	{0x000083b0, 0x33332210},
	{0x000083b4, 0x33332210},
	{0x000083b8, 0x33332210},
	{0x000083bc, 0x00000000},
	{0x000083c0, 0x00000000},
	{0x000083c4, 0x00000000},
	{0x000083c8, 0x00000000},
	{0x000083cc, 0x00000200},
	{0x000083d0, 0x000301ff},
};

static const u32 ar9300Common_wo_xlna_rx_gain_table_2p2[][2] = {
	/* Addr      allmodes  */
	{0x0000a000, 0x00010000},
	{0x0000a004, 0x00030002},
	{0x0000a008, 0x00050004},
	{0x0000a00c, 0x00810080},
	{0x0000a010, 0x00830082},
	{0x0000a014, 0x01810180},
	{0x0000a018, 0x01830182},
	{0x0000a01c, 0x01850184},
	{0x0000a020, 0x01890188},
	{0x0000a024, 0x018b018a},
	{0x0000a028, 0x018d018c},
	{0x0000a02c, 0x03820190},
	{0x0000a030, 0x03840383},
	{0x0000a034, 0x03880385},
	{0x0000a038, 0x038a0389},
	{0x0000a03c, 0x038c038b},
	{0x0000a040, 0x0390038d},
	{0x0000a044, 0x03920391},
	{0x0000a048, 0x03940393},
	{0x0000a04c, 0x03960395},
	{0x0000a050, 0x00000000},
	{0x0000a054, 0x00000000},
	{0x0000a058, 0x00000000},
	{0x0000a05c, 0x00000000},
	{0x0000a060, 0x00000000},
	{0x0000a064, 0x00000000},
	{0x0000a068, 0x00000000},
	{0x0000a06c, 0x00000000},
	{0x0000a070, 0x00000000},
	{0x0000a074, 0x00000000},
	{0x0000a078, 0x00000000},
	{0x0000a07c, 0x00000000},
	{0x0000a080, 0x29292929},
	{0x0000a084, 0x29292929},
	{0x0000a088, 0x29292929},
	{0x0000a08c, 0x29292929},
	{0x0000a090, 0x22292929},
	{0x0000a094, 0x1d1d2222},
	{0x0000a098, 0x0c111117},
	{0x0000a09c, 0x00030303},
	{0x0000a0a0, 0x00000000},
	{0x0000a0a4, 0x00000000},
	{0x0000a0a8, 0x00000000},
	{0x0000a0ac, 0x00000000},
	{0x0000a0b0, 0x00000000},
	{0x0000a0b4, 0x00000000},
	{0x0000a0b8, 0x00000000},
	{0x0000a0bc, 0x00000000},
	{0x0000a0c0, 0x001f0000},
	{0x0000a0c4, 0x01000101},
	{0x0000a0c8, 0x011e011f},
	{0x0000a0cc, 0x011c011d},
	{0x0000a0d0, 0x02030204},
	{0x0000a0d4, 0x02010202},
	{0x0000a0d8, 0x021f0200},
	{0x0000a0dc, 0x0302021e},
	{0x0000a0e0, 0x03000301},
	{0x0000a0e4, 0x031e031f},
	{0x0000a0e8, 0x0402031d},
	{0x0000a0ec, 0x04000401},
	{0x0000a0f0, 0x041e041f},
	{0x0000a0f4, 0x0502041d},
	{0x0000a0f8, 0x05000501},
	{0x0000a0fc, 0x051e051f},
	{0x0000a100, 0x06010602},
	{0x0000a104, 0x061f0600},
	{0x0000a108, 0x061d061e},
	{0x0000a10c, 0x07020703},
	{0x0000a110, 0x07000701},
	{0x0000a114, 0x00000000},
	{0x0000a118, 0x00000000},
	{0x0000a11c, 0x00000000},
	{0x0000a120, 0x00000000},
	{0x0000a124, 0x00000000},
	{0x0000a128, 0x00000000},
	{0x0000a12c, 0x00000000},
	{0x0000a130, 0x00000000},
	{0x0000a134, 0x00000000},
	{0x0000a138, 0x00000000},
	{0x0000a13c, 0x00000000},
	{0x0000a140, 0x001f0000},
	{0x0000a144, 0x01000101},
	{0x0000a148, 0x011e011f},
	{0x0000a14c, 0x011c011d},
	{0x0000a150, 0x02030204},
	{0x0000a154, 0x02010202},
	{0x0000a158, 0x021f0200},
	{0x0000a15c, 0x0302021e},
	{0x0000a160, 0x03000301},
	{0x0000a164, 0x031e031f},
	{0x0000a168, 0x0402031d},
	{0x0000a16c, 0x04000401},
	{0x0000a170, 0x041e041f},
	{0x0000a174, 0x0502041d},
	{0x0000a178, 0x05000501},
	{0x0000a17c, 0x051e051f},
	{0x0000a180, 0x06010602},
	{0x0000a184, 0x061f0600},
	{0x0000a188, 0x061d061e},
	{0x0000a18c, 0x07020703},
	{0x0000a190, 0x07000701},
	{0x0000a194, 0x00000000},
	{0x0000a198, 0x00000000},
	{0x0000a19c, 0x00000000},
	{0x0000a1a0, 0x00000000},
	{0x0000a1a4, 0x00000000},
	{0x0000a1a8, 0x00000000},
	{0x0000a1ac, 0x00000000},
	{0x0000a1b0, 0x00000000},
	{0x0000a1b4, 0x00000000},
	{0x0000a1b8, 0x00000000},
	{0x0000a1bc, 0x00000000},
	{0x0000a1c0, 0x00000000},
	{0x0000a1c4, 0x00000000},
	{0x0000a1c8, 0x00000000},
	{0x0000a1cc, 0x00000000},
	{0x0000a1d0, 0x00000000},
	{0x0000a1d4, 0x00000000},
	{0x0000a1d8, 0x00000000},
	{0x0000a1dc, 0x00000000},
	{0x0000a1e0, 0x00000000},
	{0x0000a1e4, 0x00000000},
	{0x0000a1e8, 0x00000000},
	{0x0000a1ec, 0x00000000},
	{0x0000a1f0, 0x00000396},
	{0x0000a1f4, 0x00000396},
	{0x0000a1f8, 0x00000396},
	{0x0000a1fc, 0x00000196},
	{0x0000b000, 0x00010000},
	{0x0000b004, 0x00030002},
	{0x0000b008, 0x00050004},
	{0x0000b00c, 0x00810080},
	{0x0000b010, 0x00830082},
	{0x0000b014, 0x01810180},
	{0x0000b018, 0x01830182},
	{0x0000b01c, 0x01850184},
	{0x0000b020, 0x02810280},
	{0x0000b024, 0x02830282},
	{0x0000b028, 0x02850284},
	{0x0000b02c, 0x02890288},
	{0x0000b030, 0x028b028a},
	{0x0000b034, 0x0388028c},
	{0x0000b038, 0x038a0389},
	{0x0000b03c, 0x038c038b},
	{0x0000b040, 0x0390038d},
	{0x0000b044, 0x03920391},
	{0x0000b048, 0x03940393},
	{0x0000b04c, 0x03960395},
	{0x0000b050, 0x00000000},
	{0x0000b054, 0x00000000},
	{0x0000b058, 0x00000000},
	{0x0000b05c, 0x00000000},
	{0x0000b060, 0x00000000},
	{0x0000b064, 0x00000000},
	{0x0000b068, 0x00000000},
	{0x0000b06c, 0x00000000},
	{0x0000b070, 0x00000000},
	{0x0000b074, 0x00000000},
	{0x0000b078, 0x00000000},
	{0x0000b07c, 0x00000000},
	{0x0000b080, 0x32323232},
	{0x0000b084, 0x2f2f3232},
	{0x0000b088, 0x23282a2d},
	{0x0000b08c, 0x1c1e2123},
	{0x0000b090, 0x14171919},
	{0x0000b094, 0x0e0e1214},
	{0x0000b098, 0x03050707},
	{0x0000b09c, 0x00030303},
	{0x0000b0a0, 0x00000000},
	{0x0000b0a4, 0x00000000},
	{0x0000b0a8, 0x00000000},
	{0x0000b0ac, 0x00000000},
	{0x0000b0b0, 0x00000000},
	{0x0000b0b4, 0x00000000},
	{0x0000b0b8, 0x00000000},
	{0x0000b0bc, 0x00000000},
	{0x0000b0c0, 0x003f0020},
	{0x0000b0c4, 0x00400041},
	{0x0000b0c8, 0x0140005f},
	{0x0000b0cc, 0x0160015f},
	{0x0000b0d0, 0x017e017f},
	{0x0000b0d4, 0x02410242},
	{0x0000b0d8, 0x025f0240},
	{0x0000b0dc, 0x027f0260},
	{0x0000b0e0, 0x0341027e},
	{0x0000b0e4, 0x035f0340},
	{0x0000b0e8, 0x037f0360},
	{0x0000b0ec, 0x04400441},
	{0x0000b0f0, 0x0460045f},
	{0x0000b0f4, 0x0541047f},
	{0x0000b0f8, 0x055f0540},
	{0x0000b0fc, 0x057f0560},
	{0x0000b100, 0x06400641},
	{0x0000b104, 0x0660065f},
	{0x0000b108, 0x067e067f},
	{0x0000b10c, 0x07410742},
	{0x0000b110, 0x075f0740},
	{0x0000b114, 0x077f0760},
	{0x0000b118, 0x07800781},
	{0x0000b11c, 0x07a0079f},
	{0x0000b120, 0x07c107bf},
	{0x0000b124, 0x000007c0},
	{0x0000b128, 0x00000000},
	{0x0000b12c, 0x00000000},
	{0x0000b130, 0x00000000},
	{0x0000b134, 0x00000000},
	{0x0000b138, 0x00000000},
	{0x0000b13c, 0x00000000},
	{0x0000b140, 0x003f0020},
	{0x0000b144, 0x00400041},
	{0x0000b148, 0x0140005f},
	{0x0000b14c, 0x0160015f},
	{0x0000b150, 0x017e017f},
	{0x0000b154, 0x02410242},
	{0x0000b158, 0x025f0240},
	{0x0000b15c, 0x027f0260},
	{0x0000b160, 0x0341027e},
	{0x0000b164, 0x035f0340},
	{0x0000b168, 0x037f0360},
	{0x0000b16c, 0x04400441},
	{0x0000b170, 0x0460045f},
	{0x0000b174, 0x0541047f},
	{0x0000b178, 0x055f0540},
	{0x0000b17c, 0x057f0560},
	{0x0000b180, 0x06400641},
	{0x0000b184, 0x0660065f},
	{0x0000b188, 0x067e067f},
	{0x0000b18c, 0x07410742},
	{0x0000b190, 0x075f0740},
	{0x0000b194, 0x077f0760},
	{0x0000b198, 0x07800781},
	{0x0000b19c, 0x07a0079f},
	{0x0000b1a0, 0x07c107bf},
	{0x0000b1a4, 0x000007c0},
	{0x0000b1a8, 0x00000000},
	{0x0000b1ac, 0x00000000},
	{0x0000b1b0, 0x00000000},
	{0x0000b1b4, 0x00000000},
	{0x0000b1b8, 0x00000000},
	{0x0000b1bc, 0x00000000},
	{0x0000b1c0, 0x00000000},
	{0x0000b1c4, 0x00000000},
	{0x0000b1c8, 0x00000000},
	{0x0000b1cc, 0x00000000},
	{0x0000b1d0, 0x00000000},
	{0x0000b1d4, 0x00000000},
	{0x0000b1d8, 0x00000000},
	{0x0000b1dc, 0x00000000},
	{0x0000b1e0, 0x00000000},
	{0x0000b1e4, 0x00000000},
	{0x0000b1e8, 0x00000000},
	{0x0000b1ec, 0x00000000},
	{0x0000b1f0, 0x00000396},
	{0x0000b1f4, 0x00000396},
	{0x0000b1f8, 0x00000396},
	{0x0000b1fc, 0x00000196},
};

static const u32 ar9300_2p2_soc_preamble[][2] = {
	/* Addr      allmodes  */
	{0x000040a4, 0x00a0c1c9},
	{0x00007008, 0x00000000},
	{0x00007020, 0x00000000},
	{0x00007034, 0x00000002},
	{0x00007038, 0x000004c2},
	{0x00007048, 0x00000008},
};

static const u32 ar9300PciePhy_pll_on_clkreq_disable_L1_2p2[][2] = {
	/* Addr      allmodes  */
	{0x00004040, 0x0821265e},
	{0x00004040, 0x0008003b},
	{0x00004044, 0x00000000},
};

static const u32 ar9300PciePhy_clkreq_enable_L1_2p2[][2] = {
	/* Addr      allmodes  */
	{0x00004040, 0x08253e5e},
	{0x00004040, 0x0008003b},
	{0x00004044, 0x00000000},
};

static const u32 ar9300PciePhy_clkreq_disable_L1_2p2[][2] = {
	/* Addr      allmodes  */
	{0x00004040, 0x08213e5e},
	{0x00004040, 0x0008003b},
	{0x00004044, 0x00000000},
};

#endif /* INITVALS_9003_2P2_H */
