use Test;

use lib './lib';
use lib '.';

use Lingua::NumericWordForms::Roles::Bulgarian::WordedNumberSpec;
use Lingua::NumericWordForms::Actions::Bulgarian::WordedNumberSpec;

grammar ParseObj
        does Lingua::NumericWordForms::Roles::Bulgarian::WordedNumberSpec {
    rule TOP { <numeric-word-form> }
};

sub parse-func(Str:D $spec) {
    ParseObj.parse(
            $spec.lc,
            rule => 'numeric-word-form',
            actions => Lingua::NumericWordForms::Actions::Bulgarian::WordedNumberSpec.new).made,
}

plan 42;

#-----------------------------------------------------------
# Worded number specifications parsing
#-----------------------------------------------------------
# The tests below are generated with the following Mathematica code:
#SeedRandom[39902];
#testLanguage = "Bulgarian";
#k = 6;
#lsTestNumbers =
#  Union[Join @@
#    Map[RandomInteger[#, k] &, {{0, 19}, {20, 100}, {101,
#       1000}, {1001, 10000}, {10001, 10^6}, {10^6, 10^9}, {10^9,
#       10^12}}]];
#Length[lsTestNumbers]
#
#lsSentences =
#  Map[IntegerName[#, {testLanguage, "Words"}] &, lsTestNumbers];
#Shallow[lsSentences]
#
#StringRiffle[
# MapThread[
#  "## " <> #3 <> "\n" <> "is parse-func('" <> #1 <> "'), " <> #2 <>
#    ",\n'" <> #1 <> "';" &, {lsSentences, ToString /@ lsTestNumbers,
#   ToString /@ Range[Length[lsTestNumbers]]}], "\n\n"]

## 1
is parse-func('нула'), 0,
        'нула';

## 2
is parse-func('три'), 3,
        'три';

## 3
is parse-func('четири'), 4,
        'четири';

## 4
is parse-func('девет'), 9,
        'девет';

## 5
is parse-func('осемнадесет'), 18,
        'осемнадесет';

## 6
is parse-func('деветнадесет'), 19,
        'деветнадесет';

## 7
is parse-func('двадесет и едно'), 21,
        'двадесет и едно';

## 8
is parse-func('двадесет и девет'), 29,
        'двадесет и девет';

## 9
is parse-func('петдесет и шест'), 56,
        'петдесет и шест';

## 10
is parse-func('седемдесет и шест'), 76,
        'седемдесет и шест';

## 11
is parse-func('осемдесет и пет'), 85,
        'осемдесет и пет';

## 12
is parse-func('деветдесет и седем'), 97,
        'деветдесет и седем';

## 13
is parse-func('сто шестдесет и три'), 163,
        'сто шестдесет и три';

## 14
is parse-func('сто шестдесет и осем'), 168,
        'сто шестдесет и осем';

## 15
is parse-func('двеста четири'), 204,
        'двеста четири';

## 16
is parse-func('двеста шестдесет'), 260,
        'двеста шестдесет';

## 17
is parse-func('четиристотин двадесет и седем'), 427,
        'четиристотин двадесет и седем';

## 18
is parse-func('осемстотин четири'), 804,
        'осемстотин четири';

## 19
is parse-func('две хиляди седемдесет и две'), 2072,
        'две хиляди седемдесет и две';

## 20
is parse-func('две хиляди двеста двадесет и осем'), 2228,
        'две хиляди двеста двадесет и осем';

## 21
is parse-func('пет хиляди петстотин двадесет и осем'), 5528,
        'пет хиляди петстотин двадесет и осем';

## 22
is parse-func('пет хиляди осемстотин петдесет'), 5850,
        'пет хиляди осемстотин петдесет';

## 23
is parse-func('шест хиляди петстотин осем'), 6508,
        'шест хиляди петстотин осем';

## 24
is parse-func('седем хиляди четиристотин дванадесет'), 7412,
        'седем хиляди четиристотин дванадесет';

## 25
is parse-func('двеста четиридесет и пет хиляди триста двадесет и четири'), 245324,
        'двеста четиридесет и пет хиляди триста двадесет и четири';

## 26
is parse-func('шестстотин петнадесет хиляди двеста деветдесет и осем'), 615298,
        'шестстотин петнадесет хиляди двеста деветдесет и осем';

## 27
is parse-func('седемстотин тридесет и едно хиляди сто шест'), 731106,
        'седемстотин тридесет и едно хиляди сто шест';

## 28
is parse-func('осемстотин двадесет и три хиляди осемстотин двадесет и четири'), 823824,
        'осемстотин двадесет и три хиляди осемстотин двадесет и четири';

## 29
is parse-func('осемстотин деветдесет и едно хиляди осемстотин седемдесет и едно'), 891871,
        'осемстотин деветдесет и едно хиляди осемстотин седемдесет и едно';

## 30
is parse-func('деветстотин четиридесет и едно хиляди петстотин шест'), 941506,
        'деветстотин четиридесет и едно хиляди петстотин шест';

## 31
is parse-func('петдесет и пет милиона триста деветдесет хиляди петстотин двадесет и седем'), 55390527,
        'петдесет и пет милиона триста деветдесет хиляди петстотин двадесет и седем';

## 32
is parse-func('седемдесет и шест милиона седемстотин двадесет и четири хиляди четиристотин тридесет и шест'), 76724436,
        'седемдесет и шест милиона седемстотин двадесет и четири хиляди четиристотин тридесет и шест';

## 33
is parse-func('двеста четиридесет и седем милиона петстотин седем хиляди осемнадесет'), 247507018,
        'двеста четиридесет и седем милиона петстотин седем хиляди осемнадесет';

## 34
is parse-func('петстотин шестнадесет милиона седемстотин петдесет и три хиляди триста седемдесет и осем'), 516753378,
        'петстотин шестнадесет милиона седемстотин петдесет и три хиляди триста седемдесет и осем';

## 35
is parse-func('осемстотин четиридесет и два милиона седемстотин четири хиляди седемстотин осемдесет и три'), 842704783,
        'осемстотин четиридесет и два милиона седемстотин четири хиляди седемстотин осемдесет и три';

## 36
is parse-func('деветстотин осемдесет и осем милиона деветстотин шестдесет и едно хиляди триста двадесет и четири'),
        988961324,
        'деветстотин осемдесет и осем милиона деветстотин шестдесет и едно хиляди триста двадесет и четири';

## 37
is
        parse-func('петстотин осемдесет и седем милиарда седемстотин двадесет и седем милиона двеста тридесет хиляди сто деветдесет и девет'),
        587727230199,
        'петстотин осемдесет и седем милиарда седемстотин двадесет и седем милиона двеста тридесет хиляди сто деветдесет и девет';

## 38
is
        parse-func('шестстотин двадесет и седем милиарда петстотин осемдесет милиона деветстотин тридесет и пет хиляди седемдесет и две'),
        627580935072,
        'шестстотин двадесет и седем милиарда петстотин осемдесет милиона деветстотин тридесет и пет хиляди седемдесет и две';

## 39
is
        parse-func('седемстотин осемдесет и четири милиарда шестстотин тридесет милиона седемстотин тридесет и осем хиляди сто двадесет'),
        784630738120,
        'седемстотин осемдесет и четири милиарда шестстотин тридесет милиона седемстотин тридесет и осем хиляди сто двадесет';

## 40
is
        parse-func('осемстотин четири милиарда триста деветдесет и седем милиона четиристотин шестнадесет хиляди седемстотин тридесет и шест'),
        804397416736,
        'осемстотин четири милиарда триста деветдесет и седем милиона четиристотин шестнадесет хиляди седемстотин тридесет и шест';

## 41
is
        parse-func('осемстотин шестдесет и седем милиарда петстотин шестдесет и един милиона триста осемдесет хиляди четиристотин четиринадесет'),
        867561380414,
        'осемстотин шестдесет и седем милиарда петстотин шестдесет и един милиона триста осемдесет хиляди четиристотин четиринадесет';

## 42
is
        parse-func('деветстотин осемдесет милиарда седемстотин тридесет и шест милиона сто тридесет и осем хиляди осемстотин тридесет и девет'),
        980736138839,
        'деветстотин осемдесет милиарда седемстотин тридесет и шест милиона сто тридесет и осем хиляди осемстотин тридесет и девет';

done-testing;