/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocrPlugins;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.sourceforge.javaocr.scanner.DocumentScanner;
import net.sourceforge.javaocr.scanner.DocumentScannerListenerAdaptor;
import net.sourceforge.javaocr.scanner.PixelImage;

public class CharacterExtractor
extends DocumentScannerListenerAdaptor {
    private int num = 0;
    private DocumentScanner documentScanner = new DocumentScanner();
    private File outputDir = null;
    private File inputImage = null;
    private int std_width;
    private int std_height;
    private static final Logger LOG = Logger.getLogger(CharacterExtractor.class.getName());

    public void slice(File inputImage, File outputDir, int std_width, int std_height) {
        try {
            this.std_width = std_width;
            this.std_height = std_height;
            this.inputImage = inputImage;
            this.outputDir = outputDir;
            BufferedImage img = ImageIO.read(inputImage);
            PixelImage pixelImage = new PixelImage(img);
            pixelImage.toGrayScale(true);
            pixelImage.filter();
            this.documentScanner.scan(pixelImage, this, 0, 0, pixelImage.width, pixelImage.height);
        }
        catch (IOException ex) {
            Logger.getLogger(CharacterExtractor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void processChar(PixelImage pixelImage, int x1, int y1, int x2, int y2, int rowY1, int rowY2) {
        try {
            AffineTransformOp op;
            AffineTransform tx;
            double scaleAmount;
            int areaW = x2 - x1;
            int areaH = y2 - y1;
            BufferedImage characterImage = ImageIO.read(this.inputImage);
            characterImage = characterImage.getSubimage(x1, y1, areaW, areaH);
            if (characterImage.getWidth() > this.std_width) {
                scaleAmount = (double)this.std_width / (double)characterImage.getWidth();
                tx = new AffineTransform();
                tx.scale(scaleAmount, scaleAmount);
                op = new AffineTransformOp(tx, 2);
                characterImage = op.filter(characterImage, null);
            }
            if (characterImage.getHeight() > this.std_height) {
                scaleAmount = (double)this.std_height / (double)characterImage.getHeight();
                tx = new AffineTransform();
                tx.scale(scaleAmount, scaleAmount);
                op = new AffineTransformOp(tx, 2);
                characterImage = op.filter(characterImage, null);
            }
            BufferedImage normalizedImage = new BufferedImage(this.std_width, this.std_height, 1);
            Graphics2D g = normalizedImage.createGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.std_width, this.std_height);
            int x_offset = (this.std_width - characterImage.getWidth()) / 2;
            int y_offset = (this.std_height - characterImage.getHeight()) / 2;
            g.drawImage((Image)characterImage, x_offset, y_offset, null);
            g.dispose();
            File outputfile = new File(this.outputDir + File.separator + "char_" + this.num + ".png");
            ImageIO.write((RenderedImage)normalizedImage, "png", outputfile);
            ++this.num;
        }
        catch (Exception ex) {
            Logger.getLogger(CharacterExtractor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

