#
#
#

use Test::Simple tests => 4;

use Games::Maze;

my $correct_make = 
q(                      __                     
                   __/  \__                     
                __/  \     \__                  
               /  \     \  /  \__               
          __/  \     \__/  \     \__            
       __/  \     \__/   __/  \  /  \__         
    __/  \     \__/   __/  \  /  \     \__      
 __/  \     \__/   __/  \     \  /  \  /  \__   
/  \     \__/   __/  \     \__/  \  /  \     \  
\     \__/   __/  \     \__/   __/  \  /  \  /  
/  \__/   __/  \     \__/   __/  \  /  \  /  \  
\  /   __/  \     \__/   __/  \     \  /  \  /  
/  \  /  \     \__/   __/  \     \__/  \  /  \  
\__/  \     \__/   __/  \     \__/   __/  \  /  
/   __/  \__/   __/  \     \__/   __/  \  /  \  
\  /  \  /   __/  \     \__/   __/  \     \  /  
/  \     \  /  \     \__/   __/  \     \__/  \  
\  /  \__/  \     \__/   __/  \     \__/   __/  
/  \  /   __/  \__/   __/  \     \__/   __/  \  
\  /  \  /  \  /   __/  \     \__/   __/  \  /  
/  \  /  \     \  /  \     \__/   __/  \     \  
\  /  \  /  \__/  \     \__/   __/  \     \__/  
/  \  /  \  /   __/  \__/   __/  \     \__/  \  
\__   \  /  \  /  \  /   __/  \     \__/   __/  
   \__/  \  /  \     \  /  \     \__/   __/     
      \__   \  /  \__/  \     \__/   __/        
         \__/  \  /   __/  \__/   __/           
            \__   \  /  \  /   __/              
               \__/  \      __/                 
                  \__   \__/                    
                     \  /                       
                                                
                                                
);

my $correct_solve = 
q(                      __                     
                   __/ *\__                     
                __/ *\    *\__                  
               / *\    *\  / *\__               
          __/ *\    *\__/ *\    *\__            
       __/  \    *\__/ * __/ *\  / *\__         
    __/  \     \__/ * __/ *\  / *\    *\__      
 __/  \     \__/ * __/ *\    *\  / *\  / *\__   
/  \     \__/ * __/ *\    *\__/ *\  / *\    *\  
\     \__/ * __/ *\    *\__/ * __/ *\  / *\  /  
/  \__/ * __/ *\    *\__/ * __/ *\  / *\  / *\  
\  / * __/ *\    *\__/ * __/ *\    *\  / *\  /  
/  \  / *\    *\__/ * __/ *\    *\__/ *\  / *\  
\__/ *\    *\__/ * __/ *\    *\__/ * __/ *\  /  
/ * __/ *\__/ * __/ *\    *\__/ * __/ *\  / *\  
\  / *\  / * __/ *\    *\__/ * __/ *\    *\  /  
/ *\    *\  / *\    *\__/ * __/ *\    *\__/ *\  
\  / *\__/ *\    *\__/ * __/ *\    *\__/ * __/  
/ *\  / * __/ *\__/ * __/ *\    *\__/ * __/  \  
\  / *\  / *\  / * __/ *\    *\__/ * __/  \  /  
/ *\  / *\    *\  / *\    *\__/ * __/  \     \  
\  / *\  / *\__/ *\    *\__/ * __/  \     \__/  
/ *\  / *\  / * __/ *\__/ * __/  \     \__/  \  
\__  *\  / *\  / *\  / * __/  \     \__/   __/  
   \__/ *\  / *\    *\  /  \     \__/   __/     
      \__  *\  / *\__/ *\     \__/   __/        
         \__/ *\  / * __/  \__/   __/           
            \__  *\  /  \  /   __/              
               \__/ *\      __/                 
                  \__  *\__/                    
                     \  /                       
                                                
                                                
);

my $correct_hex =
q( 016b 016b 016b 016b 016b 016b 016b 014b 014b 0143 016b 016b 016b 016b 016b 016b 016b
 016b 016b 016b 016b 016b 016b 014b 8060 8060 8022 0143 0143 016b 016b 016b 016b 016b
 016b 016b 016b 014b 014b 8061 8060 8003 8003 8009 8060 8022 0143 0143 016b 016b 016b
 016b 014b 014b 0060 0060 0003 8003 8108 8108 8060 8021 8021 8060 8022 0143 0143 016b
 016b 0060 0060 0003 0003 8108 8108 8060 8060 8003 8003 8009 8021 8021 8060 8022 0163
 016b 0021 0003 8108 8108 8060 8060 8003 8003 8108 8108 8060 8021 8021 8021 8021 0161
 016b 0001 8120 8060 8060 8003 8003 8108 8108 8060 8060 8003 8003 8009 8021 8021 0161
 016b 8120 8009 8021 8003 8108 8108 8060 8060 8003 8003 8108 8108 8060 8021 8021 0161
 016b 8021 8060 8003 8120 8060 8060 8003 8003 8108 8108 8060 8060 8003 8003 8009 0161
 016b 8021 8021 8120 8009 8021 8003 8108 8108 8060 8060 8003 8003 8108 8108 0020 0161
 016b 8021 8021 8021 8060 8003 8120 8060 8060 8003 8003 8108 8108 0060 0060 0003 0161
 016b 8041 8021 8021 8021 8120 8009 8021 8003 8108 8108 0060 0060 0003 0003 0008 0161
 016b 016b 8003 8041 8021 8021 8060 8003 8120 0060 0060 0003 0003 0108 0108 0169 0169
 016b 016b 016b 016b 8003 8041 8021 8120 8009 0021 0003 0108 0108 0169 0169 016b 016b
 016b 016b 016b 016b 016b 016b 8003 8041 0060 0103 0108 0169 0169 016b 016b 016b 016b
 016b 016b 016b 016b 016b 016b 016b 016b 8023 0169 0169 016b 016b 016b 016b 016b 016b
 016b 016b 016b 016b 016b 016b 016b 016b 016b 016b 016b 016b 016b 016b 016b 016b 016b
);

my $minos = Games::Maze->new(
		dimensions=> [8, 8], cell => 'hex', form => 'Hexagon',
		entry => [5], exit => [8],
		start => [1,6], fn_choosedir => \&first_dir
		);

$minos->make();
my $maze_form = $minos->to_ascii();
ok(($maze_form eq $correct_make), "->make() check");

$minos->solve();
$maze_form = $minos->to_ascii();
ok(($maze_form eq $correct_solve), "->solve() check");

$maze_form = $minos->to_hex_dump();
ok(($maze_form eq $correct_hex), "->to_hex_dump() check");

$minos->unsolve();
$maze_form = $minos->to_ascii();
ok(($maze_form eq $correct_make), "->unsolve() check");

exit(0);

sub first_dir
{
	return ${$_[0]}[0];
}
