/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.conglomerate;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLLongint;

public final class TemplateRow {
    private TemplateRow() {
    }

    private static DataValueDescriptor[] allocate_objects(int n, FormatableBitSet formatableBitSet, int[] nArray) throws StandardException {
        boolean bl = false;
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[n];
        int n2 = formatableBitSet == null ? nArray.length : formatableBitSet.size();
        for (int i = 0; i < n2; ++i) {
            if (formatableBitSet != null && !formatableBitSet.get(i)) continue;
            dataValueDescriptorArray[i] = (DataValueDescriptor)Monitor.newInstanceFromIdentifier(nArray[i]);
        }
        return dataValueDescriptorArray;
    }

    public static DataValueDescriptor[] newU8Row(int n) {
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[n];
        for (int i = 0; i < dataValueDescriptorArray.length; ++i) {
            dataValueDescriptorArray[i] = new SQLLongint(Long.MIN_VALUE);
        }
        return dataValueDescriptorArray;
    }

    public static DataValueDescriptor[] newRow(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length];
        try {
            int n = dataValueDescriptorArray.length;
            while (n-- > 0) {
                dataValueDescriptorArray2[n] = (DataValueDescriptor)dataValueDescriptorArray[n].getClass().newInstance();
            }
        }
        catch (Throwable throwable) {
            throw StandardException.newException("XSCG0.S");
        }
        return dataValueDescriptorArray2;
    }

    public static DataValueDescriptor[] newRow(FormatableBitSet formatableBitSet, int[] nArray) throws StandardException {
        return TemplateRow.allocate_objects(nArray.length, formatableBitSet, nArray);
    }

    public static DataValueDescriptor[] newBranchRow(int[] nArray, DataValueDescriptor dataValueDescriptor) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.allocate_objects(nArray.length + 1, null, nArray);
        dataValueDescriptorArray[nArray.length] = dataValueDescriptor;
        return dataValueDescriptorArray;
    }

    public static boolean checkColumnTypes(int[] nArray, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        boolean bl = true;
        int n = dataValueDescriptorArray.length;
        if (nArray.length != dataValueDescriptorArray.length) {
            bl = false;
        }
        return bl;
    }

    public static boolean checkPartialColumnTypes(int[] nArray, FormatableBitSet formatableBitSet, int[] nArray2, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        boolean bl = true;
        return bl;
    }
}

