/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.salt.element.AbstractElement;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;

public class ElementMenuEntry
extends AbstractElement {
    private final TextBlock block;
    private final String text;
    private HtmlColor background;
    private double xxx;

    public ElementMenuEntry(String string, UFont uFont, ISkinSimple iSkinSimple) {
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        this.block = TextBlockUtils.create(Display.create(string), fontConfiguration, HorizontalAlignment.LEFT, iSkinSimple);
        this.text = string;
    }

    public Dimension2D getPreferredDimension(StringBounder stringBounder, double d, double d2) {
        if (this.text.equals("-")) {
            return new Dimension2DDouble(10.0, 5.0);
        }
        return this.block.calculateDimension(stringBounder);
    }

    public void drawU(UGraphic uGraphic, int n, Dimension2D dimension2D) {
        if (this.background != null) {
            Dimension2D dimension2D2 = this.getPreferredDimension(uGraphic.getStringBounder(), 0.0, 0.0);
            uGraphic.apply(new UChangeBackColor(this.background)).draw(new URectangle(dimension2D2.getWidth(), dimension2D2.getHeight()));
        }
        this.block.drawU(uGraphic);
    }

    public double getX() {
        return this.xxx;
    }

    public void setX(double d) {
        this.xxx = d;
    }

    public String getText() {
        return this.text;
    }

    public HtmlColor getBackground() {
        return this.background;
    }

    public void setBackground(HtmlColor htmlColor) {
        this.background = htmlColor;
    }
}

