package ZCS::Admin::Types::FaultDetail;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'urn:zimbra' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Error_of :ATTR(:get<Error>);

__PACKAGE__->_factory(
    [ qw(        Error

    ) ],
    {
        'Error' => \%Error_of,
    },
    {
        'Error' => 'ZCS::Admin::Types::FaultDetailError',
    },
    {

        'Error' => 'Error',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

ZCS::Admin::Types::FaultDetail

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
FaultDetail from the namespace urn:zimbra.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Error




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ZCS::Admin::Types::FaultDetail
   Error =>  { # ZCS::Admin::Types::FaultDetailError
     Code =>  $some_value, # string
     Trace =>  $some_value, # string
     a =>  { value => $some_value },
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

