package Bundle::Melody::Test;

use v5.8.1;
use strict;

use vars qw($VERSION);
$VERSION = '0.9.6a';

1;

__END__

=head1 NAME

Bundle::Melody::Test - a bundle containing the
prerequisite CPAN modules for unit testing and 
other diagnostic features in Melody 
(http://openmelody.org/). 

=head1 SYNOPSIS

C<perl -MCPAN -e "install Bundle::Melody::Test">

=head1 CONTENTS

Devel::Cover

Scalar::Util

Test::Class

Test::Deep

Test::Manifest

Test::More

Test::PerlTidy

Test::Pod

Test::Pod::Coverage

Test::Strict

Test::NoWarnings

Test::Warn
 
=head1 DESCRIPTION

Bundle::Melody::Test is a bundle containing the
prerequisite CPAN modules for unit testing and 
other diagnostic features in Melody 
(http://openmelody.org/). 

=head1 SEE ALSO

E<lt>http://openmelody.org/E<gt>, L<Bundle::Melody::Test>

=head1 PARTICIPATION

I welcome and accept patches in diff format. If you wish to
hack on this code, please fork the git repository found at:
L<http://github.com/tima/perl-bundle-melody-test/>

If you have something to push back to my repository, just
use the "pull request" button on the github site.

Participation in developing Melody is also welcome. If you
wish to contribute code, the git repository can be found at:
L<http://github.com/openmelody/melody/>. For more
information, resources and ways that you can participate
visit E<lt>http://openmelody.org/E<gt>.

=head1 LICENSE

The software is released under the Artistic License. The terms of
the Artistic License are described at
L<http://www.perl.com/language/misc/Artistic.html>.

=head1 AUTHOR & COPYRIGHT

Except where otherwise noted, Bundle::Melody::Test is
Copyright 2009, Timothy Appnel, tima@cpan.org. All rights
reserved.

=cut

=end