/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.NewByteArrayInputStream;
import org.apache.derby.iapi.types.BitDataValue;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.ConcatableDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLVarbit;
import org.apache.derby.iapi.util.StringUtil;

public abstract class SQLBinary
extends DataType
implements BitDataValue {
    static final byte PAD = 32;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(class$org$apache$derby$iapi$types$SQLBinary == null ? (class$org$apache$derby$iapi$types$SQLBinary = SQLBinary.class$("org.apache.derby.iapi.types.SQLBinary")) : class$org$apache$derby$iapi$types$SQLBinary);
    byte[] dataValue;
    InputStream stream;
    int streamLength;
    static /* synthetic */ Class class$org$apache$derby$iapi$types$SQLBinary;

    public int estimateMemoryUsage() {
        int n = BASE_MEMORY_USAGE;
        if (null != this.dataValue) {
            n += this.dataValue.length;
        }
        return n;
    }

    SQLBinary() {
    }

    SQLBinary(byte[] byArray) {
        this.dataValue = byArray;
    }

    public final void setValue(byte[] byArray) {
        this.dataValue = byArray;
        this.stream = null;
        this.streamLength = -1;
    }

    public final String getString() throws StandardException {
        if (this.getValue() == null) {
            return null;
        }
        if (this.dataValue.length * 2 < 0) {
            throw StandardException.newException("22001", this.getTypeName(), (Object)"", (Object)String.valueOf(Integer.MAX_VALUE));
        }
        return StringUtil.toHexString(this.dataValue, 0, this.dataValue.length);
    }

    public final InputStream getStream() {
        return this.stream;
    }

    public final byte[] getBytes() throws StandardException {
        return this.getValue();
    }

    byte[] getValue() throws StandardException {
        try {
            if (this.dataValue == null && this.stream != null) {
                if (this.stream instanceof FormatIdInputStream) {
                    this.readExternal((FormatIdInputStream)this.stream);
                } else if (this.stream instanceof NewByteArrayInputStream) {
                    NewByteArrayInputStream newByteArrayInputStream = (NewByteArrayInputStream)this.stream;
                    this.dataValue = newByteArrayInputStream.getData();
                } else {
                    this.readExternal(new FormatIdInputStream(this.stream));
                }
                this.stream = null;
                this.streamLength = -1;
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException("XCL30.S", iOException, (Object)this.getTypeName());
        }
        return this.dataValue;
    }

    public final int getLength() throws StandardException {
        if (this.stream != null && this.streamLength != -1) {
            return this.streamLength;
        }
        return this.getBytes().length;
    }

    public final boolean isNull() {
        return this.dataValue == null && this.stream == null;
    }

    public final void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.dataValue.length;
        if (n <= 31) {
            objectOutput.write((byte)(0x80 | n & 0xFF));
        } else if (n <= 65535) {
            objectOutput.write(-96);
            objectOutput.writeShort((short)n);
        } else {
            objectOutput.write(-64);
            objectOutput.writeInt(n);
        }
        objectOutput.write(this.dataValue, 0, this.dataValue.length);
    }

    public final void readExternal(ObjectInput objectInput) throws IOException {
        this.stream = null;
        this.streamLength = -1;
        int n = SQLBinary.readBinaryLength(objectInput);
        if (n != 0) {
            this.dataValue = new byte[n];
            objectInput.readFully(this.dataValue);
        } else {
            this.readFromStream((InputStream)((Object)objectInput));
        }
    }

    public final void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        this.stream = null;
        this.streamLength = -1;
        int n = SQLBinary.readBinaryLength(arrayInputStream);
        if (n != 0) {
            this.dataValue = new byte[n];
            arrayInputStream.readFully(this.dataValue);
        } else {
            this.readFromStream(arrayInputStream);
        }
    }

    private static int readBinaryLength(ObjectInput objectInput) throws IOException {
        int n = 0;
        int n2 = objectInput.read();
        if (n < 0) {
            throw new EOFException();
        }
        if ((n2 & 0x80) != 0) {
            n = n2 == 192 ? objectInput.readInt() : (n2 == 160 ? objectInput.readUnsignedShort() : n2 & 0x1F);
        } else {
            int n3 = objectInput.read();
            int n4 = objectInput.read();
            int n5 = objectInput.read();
            if (n3 < 0 || n4 < 0 || n5 < 0) {
                throw new EOFException();
            }
            int n6 = (n2 & 0xFF) << 24 | (n3 & 0xFF) << 16 | (n4 & 0xFF) << 8 | n5 & 0xFF;
            n = n6 / 8;
            if (n6 % 8 != 0) {
                ++n;
            }
        }
        return n;
    }

    private void readFromStream(InputStream inputStream) throws IOException {
        int n;
        this.dataValue = null;
        byte[] byArray = new byte[32768];
        int n2 = 0;
        while ((n = inputStream.read(byArray, n2, byArray.length - n2)) != -1) {
            int n3 = inputStream.available();
            int n4 = n3 - (byArray.length - (n2 += n));
            if (n4 <= 0) continue;
            int n5 = byArray.length * 2;
            if (n4 > byArray.length) {
                n5 += n4;
            }
            byte[] byArray2 = new byte[n5];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
        this.dataValue = new byte[n2];
        System.arraycopy(byArray, 0, this.dataValue, 0, n2);
    }

    public final void restoreToNull() {
        this.dataValue = null;
        this.stream = null;
        this.streamLength = -1;
    }

    public final boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        if (!bl) {
            String string = dataValueDescriptor.getString();
            if (this.getString() == null || string == null) {
                return bl2;
            }
        }
        return super.compare(n, dataValueDescriptor, bl, bl2);
    }

    public final int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return -dataValueDescriptor.compare(this);
        }
        if (this.isNull() || dataValueDescriptor.isNull()) {
            if (!this.isNull()) {
                return -1;
            }
            if (!dataValueDescriptor.isNull()) {
                return 1;
            }
            return 0;
        }
        return SQLBinary.compare(this.getBytes(), dataValueDescriptor.getBytes());
    }

    public final Object cloneObject() {
        if (this.stream == null) {
            return this.getClone();
        }
        SQLBinary sQLBinary = (SQLBinary)this.getNewNull();
        sQLBinary.setStream(this.stream);
        return sQLBinary;
    }

    public final DataValueDescriptor getClone() {
        try {
            DataValueDescriptor dataValueDescriptor = this.getNewNull();
            dataValueDescriptor.setValue(this.getValue());
            return dataValueDescriptor;
        }
        catch (StandardException standardException) {
            return null;
        }
    }

    public final InputStream returnStream() {
        return this.stream;
    }

    public final void setStream(InputStream inputStream) {
        this.dataValue = null;
        this.stream = inputStream;
        this.streamLength = -1;
    }

    public final void loadStream() throws StandardException {
        this.getValue();
    }

    boolean objectNull(Object object) {
        if (object == null) {
            this.setToNull();
            return true;
        }
        return false;
    }

    public final void setValue(InputStream inputStream, int n) {
        this.dataValue = null;
        this.stream = inputStream;
        this.streamLength = n;
    }

    protected final void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor instanceof SQLBinary) {
            SQLBinary sQLBinary = (SQLBinary)dataValueDescriptor;
            this.dataValue = sQLBinary.dataValue;
            this.stream = sQLBinary.stream;
            this.streamLength = sQLBinary.streamLength;
        } else {
            this.setValue(dataValueDescriptor.getBytes());
        }
    }

    public final BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor.isNull() || dataValueDescriptor2.isNull() ? false : SQLBinary.compare(dataValueDescriptor.getBytes(), dataValueDescriptor2.getBytes()) == 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public final BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor.isNull() || dataValueDescriptor2.isNull() ? false : SQLBinary.compare(dataValueDescriptor.getBytes(), dataValueDescriptor2.getBytes()) != 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public final BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor.isNull() || dataValueDescriptor2.isNull() ? false : SQLBinary.compare(dataValueDescriptor.getBytes(), dataValueDescriptor2.getBytes()) < 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public final BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = false;
        bl = dataValueDescriptor.isNull() || dataValueDescriptor2.isNull() ? false : SQLBinary.compare(dataValueDescriptor.getBytes(), dataValueDescriptor2.getBytes()) > 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public final BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = false;
        bl = dataValueDescriptor.isNull() || dataValueDescriptor2.isNull() ? false : SQLBinary.compare(dataValueDescriptor.getBytes(), dataValueDescriptor2.getBytes()) <= 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public final BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = false;
        bl = dataValueDescriptor.isNull() || dataValueDescriptor2.isNull() ? false : SQLBinary.compare(dataValueDescriptor.getBytes(), dataValueDescriptor2.getBytes()) >= 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public final NumberDataValue charLength(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLInteger();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        numberDataValue.setValue(this.getValue().length);
        return numberDataValue;
    }

    public final BitDataValue concatenate(BitDataValue bitDataValue, BitDataValue bitDataValue2, BitDataValue bitDataValue3) throws StandardException {
        if (bitDataValue.isNull() || bitDataValue2.isNull()) {
            bitDataValue3.setToNull();
            return bitDataValue3;
        }
        byte[] byArray = bitDataValue.getBytes();
        byte[] byArray2 = bitDataValue2.getBytes();
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        bitDataValue3.setValue(byArray3);
        return bitDataValue3;
    }

    public final ConcatableDataValue substring(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, ConcatableDataValue concatableDataValue, int n) throws StandardException {
        if (concatableDataValue == null) {
            concatableDataValue = new SQLVarbit();
        }
        BitDataValue bitDataValue = (BitDataValue)concatableDataValue;
        if (this.isNull() || numberDataValue.isNull() || numberDataValue2 != null && numberDataValue2.isNull()) {
            bitDataValue.setToNull();
            return bitDataValue;
        }
        int n2 = numberDataValue.getInt();
        int n3 = numberDataValue2 != null ? numberDataValue2.getInt() : this.getLength() - n2 + 1;
        if (n2 <= 0 || n3 < 0 || n2 > this.getLength() || n3 > this.getLength() - n2 + 1) {
            throw StandardException.newException("22011");
        }
        if (n3 < 0) {
            bitDataValue.setToNull();
            return bitDataValue;
        }
        if (n2 < 0) {
            if ((n2 += this.getLength()) < 0) {
                n3 += n2;
                n2 = 0;
            }
            n3 = n3 + n2 > 0 ? (n3 += n2) : 0;
        } else if (n2 > 0) {
            --n2;
        }
        if (n3 == 0 || n3 <= 0 - n2 || n2 > this.getLength()) {
            bitDataValue.setValue(new byte[0]);
            return bitDataValue;
        }
        if (n3 >= this.getLength() - n2) {
            byte[] byArray = new byte[this.dataValue.length - n2];
            System.arraycopy(this.dataValue, n2, byArray, 0, byArray.length);
            bitDataValue.setValue(byArray);
        } else {
            byte[] byArray = new byte[n3];
            System.arraycopy(this.dataValue, n2, byArray, 0, byArray.length);
            bitDataValue.setValue(byArray);
        }
        return bitDataValue;
    }

    public final void checkHostVariable(int n) throws StandardException {
        int n2 = -1;
        if (this.stream == null) {
            if (this.dataValue != null) {
                n2 = this.dataValue.length;
            }
        } else {
            n2 = this.streamLength;
        }
        if (n2 != -1 && n2 > n) {
            throw StandardException.newException("22001", this.getTypeName(), (Object)"XX-RESOLVE-XX", (Object)String.valueOf(n));
        }
    }

    public final String toString() {
        if (this.dataValue == null) {
            if (this.stream == null) {
                return "NULL";
            }
            return "";
        }
        return StringUtil.toHexString(this.dataValue, 0, this.dataValue.length);
    }

    public final int hashCode() {
        try {
            if (this.getValue() == null) {
                return 0;
            }
        }
        catch (StandardException standardException) {
            return 0;
        }
        byte[] byArray = this.dataValue;
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by == 32) continue;
            n += byArray[i];
        }
        return n;
    }

    private static int compare(byte[] byArray, byte[] byArray2) {
        int n;
        int n2;
        int n3 = byArray.length;
        byte[] byArray3 = byArray2;
        if (byArray2.length < n3) {
            n3 = byArray2.length;
            byArray3 = byArray;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = byArray[n2] & 0xFF;
            int n4 = byArray2[n2] & 0xFF;
            if (n == n4) continue;
            return n - n4;
        }
        for (n2 = n3; n2 < byArray3.length; ++n2) {
            n = byArray3[n2];
            if (n == 32) continue;
            if (byArray == byArray3) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public void setInto(PreparedStatement preparedStatement, int n) throws SQLException, StandardException {
        preparedStatement.setBytes(n, this.getBytes());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

