# Copyright 2016 Kevin Ryde

# This file is part of Math-PlanePath.
#
# Math-PlanePath is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 3, or (at your option) any later
# version.
#
# Math-PlanePath is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with Math-PlanePath.  If not, see <http://www.gnu.org/licenses/>.


use 5.004;
use strict;

use Math::PlanePath;



=pod

 Math::PlanePath::DekkingCurve
 /m/e-curve-mckenna/
 /m/e-curve-mckenna/64.png

    *  10--11   *   *   *                n=5
       <| v |>    _   _         9  10  11  13  14        dir=0 rev=0
    *   9  12---*---*---*                                
       <| _   v   _    <|       8   7  12  17  15        initial
    *   *---*   *---*---*                                dir=-1 rev=1
      _    <|  <| _   v         2   6  18  19  16
    *---*   *   *---*   *
    |>  |>  |>    _ |>          1   3   5  21  20
    *   *---*   *---*   *
    |>    v    <| _   _         0   4  22  23  24
    0           *---*---*


        *---*---*                            n=7
        |       |                
        *   *---*   *---*---*---*
        |   |       |           |
        *   *---*---*   *---*   *
        |               |   |   |
    *   *---*---*---*   *   *---*
                    |   |        
    *---*---*   *---*   *---*    
    |       |   |           |    
    *   *---*   *   *---*   *    
    |   |       |   |   |   |    
    *   *---*---*   *   *---*    
    |               |    
    0               *---*---*---*


        *---*---*---*
       <| v   v   v |>    _   _   _   _                n=9
        *   *---*   *   *---*---*---*---*
       <|  <| v |>  |>  |>    _   _    <|
        *   *   *---*   *   *---*---*   *
       <|  <| _   v   _ |>  |>     <|  <|
        *   *---*---*---*   *   *---*   *
       <| _   _   v   _    <|  <| v    <|
        *---*---*---*---*   *   *---*---*
      _   _   _   v    <|  <| _   v   v
    *---*---*---*   *---*   *---*---*
    |>    _    <|  <| v   _   _   v |>
    *   *---*   *   *   *---*---*   *
    |>  |>  |>  |>  |>  |>    _ |>  |>
    *   *   *---*   *   *   *---*   *
    |>  |>    v    <|  <|  <| _   _ |>
    *   *---*---*---*   *   *---*---*
    |>    v   v   v    <| _   _   _   _
    0                   *---*---*---*---*

       40---*---*---*--44
       <| v   v   v   v |>    _   _   _   _   _
        *   *---*---*   *  64---*---*---*---*---*
       <|  <| v   v |>  |>  |     _   _   _    <|
        *   *   *--51   *   *   *---*---*---*  70
       <|  <|  <| v   _ |>  |>  |>    _    <|  <|      n=11
        *   *   *---*--47   *   *   *--83   *   *      11*11 == 121
       <|  <| _   v   _    <|  <|  <|  <|  <|  <|
        *  57---*---*---*--61   *   *   *--81   *      t=5
       <| _   _   v   _   v     |>  |>    v    <|      
       35---*---*---*--31  90---*   *---*---*---*
      _   _   _   v    <|  <| _   _   v   v   v        
    5---*---*---*---9   *   *---*---*---*---*
    |>    _   _   v |>  |>    _   _   v   v |>
    *  19---*---*   *   *   *---*---*--09   *
    |>  |>    _ |>  |>  |>  |>    _   v |>  |>
    *   *  15--16   *   *   *   *---*   *   *
    |>  |>  |>     <|  <|  <|  <|  <| _ |>  |>
    *   *  14---*--12   *   *   *   *---*   *
    |>  |>    v   v    <|  <|  <| _   _   _ |>
    *  22---*---*---*--26   *   *---*---*--99
    |>    v   v   v   v    <| _   _   _   _   _
    0                       *---*---*---*---*-121

  n=19
 19     *---*---*---*---*---*---*---*---*    
       <| v   v   v   v   v   v   v   v |>    _   _   _   _   _   _   _   _   _
 18     *   *---*---*---*---*---*---*   *   *---*---*---*---*---*---*---*---*---*
       <|  <| v   v   v   v   v   v |>  |>  |>    _   _   _   _   _   _   _    <|
 17     *   *   *---*---*---*---*   *   *   *   *---*---*---*---*---*---*---*   *
       <|  <|  <| v   v   v   v |>  |>  |>  |>  |>    _   _   _   _   _    <|  <|
 16     *   *   *   *---*---*   *   *   *   *   *   *---*---*---*---*---*   *   *
       <|  <|  <|  <| v   v |>  |>  |>  |>  |>  |>  |>    _   _   _    <|  <|  <|
 15     *   *   *   *   *---*   *   *   *   *   *   *   *---*---*---*   *   *   *
       <|  <|  <|  <|  <| v   _ |>  |>  |>  |>  |>  |>  |>    _    <|  <|  <|  <|
 14     *   *   *   *   *---*---*   *   *   *   *   *   *   *---*   *   *   *   *
       <|  <|  <|  <| _   v   _    <|  <|  <|  <|  <|  <|  <|  <|  <|  <|  <|  <|
 13     *   *   *   *---*---*---*---*   *   *   *   *   *   *   *---*   *   *   *
       <|  <|  <| _   _   v   _   v   _ |>  |>  |>  |>  |>  |>    v    <|  <|  <|
 12     *   *   *---*---*---*---*---*---*   *   *   *   *   *---*---*---*   *   *
       <|  <| _   _   _   v   _   v   _    <|  <|  <|  <| _   v   v   v    <|  <|
 11     *   *---*---*---*---*---*---*---*---*   *   *   *---*---*---*---*---*   *
       <| _   _   _   _   v   _   v   _   v    <|  <| _   _   v   v   v   v    <|
 10     *---*---*---*---*---*---*---*---*   *---*   *---*---*---*---*---*---*---*
      _   _   _   _   _   v   _   v    <|  <| v   _   _   _   v   v   v   v   v
 9  *---*---*---*---*---*---*---*---*   *   *---*---*---*---*---*---*---*---*   
    |>    _   _   _   _   v   _   v |>  |>    v   _   _   _   v   v   v   v |>
 8  *   *---*---*---*---*---*---*   *   *   *---*---*---*---*---*---*---*   *   
    |>  |>    _   _   _   v    <|  <|  <|  <| v   _   _   _   v   v   v |>  |> 
 7  *   *   *---*---*---*---*   *   *   *   *   *---*---*---*---*---*   *   *   
    |>  |>  |>    _   _   v |>  |>  |>  |>  |>  |>    _   _   v   v |>  |>  |>
 6  *   *   *   *---*---*   *   *   *   *   *   *   *---*---*---*   *   *   *   
    |>  |>  |>  |>    _ |>  |>  |>  |>  |>  |>  |>  |>    _   v |>  |>  |>  |>
 5  *   *   *   *   *---*   *   *   *   *   *   *   *   *---*   *   *   *   *   
    |>  |>  |>  |>  |>     <|  <|  <|  <|  <|  <|  <|  <|  <| _ |>  |>  |>  |>
 4  *   *   *   *   *---*---*   *   *   *   *   *   *   *   *---*   *   *   *   
    |>  |>  |>  |>    v   v    <|  <|  <|  <|  <|  <|  <| _   _   _ |>  |>  |>
 3  *   *   *   *---*---*---*---*   *   *   *   *   *   *---*---*---*   *   *   
    |>  |>  |>    v   v   v   v    <|  <|  <|  <|  <| _   _   _   _   _ |>  |>
 2  *   *   *---*---*---*---*---*---*   *   *   *   *---*---*---*---*---*   *   
    |>  |>    v   v   v   v   v   v    <|  <|  <| _   _   _   _   _   _   _ |>
 1  *   *---*---*---*---*---*---*---*---*   *   *---*---*---*---*---*---*---*    
    |>    v   v   v   v   v   v   v   v    <| _   _   _   _   _   _   _   _   _
 0  0                                       *---*---*---*---*---*---*---*---*---*

    0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15  16  17  18  19

Douglas M. McKenna, 1978, as described in "SquaRecurves, E-Tours, Eddies,
and Frenzies: Basic Families of Peano Curves on the Square Grid", in "The
Lighter Side of Mathematics: Proceedings of the Eugene Strens Memorial
Conference on Recreational Mathematics and its History", Mathematical
Association of America, 1994, pages 49-73, ISBN 0-88385-516-X.

=cut

sub nbase_to_xydxdy {
  my ($n, $k) = @_;
}

{
  my $k = 9;
  my @x;
  my @y;
  foreach my $n (0 .. $k*$k-1) {
    my ($x,$y, $dx,$dy) = nbase_to_xydxdy ($n, $k);
    print "$x,$y\n";      # , $dx,$dy
    $x[$n] = $x;
    $y[$n] = $y;
  }
  exit 0;
}
